
-- loads ODMR_CARS_DATA table for Data Miner OBE Demo
--
-- Paramters:
-- 1. User account - account to load the table into
-- Example:
-- @instCarsDemoData.sql DMUSER
--------------------------------------------------------

-- User Account subsitition variable
DEFINE USER_ACCOUNT = &&1

EXECUTE dbms_output.put_line('');
EXECUTE dbms_output.put_line('Load Data Miner demo table ODMR_CARS_DATA.');
EXECUTE dbms_output.put_line('');

ALTER session set current_schema = "&USER_ACCOUNT";

-- Drop table if it already exists
-- NOTE: ERRORS ARE OK FOR THE DROP TABLE AS IT CONFIRMS THE TABLE DOES NOT EXIST
DECLARE
v_sql varchar2(100); 
BEGIN
v_sql := q'[DROP TABLE "&USER_ACCOUNT"."ODMR_CARS_DATA" cascade constraints]';
EXECUTE IMMEDIATE v_sql;
DBMS_OUTPUT.PUT_LINE (v_sql ||': succeeded');
EXCEPTION
WHEN OTHERS THEN
DBMS_OUTPUT.PUT_LINE (v_sql ||': drop unneccessary - no table/view exists');
END;
/

--------------------------------------------------------
--  DDL for Table ODMR_CARS_DATA
--------------------------------------------------------

  CREATE TABLE "&USER_ACCOUNT"."ODMR_CARS_DATA" 
   (	"NAME" VARCHAR2(40 BYTE), 
	"MPG" NUMBER(10,3), 
	"CYLINDERS" NUMBER(10,3), 
	"DISPLACEMENT" NUMBER(10,3), 
	"HORSEPOWER" NUMBER(10,3), 
	"WEIGHT" NUMBER(10,3), 
	"ACCELERATION" NUMBER(10,3), 
	"MODEL_YEAR" NUMBER(10,3), 
	"ORIGIN" NUMBER(10,3)
   ) NOLOGGING;
REM INSERTING into "&USER_ACCOUNT".ODMR_CARS_DATA
INSERT ALL
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc ambassador brougham',13,8,360,175,3821,11,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc ambassador dpl',15,8,390,190,3850,8.5,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc ambassador sst',17,8,304,150,3672,11.5,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc concord',19.4,6,232,90,3210,17.2,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc concord',24.3,4,151,90,3003,20.1,80,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc concord d/l',18.1,6,258,120,3410,15.1,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc concord dl',23,4,151,null,3035,20.5,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc concord dl 6',20.2,6,232,90,3265,18.2,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc gremlin',18,6,232,100,2789,15,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc gremlin',19,6,232,100,2634,13,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc gremlin',20,6,232,100,2914,16,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc gremlin',21,6,199,90,2648,15,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc hornet',18,6,232,100,2945,16,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc hornet',18,6,199,97,2774,15.5,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc hornet',19,6,232,100,2901,16,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc hornet',22.5,6,232,90,3085,17.6,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc hornet sportabout (sw)',18,6,258,110,2962,13.5,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc matador',14,8,304,150,3672,11.5,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc matador',15,6,258,110,3730,19,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc matador',15.5,8,304,120,3962,13.9,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc matador',16,6,258,110,3632,18,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc matador',18,6,232,100,3288,15.5,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc matador (sw)',14,8,304,150,4257,15.5,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc matador (sw)',15,8,304,150,3892,12.5,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc pacer',19,6,232,90,3211,17,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc pacer d/l',17.5,6,258,95,3193,17.8,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc rebel sst',16,8,304,150,3433,12,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc rebel sst (sw)',null,8,360,175,3850,11,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('amc spirit dl',27.4,4,121,80,2670,15,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('audi 100 ls',24,4,107,90,2430,14.5,70,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('audi 100ls',20,4,114,91,2582,14,73,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('audi 100ls',23,4,115,95,2694,15,75,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('audi 4000',34.3,4,97,78,2188,15.8,80,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('audi 5000',20.3,5,131,103,2830,15.9,78,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('audi 5000s (diesel)',36.4,5,121,67,2950,19.9,80,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('audi fox',29,4,98,83,2219,16.5,74,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('bmw 2002',26,4,121,113,2234,12.5,70,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('bmw 320i',21.5,4,121,110,2600,12.8,77,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick century',17,6,231,110,3907,21,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick century',22.4,6,231,110,3415,15.8,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick century 350',13,8,350,175,4100,13,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick century limited',25,6,181,110,2945,16.4,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick century luxus (sw)',13,8,350,150,4699,14.5,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick century special',20.6,6,231,105,3380,15.8,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick electra 225 custom',12,8,455,225,4951,11,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick estate wagon (sw)',14,8,455,225,3086,10,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick estate wagon (sw)',16.9,8,350,155,4360,14.9,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick lesabre custom',13,8,350,155,4502,13.5,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick opel isuzu deluxe',30,4,111,80,2155,14.8,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick regal sport coupe (turbo)',17.7,6,231,165,3445,13.4,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick skyhawk',21,6,231,110,3039,15,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick skylark',20.5,6,231,105,3425,16.9,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick skylark',26.6,4,151,84,2635,16.4,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick skylark 320',15,8,350,165,3693,11.5,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('buick skylark limited',28.4,4,151,90,2670,16,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('cadillac eldorado',23,8,350,125,3900,17.4,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('cadillac seville',16.5,8,350,180,4380,12.1,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet bel air',15,8,350,145,4440,14,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet camaro',27,4,151,90,2950,17.3,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet caprice classic',13,8,400,150,4464,12,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet caprice classic',17,8,305,130,3840,15.4,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet caprice classic',17.5,8,305,145,3880,12.5,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet cavalier',28,4,112,88,2605,19.6,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet cavalier 2-door',34,4,112,88,2395,18,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet cavalier wagon',27,4,112,88,2640,18.6,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet chevelle concours (sw)',13,8,307,130,4098,14,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet chevelle concours (sw)',null,8,350,165,4142,11.5,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet chevelle malibu',16,6,250,105,3897,18.5,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet chevelle malibu',17,6,250,100,3329,15.5,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet chevelle malibu',18,8,307,130,3504,12,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet chevelle malibu classic',16,6,250,100,3781,17,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet chevelle malibu classic',17.5,8,305,140,4215,13,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet chevette',29,4,85,52,2035,22.2,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet chevette',30,4,98,68,2155,16.5,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet chevette',30.5,4,98,63,2051,17,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet chevette',32.1,4,98,70,2120,15.5,80,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet citation',23.5,6,173,110,2725,12.6,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet citation',28,4,151,90,2678,16.5,80,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet citation',28.8,6,173,115,2595,11.3,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet concours',17.5,6,250,110,3520,16.4,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet impala',11,8,400,150,4997,14,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet impala',13,8,350,165,4274,12,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet impala',14,8,350,165,4209,12,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet impala',14,8,454,220,4354,9,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet malibu',13,8,350,145,3988,13,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet malibu',20.5,6,200,95,3155,18.2,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet malibu classic (sw)',19.2,8,267,125,3605,15,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet monte carlo',15,8,400,150,3761,9.5,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet monte carlo landau',15.5,8,350,170,4165,11.4,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet monte carlo landau',19.2,8,305,145,3425,13.2,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet monte carlo s',15,8,350,145,4082,13,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet monza 2+2',20,8,262,110,3221,13.5,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet nova',15,6,250,100,3336,17,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet nova',18,6,250,105,3459,16,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet nova',22,6,250,105,3353,14.5,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet nova custom',16,6,250,100,3278,18,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet vega',20,4,140,90,2408,19.5,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet vega',21,4,140,72,2401,19.5,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet vega',25,4,140,75,2542,17,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet vega (sw)',22,4,140,72,2408,19,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet vega 2300',28,4,140,90,2264,15.5,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevrolet woody',24.5,4,98,60,2164,22.1,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevy c10',13,8,350,145,4055,12,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevy c20',10,8,307,200,4376,15,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chevy s-10',31,4,119,82,2720,19.4,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chrysler cordoba',15.5,8,400,190,4325,12.2,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chrysler lebaron medallion',26,4,156,92,2585,14.5,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chrysler lebaron salon',17.6,6,225,85,3465,16.6,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chrysler lebaron town @ country (sw)',18.5,8,360,150,3940,13,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chrysler new yorker brougham',13,8,440,215,4735,11,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('chrysler newport royal',13,8,400,190,4422,12.5,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('citroen ds-21 pallas',null,4,133,115,3090,17.5,70,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 1200',35,4,72,69,1613,18,71,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 200sx',32.9,4,119,100,2615,14.8,81,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 200-sx',23.9,4,119,97,2405,14.9,78,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 210',31.8,4,85,65,2020,19.2,79,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 210',40.8,4,85,65,2110,19.2,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 210 mpg',37,4,85,65,1975,19.4,81,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 280-zx',32.7,6,168,132,2910,11.4,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 310',37.2,4,86,65,2019,16.4,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 310 gx',38,4,91,67,1995,16.2,82,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 510',27.2,4,119,97,2300,14.7,78,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 510 (sw)',28,4,97,92,2288,17,72,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 510 hatchback',37,4,119,92,2434,15,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 610',22,4,108,94,2379,16.5,73,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 710',24,4,119,97,2545,17,75,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 710',32,4,83,61,2003,19,74,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 810',22,6,146,97,2815,14.5,77,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun 810 maxima',24.2,6,146,120,2930,13.8,81,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun b210',31,4,79,67,1950,19,74,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun b-210',32,4,85,70,1990,17,76,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun b210 gx',39.4,4,85,70,2070,18.6,78,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun f-10 hatchback',33.5,4,85,70,1945,16.8,77,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun pl510',27,4,97,88,2130,14.5,71,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('datsun pl510',27,4,97,88,2130,14.5,70,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge aries se',29,4,135,84,2525,16,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge aries wagon (sw)',25.8,4,156,92,2620,14.4,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge aspen',18.6,6,225,110,3620,18.7,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge aspen',19.1,6,225,90,3381,18.7,80,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge aspen 6',20.6,6,225,110,3360,16.6,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge aspen se',20,6,225,100,3651,17.7,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge challenger se',15,8,383,170,3563,10,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge charger 2.2',36,4,135,84,2370,13,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge colt',26,4,98,79,2255,17.7,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge colt',27.9,4,156,105,2800,14.4,80,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge colt',28,4,90,75,2125,14.5,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge colt (sw)',28,4,98,80,2164,15,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge colt hardtop',25,4,98,80,2126,17,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge colt hatchback custom',35.7,4,98,80,1915,14.4,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge colt m/m',33.5,4,98,83,2075,15.9,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge coronet brougham',16,8,318,150,4190,13,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge coronet custom',15,8,318,150,3777,12.5,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge coronet custom (sw)',14,8,318,150,4457,13.5,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge d100',13,8,318,150,3755,14,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge d200',11,8,318,210,4382,13.5,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge dart custom',15,8,318,150,3399,11,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge diplomat',19.4,8,318,140,3735,13.2,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge magnum xe',17.5,8,318,140,4080,13.7,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge monaco (sw)',12,8,383,180,4955,11.5,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge monaco brougham',15.5,8,318,145,4140,13.7,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge omni',30.9,4,105,75,2230,14.5,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge rampage',32,4,135,84,2295,11.6,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('dodge st. regis',18.2,8,318,135,3830,15.2,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('fiat 124 sport coupe',26,4,98,90,2265,15.5,73,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('fiat 124 tc',26,4,116,75,2246,14,74,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('fiat 124b',30,4,88,76,2065,14.5,71,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('fiat 128',24,4,90,75,2108,15.5,74,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('fiat 128',29,4,68,49,1867,19.5,73,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('fiat 131',28,4,107,86,2464,15.5,76,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('fiat strada custom',37.3,4,91,69,2130,14.7,79,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('fiat x1.9',31,4,79,67,2000,16,74,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford capri II',25,4,140,92,2572,14.9,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford country',12,8,400,167,4906,12.5,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford country squire (sw)',13,8,400,170,4746,12,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford country squire (sw)',15.5,8,351,142,4054,14.3,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford escort 2h',29.9,4,98,65,2380,20.7,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford escort 4w',34.4,4,98,65,2045,16.2,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford f108',13,8,302,130,3870,15,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford f250',10,8,360,215,4615,14,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford fairmont',26.4,4,140,88,2870,18.1,80,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford fairmont (auto)',20.2,6,200,85,2965,15.8,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford fairmont (man)',25.1,4,140,88,2720,15.4,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford fairmont 4',22.3,4,140,88,2890,17.3,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford fairmont futura',24,4,140,92,2865,16.4,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford fiesta',36.1,4,98,66,1800,14.4,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford futura',18.1,8,302,139,3205,11.2,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford galaxie 500',14,8,351,153,4154,13.5,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford galaxie 500',14,8,351,153,4129,13,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford galaxie 500',15,8,429,198,4341,10,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford gran torino',14,8,302,137,4042,14.5,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford gran torino',14.5,8,351,152,4215,12.8,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford gran torino',16,8,302,140,4141,14,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford gran torino (sw)',13,8,302,140,4294,16,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford gran torino (sw)',14,8,302,140,4638,16,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford granada',18.5,6,250,98,3525,19,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford granada ghia',18,6,250,78,3574,21,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford granada gl',20.2,6,200,88,3060,17.1,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford granada l',22,6,232,112,2835,14.7,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford ltd',13,8,351,158,4363,13,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford ltd',14,8,351,148,4657,13.5,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford ltd landau',17.6,8,302,129,3725,13.4,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford maverick',15,6,250,72,3158,19.5,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford maverick',18,6,250,88,3021,16.5,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford maverick',21,6,200,null,2875,17,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford maverick',21,6,200,85,2587,16,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford maverick',24,6,200,81,3012,17.6,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford mustang',18,6,250,88,3139,14.5,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford mustang boss 302',null,8,302,140,3353,8,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford mustang cobra',23.6,4,140,null,2905,14.3,80,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford mustang gl',27,4,140,86,2790,15.6,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford mustang II',13,8,302,129,3169,12,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford mustang ii 2+2',25.5,4,140,89,2755,15.8,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford pinto',18,6,171,97,2984,14.5,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford pinto',19,4,122,85,2310,18.5,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford pinto',23,4,140,83,2639,17,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford pinto',25,4,98,null,2046,19,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford pinto',26,4,122,80,2451,16.5,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford pinto',26.5,4,140,72,2565,13.6,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford pinto (sw)',22,4,122,86,2395,16,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford pinto runabout',21,4,122,86,2226,16.5,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford ranger',28,4,120,79,2625,18.6,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford thunderbird',16,8,351,149,4335,14.5,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford torino',17,8,302,140,3449,10.5,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford torino (sw)',null,8,351,153,4034,11,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('ford torino 500',19,6,250,88,3302,15.5,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('hi 1200d',9,8,304,193,4732,18.5,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda accord',32.4,4,107,72,2290,17,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda accord',36,4,107,75,2205,14.5,82,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda accord cvcc',31.5,4,98,68,2045,18.5,77,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda accord lx',20.5,4,98,68,2135,16.6,78,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda civic',24,4,120,97,2489,15,74,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda civic',33,4,91,53,1795,17.4,76,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda civic',38,4,91,67,1965,15,82,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda civic (auto)',32,4,91,67,1965,15.7,82,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda civic 1300',35.1,4,81,60,1760,16.1,81,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda civic 1500 gl',44.6,4,91,67,1850,13.8,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda civic cvcc',33,4,91,53,1795,17.5,75,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda civic cvcc',36.1,4,91,60,1800,16.4,78,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('honda prelude',33.7,4,107,75,2210,14.4,81,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('maxda glc deluxe',34.1,4,86,65,1975,15.2,79,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('maxda rx3',18,3,70,90,2124,13.5,73,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mazda 626',31.3,4,120,75,2542,17.5,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mazda 626',31.6,4,120,74,2635,18.3,81,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mazda glc',46.6,4,86,65,2110,17.9,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mazda glc 4',34.1,4,91,68,1985,16,81,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mazda glc custom',31,4,91,68,1970,17.6,82,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mazda glc custom l',37,4,91,68,2025,18.2,82,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mazda glc deluxe',32.8,4,78,52,1985,19.4,78,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mazda rx2 coupe',19,3,70,97,2330,13.5,72,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mazda rx-4',21.5,3,80,110,2720,13.5,77,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mazda rx-7 gs',23.7,3,70,100,2420,12.5,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercedes benz 300d',25.4,5,183,77,3530,20.1,79,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercedes-benz 240d',30,4,146,67,3250,21.8,80,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercedes-benz 280s',16.5,6,168,120,3820,16.7,76,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercury capri 2000',23,4,122,86,2220,14,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercury capri v6',21,6,155,107,2472,14,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercury cougar brougham',15,8,302,130,4295,14.9,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercury grand marquis',16.5,8,351,138,3955,13.2,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercury lynx l',36,4,98,70,2125,17.3,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercury marquis',11,8,429,208,4633,11,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercury marquis brougham',12,8,429,198,4952,11.5,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercury monarch',15,6,250,72,3432,21,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercury monarch ghia',20.2,8,302,139,3570,12.8,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercury zephyr',20.8,6,200,85,3070,16.7,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('mercury zephyr 6',19.8,6,200,85,2990,18.2,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('nissan stanza xe',36,4,120,88,2160,14.5,82,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('oldsmobile cutlass ciera (diesel)',38,6,262,85,3015,17,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('oldsmobile cutlass ls',26.6,8,350,105,3725,19,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('oldsmobile cutlass salon brougham',19.9,8,260,110,3365,15.5,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('oldsmobile cutlass salon brougham',23.9,8,260,90,3420,22.2,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('oldsmobile cutlass supreme',17,8,260,110,4060,19,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('oldsmobile delta 88 royale',12,8,350,160,4456,13.5,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('oldsmobile omega',11,8,350,180,3664,11,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('oldsmobile omega brougham',26.8,6,173,115,2700,12.9,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('oldsmobile starfire sx',23.8,4,151,85,2855,17.6,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('oldsmobile vista cruiser',12,8,350,180,4499,12.5,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('opel 1900',25,4,116,81,2220,16.9,76,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('opel 1900',28,4,116,90,2123,14,71,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('opel manta',24,4,116,75,2158,15.5,73,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('opel manta',26,4,97,78,2300,14.5,74,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('peugeot 304',30,4,79,70,2074,19.5,71,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('peugeot 504',19,4,120,88,3270,21.9,76,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('peugeot 504',23,4,120,88,2957,17,75,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('peugeot 504',25,4,110,87,2672,17.5,70,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('peugeot 504',27.2,4,141,71,3190,24.8,79,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('peugeot 504 (sw)',21,4,120,87,2979,19.5,72,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('peugeot 505s turbo diesel',28.1,4,141,80,3230,20.4,81,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('peugeot 604sl',16.2,6,163,133,3410,15.8,78,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth arrow gs',25.5,4,122,96,2300,15.5,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth champ',39,4,86,64,1875,16.4,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth cricket',26,4,91,70,1955,20.5,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth ''cuda 340',14,8,340,160,3609,8,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth custom suburb',13,8,360,170,4654,13,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth duster',20,6,198,95,3102,16.5,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth duster',22,6,198,95,2833,15.5,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth duster',23,6,198,95,2904,16,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth fury',18,6,225,95,3785,19,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth fury gran sedan',14,8,318,150,4237,14.5,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth fury III',14,8,318,150,4096,13,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth fury III',14,8,440,215,4312,8.5,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth fury III',15,8,318,150,4135,13.5,72,1)
SELECT * FROM DUAL;

INSERT ALL
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth grand fury',16,8,318,150,4498,14.5,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth horizon',34.2,4,105,70,2200,13.2,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth horizon 4',34.7,4,105,63,2215,14.9,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth horizon miser',38,4,105,63,2125,14.7,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth horizon tc3',34.5,4,105,70,2150,14.9,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth reliant',27.2,4,135,84,2490,15.7,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth reliant',30,4,135,84,2385,12.9,81,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth sapporo',23.2,4,156,105,2745,16.7,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth satellite',18,8,318,150,3436,11,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth satellite (sw)',null,8,383,175,4166,10.5,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth satellite custom',16,6,225,105,3439,15.5,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth satellite custom (sw)',14,8,318,150,4077,14,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth satellite sebring',18,6,225,105,3613,16.5,74,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth valiant',18,6,225,105,3121,16.5,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth valiant',22,6,225,100,3233,15.4,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth valiant custom',19,6,225,95,3264,16,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth volare',20.5,6,225,100,3430,17.2,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth volare custom',19,6,225,100,3630,17.7,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('plymouth volare premier v8',13,8,318,150,3940,13.2,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac astro',23,4,140,78,2592,18.5,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac catalina',14,8,400,175,4385,12,72,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac catalina',14,8,455,225,4425,10,70,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac catalina',16,8,400,170,4668,11.5,75,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac catalina brougham',14,8,400,175,4464,11.5,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac firebird',19,6,250,100,3282,15,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac grand prix',16,8,400,230,4278,9.5,73,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac grand prix lj',16,8,400,180,4220,11.1,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac j2000 se hatchback',31,4,112,85,2575,16.2,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac lemans v6',21.5,6,231,115,3245,15.4,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac phoenix',27,4,151,90,2735,18,82,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac phoenix',33.5,4,151,90,2556,13.2,79,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac phoenix lj',19.2,6,231,105,3535,19.2,78,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac safari (sw)',13,8,400,175,5140,12,71,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac sunbird coupe',24.5,4,151,88,2740,16,77,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('pontiac ventura sj',18.5,6,250,110,3645,16.2,76,1)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('renault 12 (sw)',26,4,96,69,2189,18,72,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('renault 12tl',27,4,101,83,2202,15.3,76,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('renault 18i',34.5,4,100,null,2320,15.8,81,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('renault 5 gtl',36,4,79,58,1825,18.6,77,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('renault lecar deluxe',40.9,4,85,null,1835,17.3,80,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('saab 900s',null,4,121,110,2800,15.4,81,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('saab 99e',25,4,104,95,2375,17.5,70,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('saab 99gle',21.6,4,121,115,2795,15.7,78,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('saab 99le',24,4,121,110,2660,14,73,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('saab 99le',25,4,121,115,2671,13.5,75,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('subaru',26,4,108,93,2391,15.5,74,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('subaru',32.3,4,97,67,2065,17.8,81,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('subaru dl',30,4,97,67,1985,16.4,77,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('subaru dl',33.8,4,97,67,2145,18,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota carina',20,4,97,88,2279,19,73,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota celica gt',32,4,144,96,2665,13.9,82,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota celica gt liftback',21.1,4,134,95,2515,14.8,78,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corolla',28,4,97,75,2155,16.4,76,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corolla',29,4,97,75,2171,16,75,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corolla',32.2,4,108,75,2265,15.2,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corolla',32.4,4,108,75,2350,16.8,81,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corolla',34,4,108,70,2245,16.9,82,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corolla 1200',31,4,71,65,1773,19,71,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corolla 1200',32,4,71,65,1836,21,74,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corolla 1600 (sw)',27,4,97,88,2100,16.5,72,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corolla liftback',26,4,97,75,2265,18.2,77,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corolla tercel',38.1,4,89,60,1968,18.8,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corona',24,4,134,96,2702,13.5,75,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corona',25,4,113,95,2228,14,71,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corona',27.5,4,134,95,2560,14.2,78,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corona',31,4,76,52,1649,16.5,74,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corona hardtop',24,4,113,95,2278,15.5,72,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corona liftback',29.8,4,134,90,2711,15.5,80,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corona mark II',24,4,113,95,2372,15,70,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota corona mark II (sw)',23,4,120,97,2506,14.5,72,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota cressida',25.4,6,168,116,2900,12.6,81,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota mark II',19,6,156,108,2930,15.5,76,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota mark II',20,6,156,122,2807,13.5,73,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota starlet',39.1,4,79,58,1755,16.9,81,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('toyota tercel',37.7,4,89,62,2050,17.3,81,3)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('triumph tr7 coupe',35,4,122,88,2500,15.1,80,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('vokswagen rabbit',29.8,4,89,62,1845,15.3,80,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen 1131 deluxe sedan',26,4,97,46,1835,20.5,70,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen 411 (sw)',22,4,121,76,2511,18,72,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen dasher',25,4,90,71,2223,16.5,75,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen dasher',26,4,79,67,1963,15.5,74,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen dasher',30.5,4,97,78,2190,14.1,77,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen dasher (diesel)',43.4,4,90,48,2335,23.7,80,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen jetta',33,4,105,74,2190,14.2,81,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen model 111',27,4,97,60,1834,19,71,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen pickup',44,4,97,52,2130,24.6,82,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen rabbit',29,4,90,70,1937,14,75,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen rabbit',29,4,90,70,1937,14.2,76,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen rabbit',29.5,4,97,71,1825,12.2,76,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen rabbit',41.5,4,98,76,2144,14.7,80,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen rabbit c (diesel)',44.3,4,90,48,2085,21.7,80,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen rabbit custom',29,4,97,78,1940,14.5,77,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen rabbit custom',31.9,4,89,71,1925,14,79,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen rabbit custom diesel',43.1,4,90,48,1985,21.5,78,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen rabbit l',36,4,105,74,1980,15.3,82,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen scirocco',31.5,4,89,71,1990,14.9,78,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen super beetle',26,4,97,46,1950,21,73,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen super beetle 117',null,4,97,48,1978,20,71,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volkswagen type 3',23,4,97,54,2254,23.5,72,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volvo 144ea',19,4,121,112,2868,15.5,73,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volvo 145e (sw)',18,4,121,112,2933,14.5,72,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volvo 244dl',22,4,121,98,2945,14.5,75,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volvo 245',20,4,130,102,3150,15.7,76,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volvo 264gl',17,6,163,125,3140,13.6,78,2)
INTO ODMR_CARS_DATA (NAME,MPG,CYLINDERS,DISPLACEMENT,HORSEPOWER,WEIGHT,ACCELERATION,MODEL_YEAR,ORIGIN) values ('volvo diesel',30.7,6,145,76,3160,19.6,81,2)
SELECT * FROM DUAL;
commit;
