<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:oja="http://xmlns.oracle.com/jdeveloper/1013/audit"
                xmlns="http://www.w3.org/1999/xhtml"
                exclude-result-prefixes="xsl oja">

  <!--
  - Converts Audit report XML to an HTML document containing a table of contents,
  - and for each model, a table with a row for each violation in the model,
  - containing the line number, the severity, the message, and a link to a
  - description of the violated rule.
  -->


  <!--
  - This style sheet outputs HTML, by default using the UTF-8 encoding. When 
  - Audit applies the style sheet, it overrides the encoding attribute to the
  - global JDeveloper encoding.
  -->
  <xsl:output method="html"/>


  <!--
  - The character sequence to use when outputting a line break.
  -
  - Unlike XML document consumers, some text document consumers expect a
  - particular line terminator sequence. Audit generates the XML document
  - using the line terminator indicated in the JDeveloper environment options,
  - and sets this parameter to the same line terminator sequence so that a 
  - and sets this parameter to te same line terminator sequence so that a
  - careful style sheet can ensure that the output file has consistent
  - line terminators.
  -->
  <xsl:param name="newline">
<xsl:text>
</xsl:text>
  </xsl:param>

  <!-- 
  -  Apply a template to each model in the tree.
  -->
  <xsl:template match="/">
    <html>
      <head>
        <title>
          <xsl:value-of select="/oja:profile-report/oja:title"/>
        </title>
        <!-- Still looking for a better way to get consistent line breaks... -->
        <style type="text/css">
          <xsl:value-of select="$newline"/>
          <xsl:text>          H1, H2, TH { BORDER: #cccc99 0px solid; BORDER-BOTTOM: #cccc99 2px solid; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          H1, H2, H3, H4, P, TH, TD { FONT-FAMILY: sans-serif; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          H1, H3, H4, P, TH, TD { BACKGROUND-COLOR: #ffffff; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          H1, H2, H3 { COLOR: #336699; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          H4, P, TH, TD { COLOR: #000000; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          H1 { FONT-SIZE: 170%; WIDTH: 100%; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          H2 { BACKGROUND-COLOR: #cccc99; FONT-SIZE: 130%; WIDTH: 100%; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          H3 { FONT-SIZE: 110%; WIDTH: 100%; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          H4 { FONT-SIZE: 11pt; FONT-WEIGHT: bold; WIDTH: 100%; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          P { FONT-SIZE: 10pt; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          TABLE { BORDER: #cccc99 2px solid; BORDER-COLLAPSE: COLLAPSE; MARGIN-BOTTOM: 12px; PAGE-BREAK-INSIDE: AVOID; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          TR { PAGE-BREAK-INSIDE: AVOID; TEXT-ALIGN: left; VERTICAL-ALIGN: top; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          TH { COLOR: #000000; FONT-WEIGHT: bold; TEXT-ALIGN: left; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          TD { COLOR: #000000; FONT-SIZE: 10pt; TEXT-ALIGN: left; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          TH { FONT-SIZE: 8pt; TEXT-ALIGN: left; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          .line { WIDTH: 30pt; PADDING-RIGHT: 20pt; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          TH.line { TEXT-ALIGN: center; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          TD.line { TEXT-ALIGN: right; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          .severity .fixes { PADDING-RIGHT: 20pt; WIDTH: 60pt; }</xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          .heading { COLOR: #000000; FONT-WEIGHT: bold; TEXT-ALIGN: left;}
          </xsl:text>
          <xsl:value-of select="$newline"/>
          <xsl:text>          .value .none { }
          </xsl:text>
          <xsl:value-of select="$newline"/>

          <xsl:text>        </xsl:text>
        </style>
      </head>
      <body>
        <h1>
          <xsl:text>Profile Report for </xsl:text><xsl:value-of select="/oja:profile-report/oja:title"/>
        </h1>
        <div>
          <a href="#Profile">Profile</a>
        </div>
        <div>
          <a href="#Rules">Rules</a>
        </div>
        <div>
          <a href="#Assists">Assists</a>
        </div>
        <div>
          <a href="#Metrics">Metrics</a>
        </div>
        <xsl:apply-templates>
          <xsl:sort select="/oja:rules/oja:rule/oja:category"/>
        </xsl:apply-templates>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="/oja:profile-report/oja:profile">
    <h3>
      <a name="Profile">Profile:</a>
    </h3>
    <table width="100%">
      <tr>
        <td class="heading">
          <xsl:text>Name:</xsl:text>
        </td>
        <td class="value">
          <xsl:value-of select="oja:name"/>
        </td>
      </tr>
      <tr>
        <td class="heading">
          <xsl:text>Key:</xsl:text>
        </td>
        <td>
          <xsl:choose>
            <xsl:when test="string-length(oja:key) &gt; 0">
          <xsl:value-of select="oja:key"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>No Key Specified</xsl:text>
          </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
      <tr>
        <td class="heading">
          <xsl:text>isDefault:</xsl:text>
        </td>
        <td class="value">
          <xsl:value-of select="oja:default"/>
        </td>
      </tr>
      <tr>
        <td class="heading">
          <xsl:text>Url:</xsl:text>
        </td>
        <td class="value">
          <xsl:value-of select="oja:url"/>
        </td>
      </tr>

    </table>
  </xsl:template>


  <!-- RULES section -->
  <xsl:template match="/oja:profile-report/oja:rules">
    <h3>
      <a name="Rules">Rules:</a>
    </h3>
    <xsl:for-each select="oja:rule">
      <xsl:call-template name="rule_assist"/>
    </xsl:for-each>
  </xsl:template>

  <!-- Assists section -->
  <xsl:template match="/oja:profile-report/oja:assists">
    <h3>
      <a name="Assists">Assists:</a>
    </h3>
    <xsl:for-each select="oja:assist">
      <xsl:call-template name="rule_assist"/>
    </xsl:for-each>
  </xsl:template>

  <!-- rules and assists only vary by category so use the same template to process them -->
  <xsl:template name="rule_assist">
    <table border="1" style="width: 100%">
      <tbody>
        <tr>
          <td class="heading">
            <xsl:text>Name / ID</xsl:text>
          </td>
          <td class="heading">
            <xsl:text>Category</xsl:text>
          </td>
          <td class="heading">
            <xsl:text>Parameters</xsl:text>
          </td>
        </tr>
        <tr>
          <td>
            <div>

              <xsl:value-of select="oja:name"/>
              <xsl:text>&nbsp;/&nbsp;</xsl:text>
              <xsl:value-of select="@id"/>

            </div>
          </td>
          <td>
            <xsl:value-of select="oja:category"/>
          </td>
          <td>
            <xsl:choose>
              <xsl:when test="count(oja:rule-params/oja:rule-param) &gt; 0">
                <xsl:for-each select="oja:rule-params/oja:rule-param">

                  <div>
                    <span class="heading">
                      <xsl:text>Name:&nbsp;</xsl:text>
                    </span>
                    <xsl:value-of select="oja:param-name"/>
                  </div>
                  <div>
                    <span class="heading">
                      <xsl:text>Required:&nbsp;</xsl:text>
                    </span>
                    <xsl:value-of select="oja:param-required"/>
                  </div>
                  <div>
                    <span class="heading">
                      <xsl:text>Type:&nbsp;</xsl:text>
                    </span>
                    <xsl:value-of select="oja:param-type"/>
                  </div>
                </xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>No Parameters specified</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr class="heading">
          <td colspan="2">Description</td>
          <td>Settings</td>
        </tr>
        <tr>
          <td colspan="2">
            <xsl:choose>
              <xsl:when test="string-length(oja:description) &gt; 0">
                <xsl:value-of select="oja:description"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>No Description</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </td>
          <td>

            <div>
              <span class="heading">
                <xsl:text>Style:&nbsp;</xsl:text>
              </span>
              <xsl:value-of select="oja:style"/>
            </div>
            <div>
              <span class="heading">
                <xsl:text>Severity:&nbsp;</xsl:text>
              </span>
              <xsl:value-of select="oja:severity"/>
            </div>
            <div>
              <span class="heading">
                <xsl:text>Enabled:&nbsp;</xsl:text>
              </span>
              <xsl:value-of select="@enabled"/>
            </div>

          </td>
        </tr>
        <tr class="heading">
          <td>DefaultTransform:</td>
          <td colspan="2">Transforms:</td>
        </tr>
        <tr>
          <td>
            <xsl:choose>
              <xsl:when test="count(oja:defaultTransform/oja:transform) &gt; 0">
                <xsl:for-each select="oja:defaultTransform/oja:transform">
                  <div>
                    <span class="heading">
                      <xsl:text>Transform Name:&nbsp;</xsl:text>
                    </span>
                    <xsl:value-of select="oja:name"/>
                  </div>
                  <xsl:if test="string-length(oja:description) &gt; 0">

                    <div>
                      <span class="heading">
                        <xsl:text>Description:&nbsp;</xsl:text>
                      </span>
                      <xsl:value-of select="oja:description"/>
                    </div>
                  </xsl:if>
                  <div>
                    <span class="heading">
                      <xsl:text>ID:&nbsp;</xsl:text>
                    </span>
                    <xsl:value-of select="@id"/>
                  </div>
                </xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>No Default Transform</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </td>
          <td colspan="2">
            <xsl:choose>
              <xsl:when test="count(oja:transforms/oja:transform) &gt; 0">
                <table border="0" class="none" style="border-color:white">

                  <xsl:for-each select="oja:transforms/oja:transform">
                    <tr>
                      <td>
                        <span class="heading" style="align:center;vertical-align:center">&nbsp;<xsl:value-of
                            select="position()"/>&nbsp;
                        </span>
                      </td>
                      <td>
                        <div>
                          <span class="heading">
                            <xsl:text>Transform Name:&nbsp;</xsl:text>
                          </span>
                          <xsl:value-of select="oja:name"/>
                        </div>
                        <xsl:if test="string-length(oja:description) &gt; 0">

                          <div>
                            <span class="heading">
                              <xsl:text>Description:&nbsp;</xsl:text>
                            </span>
                            <xsl:value-of select="oja:description"/>
                          </div>
                        </xsl:if>

                        <div>
                          <span class="heading">
                            <xsl:text>ID:&nbsp;</xsl:text>
                          </span>
                          <xsl:value-of select="@id"/>
                        </div>
                      </td>
                    </tr>
                  </xsl:for-each>
                </table>

              </xsl:when>
              <xsl:otherwise>
                <xsl:text>No Transforms</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <xsl:if test="string-length(oja:tip) &gt; 0">
          <tr>
            <td colspan="3">
              <span class="heading">
                <xsl:text>ToolTip:&nbsp;</xsl:text>
              </span>
              <xsl:value-of select="oja:tip"/>
            </td>
          </tr>
        </xsl:if>
      </tbody>
    </table>
  </xsl:template>


  <!-- Metrics section -->
  <xsl:template match="/oja:profile-report/oja:metrics">
    <h3>
      <a name="Metrics">Metrics:</a>
    </h3>
    <xsl:for-each select="oja:metric">   
      <table border="1" style="width: 100%">
        <tbody>
          <tr>
            <td class="heading">
              <xsl:text>Name</xsl:text>
            </td>
            <td class="heading" colspan="2">
              <xsl:text>Category</xsl:text>
            </td>

          </tr>
          <tr>
            <td>
              <xsl:value-of select="oja:name"/>
            </td>
            <td colspan="2">
              <xsl:value-of select="oja:category"/>
            </td>
          </tr>
          <tr>
            <td colspan="3" class="heading">Description</td>
          </tr>
          <tr>
            <td colspan="3">
              <xsl:value-of select="oja:description"/>
            </td>
          </tr>
          <tr>
            <td class="heading">
              <xsl:text>Type</xsl:text>
            </td>
            <td class="heading">
              <xsl:text>Threshhold</xsl:text>
            </td>
            <td class="heading">
              <xsl:text>Tip</xsl:text>
            </td>
          </tr>
          <tr>
            <td>
              <xsl:value-of select="oja:type"/>
            </td>
            <td>
              <xsl:choose>
                <xsl:when test="string-length(oja:threshhold) &gt; 0">
                  <xsl:value-of select="oja:threshhold"/>
                </xsl:when>
                <xsl:otherwise>
                  no Threshhold
                </xsl:otherwise>
              </xsl:choose>
            </td>
            <td>
              <xsl:choose>
                <xsl:when test="string-length(oja:tip) &gt; 0">
                  <xsl:value-of select="oja:tip"/>
                </xsl:when>
                <xsl:otherwise>
                  No ToolTip
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </tbody>
      </table>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>