<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:oja="http://xmlns.oracle.com/jdeveloper/1013/audit"
  xmlns="http://www.w3.org/1999/xhtml"
  exclude-result-prefixes="xsl oja" >

  <!--
  - Converts Audit report XML to an HTML document containing a table of contents,
  - and for each model, a table with a row for each violation in the model,
  - containing the line number, the severity, the message, and a link to a
  - description of the violated rule.
  -->

  
  <!--
  - This style sheet outputs HTML, by default using the UTF-8 encoding. When 
  - Audit applies the style sheet, it overrides the encoding attribute to the
  - global JDeveloper encoding.
  -->
  <xsl:output method="html"/>

  
  <!--
  - The character sequence to use when outputting a line break.
  -
  - Unlike XML document consumers, some text document consumers expect a
  - particular line terminator sequence. Audit generates the XML document
  - using the line terminator indicated in the JDeveloper environment options,
  - and sets this parameter to the same line terminator sequence so that a 
  - careful style sheet can ensure that the output file has consistent
  - line terminators.
  -->
  <xsl:param name="newline">
<xsl:text>
</xsl:text>
  </xsl:param>

  <!-- 
  -  Apply a template to each model in the tree.
  -->
  <xsl:template match="/">
    <html>
      <head>
        <title><xsl:value-of select="/oja:audit/oja:title"/></title>
        <!-- Still looking for a better way to get consistent line breaks... -->
        <style type="text/css">
          <xsl:value-of select="$newline"/>
          <xsl:text>          H1, H2, TH { BORDER: #cccc99 0px solid; BORDER-BOTTOM: #cccc99 2px solid; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          H1, H2, H3, H4, P, TH, TD { FONT-FAMILY: sans-serif; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          H1, H3, H4, P, TH, TD { BACKGROUND-COLOR: #ffffff; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          H1, H2, H3 { COLOR: #336699; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          H4, P, TH, TD { COLOR: #000000; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          H1 { FONT-SIZE: 170%; WIDTH: 100%; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          H2 { BACKGROUND-COLOR: #cccc99; FONT-SIZE: 130%; WIDTH: 100%; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          H3 { FONT-SIZE: 110%; WIDTH: 100%; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          H4 { FONT-SIZE: 11pt; FONT-WEIGHT: bold; WIDTH: 100%; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          P { FONT-SIZE: 10pt; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          TABLE { BORDER: #cccc99 2px solid; BORDER-COLLAPSE: COLLAPSE; MARGIN-BOTTOM: 12px; PAGE-BREAK-INSIDE: AVOID; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          TR { PAGE-BREAK-INSIDE: AVOID; TEXT-ALIGN: left; VERTICAL-ALIGN: top; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          TH { COLOR: #000000; FONT-WEIGHT: bold; TEXT-ALIGN: left; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          TD { COLOR: #000000; FONT-SIZE: 10pt; TEXT-ALIGN: left; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          TH { FONT-SIZE: 8pt; TEXT-ALIGN: left; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          .line { WIDTH: 30pt; PADDING-RIGHT: 20pt; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          TH.line { TEXT-ALIGN: center; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          TD.line { TEXT-ALIGN: right; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>          .severity .fixes { PADDING-RIGHT: 20pt; WIDTH: 60pt; }</xsl:text> <xsl:value-of select="$newline"/>
          <xsl:text>        </xsl:text></style>
      </head>
      <body>
        <h1><xsl:value-of select="/oja:audit/oja:title"/></h1>
        <xsl:apply-templates select="/oja:audit/oja:models/oja:model"/>
      </body>
    </html>
  </xsl:template>

  <!--
  - For a model, IF it has violations, output a heading element, output a 
  - <table> tag, output the header row, apply a template to each violation 
  - whose model is the current model, and output a </table> tag.
  -->
  <xsl:template match="oja:model">
    <xsl:variable name="violations" select="/oja:audit//oja:construct[oja:location/@model = current()/@id]/oja:children/oja:violation"/>
    <xsl:if test="count($violations) > 0">
      <h2><xsl:value-of select="oja:file/oja:path"/></h2>
      <table width="100%">
        <tr>
          <th class="line">Line</th>
          <th class="severity">Severity</th>
          <th>Message</th>
          <th>Fixes Applied</th>
        </tr>
        <xsl:apply-templates select="$violations"/>
      </table>
    </xsl:if>
  </xsl:template>

  <!--
  - For a violation, output the table cells. The rule severity is
  - obtained by dereferencing the rule attribute of the violation.
  -->
  <xsl:template match="oja:violation">
    <tr>
      <td class="line"><xsl:value-of select="oja:location/oja:line-number"/></td>
      <td class="severity"><xsl:value-of select="id(@rule)/oja:severity"/></td>
      <td><xsl:value-of select="oja:message"/></td>
      <td class="fixes"><xsl:apply-templates select="oja:transforms-applied/oja:transform-applied"/></td>
    </tr>
  </xsl:template>

  <!--
  - For an applied transform, output the transform name.
  -->
  <xsl:template match="oja:transform-applied">
    <xsl:value-of select="id(@transform)/oja:label"/>
  </xsl:template>

</xsl:stylesheet>
