/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.preferences.ClassificationModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.preferences.PreferencesLrb;
import oracle.dmt.dataminer.workflow.preferences.TestLiftProfitDialogPanel;
import oracle.ide.config.Preferences;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.PropertyStorage;

public class ClassificationModelBuildPreferencesPanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private ButtonGroup buttonGroup;
    private JCheckBox jAccuracyMetricsCheckBox;
    private JCheckBox jChkDT;
    private JCheckBox jChkGLM;
    private JCheckBox jChkNB;
    private JCheckBox jChkParallel;
    private JCheckBox jChkSVM;
    private JCheckBox jConfusionMatrixCheckBox;
    private JLabel jCreateSplitAsLabel;
    private JButton jEditTargetsButton;
    private JLabel jLabel;
    private JCheckBox jLiftProfitCheckBox;
    private JLabel jLiftProfitTargetSelectionLabel;
    private JCheckBox jROCCheckBox;
    private JRadioButton jRadioAllData;
    private JRadioButton jRadioSplit;
    private JRadioButton jRadioTest;
    private JComboBox<String> jSplitTableViewComboBox;
    private JLabel jSplitTestPercentLabel;
    private JLabel jTestDataLabel;
    private JSpinner jTestDataPercentSpinner;
    private JLabel jTestResultsLabel;
    private JCheckBox jTuneCheckBox;

    public ClassificationModelBuildPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jLabel = new JLabel();
        this.jChkDT = new JCheckBox();
        this.jChkGLM = new JCheckBox();
        this.jChkNB = new JCheckBox();
        this.jChkSVM = new JCheckBox();
        this.jTestResultsLabel = new JLabel();
        this.jAccuracyMetricsCheckBox = new JCheckBox();
        this.jConfusionMatrixCheckBox = new JCheckBox();
        this.jROCCheckBox = new JCheckBox();
        this.jLiftProfitCheckBox = new JCheckBox();
        this.jLiftProfitTargetSelectionLabel = new JLabel();
        this.jEditTargetsButton = new JButton();
        this.jTuneCheckBox = new JCheckBox();
        this.jTestDataLabel = new JLabel();
        this.jRadioAllData = new JRadioButton();
        this.jRadioSplit = new JRadioButton();
        this.jSplitTestPercentLabel = new JLabel();
        this.jTestDataPercentSpinner = new JSpinner();
        this.jCreateSplitAsLabel = new JLabel();
        this.jSplitTableViewComboBox = new JComboBox();
        this.jChkParallel = new JCheckBox();
        this.jRadioTest = new JRadioButton();
        this.jLabel.setText("Automatic Model Generation");
        this.jChkDT.setText("jCheckBox1");
        this.jChkGLM.setText("jCheckBox1");
        this.jChkNB.setText("jCheckBox1");
        this.jChkSVM.setText("jCheckBox1");
        this.jTestResultsLabel.setText("Test Results");
        this.jAccuracyMetricsCheckBox.setText("Accuracy Metrics");
        this.jAccuracyMetricsCheckBox.setOpaque(false);
        this.jAccuracyMetricsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationModelBuildPreferencesPanel.this.jAccuracyMetricsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jConfusionMatrixCheckBox.setText("Confusion Matrix");
        this.jConfusionMatrixCheckBox.setOpaque(false);
        this.jConfusionMatrixCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationModelBuildPreferencesPanel.this.jConfusionMatrixCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jROCCheckBox.setText("ROC Curve (Binary Class Only)");
        this.jROCCheckBox.setOpaque(false);
        this.jROCCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationModelBuildPreferencesPanel.this.jROCCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jLiftProfitCheckBox.setText("Lift and Profit");
        this.jLiftProfitCheckBox.setOpaque(false);
        this.jLiftProfitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationModelBuildPreferencesPanel.this.jLiftProfitCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jLiftProfitTargetSelectionLabel.setText("Top 5 target class values by frequency");
        this.jEditTargetsButton.setText("Edit...");
        this.jTuneCheckBox.setText("Generate Selected Test Results for Model Tuning");
        this.jTuneCheckBox.setOpaque(false);
        this.jTestDataLabel.setText("Test Data");
        this.buttonGroup.add(this.jRadioAllData);
        this.jRadioAllData.setText("Use All Mining Build Data for Testing");
        this.jRadioAllData.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioAllData.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioAllData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationModelBuildPreferencesPanel.this.jRadioAllDataActionPerformed(actionEvent);
            }
        });
        this.buttonGroup.add(this.jRadioSplit);
        this.jRadioSplit.setText("Use Split Build Data for Testing");
        this.jRadioSplit.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioSplit.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationModelBuildPreferencesPanel.this.jRadioSplitActionPerformed(actionEvent);
            }
        });
        this.jSplitTestPercentLabel.setText("Split for Test (%):");
        this.jTestDataPercentSpinner.setModel(new SpinnerNumberModel(40, 0, 100, 10));
        this.jCreateSplitAsLabel.setText("Create Split as:");
        this.jSplitTableViewComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationModelBuildPreferencesPanel.this.jSplitTableViewComboBoxActionPerformed(actionEvent);
            }
        });
        this.jChkParallel.setText("Parallel");
        this.buttonGroup.add(this.jRadioTest);
        this.jRadioTest.setText("Use Test Data Source for Testing");
        this.jRadioTest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioTest.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationModelBuildPreferencesPanel.this.jRadioTestActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel, -1, -1, Short.MAX_VALUE).addGap(12, 12, 12)).addGroup(groupLayout.createSequentialGroup().addGap(24, 24, 24).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jChkDT, -2, 205, -2).addComponent(this.jChkGLM, -2, 205, -2).addComponent(this.jChkNB, -2, 205, -2).addComponent(this.jChkSVM, -2, 205, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jConfusionMatrixCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jROCCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jAccuracyMetricsCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jLiftProfitCheckBox, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTuneCheckBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jLiftProfitTargetSelectionLabel, -2, 275, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEditTargetsButton).addGap(0, 0, Short.MAX_VALUE)))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTestResultsLabel, -2, 140, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTestDataLabel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioSplit, -2, 373, -2).addComponent(this.jRadioAllData, -2, 372, -2).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCreateSplitAsLabel, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSplitTableViewComboBox, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSplitTestPercentLabel, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTestDataPercentSpinner, -2, 47, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChkParallel, -2, 104, -2)).addComponent(this.jRadioTest)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this.jChkDT, this.jChkGLM, this.jChkNB, this.jChkSVM);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jChkDT).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jChkGLM).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jChkNB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jChkSVM).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTestResultsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAccuracyMetricsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jConfusionMatrixCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jROCCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLiftProfitCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLiftProfitTargetSelectionLabel).addComponent(this.jEditTargetsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTuneCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTestDataLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioAllData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioSplit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSplitTestPercentLabel).addComponent(this.jTestDataPercentSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCreateSplitAsLabel).addComponent(this.jSplitTableViewComboBox, -2, -1, -2).addComponent(this.jChkParallel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioTest).addContainerGap(18, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jChkDT, this.jChkGLM, this.jChkNB, this.jChkSVM);
    }

    private void jAccuracyMetricsCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.jAccuracyMetricsCheckBox.isSelected()) {
            this.jROCCheckBox.setSelected(false);
            this.jLiftProfitCheckBox.setSelected(false);
            this.jTuneCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jConfusionMatrixCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.jConfusionMatrixCheckBox.isSelected()) {
            this.jROCCheckBox.setSelected(false);
            this.jLiftProfitCheckBox.setSelected(false);
            this.jTuneCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jROCCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.jROCCheckBox.isSelected()) {
            this.jAccuracyMetricsCheckBox.setSelected(true);
            this.jConfusionMatrixCheckBox.setSelected(true);
        }
        this.enableControls();
    }

    private void jLiftProfitCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.jLiftProfitCheckBox.isSelected()) {
            this.jAccuracyMetricsCheckBox.setSelected(true);
            this.jConfusionMatrixCheckBox.setSelected(true);
        }
        this.enableControls();
    }

    private void jRadioAllDataActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jRadioSplitActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jSplitTableViewComboBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jRadioTestActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    @Override
    public void initRes() {
        this.jLabel.setText(PreferencesLrb.get("AUTO_MODEL_GENERATION"));
        this.jChkDT.setText(PreferencesLrb.get("DECISION_TREE_CHECK"));
        this.jChkNB.setText(PreferencesLrb.get("NAIVE_BAYES_CHECK"));
        this.jChkGLM.setText(PreferencesLrb.get("GENERAL_LINEAR_CHECK"));
        this.jChkSVM.setText(PreferencesLrb.get("SUPPORT_VECTOR_CHECK"));
        this.jTestResultsLabel.setText(PreferencesLrb.get("TEST_RESULTS"));
        this.jAccuracyMetricsCheckBox.setText(PreferencesLrb.get("TEST_ACCURACY_METRICS"));
        this.jConfusionMatrixCheckBox.setText(PreferencesLrb.get("TEST_CONFUSION_MATRIX"));
        this.jROCCheckBox.setText(PreferencesLrb.get("TEST_ROC"));
        this.jLiftProfitCheckBox.setText(PreferencesLrb.get("TEST_LIFT_N_PROFIT"));
        this.jEditTargetsButton.setText(PreferencesLrb.get("TEST_EDIT"));
        this.jTuneCheckBox.setText(PreferencesLrb.get("TEST_TUNING"));
        this.jTestDataLabel.setText(PreferencesLrb.get("TEST_DATA"));
        this.jRadioAllData.setText(PreferencesLrb.get("TEST_ALL_BUILD_DATA"));
        this.jRadioSplit.setText(PreferencesLrb.get("TEST_SPLIT_BUILD_DATA"));
        this.jRadioTest.setText(PreferencesLrb.get("TEST_TEST_DATA"));
        this.jSplitTestPercentLabel.setText(PreferencesLrb.get("SPLIT_TEST_DATA_PERCENT"));
        this.jCreateSplitAsLabel.setText(PreferencesLrb.get("CREATE_SPLIT_AS_TABLE_VIEW"));
        this.jChkParallel.setText(PreferencesLrb.get("SPLIT_DATA_TABLE_PARALLEL_OPTION"));
        this.setHelpID("preferences_build_classification");
    }

    @Override
    public void initUI() {
        this.jLabel.setOpaque(true);
        this.jEditTargetsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestLiftProfitDialogPanel testLiftProfitDialogPanel = new TestLiftProfitDialogPanel();
                if (testLiftProfitDialogPanel.showAsDialog((Component)((Object)ClassificationModelBuildPreferencesPanel.this))) {
                    ClassificationModelBuildPreferencesPanelSettings classificationModelBuildPreferencesPanelSettings = ClassificationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)Preferences.getPreferences());
                    String string = null;
                    string = classificationModelBuildPreferencesPanelSettings.isTOPN() ? MessageFormat.format(PreferencesLrb.get("TEST_TOP_N_TARGETS"), classificationModelBuildPreferencesPanelSettings.getNTarget()) : MessageFormat.format(PreferencesLrb.get("TEST_BTN_N_TARGETS"), classificationModelBuildPreferencesPanelSettings.getNTarget());
                    ClassificationModelBuildPreferencesPanel.this.jLiftProfitTargetSelectionLabel.setText(string);
                }
            }
        });
        this.enableControls();
    }

    private void enableControls() {
        this.jTuneCheckBox.setEnabled(this.jROCCheckBox.isSelected() || this.jLiftProfitCheckBox.isSelected());
        boolean bl = this.jLiftProfitCheckBox.isSelected();
        this.jLiftProfitTargetSelectionLabel.setEnabled(bl);
        this.jEditTargetsButton.setEnabled(bl);
        boolean bl2 = this.jRadioSplit.isSelected();
        this.jTestDataPercentSpinner.setEnabled(bl2);
        this.jSplitTableViewComboBox.setEnabled(bl2);
        String string = (String)this.jSplitTableViewComboBox.getSelectedItem();
        this.jChkParallel.setEnabled(bl2 && ServerConstants.SplitDataFormat.isTable(ServerConstants.SplitDataFormat.toSchema(string)));
    }

    public void onEntry(TraversableContext traversableContext) {
        ClassificationModelBuildPreferencesPanelSettings classificationModelBuildPreferencesPanelSettings = ClassificationModelBuildPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this.jChkDT.setSelected(classificationModelBuildPreferencesPanelSettings.isDt());
        this.jChkGLM.setSelected(classificationModelBuildPreferencesPanelSettings.isGlm());
        this.jChkNB.setSelected(classificationModelBuildPreferencesPanelSettings.isNb());
        this.jChkSVM.setSelected(classificationModelBuildPreferencesPanelSettings.isSvm());
        this.jAccuracyMetricsCheckBox.setSelected(classificationModelBuildPreferencesPanelSettings.isAccuracyMetrics());
        this.jConfusionMatrixCheckBox.setSelected(classificationModelBuildPreferencesPanelSettings.isConfusionMatrix());
        this.jROCCheckBox.setSelected(classificationModelBuildPreferencesPanelSettings.isROC());
        this.jLiftProfitCheckBox.setSelected(classificationModelBuildPreferencesPanelSettings.isLift());
        String string = null;
        string = classificationModelBuildPreferencesPanelSettings.isTOPN() ? MessageFormat.format(PreferencesLrb.get("TEST_TOP_N_TARGETS"), classificationModelBuildPreferencesPanelSettings.getNTarget()) : MessageFormat.format(PreferencesLrb.get("TEST_BTN_N_TARGETS"), classificationModelBuildPreferencesPanelSettings.getNTarget());
        this.jLiftProfitTargetSelectionLabel.setText(string);
        this.jTuneCheckBox.setSelected(classificationModelBuildPreferencesPanelSettings.isTune());
        this.jRadioAllData.setSelected(classificationModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_ALL"));
        this.jRadioSplit.setSelected(classificationModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_SPLIT"));
        this.jRadioTest.setSelected(classificationModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_TEST"));
        this.jTestDataPercentSpinner.setValue(classificationModelBuildPreferencesPanelSettings.getTestSplitPercent());
        this.jSplitTableViewComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.SplitDataFormat.toHuman("Table"), ServerConstants.SplitDataFormat.toHuman("View")}));
        this.jSplitTableViewComboBox.setSelectedItem(ServerConstants.SplitDataFormat.toHuman(classificationModelBuildPreferencesPanelSettings.createSplitAsTable() ? "Table" : "View"));
        this.jChkParallel.setSelected(classificationModelBuildPreferencesPanelSettings.isParallelTable());
    }

    public void onExit(TraversableContext traversableContext) {
        ClassificationModelBuildPreferencesPanelSettings classificationModelBuildPreferencesPanelSettings = ClassificationModelBuildPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        classificationModelBuildPreferencesPanelSettings.setDt(this.jChkDT.isSelected());
        classificationModelBuildPreferencesPanelSettings.setGlm(this.jChkGLM.isSelected());
        classificationModelBuildPreferencesPanelSettings.setNb(this.jChkNB.isSelected());
        classificationModelBuildPreferencesPanelSettings.setSvm(this.jChkSVM.isSelected());
        classificationModelBuildPreferencesPanelSettings.setAccuracyMetrics(this.jAccuracyMetricsCheckBox.isSelected());
        classificationModelBuildPreferencesPanelSettings.setConfusionMatrix(this.jConfusionMatrixCheckBox.isSelected());
        classificationModelBuildPreferencesPanelSettings.setROC(this.jROCCheckBox.isSelected());
        classificationModelBuildPreferencesPanelSettings.setLift(this.jLiftProfitCheckBox.isSelected());
        classificationModelBuildPreferencesPanelSettings.setTune(this.jTuneCheckBox.isSelected());
        classificationModelBuildPreferencesPanelSettings.setTestDataOption(this.jRadioAllData.isSelected() ? "TEST_DATA_OPTION_ALL" : (this.jRadioSplit.isSelected() ? "TEST_DATA_OPTION_SPLIT" : "TEST_DATA_OPTION_TEST"));
        classificationModelBuildPreferencesPanelSettings.setTestSplitPercent((Integer)this.jTestDataPercentSpinner.getValue());
        String string = (String)this.jSplitTableViewComboBox.getSelectedItem();
        classificationModelBuildPreferencesPanelSettings.setCreateSplitAsTable(ServerConstants.SplitDataFormat.isTable(ServerConstants.SplitDataFormat.toSchema(string)));
        classificationModelBuildPreferencesPanelSettings.setParallelTable(this.jChkParallel.isSelected());
    }

    private static ClassificationModelBuildPreferencesPanelSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return ClassificationModelBuildPreferencesPanelSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

