/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;

public class CacheSettingsPanelSettings
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.dmt.dataminer.workflow.preferences.CacheSettingsPanelSettings";
    private static int _NUMBER_OF_ROWS = 2000;
    private static int _SEED = 12345;
    private static double _PERCENT = 60.0;

    static CacheSettingsPanelSettings getInstance() {
        return CacheSettingsPanelSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private CacheSettingsPanelSettings(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static CacheSettingsPanelSettings getInstance(PropertyStorage propertyStorage) {
        return new CacheSettingsPanelSettings(CacheSettingsPanelSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public void addStructureChangeListener(StructureChangeListener structureChangeListener) {
        this._hash.addStructureChangeListener(structureChangeListener);
    }

    public void removeStructureChangeListener(StructureChangeListener structureChangeListener) {
        this._hash.removeStructureChangeListener(structureChangeListener);
    }

    public boolean isRandom() {
        return this._hash.getBoolean("random", true);
    }

    public void setRandom(boolean bl) {
        this._hash.putBoolean("random", bl);
    }

    public int getSeed() {
        return this._hash.getInt("seed", _SEED);
    }

    public void setSeed(int n) {
        this._hash.putLong("seed", (long)n);
    }

    public void removeSeed() {
        this._hash.remove("seed");
    }

    public boolean isPercent() {
        return this._hash.getBoolean("sampling_percent", true);
    }

    public void setPercent(boolean bl) {
        this._hash.putBoolean("sampling_percent", bl);
    }

    public int getNumberOfRows() {
        return this._hash.getInt("sampling_number_of_rows", _NUMBER_OF_ROWS);
    }

    public void setNumberOfRows(int n) {
        this._hash.putInt("sampling_number_of_rows", n);
    }

    public void removeNumberOfRows() {
        this._hash.remove("sampling_number_of_rows");
    }

    public double getPercentValue() {
        return this._hash.getDouble("percent_value", _PERCENT);
    }

    public void setPercentValue(double d) {
        this._hash.putDouble("percent_value", d);
    }

    public void removePercentValue() {
        this._hash.remove("percent_value");
    }
}

