/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyOutputColumnNameGenerator;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.DynamicHelper;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.SampleSettingsProperties;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumns;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ParameterDataType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public abstract class DynamicNode
extends AbstractTransformNode
implements ApplyChainNode,
DataConsumer,
SampleSettingsProperties {
    private static final Logger theLogger = Logger.getLogger(DynamicNode.class.getName());
    protected Boolean _isEnableLegacyApplyOutputTypes;
    protected boolean _is12gDB;
    protected static final String SERVER_SQL_EXPRESSION = "SERVER_SQL_EXPRESSION";
    protected static final String CLIENT_SQL_EXPRESSION = "CLIENT_SQL_EXPRESSION";
    public static final String REFACTOR_SUPPLEMENTAL_COLUMNS = "refactorSupplementalColumns";
    protected static final String ALL_COLUMNS = NodeMessagesLrb.get("DYNAMIC_PREDICTION_INPUT");
    public static final String CASE_ATTRIBUTE = "CASE_ATTRIBUTE";
    public static final String CASE_ATTRIBUTE_SUPPLEMENTAL = "case_id_derived_supplementals";
    public static final String PARTITIONS_EXPRESSIONS = "PARTITIONS_EXPRESSIONS";
    public static final String PARTITION_EXPRESSIONS_ATTRIBUTES = "partition expressions attributes";
    public static final String PARTITION_EXPRESSIONS_SUPPLEMENTAL = "partition expressions derived supplementals";
    public static final String PREDICTIONS_ONLY = "Predictions Only";
    public static final String PARTITIONS_EXPRESSION_EDIT = "PARTITIONS_EXPRESSION_EDIT";
    public static final String PARTITIONS = "Partitions";
    public static final String SUPPLEMENTALS = "Supplementals";
    public static final String OUTPUT_SUPPLEMENTAL = "OUTPUT_SUPPLEMENTAL";
    protected DynamicApplyOutputColumnNameGenerator _outputColumnNameGenerator;

    public DynamicNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    public DynamicApplyOutputColumnNameGenerator getNameGenerator() {
        if (this._outputColumnNameGenerator == null) {
            this._outputColumnNameGenerator = new DynamicApplyOutputColumnNameGenerator(this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns());
        }
        return this._outputColumnNameGenerator;
    }

    public abstract DynamicNodeBaseSettingsType getDynamicNodeBaseSettingsType();

    @Override
    public abstract URL getNodeIcon();

    @Override
    public abstract Icon getExplorerIcon();

    @Override
    public abstract String getHelpTopic();

    @Override
    public abstract String generateSQLExpression();

    @Override
    public abstract Attributes getAttributes();

    @Override
    public abstract String getDefaultName();

    @Override
    public abstract void refactorForApply() throws Exception;

    protected void detectDBVersion() {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        try {
            Version version = connectionFolder.getDbVersion();
            this._is12gDB = ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true);
            this._isEnableLegacyApplyOutputTypes = connectionFolder.isEnableLegacyApplyOutputTypes(this.getContext());
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage(), exception);
        }
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        if (!super.isVersionSupported(context, stringBuffer)) {
            return false;
        }
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        if (!ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true)) {
            String string = MessageFormat.format(CodeGenLrb.get("VALIDATE_NODE_TYPE_NOT_SUPPORTED"), this.getDefaultName());
            stringBuffer.append(string);
            return false;
        }
        return true;
    }

    protected DynamicNodeBaseSettingsType initDynamicNodeBaseSettingsType() {
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = new DynamicNodeBaseSettingsType();
        CaseAttributes caseAttributes = new CaseAttributes();
        caseAttributes.getAttribute();
        dynamicNodeBaseSettingsType.setCaseAttributes(caseAttributes);
        MiningAttributes miningAttributes = new MiningAttributes();
        miningAttributes.getMiningAttribute();
        miningAttributes.setAutoSpec(AutoSpecType.YES);
        dynamicNodeBaseSettingsType.setMiningAttributes(miningAttributes);
        PartitionExpressions partitionExpressions = new PartitionExpressions();
        partitionExpressions.getPartitionExpression();
        dynamicNodeBaseSettingsType.setPartitionExpressions(partitionExpressions);
        DynamicApplyOutputColumns dynamicApplyOutputColumns = new DynamicApplyOutputColumns();
        dynamicApplyOutputColumns.getDynamicApplyOutputColumn();
        dynamicNodeBaseSettingsType.setDynamicApplyOutputColumns(dynamicApplyOutputColumns);
        SupplementalAttributesType supplementalAttributesType = new SupplementalAttributesType();
        supplementalAttributesType.getAttribute();
        supplementalAttributesType.setAutoSpec(AutoSpecType.YES);
        dynamicNodeBaseSettingsType.setSupplementalAttributes(supplementalAttributesType);
        return dynamicNodeBaseSettingsType;
    }

    protected DynamicHelper copyPreviousStateCommon(MiningAttributes miningAttributes, SupplementalAttributesType supplementalAttributesType, CaseAttributes caseAttributes, PartitionExpressions partitionExpressions) {
        Object object3;
        Object object22;
        MiningAttributes miningAttributes2 = new MiningAttributes();
        miningAttributes2.setAutoSpec(miningAttributes.getAutoSpec());
        for (Object object22 : miningAttributes.getMiningAttribute()) {
            object3 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(object22);
            miningAttributes2.getMiningAttribute().add(object3);
        }
        SupplementalAttributesType supplementalAttributesType2 = new SupplementalAttributesType();
        supplementalAttributesType2.setAutoSpec(supplementalAttributesType.getAutoSpec());
        for (Object object3 : supplementalAttributesType.getAttribute()) {
            Object object4 = (AttributeType)MetaDataHelper.copyMetadataObject(object3);
            supplementalAttributesType2.getAttribute().add(object4);
        }
        object22 = new CaseAttributes();
        for (Object object4 : caseAttributes.getAttribute()) {
            AttributeType attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(object4);
            object22.getAttribute().add(attributeType);
        }
        object3 = new PartitionExpressions();
        for (AttributeType attributeType : partitionExpressions.getPartitionExpression()) {
            PartitionExpressionType partitionExpressionType = (PartitionExpressionType)MetaDataHelper.copyMetadataObject(attributeType);
            object3.getPartitionExpression().add(partitionExpressionType);
        }
        return new DynamicHelper(miningAttributes2, supplementalAttributesType2, (CaseAttributes)object22, (PartitionExpressions)object3);
    }

    protected boolean performValidation() {
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        boolean bl = true;
        if (dynamicNodeBaseSettingsType.getDynamicApplyOutputColumns().getDynamicApplyOutputColumn().isEmpty()) {
            bl = false;
            this.addMessage("DYNAMIC_ANOMALY_NODE_NO_PREDICTION", MessageEnumType.WARNING, new String[0]);
        }
        if (bl) {
            if (!dynamicNodeBaseSettingsType.getMiningAttributes().getMiningAttribute().isEmpty()) {
                for (AttributeType attributeType : dynamicNodeBaseSettingsType.getMiningAttributes().getMiningAttribute()) {
                    if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                    bl = false;
                    this.addMessage("DYNAMIC_PREDICTION_NODE_INVALID_INPUT_ATTR", MessageEnumType.WARNING, new String[0]);
                    break;
                }
            } else {
                bl = false;
                this.addMessage("DYNAMIC_PREDICTION_NODE_NO_INPUTS", MessageEnumType.WARNING, new String[0]);
            }
        }
        if (bl) {
            for (AttributeType attributeType : dynamicNodeBaseSettingsType.getSupplementalAttributes().getAttribute()) {
                if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl = false;
                this.addMessage("DYNAMIC_PREDICTION_NODE_INVALID_SUPPL_ATTR", MessageEnumType.WARNING, new String[0]);
                break;
            }
        }
        if (bl) {
            for (AttributeType attributeType : dynamicNodeBaseSettingsType.getCaseAttributes().getAttribute()) {
                if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl = false;
                this.addMessage("DYNAMIC_PREDICTION_NODE_INVALID_CASE_ATTR", MessageEnumType.WARNING, new String[0]);
                break;
            }
        }
        if (bl) {
            for (AttributeType attributeType : dynamicNodeBaseSettingsType.getPartitionExpressions().getPartitionExpression()) {
                AttributeType attributeType2;
                if (null != attributeType.getSQLExpression() || (attributeType2 = attributeType.getPartitionAttribute()).getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl = false;
                this.addMessage("DYNAMIC_PREDICTION_NODE_INVALID_PARTITION_ATTR", MessageEnumType.WARNING, new String[0]);
                break;
            }
        }
        return bl;
    }

    public void validateSimple(boolean bl) {
        boolean bl2 = super.validate(bl);
        bl2 = this.performValidation();
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
    }

    public static String getPredictionOutputColumnTypeManual(MiningAttributeType miningAttributeType) {
        if (miningAttributeType.getMiningType().equals("Categorical")) {
            return "VARCHAR2";
        }
        if (miningAttributeType.getMiningType().equals("Numerical")) {
            return miningAttributeType.getDataType();
        }
        return "VARCHAR2";
    }

    @Override
    public void addMessage(String string, MessageEnumType messageEnumType, String ... stringArray) {
        MessageType.Resource.Parameters.Value value;
        int n;
        MessageType messageType = new MessageType();
        MessageType.Resource resource = new MessageType.Resource();
        messageType.setResource(resource);
        messageType.setType(messageEnumType);
        resource.setId(string);
        resource.setParameters(new MessageType.Resource.Parameters());
        List list = resource.getParameters().getValue();
        for (n = 0; n < stringArray.length; ++n) {
            value = new MessageType.Resource.Parameters.Value();
            value.setType(ParameterDataType.STRING);
            value.setValue(stringArray[n]);
            list.add(value);
        }
        n = 0;
        value = this.getData().getMessages();
        List list2 = value.getMessage();
        for (MessageType messageType2 : list2) {
            if (!messageType2.getResource().getId().equals(messageType.getResource().getId()) || !messageType2.getType().equals((Object)messageType2.getType())) continue;
            n = 1;
            break;
        }
        if (n != 0) {
            return;
        }
        super.addMessage(string, messageEnumType, stringArray);
    }

    public boolean isCaseIdAttribute(AttributeType attributeType, List<AttributeType> list) {
        boolean bl = false;
        for (AttributeType attributeType2 : list) {
            if (!attributeType2.getName().equals(attributeType.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isPartitionAttribute(MiningAttributeType miningAttributeType, List<PartitionExpressionType> list) {
        boolean bl = false;
        for (PartitionExpressionType partitionExpressionType : list) {
            AttributeType attributeType;
            if (null != partitionExpressionType.getSQLExpression() || !(attributeType = partitionExpressionType.getPartitionAttribute()).getName().equals(miningAttributeType.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void removeMissingSupplColumns(DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType, List<AttributeType> list) {
        List list2 = dynamicNodeBaseSettingsType.getSupplementalAttributes().getAttribute();
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>(list2.size());
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            list2.remove(attributeType2);
        }
    }

    protected void removeMissingInputColumns(DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType, List<MiningAttributeType> list) {
        List list2 = dynamicNodeBaseSettingsType.getMiningAttributes().getMiningAttribute();
        HashMap<String, MiningAttributeType> hashMap = new HashMap<String, MiningAttributeType>(list2.size());
        for (MiningAttributeType miningAttributeType : list2) {
            hashMap.put(miningAttributeType.getName(), miningAttributeType);
        }
        for (MiningAttributeType miningAttributeType : list) {
            MiningAttributeType miningAttributeType2 = (MiningAttributeType)hashMap.get(miningAttributeType.getName());
            list2.remove(miningAttributeType2);
        }
    }

    protected void updateAllColumnsAndStatus(DynamicHelper dynamicHelper, DynamicHelper dynamicHelper2, boolean bl) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ComplexProperty complexProperty = new ComplexProperty(ALL_COLUMNS, dynamicHelper);
        complexProperty.setOldData(dynamicHelper2);
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        arrayList.add(complexProperty);
        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty2.setOldData(this.getSQLExpression());
        arrayList.add(complexProperty2);
        NodeStatusType nodeStatusType = bl ? NodeStatusType.READY : NodeStatusType.INVALID;
        ComplexProperty complexProperty3 = new ComplexProperty("status", nodeStatusType);
        complexProperty2.setOldData(this.getState());
        arrayList.add(complexProperty3);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
    }

    protected void updateAllColumnsTxn(DynamicHelper dynamicHelper, DynamicHelper dynamicHelper2) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ComplexProperty complexProperty = new ComplexProperty(ALL_COLUMNS, dynamicHelper);
        complexProperty.setOldData(dynamicHelper2);
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        arrayList.add(complexProperty);
        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty2.setOldData(this.getSQLExpression());
        arrayList.add(complexProperty2);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
    }

    protected void copyAttributes(List<MiningAttributeType> list, List<AttributeType> list2) {
        for (AttributeType attributeType : list2) {
            AttributeType attributeType2 = new AttributeType();
            attributeType2.setName(attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty() ? attributeType.getAlias() : attributeType.getName());
            attributeType2.setDataType(attributeType.getDataType());
            attributeType2.setDataTypeQualifier(attributeType.getDataTypeQualifier());
            attributeType2.setStatus(attributeType.getStatus());
            attributeType2.setAnnotation(attributeType.getAnnotation());
            MiningAttributeType miningAttributeType = MetaDataHelper.createMiningAttributeFrom(attributeType2);
            miningAttributeType.setInput("Yes");
            list.add(miningAttributeType);
        }
    }

    protected void updateStatusFromDataProvider() {
        Object object;
        Object object22;
        Object object3;
        List list;
        SupplementalAttributesType supplementalAttributesType2;
        List list2;
        PartitionExpressions partitionExpressions;
        Object object4;
        Object object5;
        String string;
        AttributeType attributeType2;
        AbstractNode abstractNode = this.findParentNode();
        Attributes attributes = null;
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        if (dataProvider != null) {
            attributes = dataProvider.getAttributes();
        }
        List list3 = attributes != null ? attributes.getAttribute() : new ArrayList();
        HashMap<Object, AttributeType> hashMap = new HashMap<Object, AttributeType>();
        for (AttributeType attributeType2 : list3) {
            string = attributeType2.getAlias();
            object5 = string != null && string.trim().length() > 0 ? string : attributeType2.getName();
            hashMap.put(object5, attributeType2);
        }
        HashMap hashMap2 = new HashMap();
        attributeType2 = this.getDynamicNodeBaseSettingsType();
        string = attributeType2.getCaseAttributes();
        object5 = string.getAttribute();
        if (!object5.isEmpty()) {
            object4 = object5.iterator();
            while (object4.hasNext()) {
                partitionExpressions = (AttributeType)object4.next();
                hashMap2.put(partitionExpressions.getName(), partitionExpressions);
                list2 = (AttributeType)hashMap.get(partitionExpressions.getName());
                if (null == list2) {
                    partitionExpressions.setStatus(AttributeStatus.MISSING);
                    continue;
                }
                if (!AttributeTypeHelper.areCompatibleTypes(list2.getDataType(), partitionExpressions.getDataType())) {
                    partitionExpressions.setStatus(AttributeStatus.INVALID);
                    partitionExpressions.setDataTypeQualifier(list2.getDataTypeQualifier());
                    continue;
                }
                partitionExpressions.setStatus(list2.getStatus());
                partitionExpressions.setDataTypeQualifier(list2.getDataTypeQualifier());
            }
        }
        object4 = new HashMap();
        partitionExpressions = attributeType2.getPartitionExpressions();
        list2 = partitionExpressions.getPartitionExpression();
        if (!list2.isEmpty()) {
            for (SupplementalAttributesType supplementalAttributesType2 : list2) {
                list = supplementalAttributesType2.getPartitionAttribute();
                hashMap2.put(list.getName(), list);
                if (null != supplementalAttributesType2.getSQLExpression()) {
                    object4.put(list.getName(), supplementalAttributesType2.getSQLExpression());
                    continue;
                }
                object3 = (AttributeType)hashMap.get(list.getName());
                if (null == object3) {
                    list.setStatus(AttributeStatus.MISSING);
                    continue;
                }
                if (!AttributeTypeHelper.areCompatibleTypes(object3.getDataType(), list.getDataType())) {
                    list.setStatus(AttributeStatus.INVALID);
                    list.setDataTypeQualifier(object3.getDataTypeQualifier());
                    continue;
                }
                list.setStatus(object3.getStatus());
                list.setDataTypeQualifier(object3.getDataTypeQualifier());
            }
        }
        ArrayList arrayList = new ArrayList();
        supplementalAttributesType2 = attributeType2.getSupplementalAttributes();
        list = supplementalAttributesType2.getAttribute();
        if (!list.isEmpty()) {
            for (Object object22 : list) {
                object = (AttributeType)hashMap.get(object22.getName());
                if (null == object) {
                    if (null == hashMap2.get(object22.getName())) {
                        arrayList.add(object22);
                        continue;
                    }
                    if (null != object4.get(object22.getName())) continue;
                    object22.setStatus(AttributeStatus.INVALID);
                    continue;
                }
                if (!AttributeTypeHelper.areCompatibleTypes(object.getDataType(), object22.getDataType())) {
                    if (object22.getDataType().equals("UNKNOWN")) {
                        object22.setStatus(object.getStatus());
                        object22.setDataTypeQualifier(object.getDataTypeQualifier());
                        continue;
                    }
                    object22.setStatus(AttributeStatus.INVALID);
                    object22.setDataTypeQualifier(object.getDataTypeQualifier());
                    continue;
                }
                object22.setStatus(object.getStatus());
                object22.setDataTypeQualifier(object.getDataTypeQualifier());
            }
        }
        if (!arrayList.isEmpty()) {
            this.removeMissingSupplColumns((DynamicNodeBaseSettingsType)attributeType2, arrayList);
        }
        object3 = attributeType2.getMiningAttributes().getMiningAttribute();
        object22 = new ArrayList();
        object = object3.iterator();
        while (object.hasNext()) {
            MiningAttributeType miningAttributeType = (MiningAttributeType)object.next();
            AttributeType attributeType3 = (AttributeType)hashMap.get(miningAttributeType.getName());
            if (null == attributeType3) {
                object22.add(miningAttributeType);
                continue;
            }
            if (!AttributeTypeHelper.areCompatibleTypes(attributeType3.getDataType(), miningAttributeType.getDataType())) {
                if (miningAttributeType.getDataType().equals("UNKNOWN")) {
                    miningAttributeType.setStatus(attributeType3.getStatus());
                    miningAttributeType.setDataTypeQualifier(attributeType3.getDataTypeQualifier());
                    continue;
                }
                miningAttributeType.setStatus(AttributeStatus.INVALID);
                miningAttributeType.setDataTypeQualifier(attributeType3.getDataTypeQualifier());
                continue;
            }
            miningAttributeType.setStatus(attributeType3.getStatus());
            miningAttributeType.setDataTypeQualifier(attributeType3.getDataTypeQualifier());
            hashMap.remove(miningAttributeType.getName());
        }
        if (!object22.isEmpty()) {
            this.removeMissingInputColumns((DynamicNodeBaseSettingsType)attributeType2, (List<MiningAttributeType>)object22);
        }
        object = new ArrayList(hashMap.values());
        this.copyAttributes((List<MiningAttributeType>)object3, (List<AttributeType>)object);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        SupplementalAttributesType supplementalAttributesType = new SupplementalAttributesType();
        supplementalAttributesType.setAutoSpec(AutoSpecType.NO);
        List list = supplementalAttributesType.getAttribute();
        if (null != this.getDynamicNodeBaseSettingsType().getSupplementalAttributes()) {
            for (AttributeType attributeType : this.getDynamicNodeBaseSettingsType().getSupplementalAttributes().getAttribute()) {
                AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
                list.add(attributeType2);
                AttributeType attributeType3 = map.get(attributeType.getName());
                if (attributeType3 == null) continue;
                String string = attributeType2.getName();
                if (!attributeType2.getName().equals(attributeType3.getName())) {
                    attributeType2.setName(attributeType3.getName());
                }
                if (!attributeType2.getDataType().equals(attributeType3.getDataType())) {
                    attributeType2.setDataType(attributeType3.getDataType());
                }
                hashMap.put(string, attributeType2);
            }
        }
        if (!hashMap.isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), REFACTOR_SUPPLEMENTAL_COLUMNS, supplementalAttributesType);
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    protected String generateSupplementalCode(String string) {
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        SupplementalAttributesType supplementalAttributesType = dynamicNodeBaseSettingsType.getSupplementalAttributes();
        List list = supplementalAttributesType.getAttribute();
        String string2 = null;
        if (list == null || list.isEmpty()) {
            string2 = StringUtils.getReplacedString(string, "<SUPPLEMENTAL_DATA>", "");
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (AttributeType attributeType : list) {
                String string3 = attributeType.getName();
                PartitionExpressionType partitionExpressionType = DynamicApplyHelper.getPartitionExpression(dynamicNodeBaseSettingsType, string3);
                if (null != partitionExpressionType) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",\n");
                    }
                    if (null == partitionExpressionType.getSQLExpression()) {
                        stringBuilder.append("\t\"" + partitionExpressionType.getPartitionAttribute().getName() + "\"");
                        continue;
                    }
                    stringBuilder.append("\t" + partitionExpressionType.getSQLExpression());
                    stringBuilder.append(" \"");
                    stringBuilder.append(partitionExpressionType.getPartitionAttribute().getName());
                    stringBuilder.append("\"");
                    continue;
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",\n");
                }
                stringBuilder.append("\t\"" + string3 + "\"");
            }
            stringBuilder.append(",");
            string2 = StringUtils.getReplacedString(string, "<SUPPLEMENTAL_DATA>", stringBuilder.toString());
        }
        return string2;
    }

    public void setSQLPredictionExpression(String string) {
        this.getDynamicNodeBaseSettingsType().setSQLPredictionExpression(string);
    }

    public abstract Map<String, String> generateSQLExpressions();

    @Override
    public Object getProperty(String string) {
        Object object = null;
        if (string.equals(REFACTOR_SUPPLEMENTAL_COLUMNS)) {
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
            object = dynamicNodeBaseSettingsType.getSupplementalAttributes();
        } else if (string.equals(PREDICTIONS_ONLY)) {
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
            object = dynamicNodeBaseSettingsType.getDynamicApplyOutputColumns();
        } else if (string.equals(PARTITIONS_EXPRESSIONS)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(PARTITION_EXPRESSIONS_ATTRIBUTES, this.getDynamicNodeBaseSettingsType().getPartitionExpressions());
            hashMap.put(PARTITION_EXPRESSIONS_SUPPLEMENTAL, this.getDynamicNodeBaseSettingsType().getSupplementalAttributes());
            object = hashMap;
        } else if (string.equals(PARTITIONS_EXPRESSION_EDIT)) {
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
            object = dynamicNodeBaseSettingsType.getPartitionExpressions();
        } else if (string.equals(CASE_ATTRIBUTE)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(CASE_ATTRIBUTE, this.getDynamicNodeBaseSettingsType().getCaseAttributes());
            hashMap.put(CASE_ATTRIBUTE_SUPPLEMENTAL, this.getDynamicNodeBaseSettingsType().getSupplementalAttributes());
            object = hashMap;
        } else if (string.equals(OUTPUT_SUPPLEMENTAL)) {
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
            object = dynamicNodeBaseSettingsType.getSupplementalAttributes();
        } else if (string.equals("SQL_EXPRESSION")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(CLIENT_SQL_EXPRESSION, this.getSQLExpression());
            hashMap.put(SERVER_SQL_EXPRESSION, this.getDynamicNodeBaseSettingsType().getSQLPredictionExpression());
            object = hashMap;
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(REFACTOR_SUPPLEMENTAL_COLUMNS) || complexProperty.getPropertyName().equals(OUTPUT_SUPPLEMENTAL) || complexProperty.getPropertyName().equals(PARTITIONS_EXPRESSIONS) || complexProperty.getPropertyName().equals(PARTITIONS_EXPRESSION_EDIT) || complexProperty.getPropertyName().equals(PREDICTIONS_ONLY) || complexProperty.getPropertyName().equals(CASE_ATTRIBUTE) || complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        if (string.equals(REFACTOR_SUPPLEMENTAL_COLUMNS)) {
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
            SupplementalAttributesType supplementalAttributesType = (SupplementalAttributesType)object;
            dynamicNodeBaseSettingsType.setSupplementalAttributes(supplementalAttributesType);
        } else if (string.equals(PREDICTIONS_ONLY)) {
            DynamicApplyOutputColumns dynamicApplyOutputColumns = (DynamicApplyOutputColumns)object;
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
            dynamicNodeBaseSettingsType.setDynamicApplyOutputColumns(dynamicApplyOutputColumns);
        } else if (string.equals(PARTITIONS_EXPRESSION_EDIT)) {
            PartitionExpressions partitionExpressions = (PartitionExpressions)object;
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
            dynamicNodeBaseSettingsType.setPartitionExpressions(partitionExpressions);
        } else if (string.equals(PARTITIONS_EXPRESSIONS)) {
            Map map = (Map)object;
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
            PartitionExpressions partitionExpressions = (PartitionExpressions)map.get(PARTITION_EXPRESSIONS_ATTRIBUTES);
            dynamicNodeBaseSettingsType.setPartitionExpressions(partitionExpressions);
            SupplementalAttributesType supplementalAttributesType = (SupplementalAttributesType)map.get(PARTITION_EXPRESSIONS_SUPPLEMENTAL);
            dynamicNodeBaseSettingsType.setSupplementalAttributes(supplementalAttributesType);
        } else if (string.equals(OUTPUT_SUPPLEMENTAL)) {
            SupplementalAttributesType supplementalAttributesType = (SupplementalAttributesType)object;
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
            dynamicNodeBaseSettingsType.setSupplementalAttributes(supplementalAttributesType);
        } else if (string.equals(CASE_ATTRIBUTE)) {
            Map map = (Map)object;
            CaseAttributes caseAttributes = (CaseAttributes)map.get(CASE_ATTRIBUTE);
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
            dynamicNodeBaseSettingsType.setCaseAttributes(caseAttributes);
            SupplementalAttributesType supplementalAttributesType = (SupplementalAttributesType)map.get(CASE_ATTRIBUTE_SUPPLEMENTAL);
            dynamicNodeBaseSettingsType.setSupplementalAttributes(supplementalAttributesType);
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                Map<String, String> map = this.generateSQLExpressions();
                this.setSQLExpression(map.get(CLIENT_SQL_EXPRESSION));
                this.setSQLPredictionExpression(map.get(SERVER_SQL_EXPRESSION));
            } else if (object instanceof Map) {
                HashMap hashMap = (HashMap)object;
                this.setSQLExpression((String)hashMap.get(CLIENT_SQL_EXPRESSION));
                this.setSQLPredictionExpression((String)hashMap.get(SERVER_SQL_EXPRESSION));
            } else if (object != null) {
                this.setSQLExpression(object.toString());
                this.setSQLPredictionExpression(object.toString());
            }
        } else {
            super.setProperty(string, object);
        }
    }

    protected void convertNestedVarcharTypes(boolean bl) {
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        if (dynamicNodeBaseSettingsType.getSupplementalAttributes() != null && !dynamicNodeBaseSettingsType.getSupplementalAttributes().getAttribute().isEmpty()) {
            for (AttributeType attributeType : dynamicNodeBaseSettingsType.getSupplementalAttributes().getAttribute()) {
                if (!attributeType.getDataType().equals("ODMR_NESTED_VARCHAR2") && !attributeType.getDataType().equals("ODMR_NESTED_VARCHAR2_EX")) continue;
                this.convertExType(attributeType, bl);
            }
        }
        if (!dynamicNodeBaseSettingsType.getMiningAttributes().getMiningAttribute().isEmpty()) {
            for (AttributeType attributeType : dynamicNodeBaseSettingsType.getMiningAttributes().getMiningAttribute()) {
                if (!attributeType.getDataType().equals("ODMR_NESTED_VARCHAR2") && !attributeType.getDataType().equals("ODMR_NESTED_VARCHAR2_EX")) continue;
                this.convertExType(attributeType, bl);
            }
        }
    }

    protected void convertExType(AttributeType attributeType, boolean bl) {
        if (bl && attributeType.getDataType().equals("ODMR_NESTED_VARCHAR2_EX")) {
            return;
        }
        if (!bl && attributeType.getDataType().equals("ODMR_NESTED_VARCHAR2")) {
            return;
        }
        attributeType.setDataType(bl ? "ODMR_NESTED_VARCHAR2_EX" : "ODMR_NESTED_VARCHAR2");
    }
}

