/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.UnsupervisedBuildNode;
import oracle.dmt.dataminer.workflow.preferences.ClusteringModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ExpectationMaximizationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.KMeansModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public final class ClusteringBuildNode
extends UnsupervisedBuildNode {
    private static final Logger theLogger = Logger.getLogger(ClusteringBuildNode.class.getName());
    public static final String CLUS_NUM_CLUSTERS = "CLUS_NUM_CLUSTERS";
    public static final String KMNS_BLOCK_GROWTH = "KMNS_BLOCK_GROWTH";
    public static final String KMNS_CONV_TOLERANCE = "KMNS_BLOCK_GROWTH";
    public static final String KMNS_DISTANCE = "KMNS_BLOCK_GROWTH";
    public static final String KMNS_ITERATIONS = "KMNS_BLOCK_GROWTH";
    public static final String KMNS_MIN_PCT_ATTR_SUPPORT = "KMNS_BLOCK_GROWTH";
    public static final String KMNS_NUM_BINS = "KMNS_BLOCK_GROWTH";
    public static final String KMNS_SPLIT_CRITERION = "KMNS_BLOCK_GROWTH";
    public static final String OCLT_MAX_BUFFER = "OCLT_MAX_BUFFER";
    public static final String OCLT_SENSITIVITY = "OCLT_SENSITIVITY";
    public static final String ODMS_APPROXIMATE_COMPUTATION = "ODMS_APPROXIMATE_COMPUTATION";
    public static final String EMCS_NUM_COMPONENTS = "EMCS_NUM_COMPONENTS";
    public static final String EMCS_CLUSTER_COMPONENTS = "EMCS_CLUSTER_COMPONENTS";
    public static final String EMCS_CLUSTER_THRESH = "EMCS_CLUSTER_THRESH";
    public static final String EMCS_MAX_NUM_ATTR_2D = "EMCS_MAX_NUM_ATTR_2D";
    public static final String EMCS_NUM_PROJECTIONS = "EMCS_NUM_PROJECTIONS";
    public static final String EMCS_NUM_QUANTILE_BINS = "EMCS_NUM_QUANTILE_BINS";
    public static final String EMCS_NUM_TOPN_BINS = "EMCS_NUM_TOPN_BINS";
    public static final String EMCS_NUM_EQUIWIDTH_BINS = "EMCS_NUM_EQUIWIDTH_BINS";
    public static final String EMCS_MIN_PCT_ATTR_SUPPORT = "EMCS_MIN_PCT_ATTR_SUPPORT";
    public static final String EMCS_CLUSTER_STATISTICS = "EMCS_CLUSTER_STATISTICS";
    public static final String EMCS_NUM_DISTRIBUTION = "EMCS_NUM_DISTRIBUTION";
    public static final String EMCS_NUM_ITERATIONS = "EMCS_NUM_ITERATIONS";
    public static final String EMCS_LOGLIKE_IMPROVEMENT = "EMCS_LOGLIKE_IMPROVEMENT";
    public static final String EMCS_LINKAGE_FUNCTION = "EMCS_LINKAGE_FUNCTION";
    public static final String EMCS_CONVERGENCE_CRITERION = "EMCS_CONVERGENCE_CRITERION";
    public static final String EMCS_ATTRIBUTE_FILTER = "EMCS_ATTRIBUTE_FILTER";
    private static Preferences _p = Preferences.getPreferences();
    private ClusteringModelBuildPreferencesPanelSettings clustBuildPref = ClusteringModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)_p);
    private Version _dbVersion = null;

    public ClusteringBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        try {
            this._dbVersion = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        ClusteringBuildNodeType.Models models = new ClusteringBuildNodeType.Models();
        clusteringBuildNodeType.setModels(models);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.clustBuildPref.isOC()) {
            arrayList.add("ALGO_O_CLUSTER");
        }
        if (this.clustBuildPref.isKM()) {
            arrayList.add("ALGO_KMEANS");
        }
        if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, this._dbVersion, true) && this.clustBuildPref.isEM()) {
            arrayList.add("ALGO_EXPECTATION_MAXIMIZATION");
        }
        List<String> list = WorkflowUtils.getNewModelNames(context, "CLUSTERING", arrayList);
        int n = 0;
        ModelType modelType = null;
        if (this.clustBuildPref.isOC()) {
            modelType = this.createNewClusteringModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addOCModel((OClusterModelType)modelType);
        }
        if (this.clustBuildPref.isKM()) {
            modelType = this.createNewClusteringModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addKMModel((KMeansModelType)modelType);
        }
        if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, this._dbVersion, true) && this.clustBuildPref.isEM()) {
            modelType = this.createNewClusteringModel(list.get(n), "", (String)arrayList.get(n));
            modelType.setUseForOutput(true);
            this.addEMModel((ExpectationMaximizationModelType)modelType);
        }
        clusteringBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addKMModel(KMeansModelType kMeansModelType) {
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        ClusteringBuildNodeType.Models models = clusteringBuildNodeType.getModels();
        List list = models.getKMeansModel();
        list.add(kMeansModelType);
    }

    public void addOCModel(OClusterModelType oClusterModelType) {
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        ClusteringBuildNodeType.Models models = clusteringBuildNodeType.getModels();
        List list = models.getOClusterModel();
        list.add(oClusterModelType);
    }

    public void addEMModel(ExpectationMaximizationModelType expectationMaximizationModelType) {
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        ClusteringBuildNodeType.Models models = clusteringBuildNodeType.getModels();
        List list = models.getExpectationMaximizationModel();
        list.add(expectationMaximizationModelType);
    }

    public ModelType createNewClusteringModel(String string, String string2, String string3) {
        ModelType modelType = super.createNewModel(string, string2, "CLUSTERING", string3);
        return modelType;
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_CLUS_BUILD_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        ClusteringBuildNodeType.Models models = clusteringBuildNodeType.getModels();
        if (models.getKMeansModel().isEmpty() && models.getOClusterModel().isEmpty() && models.getExpectationMaximizationModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getKMeansModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getOClusterModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getExpectationMaximizationModel())) {
                bl3 = false;
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list2 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)clusteringBuildNodeType, modelType);
                if (list2.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)clusteringBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)clusteringBuildNodeType, modelType);
                if (!list3.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)clusteringBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            ClusteringBuildNodeType clusteringBuildNodeType2 = (ClusteringBuildNodeType)this.getData();
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)clusteringBuildNodeType2, string2);
                modelType.setStatus((ModelStatusType)entry.getValue());
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            ClusteringBuildNodeType clusteringBuildNodeType3 = (ClusteringBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)clusteringBuildNodeType3, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)clusteringBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)clusteringBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public Object getProperty(String string) {
        return super.getProperty(string);
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.CLUSTERING;
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.CLUSTERING;
    }

    @Override
    public AttributeType getTargetAttribute() {
        return null;
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "clustering_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_CLUSTERING_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_CLUSTERING_ICON"));
    }

    private String generateBuildSettingsCode(Context context, ClusteringBuildNodeType clusteringBuildNodeType, ClusteringModelType clusteringModelType, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  execSQL('CREATE TABLE '||v_build_setting||' (SETTING_NAME VARCHAR2(30), SETTING_VALUE VARCHAR2(128))'); \n");
        if (clusteringModelType instanceof ExpectationMaximizationModelType) {
            ExpectationMaximizationModelType expectationMaximizationModelType = (ExpectationMaximizationModelType)clusteringModelType;
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getCLUSNUMCLUSTERS() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLUS_NUM_CLUSTERS||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getCLUSNUMCLUSTERS() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSATTRIBUTEFILTER() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_ATTRIBUTE_FILTER||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSATTRIBUTEFILTER() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSCLUSTERCOMPONENTS() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_CLUSTER_COMPONENTS||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSCLUSTERCOMPONENTS() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSCLUSTERSTATISTICS() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_CLUSTER_STATISTICS||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSCLUSTERSTATISTICS() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSCLUSTERTHRESH() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_CLUSTER_THRESH||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSCLUSTERTHRESH() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSCONVERGENCECRITERION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_CONVERGENCE_CRITERION||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSCONVERGENCECRITERION() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSLINKAGEFUNCTION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES (''EMCS_LINKAGE_FUNCTION'', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSLINKAGEFUNCTION() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSMAXNUMATTR2D() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_MAX_NUM_ATTR_2D||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSMAXNUMATTR2D() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSMINPCTATTRSUPPORT() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_MIN_PCT_ATTR_SUPPORT||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSMINPCTATTRSUPPORT() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSNUMCOMPONENTS() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_NUM_COMPONENTS||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSNUMCOMPONENTS() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSNUMDISTRIBUTION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_NUM_DISTRIBUTION||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSNUMDISTRIBUTION() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSNUMITERATIONS() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_NUM_ITERATIONS||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSNUMITERATIONS() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSNUMPROJECTIONS() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_NUM_PROJECTIONS||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSNUMPROJECTIONS() + "'')'); \n");
            }
            if (expectationMaximizationModelType.getExpectationMaximizationAlgo().getODMSAPPROXIMATECOMPUTATION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_APPROXIMATE_COMPUTATION||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getODMSAPPROXIMATECOMPUTATION() + "'')'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_LOGLIKE_IMPROVEMENT||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSLOGLIKEIMPROVEMENT() + "'')'); \n");
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.EMCS_NUM_EQUIWIDTH_BINS||''', ''" + expectationMaximizationModelType.getExpectationMaximizationAlgo().getEMCSNUMEQUIWIDTHBINS() + "'')'); \n");
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_EXPECTATION_MAXIMIZATION||''')'); \n");
        } else if (clusteringModelType instanceof KMeansModelType) {
            KMeansModelType kMeansModelType = (KMeansModelType)clusteringModelType;
            if (kMeansModelType.getKMeansAlgo().getCLUSNUMCLUSTERS() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLUS_NUM_CLUSTERS||''', ''" + kMeansModelType.getKMeansAlgo().getCLUSNUMCLUSTERS() + "'')'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.KMNS_BLOCK_GROWTH||''', ''" + kMeansModelType.getKMeansAlgo().getKMNSBLOCKGROWTH() + "'')'); \n");
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.KMNS_CONV_TOLERANCE||''', ''" + kMeansModelType.getKMeansAlgo().getKMNSCONVTOLERANCE() + "'')'); \n");
            if (kMeansModelType.getKMeansAlgo().getKMNSDISTANCE() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.KMNS_DISTANCE||''', ''" + kMeansModelType.getKMeansAlgo().getKMNSDISTANCE() + "'')'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.KMNS_ITERATIONS||''', ''" + kMeansModelType.getKMeansAlgo().getKMNSITERATIONS() + "'')'); \n");
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.KMNS_MIN_PCT_ATTR_SUPPORT||''', ''" + kMeansModelType.getKMeansAlgo().getKMNSMINPCTATTRSUPPORT() + "'')'); \n");
            if (kMeansModelType.getKMeansAlgo().getKMNSNUMBINS() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.KMNS_NUM_BINS||''', ''" + kMeansModelType.getKMeansAlgo().getKMNSNUMBINS() + "'')'); \n");
            }
            if (kMeansModelType.getKMeansAlgo().getKMNSSPLITCRITERION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.KMNS_SPLIT_CRITERION||''', ''" + kMeansModelType.getKMeansAlgo().getKMNSSPLITCRITERION() + "'')'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_KMEANS||''')'); \n");
        } else if (clusteringModelType instanceof OClusterModelType) {
            OClusterModelType oClusterModelType = (OClusterModelType)clusteringModelType;
            if (oClusterModelType.getOClusterAlgo().getCLUSNUMCLUSTERS() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLUS_NUM_CLUSTERS||''', ''" + oClusterModelType.getOClusterAlgo().getCLUSNUMCLUSTERS() + "'')'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.OCLT_MAX_BUFFER||''', ''" + oClusterModelType.getOClusterAlgo().getOCLTMAXBUFFER() + "'')'); \n");
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.OCLT_SENSITIVITY||''', ''" + oClusterModelType.getOClusterAlgo().getOCLTSENSITIVITY() + "'')'); \n");
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_OCLUSTER||''')'); \n");
        }
        if (bl) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_ON||''')'); \n");
        } else {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_OFF||''')'); \n");
        }
        return stringBuffer.toString();
    }

    private String generateBuildCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, ClusteringModelType clusteringModelType) throws Exception {
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        String string = CodeTemplate.getInstance().getTemplate("workflow_generic_build_model.sql");
        string = CodeTemplate.updateBodyTemplate(string, "<MINING_FUNCTION>", "DBMS_DATA_MINING.CLUSTERING");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = this.generateDataUsageCode(version, (BuildNodeType)clusteringBuildNodeType, (ModelType)clusteringModelType, null, stringBuffer, stringBuffer2);
        String string2 = this.generateBuildSettingsCode(context, clusteringBuildNodeType, clusteringModelType, bl);
        String string3 = ConnectionFolder.getUserAccountName(this.getContext());
        String string4 = clusteringModelType.getName();
        parameterizedSourceDefinitions.addParameterizedSourceDefinition(this, string3, string4, DatabaseObjectType.MODEL);
        String string5 = parameterizedSourceDefinitions.getParmNameWithAmpersand(this, string3, string4, DatabaseObjectType.MODEL);
        String string6 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        string = CodeTemplate.updateBodyTemplate(string, "<PARALLEL_HINT>", string6);
        string = CodeTemplate.updateBodyTemplate(string, "<DATA_USAGE_ATTRIBUTES>", stringBuffer.toString());
        string = CodeTemplate.updateBodyTemplate(string, "<DATA_USAGE_TRANSFORMATIONS>", stringBuffer2.toString());
        string = CodeTemplate.updateBodyTemplate(string, "<BUILD_SETTING>", string2);
        string = CodeTemplate.updateBodyTemplate(string, "<MODEL_NAME_PARAM>", string5);
        string = CodeTemplate.updateBodyTemplate(string, "<BUILD_MODEL_ID>", clusteringModelType.getId());
        String string7 = null;
        if (clusteringModelType instanceof ExpectationMaximizationModelType) {
            string7 = MiningAlgorithms.EXPECTATION_MAXIMIZATION.toString();
        } else if (clusteringModelType instanceof KMeansModelType) {
            string7 = MiningAlgorithms.KMEANS.toString();
        } else if (clusteringModelType instanceof OClusterModelType) {
            string7 = MiningAlgorithms.OCLUSTER.toString();
        }
        string = CodeTemplate.updateBodyTemplate(string, "<BUILD_MODEL_TYPE>", string7);
        return string;
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        if (!super.isVersionSupported(context, stringBuffer)) {
            return false;
        }
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        if (!ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true) && !clusteringBuildNodeType.getModels().getExpectationMaximizationModel().isEmpty()) {
            stringBuffer.append(CodeGenLrb.get("VALIDATE_EM_BUILD_SETTING_NOT_SUPPORTED"));
            return false;
        }
        return true;
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = super.generateCode(context, parameterizedSourceDefinitions, string);
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        StringBuffer stringBuffer = new StringBuffer();
        for (ExpectationMaximizationModelType expectationMaximizationModelType : clusteringBuildNodeType.getModels().getExpectationMaximizationModel()) {
            stringBuffer.append(this.generateBuildCode(context, parameterizedSourceDefinitions, (ClusteringModelType)expectationMaximizationModelType));
        }
        for (ExpectationMaximizationModelType expectationMaximizationModelType : clusteringBuildNodeType.getModels().getKMeansModel()) {
            stringBuffer.append(this.generateBuildCode(context, parameterizedSourceDefinitions, (ClusteringModelType)expectationMaximizationModelType));
        }
        for (ExpectationMaximizationModelType expectationMaximizationModelType : clusteringBuildNodeType.getModels().getOClusterModel()) {
            stringBuffer.append(this.generateBuildCode(context, parameterizedSourceDefinitions, (ClusteringModelType)expectationMaximizationModelType));
        }
        string2 = CodeTemplate.updateBodyTemplate(string2, "<BUILD_MODELS>", stringBuffer.toString());
        return string2;
    }
}

