/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.clustering;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.inspect.AbstractNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.ide.Context;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.model.Element;

public class ClusteringPartitionedBuildNodePropertyModel
extends AbstractNodePropertyModel {
    private static int PROPERTY_START_INDEX = ClusteringPartitionedBuildNodePropertyModel.getInitialIndex();

    public ClusteringPartitionedBuildNodePropertyModel(Context context) {
        super(context);
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 1) {
            return;
        }
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        List<Property> list = this.getRows();
        Property property = new Property("modelAddedorRemoved", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.MODEL_ADDED_REMOVED, property);
        property = new Property("algTreeSettings", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), nodeType.getName(), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.ALGORITHM_SETTINGS, property);
        property = new Property("caseAttributes", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.CASE_IDS, property);
        property = new Property("modelsRerun", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), nodeType.getName(), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.MODELS_RERUN, property);
        property = new Property("modelAnnotation", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.MODEL_ANNOTATION, property);
        property = new Property("modelName", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.MODEL_NAME, property);
        property = new Property("modelUseForOutput", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.MODEL_USEFOROUTPUT, property);
        property = new Property("miningAttributeSettings", PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE"), nodeType.getName(), PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.MINING_ATTRIBUTE_SETTINGS, property);
        property = new Property("PARTITIONS_MAX_NUM", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.PARTITIONS_MAX_NUM, property);
        property = new Property("PARTITIONS_EXPRESSION_EDIT", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.PARTITIONS_EXPRESSION_EDIT, property);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Property property = this.getRows().get(n);
        Object[] objectArray = this.getColumnMapping();
        Object object = null;
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= objectArray.length) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        Object object2 = objectArray[n2];
        object = PropertyModel.COLUMN_ID.equals(object2) ? property.getId() : (PropertyModel.COLUMN_GROUP.equals(object2) ? property.getGroup() : (PropertyModel.COLUMN_DISPLAY_NAME.equals(object2) ? property.getDisplayName() : (PropertyModel.COLUMN_DISPLAY_VALUE.equals(object2) ? property.getValue() : (PropertyModel.COLUMN_DESCRIPTION.equals(object2) ? property.getDescription() : (PropertyModel.COLUMN_NAME.equals(object2) ? property.getId() : (PropertyModel.COLUMN_VALUE.equals(object2) ? property.getValue() : (PropertyModel.COLUMN_IS_WRITABLE.equals(object2) ? Boolean.valueOf(this.isCellEditable(n, n2)) : (PropertyModel.COLUMN_IS_HIDDEN.equals(object2) ? Boolean.valueOf(false) : (IdePropertyModel.COLUMN_HELP.equals(object2) ? "clustering_node_pi" : PropertyModel.DOES_NOT_EXIST)))))))));
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object[] objectArray = this.getColumnMapping();
        Object object2 = objectArray[n2];
        List<Property> list = this.getRows();
        if (PropertyModel.COLUMN_ID.equals(object2)) {
            WorkflowNodeInspectorElement workflowNodeInspectorElement = this._workflowNodeInspectorElement;
            if (n == RowIndex.MODEL_ADDED_REMOVED || n == RowIndex.MINING_ATTRIBUTE_SETTINGS || n == RowIndex.ALGORITHM_SETTINGS || n == RowIndex.CASE_IDS || n == RowIndex.MODELS_RERUN || n == RowIndex.MODEL_ANNOTATION || n == RowIndex.MODEL_NAME || n == RowIndex.MODEL_USEFOROUTPUT || n == RowIndex.PARTITIONS_MAX_NUM || n == RowIndex.PARTITIONS_EXPRESSION_EDIT) {
                ComplexProperty complexProperty = (ComplexProperty)object;
                list.get(n).setValue(object);
                workflowNodeInspectorElement.updateNode(complexProperty);
            } else {
                super.setValueAt(object, n, n2);
            }
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    private static void prepareStatusReady(List<Property> list, AbstractBuildNode abstractBuildNode) {
        List<ModelType> list2 = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        for (ModelType modelType : list2) {
            hashMap.put(modelType.getId(), ModelStatusType.READY);
        }
        if (!hashMap.isEmpty()) {
            list.add(new Property(String.valueOf(RowIndex.MODELS_RERUN), null, new ComplexProperty("modelsRerun", hashMap), null, null));
        }
    }

    public static void updateMaxNumPartitions(List<Property> list, AbstractBuildNode abstractBuildNode, BigInteger bigInteger, BigInteger bigInteger2) {
        ComplexProperty complexProperty = new ComplexProperty("PARTITIONS_MAX_NUM", bigInteger);
        complexProperty.setOldData(bigInteger2);
        list.add(new Property(String.valueOf(RowIndex.PARTITIONS_MAX_NUM), null, complexProperty, null, null));
        ClusteringPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    public static void updatePartitionColumns(List<Property> list, AbstractBuildNode abstractBuildNode, PartitionExpressions partitionExpressions, PartitionExpressions partitionExpressions2) {
        ComplexProperty complexProperty = new ComplexProperty("PARTITIONS_EXPRESSION_EDIT", partitionExpressions);
        complexProperty.setOldData(partitionExpressions2);
        list.add(new Property(String.valueOf(RowIndex.PARTITIONS_EXPRESSION_EDIT), null, complexProperty, null, null));
        ClusteringPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    static /* synthetic */ int access$008() {
        return PROPERTY_START_INDEX++;
    }

    protected static class Groups {
        public static final PropertyGroupImpl CUSTOM_BUILD = new PropertyGroupImpl(PreferencesLrb.get("PI_BUILD_NODE_GROUP_BUILD_TITLE"));

        protected Groups() {
        }
    }

    static interface RowIndex
    extends AbstractNodePropertyModel.RowIndex {
        public static final int MODEL_ADDED_REMOVED = ClusteringPartitionedBuildNodePropertyModel.access$008();
        public static final int ALGORITHM_SETTINGS = ClusteringPartitionedBuildNodePropertyModel.access$008();
        public static final int CASE_IDS = ClusteringPartitionedBuildNodePropertyModel.access$008();
        public static final int MODELS_RERUN = ClusteringPartitionedBuildNodePropertyModel.access$008();
        public static final int MODEL_ANNOTATION = ClusteringPartitionedBuildNodePropertyModel.access$008();
        public static final int MODEL_NAME = ClusteringPartitionedBuildNodePropertyModel.access$008();
        public static final int MODEL_USEFOROUTPUT = ClusteringPartitionedBuildNodePropertyModel.access$008();
        public static final int MINING_ATTRIBUTE_SETTINGS = ClusteringPartitionedBuildNodePropertyModel.access$008();
        public static final int PARTITIONS_MAX_NUM = ClusteringPartitionedBuildNodePropertyModel.access$008();
        public static final int PARTITIONS_EXPRESSION_EDIT = ClusteringPartitionedBuildNodePropertyModel.access$008();
    }
}

