/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.CommentTextFieldEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.controls.renderers.OutputCellRenderer;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.comparator.BooleanComparator;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameCellEditor;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelPanel;
import oracle.dmt.dataminer.workflow.dialog.test.TuneDialog;
import oracle.dmt.dataminer.workflow.inspect.AbstractButtonState;
import oracle.dmt.dataminer.workflow.inspect.ClassificationBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.ClassificationBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.inspect.GeneralBuildPIPanel;
import oracle.dmt.dataminer.workflow.inspect.ModelBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TuningType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.Pair;

public class ClassificationBuildPIComponentBuildPanel
extends GeneralBuildPIPanel
implements ClassificationBuildPIComponentGUI {
    private static final Logger theLogger = Logger.getLogger(ClassificationBuildPIComponentBuildPanel.class.getName());
    private static final String _NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
    private static final String _COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
    private static final String _BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
    private static final String _ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
    private static final String _LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
    private static final String _PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");
    private static final String _NOT_TESTED = BuildEditorLrb.get("BUILD_MODEL_NOT_TESTED");
    private static final TuningType _notuning = new TuningType();
    private List<ClassificationResultType> _classResults;
    private List<ClassificationResultType> _classResultsForTuning;
    private boolean _isPartitionModel;
    private JButton _viewModelBtn;
    private JButton _viewTestBtn;
    private DropDownMenuButton _tuneBtn;
    private JButton _removeBtn;
    private JButton _addBtn;
    private static final String NOT_TESTED = "Not tested";
    private DataMinerTablePanel dataMinerTablePanel;

    public ClassificationBuildPIComponentBuildPanel(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this._isPartitionModel = !abstractBuildNode.getPartitionAttributes(null).isEmpty();
        this._classResults = MetaDataHelper.getClassResultsCollection(abstractBuildNode);
        this._classResultsForTuning = MetaDataHelper.getClassResultsForTuningCollection(abstractBuildNode);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return ClassificationBuildPIComponentHelper.getContext(propertyModel);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return ClassificationBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public void updateCell(int n, int n2) {
        GenericBaseTableModel genericBaseTableModel = (GenericBaseTableModel)this.getTable().getModel();
        genericBaseTableModel.fireTableCellUpdated(n, n2);
    }

    @Override
    protected int getModelNameIdFromPropertyModel() {
        return ModelBuildNodePropertyModel.RowIndex.MODEL_NAME;
    }

    @Override
    protected int getModelsRerunIdFromPropertyModel() {
        return ModelBuildNodePropertyModel.RowIndex.MODELS_RERUN;
    }

    @Override
    protected int getTestsRerunIdFromPropertyModel() {
        return ModelBuildNodePropertyModel.RowIndex.TESTS_RERUN;
    }

    @Override
    public boolean getClearState() {
        return this._clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this._clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.dataMinerTablePanel, -1, 500, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.dataMinerTablePanel, -1, 201, Short.MAX_VALUE)));
    }

    public void initRes() {
    }

    @Override
    public void initUI(PropertyModel propertyModel) {
        super.initUI(propertyModel);
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        ModelsTableModel modelsTableModel = new ModelsTableModel(this._models);
        this.setupModelsTable(modelsTableModel);
        modelsTableModel.setWritable(this.isWritable());
        this.dataMinerTablePanel.setup((TableModel)((Object)modelsTableModel), BuildEditorLrb.get("BUILD_MODEL_SETTINGS_LBL"), new String[]{modelsTableModel.COLUMN_NAMES[0], modelsTableModel.COLUMN_NAMES[5]}, 0);
        this.createTuneDropDown();
        this.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    XMLGregorianCalendar xMLGregorianCalendar;
                    boolean bl = false;
                    ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)ClassificationBuildPIComponentBuildPanel.this.getTable().getModel());
                    if (modelsTableModel.getDataVector().isEmpty()) {
                        return;
                    }
                    int[] nArray = ClassificationBuildPIComponentBuildPanel.this.getTable().getSelectedRowsInModel();
                    if (nArray.length == 0) {
                        return;
                    }
                    ModelType modelType = modelsTableModel.getDataVector().get(nArray[0]);
                    if (modelType.getStatus() == ModelStatusType.COMPLETE) {
                        bl = true;
                    } else if (modelType.getStatus() == ModelStatusType.READY && (xMLGregorianCalendar = modelType.getCreationDate()) != null) {
                        bl = true;
                    }
                    if (bl) {
                        ClassificationBuildPIComponentBuildPanel.this.viewModel();
                    }
                }
            }
        });
        this._viewModelBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_ENA));
        this._viewModelBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_VIEW"));
        this._viewModelBtn.setDisabledIcon(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_DIS));
        this._viewModelBtn.setEnabled(false);
        this._viewModelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationBuildPIComponentBuildPanel.this.viewModel();
            }
        });
        this._viewTestBtn = new JButton(OracleIcons.getIcon((String)"showdifferences.png"));
        this._viewTestBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_RESULTS_COMPARE"));
        this._viewTestBtn.setEnabled(this.compareEnabled());
        this._viewTestBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<ClassificationResultType> arrayList = new ArrayList<ClassificationResultType>();
                for (ClassificationResultType classificationResultType : ClassificationBuildPIComponentBuildPanel.this._classResults) {
                    XMLGregorianCalendar xMLGregorianCalendar = classificationResultType.getCreationDate();
                    if (xMLGregorianCalendar == null) continue;
                    arrayList.add(classificationResultType);
                }
                if (arrayList.isEmpty()) {
                    return;
                }
                ClassificationBuildPIComponentBuildPanel.this.viewCompare(arrayList);
            }
        });
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_REMOVE"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = BuildEditDialog.getModelsDeleteMessage((JTable)((Object)ClassificationBuildPIComponentBuildPanel.this.getTable()));
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)BuildEditorLrb.get("REMOVE_MODELS_TITLE"), null, (boolean)true)) {
                    return;
                }
                int[] nArray = ClassificationBuildPIComponentBuildPanel.this.getTable().getSelectedRowsInModel();
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)ClassificationBuildPIComponentBuildPanel.this.getTable().getModel());
                ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                for (int i = 0; i < nArray.length; ++i) {
                    ModelType modelType = modelsTableModel.getDataVector().get(nArray[i]);
                    arrayList.add(modelType);
                }
                ClassificationBuildPIComponentBuildPanel.this.setValue(arrayList, "modelRemoved", "modelAdded");
            }
        });
        this._removeBtn.setEnabled(false);
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ADD"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelType modelType;
                AbstractBuildNode abstractBuildNode = ClassificationBuildPIComponentBuildPanel.this.getTargetNode((PropertyModel)ClassificationBuildPIComponentBuildPanel.this._model);
                if (abstractBuildNode instanceof ClassificationBuildNode && (modelType = NewModelPanel.addNewModel(ClassificationBuildPIComponentBuildPanel.this, (BuildNodeType)abstractBuildNode.getData(), ClassificationBuildPIComponentBuildPanel.this.getContext((PropertyModel)ClassificationBuildPIComponentBuildPanel.this._model), abstractBuildNode)) != null) {
                    ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                    arrayList.add(modelType);
                    ClassificationBuildPIComponentBuildPanel.this.setValue(arrayList, "modelAdded", "modelRemoved");
                }
            }
        });
        this._addBtn.setEnabled(this.isWritable());
        this.dataMinerTablePanel.addControlBarComponents(new Component[]{this._addBtn, this._removeBtn, this._duplicateBtn, this._viewModelBtn, this._viewTestBtn, this._tuneBtn});
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ClassificationBuildPIComponentBuildPanel.this.handleModelSelectionChanged();
            }
        });
        this.getTable().setFillsViewportHeight(true);
    }

    @Override
    protected DataMinerTable getTable() {
        return this.dataMinerTablePanel.getTable();
    }

    protected void updateWorkFlow() {
        this.updateWorkFlowInternal();
    }

    public void reloadUI(PropertyModel propertyModel) {
        Object object;
        ModelsTableModel modelsTableModel;
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        int[] nArray = this.getTable().getSelectedRowsInModel();
        ArrayList<ModelType> arrayList = null;
        if (nArray != null && nArray.length > 0) {
            modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
            arrayList = new ArrayList<ModelType>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                object = modelsTableModel.getDataVector().get(nArray[i]);
                arrayList.add((ModelType)object);
            }
        }
        this._models.clear();
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this._isPartitionModel = !abstractBuildNode.getPartitionAttributes(null).isEmpty();
        this._classResults.clear();
        this._classResults = MetaDataHelper.getClassResultsCollection(abstractBuildNode);
        this._classResultsForTuning.clear();
        this._classResultsForTuning = MetaDataHelper.getClassResultsForTuningCollection(abstractBuildNode);
        modelsTableModel = new ModelsTableModel(this._models);
        this.setupModelsTable(modelsTableModel);
        modelsTableModel.setWritable(this.isWritable());
        if (arrayList != null) {
            Object object2;
            Vector<Integer> vector = new Vector<Integer>();
            object = modelsTableModel.getDataVector();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                object2 = (ModelType)((Vector)object).get(i);
                if (!arrayList.contains(object2)) continue;
                vector.add(i);
            }
            if (!vector.isEmpty()) {
                Integer[] integerArray = vector.toArray(new Integer[vector.size()]);
                object2 = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object2[i] = (ModelType)integerArray[i];
                }
                this.getTable().setSelectedRowsInModel((int[])object2);
            }
        }
        this._viewTestBtn.setEnabled(this.compareEnabled());
    }

    @Override
    protected ModelType getModelType(int n) {
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
        ModelType modelType = modelsTableModel.getDataVector().get(this.getTable().convertRowIndexToModel(n));
        return modelType;
    }

    private void setupModelsTable(ModelsTableModel modelsTableModel) {
        this.getTable().setModel((TableModel)((Object)modelsTableModel));
        this.getTable().setSorted(true);
        this.getTable().setUpdateSelectionOnSort(true);
        this.getTable().getTableHeader().setReorderingAllowed(false);
        this.getTable().sizeTableToContents();
        this.getTable().setAutoResizeMode(4);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)jTable.getModel());
                if (modelsTableModel.getDataVector().isEmpty()) {
                    return null;
                }
                int n3 = jTable.convertRowIndexToModel(n);
                ModelType modelType = modelsTableModel.getDataVector().get(n3);
                return IconCellRenderer.getIconForPIStatus(modelType.getStatus());
            }
        });
        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(iconCellRenderer);
        IconCellRenderer iconCellRenderer2 = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)jTable.getModel());
                int n3 = jTable.convertRowIndexToModel(n);
                if (modelsTableModel.getDataVector().isEmpty()) {
                    return null;
                }
                ModelType modelType = modelsTableModel.getDataVector().get(n3);
                ClassificationResultType classificationResultType = null;
                for (ClassificationResultType classificationResultType2 : ClassificationBuildPIComponentBuildPanel.this._classResults) {
                    if (!classificationResultType2.getModelId().equals(modelType.getId())) continue;
                    classificationResultType = classificationResultType2;
                    break;
                }
                if (object.equals(ClassificationBuildPIComponentBuildPanel.NOT_TESTED)) {
                    return OracleIcons.getIcon((String)"incompletestatus.png");
                }
                if (classificationResultType != null) {
                    return IconCellRenderer.getIconForPIStatus(classificationResultType.getStatus());
                }
                return OracleIcons.getIcon((String)"database_error.png");
            }
        });
        TableColumn tableColumn2 = this.getTable().getColumnModel().getColumn(3);
        tableColumn2.setCellRenderer(iconCellRenderer2);
        TableColumn tableColumn3 = this.getTable().getColumnModel().getColumn(1);
        tableColumn3.setCellEditor(new OutputCellEditor());
        tableColumn3.setCellRenderer(new OutputCellRenderer());
        TableColumn tableColumn4 = this.getTable().getColumnModel().getColumn(6);
        tableColumn4.setCellEditor(new CommentTextFieldEditor(this.getContext((PropertyModel)this._model)));
        tableColumn4.setMaxWidth(200);
        TableColumn tableColumn5 = this.getTable().getColumnModel().getColumn(0);
        tableColumn5.setCellEditor(new ModelNameCellEditor(this.getContext((PropertyModel)this._model), this.getWorkflowModel(), (BuildNodeType)this.getTargetNode((PropertyModel)this._model).getData()));
        tableColumn5.setMinWidth(100);
    }

    @Override
    public boolean isWritable() {
        return ClassificationBuildPIComponentHelper.isWritable((PropertyModel)this._model);
    }

    private void setEnabled(AbstractButton[] abstractButtonArray, boolean[] blArray) {
        boolean bl = this.isWritable();
        AbstractButtonState abstractButtonState = new AbstractButtonState(abstractButtonArray, blArray);
        abstractButtonState.setState(bl);
    }

    private void setValue(ModelType modelType, Object object) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (object != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(modelType.getId(), (String)object);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.MODEL_ANNOTATION), null, new ComplexProperty("modelAnnotation", hashMap), null, null));
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(List<Pair<String, Boolean>> list) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.MODEL_USEFOROUTPUT), null, new ComplexProperty("modelUseForOutput", list), null, null));
        this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT"), abstractBuildNode, arrayList);
        this.updateWorkFlow();
    }

    @Override
    protected void setValue(List<ModelType> list, String string, String string2) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (list != null && !list.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.MODEL_ADDED_REMOVED), null, new ComplexProperty(string, string2, list), null, null));
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)abstractBuildNode.getData();
            ArrayList<ClassificationResultType> arrayList2 = new ArrayList<ClassificationResultType>();
            block0: for (ModelType modelType : list) {
                for (ClassificationResultType classificationResultType : classificationBuildNodeType.getResults().getClassificationResult()) {
                    if (!modelType.getId().equals(classificationResultType.getModelId())) continue;
                    arrayList2.add(classificationResultType);
                    continue block0;
                }
            }
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.TESTS_ADDED_REMOVED), null, new ComplexProperty("testsRemoved", "testsRestored", arrayList2), null, null));
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ADDED_REMOVED"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void handleModelSelectionChanged() {
        Object[] objectArray;
        AbstractButton[] abstractButtonArray;
        boolean bl;
        boolean bl2 = false;
        int n = this.getTable().getSelectedRowCount();
        boolean bl3 = bl = n == 1;
        if (n > 0) {
            XMLGregorianCalendar xMLGregorianCalendar;
            abstractButtonArray = (AbstractButton[])this.getTable().getModel();
            objectArray = this.getTable().getSelectedRowsInModel();
            ModelType modelType = abstractButtonArray.getDataVector().get(objectArray[0]);
            if (modelType.getStatus() == ModelStatusType.COMPLETE) {
                bl2 = true;
            } else if (modelType.getStatus() == ModelStatusType.READY && (xMLGregorianCalendar = modelType.getCreationDate()) != null) {
                bl2 = true;
            }
        }
        this._viewModelBtn.setEnabled(bl2 && bl);
        this._viewTestBtn.setEnabled(this.compareEnabled());
        this._tuneBtn.setEnabled(this.tuneEnabled());
        abstractButtonArray = new AbstractButton[]{this._removeBtn, this._addBtn, this._duplicateBtn};
        objectArray = new boolean[]{n != -1, true, n > 0};
        this.setEnabled(abstractButtonArray, (boolean[])objectArray);
    }

    private boolean tuneEnabled() {
        boolean bl = false;
        if (!this._isPartitionModel) {
            int[] nArray = this.getTable().getSelectedRowsInModel();
            if (nArray == null || nArray.length == 0) {
                return false;
            }
            bl = true;
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
            for (int i = 0; i < nArray.length; ++i) {
                ModelType modelType = modelsTableModel.getDataVector().get(nArray[0]);
                if (modelType.getStatus() == ModelStatusType.COMPLETE) continue;
                bl = false;
                break;
            }
        }
        return this.isWritable() && bl;
    }

    private boolean compareEnabled() {
        boolean bl = false;
        if (this._classResults.size() > 1) {
            for (ClassificationResultType classificationResultType : this._classResults) {
                XMLGregorianCalendar xMLGregorianCalendar = classificationResultType.getCreationDate();
                if (xMLGregorianCalendar == null) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void viewCompare(List<ClassificationResultType> list) {
        Context context = this.getContext((PropertyModel)this._model);
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        try {
            Element[] elementArray = context.getSelection();
            WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
            NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
            if (nodeType instanceof ClassificationBuildNodeType) {
                ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)nodeType;
                TestCompareNode testCompareNode = WorkflowEditor.createClassTestCompareNode(context, workflowNode, classificationBuildNodeType, list);
                if (testCompareNode != null) {
                    EditorUtil.openDefaultEditorInFrame((Node)testCompareNode);
                } else {
                    MessageDialog.error((Component)this, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                }
            }
        }
        catch (DBException dBException) {
            theLogger.log(Level.SEVERE, dBException.getMessage(), dBException);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void viewModel() {
        int[] nArray = this.getTable().getSelectedRowsInModel();
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
        ModelType modelType = modelsTableModel.getDataVector().get(nArray[0]);
        if (modelType instanceof CSupportVectorMachineModelType) {
            LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer(modelType);
            loadSVMModelViewer.execute();
        } else {
            Class clazz = null;
            if (modelType instanceof NaiveBayesModelType) {
                clazz = NBModelNode.class;
            } else if (modelType instanceof DecisionTreeModelType) {
                clazz = DTModelNode.class;
            } else if (modelType instanceof CGeneralizedLinearModelType) {
                clazz = GLMCModelNode.class;
            }
            Context context = this.getContext((PropertyModel)this._model);
            String string = modelType.getName();
            String string2 = this.getTargetNode((PropertyModel)this._model).getData().getName();
            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
            BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string2, string);
            EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
        }
    }

    private void createTuneDropDown() {
        this._tuneBtn = new DropDownMenuButton();
        this._tuneBtn.setEnabled(false);
        this._tuneBtn.setIcon((Icon)DataMinerIcons.get(Icons.TUNE));
        this._tuneBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_TUNE"));
        this._tuneBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    int[] nArray = ClassificationBuildPIComponentBuildPanel.this.getTable().getSelectedRowsInModel();
                    ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)ClassificationBuildPIComponentBuildPanel.this.getTable().getModel());
                    final HashMap<String, TuningType> hashMap = new HashMap<String, TuningType>();
                    for (int i = 0; i < nArray.length; ++i) {
                        ModelType modelType = modelsTableModel.getDataVector().get(nArray[i]);
                        hashMap.put(modelType.getId(), _notuning);
                    }
                    if (!hashMap.isEmpty()) {
                        ClassificationBuildPIComponentBuildPanel.this._tuneBtn.addPopupItem((Action)new AbstractAction(PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE")){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                ClassificationBuildPIComponentBuildPanel.this.setTuning(hashMap, _notuning);
                            }
                        });
                        ClassificationBuildPIComponentBuildPanel.this._tuneBtn.addPopupItem((Action)new AbstractAction(PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_TUNED")){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                ClassificationBuildPIComponentBuildPanel.this.setCustomTuning(hashMap);
                            }
                        });
                    }
                } else if (itemEvent.getStateChange() == 2) {
                    ClassificationBuildPIComponentBuildPanel.this._tuneBtn.removeAllPopupItems();
                }
            }
        });
    }

    private void setCustomTuning(Map<String, Object> map) {
        Object object;
        Object object2;
        ArrayList<ClassificationResultType> arrayList = new ArrayList<ClassificationResultType>(map.size());
        Context context = this._classResultsForTuning.iterator();
        while (context.hasNext()) {
            object2 = context.next();
            if (!map.containsKey(object2.getModelId())) continue;
            arrayList.add((ClassificationResultType)object2);
        }
        if (arrayList.isEmpty()) {
            context = this._models.iterator();
            while (context.hasNext()) {
                object2 = (ModelType)context.next();
                if (!map.containsKey(object2.getId())) continue;
                object = new ClassificationResultType();
                object.setCreationDate(object2.getCreationDate());
                object.setModelId(object2.getId());
                object.setName(object2.getName());
                object.setStatus(object2.getStatus());
                arrayList.add((ClassificationResultType)object);
            }
        }
        if (((TuneDialog)(object2 = new TuneDialog())).invoke(context = this.getContext((PropertyModel)this._model), arrayList, this.getTargetNode((PropertyModel)this._model))) {
            object = ((AbstractPropertiesDialog)object2).getUserObject();
            if (object == null) {
                return;
            }
            if (!(object instanceof Hashtable)) {
                return;
            }
            Hashtable hashtable = (Hashtable)((Hashtable)object).get("MODEL_SETTING_TUNE_OPTION");
            if (hashtable.isEmpty()) {
                return;
            }
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
            for (ClassificationResultType classificationResultType : this._classResults) {
                if (!hashtable.containsKey(classificationResultType.getModelId()) || !classificationResultType.getStatus().equals((Object)ModelStatusType.COMPLETE)) continue;
                hashMap.put(classificationResultType.getModelId(), ModelStatusType.READY);
            }
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.TUNING), null, new ComplexProperty("tuningChanged", hashtable), null, null));
            arrayList2.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.TESTS_RERUN), null, new ComplexProperty("testsRerun", hashMap), null, null));
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_TUNED"), this.getTargetNode((PropertyModel)this._model), arrayList2);
            this.updateWorkFlow();
        }
    }

    private void setTuning(Map<String, Object> map, Object object) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        Set<String> set = map.keySet();
        for (String object22 : set) {
            map.put(object22, object);
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        for (ClassificationResultType classificationResultType : this._classResults) {
            if (!map.containsKey(classificationResultType.getModelId()) || !classificationResultType.getStatus().equals((Object)ModelStatusType.COMPLETE)) continue;
            hashMap.put(classificationResultType.getModelId(), ModelStatusType.READY);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.TUNING), null, new ComplexProperty("tuningChanged", map), null, null));
        arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.TESTS_RERUN), null, new ComplexProperty("testsRerun", hashMap), null, null));
        this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_TUNED_CHANGED"), this.getTargetNode((PropertyModel)this._model), arrayList);
        this.updateWorkFlow();
    }

    static {
        _notuning.setNone(new TuningType.None());
    }

    private class LoadSVMModelViewer
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        ModelType _modelType;
        boolean _isLinear = false;

        public LoadSVMModelViewer(ModelType modelType) {
            this._modelType = modelType;
        }

        protected Object doInBackground() throws Exception {
            try {
                Model model = new Model();
                Context context = ClassificationBuildPIComponentBuildPanel.this.getContext((PropertyModel)ClassificationBuildPIComponentBuildPanel.this._model);
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
                String string = connectionFolder.getUserAccountName();
                Vector<MiningModelSettings> vector = model.getModelSetting(connectionFolder, string, this._modelType.getName());
                MiningModelSettings miningModelSettings = MiningModelSettings.findSetting("SVMS_KERNEL_FUNCTION", vector);
                this._isLinear = miningModelSettings.getSettingValue().equals("SVMS_LINEAR");
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return this._isLinear;
        }

        @Override
        protected void done() {
            super.done();
            if (this._success && this._ex == null) {
                Context context = ClassificationBuildPIComponentBuildPanel.this.getContext((PropertyModel)ClassificationBuildPIComponentBuildPanel.this._model);
                BaseTreeNode baseTreeNode = null;
                String string = this._modelType.getName();
                if (string != null) {
                    WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                    String string2 = ClassificationBuildPIComponentBuildPanel.this.getTargetNode((PropertyModel)ClassificationBuildPIComponentBuildPanel.this._model).getData().getName();
                    baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string2, string);
                    EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
                }
            } else if (this._ex != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_MESG"), null);
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_MESG"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), null);
            }
        }
    }

    class ModelsTableModel
    extends GenericBaseTableModel
    implements BuildNodeTableModel {
        private final String[] COLUMN_NAMES = new String[]{PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_NAME"), PropertyLrb.get("PI_ATTRIBUTES_MODEL_USE_FOR_OUTPUT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_BUILD"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_COMMENT")};
        private static final int MODEL_NAME = 0;
        private static final int OUTPUT = 1;
        private static final int BUILD = 2;
        private static final int TEST = 3;
        private static final int TUNE = 4;
        private static final int ALGORITHM = 5;
        private static final int COMMENT = 6;
        private Vector<ModelType> _srcData;
        private Map<String, ModelType> _srcMap;
        private boolean _writable = true;

        public ModelsTableModel(List<ModelType> list) {
            this._srcData = new Vector(list.size());
            this._srcData.addAll(list);
            this._srcMap = new HashMap<String, ModelType>();
            for (ModelType modelType : list) {
                this._srcMap.put(modelType.getName(), modelType);
            }
            this.setColumnIdentifiers(this.COLUMN_NAMES);
            this.setRowCount(this._srcData.size());
            this.setColumnCount(this.COLUMN_NAMES.length);
        }

        @Override
        public List<ModelType> getDataList() {
            return new ArrayList<ModelType>(this._srcData);
        }

        public Comparator getColumnSortComparator(int n) {
            switch (n) {
                case 1: {
                    return BooleanComparator.getComparator();
                }
            }
            return super.getColumnSortComparator(n);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public void setWritable(boolean bl) {
            this._writable = bl;
        }

        public Vector<ModelType> getDataVector() {
            return this._srcData;
        }

        @Override
        public String getOriginalModelName(int n) {
            String string = null;
            ModelType modelType = this._srcData.get(n);
            string = modelType.getName();
            return string;
        }

        public Class<?> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return String.class;
        }

        public Pair getValueAtCheckBoxColumn(int n) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            ModelType modelType = this._srcData.get(n);
            Pair pair = new Pair((Object)modelType.getName(), (Object)modelType.isUseForOutput());
            return pair;
        }

        public Object getValueAt(int n, int n2) {
            if (this._srcData.isEmpty()) {
                return null;
            }
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelType modelType = this._srcData.get(n);
            Object object = null;
            block0 : switch (n2) {
                case 0: {
                    object = modelType.getName();
                    break;
                }
                case 5: {
                    object = MetaDataHelper.getAlgorithmName(modelType);
                    break;
                }
                case 3: {
                    object = _NOT_TESTED;
                    for (ClassificationResultType classificationResultType : ClassificationBuildPIComponentBuildPanel.this._classResults) {
                        if (!modelType.getId().equals(classificationResultType.getModelId())) continue;
                        XMLGregorianCalendar xMLGregorianCalendar = classificationResultType.getCreationDate();
                        if (xMLGregorianCalendar == null) break block0;
                        object = TimeUtils.formatDate(xMLGregorianCalendar);
                        break block0;
                    }
                    break;
                }
                case 4: {
                    object = _NONE;
                    if (!(modelType instanceof ClassificationModelType)) break;
                    ClassificationModelType classificationModelType = (ClassificationModelType)modelType;
                    TuningType tuningType = classificationModelType.getTuning();
                    if (tuningType == null) {
                        object = _NONE;
                        break;
                    }
                    if (null != tuningType.getCustom()) {
                        if (null != tuningType.getCustom().getSettings().getROC()) {
                            object = _ROC;
                            break;
                        }
                        if (null != tuningType.getCustom().getSettings().getLift()) {
                            object = _LIFT;
                            break;
                        }
                        if (null == tuningType.getCustom().getSettings().getProfit()) break;
                        object = _PROFIT;
                        break;
                    }
                    if (null != tuningType.getCost()) {
                        object = _COST;
                        break;
                    }
                    if (null == tuningType.getBenefit()) break;
                    object = _BENEFIT;
                    break;
                }
                case 2: {
                    XMLGregorianCalendar xMLGregorianCalendar = modelType.getCreationDate();
                    if (xMLGregorianCalendar != null) {
                        object = TimeUtils.formatDate(xMLGregorianCalendar);
                        break;
                    }
                    object = GeneralBuildPIPanel._NOT_BUILT;
                    break;
                }
                case 6: {
                    String string = modelType.getAnnotation();
                    object = string != null ? string : "";
                    break;
                }
                case 1: {
                    object = modelType.isUseForOutput() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 6 || n2 == 0 || n2 == 1) {
                return this._writable;
            }
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            ModelType modelType = this._srcData.get(n);
            switch (n2) {
                case 6: {
                    ClassificationBuildPIComponentBuildPanel.this.setValue(modelType, object);
                    this.fireTableCellUpdated(n, n2);
                    break;
                }
                case 0: {
                    ClassificationBuildPIComponentBuildPanel.this.renameModel(this._srcData, object, n, n2);
                    break;
                }
                case 1: {
                    Boolean bl = (Boolean)object;
                    ArrayList<Pair> arrayList = new ArrayList<Pair>();
                    arrayList.add(new Pair((Object)modelType.getId(), (Object)bl));
                    ClassificationBuildPIComponentBuildPanel.this.setValue(arrayList);
                    break;
                }
                default: {
                    throw new RuntimeException("Not a valid column");
                }
            }
        }
    }
}

