/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.util.ResourceUtils;

public class OutLierPanelStdDev
extends JPanel {
    private TransformationType.Outlier outlier;
    private Double stdDev;
    private Object average;
    private boolean wizard;
    private ButtonGroup buttonGroup1;
    private JRadioButton jBtnEdge;
    private JRadioButton jBtnNulls;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLblLowerTxt;
    private JTextField jLblMultiples;
    private JLabel jLblReplaceWith;
    private JLabel jLblUpperTxt;

    public OutLierPanelStdDev(TransformationType.Outlier outlier, Double d, Object object, boolean bl) {
        this.outlier = outlier;
        this.stdDev = d;
        this.average = object;
        this.wizard = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLblLowerTxt = new JLabel();
        this.jLblUpperTxt = new JLabel();
        this.jLblReplaceWith = new JLabel();
        this.jBtnNulls = new JRadioButton();
        this.jBtnEdge = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jLblMultiples = new NumberTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLblLowerTxt.setText("Lower Value:");
        this.jLblUpperTxt.setText("Upper Value:");
        this.jLblReplaceWith.setText("Replace With:");
        this.jBtnNulls.setText("Nulls");
        this.jBtnEdge.setText("Edge Values");
        this.jLabel1.setText("Outlier Type:");
        this.jLblMultiples.setHorizontalAlignment(4);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("jLabel2");
        this.jLabel2.setHorizontalTextPosition(4);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("jLabel3");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(37, 37, 37).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(36, 36, 36).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBtnEdge).addComponent(this.jBtnNulls))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblUpperTxt, -1, 110, Short.MAX_VALUE).addComponent(this.jLblLowerTxt, -2, 110, -2))).addComponent(this.jLblReplaceWith, -2, 119, -2)).addGap(44, 44, 44)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 158, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblMultiples, -2, 66, -2).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -2, 53, -2)))).addGap(36, 36, 36)));
        groupLayout.linkSize(0, this.jLblLowerTxt, this.jLblUpperTxt);
        groupLayout.linkSize(0, this.jLabel2, this.jLabel3);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLblMultiples, -2, -1, -2)).addGap(13, 13, 13).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblLowerTxt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLblUpperTxt).addGap(18, 18, 18).addComponent(this.jLblReplaceWith).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jBtnNulls).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jBtnEdge)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabel1, (Component)this.jLblMultiples, (String)XformDialogsLrb.get("OUTLIER_STD_DEV_MULTIPLES"));
        ResourceUtils.resLabel((JLabel)this.jLblLowerTxt, (Component)this.jLabel2, (String)XformDialogsLrb.get("OUTLIER_STD_DEV_LOWER"));
        ResourceUtils.resLabel((JLabel)this.jLblUpperTxt, (Component)this.jLabel3, (String)XformDialogsLrb.get("OUTLIER_STD_DEV_UPPER"));
        this.jLblReplaceWith.setText(XformDialogsLrb.get("OUTLIER_COMMON_REPLACE_WITH"));
        this.jBtnNulls.setText(XformDialogsLrb.get("OUTLIER_COMMON_NULLS"));
        this.jBtnEdge.setText(XformDialogsLrb.get("OUTLIER_COMMON_EDGE_VALUES"));
    }

    public void initUI() {
        Double d = null;
        boolean bl = true;
        if (!this.wizard && this.outlier != null) {
            TransformationType.Outlier.StandardDeviation standardDeviation = this.outlier.getStandardDeviation();
            if (standardDeviation != null) {
                d = standardDeviation.getMultiplesSigma();
            }
            bl = this.outlier.getReplaceWith().equals(TransformationStatisticsState.NULLS);
        }
        this.buttonGroup1.add(this.jBtnNulls);
        this.buttonGroup1.add(this.jBtnEdge);
        this.jBtnNulls.setSelected(bl);
        this.jBtnEdge.setSelected(!bl);
        if (d == null) {
            d = 3.0;
        }
        ((NumberTextField)this.jLblMultiples).setDataType(Double.class);
        ((NumberTextField)this.jLblMultiples).setSigned(false);
        this.jLblMultiples.setLocale(Locale.getDefault());
        ((NumberTextField)this.jLblMultiples).setNumber((Number)d);
        if (this.wizard) {
            this.jLabel2.setVisible(false);
            this.jLabel3.setVisible(false);
        } else {
            this.updateUpperLower(d);
        }
        this.jLblMultiples.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Double d = ((NumberTextField)OutLierPanelStdDev.this.jLblMultiples).getNumber().doubleValue();
                OutLierPanelStdDev.this.updateUpperLower(d);
            }
        });
    }

    private void updateUpperLower(Double d) {
        if (this.stdDev == null || this.average == null || d == null || !(this.average instanceof Double)) {
            this.jLabel2.setText("");
            this.jLabel3.setText("");
        } else {
            double d2 = (Double)this.average - d * this.stdDev;
            double d3 = (Double)this.average + d * this.stdDev;
            this.jLabel2.setText(NumericFormat.format(d2, true, 5));
            this.jLabel3.setText(String.valueOf(NumericFormat.format(d3, true, 5)));
        }
    }

    public Double getSigmaMultiple() {
        return ((NumberTextField)this.jLblMultiples).getNumber().doubleValue();
    }

    public String getReplaceWith() {
        return this.jBtnNulls.isSelected() ? TransformationStatisticsState.NULLS : TransformationStatisticsState.EDGES;
    }
}

