/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.util.ResourceUtils;

public class OutLierPanelPercent
extends JPanel {
    private TransformationType.Outlier outlier;
    private boolean wizard;
    private ButtonGroup buttonGroup1;
    private JRadioButton jBtnEdge;
    private JRadioButton jBtnNulls;
    private JLabel jLblLowerTxt;
    private JLabel jLblReplaceWith;
    private JLabel jLblUpperTxt;
    private JTextField jTextLower;
    private JTextField jTextUpper;

    public OutLierPanelPercent(TransformationType.Outlier outlier, boolean bl) {
        this.outlier = outlier;
        this.wizard = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLblLowerTxt = new JLabel();
        this.jLblUpperTxt = new JLabel();
        this.jLblReplaceWith = new JLabel();
        this.jBtnNulls = new JRadioButton();
        this.jBtnEdge = new JRadioButton();
        this.jTextLower = new NumberTextField();
        this.jTextUpper = new NumberTextField();
        this.jLblLowerTxt.setText("Lower Value:");
        this.jLblUpperTxt.setText("Upper Value:");
        this.jLblReplaceWith.setText("Replace With:");
        this.jBtnNulls.setText("Nulls");
        this.jBtnEdge.setText("Edge Values");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jLblReplaceWith, -2, 120, -2).addContainerGap(171, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(70, 70, 70).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBtnEdge).addComponent(this.jBtnNulls)).addContainerGap(154, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(46, 46, 46).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLblLowerTxt, -2, 124, -2).addComponent(this.jLblUpperTxt, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextLower, -1, 65, Short.MAX_VALUE).addComponent(this.jTextUpper, GroupLayout.Alignment.TRAILING, -2, 65, -2)).addGap(82, 82, 82)));
        groupLayout.linkSize(0, this.jTextLower, this.jTextUpper);
        groupLayout.linkSize(0, this.jLblLowerTxt, this.jLblUpperTxt);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTextLower, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextUpper, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblLowerTxt).addGap(18, 18, 18).addComponent(this.jLblUpperTxt))).addGap(18, 18, 18).addComponent(this.jLblReplaceWith).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jBtnNulls).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jBtnEdge).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLblLowerTxt, (Component)this.jTextLower, (String)XformDialogsLrb.get("OUTLIER_PERCENT_LOWER"));
        ResourceUtils.resLabel((JLabel)this.jLblUpperTxt, (Component)this.jTextUpper, (String)XformDialogsLrb.get("OUTLIER_PERCENT_UPPER"));
        this.jLblReplaceWith.setText(XformDialogsLrb.get("OUTLIER_COMMON_REPLACE_WITH"));
        this.jBtnNulls.setText(XformDialogsLrb.get("OUTLIER_COMMON_NULLS"));
        this.jBtnEdge.setText(XformDialogsLrb.get("OUTLIER_COMMON_EDGE_VALUES"));
    }

    public void initUI() {
        boolean bl = true;
        double d = 5.0;
        double d2 = 5.0;
        if (!this.wizard && this.outlier != null) {
            TransformationType.Outlier.Percent percent = this.outlier.getPercent();
            if (percent != null) {
                d = Double.valueOf(NumericFormat.format(percent.getLowerPercent(), false, 2));
                this.setPercentValue(this.jTextLower, d);
                d2 = Double.valueOf(NumericFormat.format(percent.getUpperPercent(), false, 2));
                this.setPercentValue(this.jTextUpper, d2);
            }
            bl = this.outlier.getReplaceWith().equals(TransformationStatisticsState.NULLS);
        }
        this.setPercentValue(this.jTextLower, d);
        this.setPercentValue(this.jTextUpper, d2);
        this.buttonGroup1.add(this.jBtnNulls);
        this.buttonGroup1.add(this.jBtnEdge);
        this.jBtnNulls.setSelected(bl);
        this.jBtnEdge.setSelected(!bl);
    }

    private void setPercentValue(JTextField jTextField, double d) {
        ((NumberTextField)jTextField).setDataType(Double.class);
        ((NumberTextField)jTextField).setSigned(false);
        jTextField.setLocale(Locale.getDefault());
        ((NumberTextField)jTextField).setNumber((Number)d);
    }

    public String getReplaceWith() {
        return this.jBtnNulls.isSelected() ? TransformationStatisticsState.NULLS : TransformationStatisticsState.EDGES;
    }

    public Double getLowerPercent() {
        if (null == this.jTextLower.getText()) {
            return null;
        }
        Number number = ((NumberTextField)this.jTextLower).getNumber();
        return number != null ? Double.valueOf(number.doubleValue()) : null;
    }

    public Double getUpperPercent() {
        if (null == this.jTextUpper.getText()) {
            return null;
        }
        Number number = ((NumberTextField)this.jTextUpper).getNumber();
        return number != null ? Double.valueOf(number.doubleValue()) : null;
    }
}

