/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningCustomBase;
import oracle.dmt.dataminer.workflow.dialog.transformations.NullBinsSelectionPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.xmlschema.TransformNulls;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;

public class BinningCustomNumeric
extends BinningCustomBase {
    private boolean invalidRange = false;
    private JTextField jTxtNullValue;
    private NullBinsSelectionPanel jLabelExplanation;
    private ComponentWithTitlebar<JComponent> jBinsTableComponent;
    private JPanel jHostPanel;
    private JCheckBox jchkBoxXformNulls;

    @Override
    public boolean isInvalidRange() {
        return this.invalidRange;
    }

    public BinningCustomNumeric(String string, String string2, TransformationStatisticsState transformationStatisticsState, String string3, Object object, int n, TransformNulls transformNulls) {
        super(string, string2, transformationStatisticsState, string3, object, n, transformNulls);
        this.initComponents();
        this.initElements();
        this.loadComponents();
    }

    private void initComponents() {
        this.jBinsTableComponent = new ComponentWithTitlebar();
        this.jchkBoxXformNulls = new JCheckBox();
        this.jHostPanel = new JPanel();
        this.jchkBoxXformNulls.setText("Transform NULL's");
        this.jHostPanel.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jchkBoxXformNulls, -1, 144, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jHostPanel, -1, 282, Short.MAX_VALUE)).addComponent((Component)this.jBinsTableComponent, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jBinsTableComponent, -1, 209, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jchkBoxXformNulls).addComponent(this.jHostPanel, -2, 23, -2))));
    }

    @Override
    protected JLabel getJLabelOther() {
        return null;
    }

    @Override
    protected JCheckBox getCheckBoxBoxXformNulls() {
        return this.jchkBoxXformNulls;
    }

    @Override
    public JTextField getJTextFieldOther() {
        return null;
    }

    @Override
    public JPanel getHostPanel() {
        return this.jHostPanel;
    }

    @Override
    public JTextField getTxtNullValue() {
        return this.jTxtNullValue;
    }

    @Override
    public void enableNullBins(boolean bl) {
        this.jTxtNullValue.setEnabled(bl);
        this.jLabelExplanation.enableControls(bl);
    }

    @Override
    protected ComponentWithTitlebar<JComponent> getComponentWithTitlebar() {
        return this.jBinsTableComponent;
    }

    protected void initElements() {
        this.jLabelExplanation = new NullBinsSelectionPanel(this);
        this.jTxtNullValue = new JTextField();
    }

    protected void setExplanation(TransformNulls transformNulls) {
        this.jLabelExplanation.setNullBinPlacementSelection(transformNulls);
    }

    @Override
    protected void setExplanation(int n) {
        if (!this.jLabelExplanation.isCustomNullValuePlacementSelection() && this.jchkBoxXformNulls.isSelected()) {
            this.jLabelExplanation.setBinIdAuto(n);
        }
    }

    @Override
    protected void addTransfromNullsActionListener() {
        this.jchkBoxXformNulls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = BinningCustomNumeric.this.jchkBoxXformNulls.isSelected();
                BinningCustomNumeric.this.transformNulls.setIncludeNulls(bl);
                if (null != BinningCustomNumeric.this.jTxtNullValue) {
                    BinningCustomNumeric.this.enableNullBins(bl);
                }
                BinningCustomNumeric.this.jLabelExplanation.enableControls(bl);
                if (bl) {
                    BinningCustomBase.BinsTableModel binsTableModel = (BinningCustomBase.BinsTableModel)((Object)BinningCustomNumeric.this._jAttributesTable.getModel());
                    Vector<NameValuePair> vector = binsTableModel.getDataVector();
                    boolean bl2 = null != ((TransformationType.Binning.CustomNumeric)BinningCustomNumeric.this.customBinning).getBinLabels().getNumberSequence();
                    int n = BinningCustomNumeric.this.findMaxNumBinValue(vector, bl2);
                    if (!BinningCustomNumeric.this.jLabelExplanation.isCustomNullValuePlacementSelection()) {
                        BinningCustomNumeric.this.jLabelExplanation.setBinIdAuto(n);
                    }
                }
            }
        });
    }

    @Override
    protected void setupItemsTable(final BinningCustomBase.BinsTableModel binsTableModel, GenericTable genericTable) {
        super.setupItemsTable(binsTableModel, genericTable);
        final NumberTextField numberTextField = new NumberTextField();
        numberTextField.setDecimal(true);
        numberTextField.setSigned(true);
        numberTextField.setGroupingEnabled(true);
        numberTextField.setDataType(Double.class);
        numberTextField.addFocusListener((FocusListener)new FocusAdapter(){
            private int editedRow = -1;

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Double d = numberTextField.getNumber().doubleValue();
                Vector<NameValuePair> vector = binsTableModel.getDataVector();
                for (int i = 0; i < vector.size(); ++i) {
                    NameValuePair nameValuePair = vector.get(i);
                    if (nameValuePair.getValue() == null || d == null || !nameValuePair.getValue().toString().equals(d.toString())) continue;
                    this.editedRow = i;
                    break;
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                BinningCustomNumeric.this.invalidRange = false;
                Double d = numberTextField.getNumber().doubleValue();
                if (this.editedRow != -1) {
                    boolean bl;
                    Double d2;
                    Double d3;
                    Object object;
                    Vector<NameValuePair> vector = binsTableModel.getDataVector();
                    NameValuePair nameValuePair = vector.get(this.editedRow);
                    NameValuePair nameValuePair2 = vector.get(this.editedRow - 1);
                    NameValuePair nameValuePair3 = this.editedRow == vector.size() - 1 ? null : vector.get(this.editedRow + 1);
                    Object object2 = nameValuePair2.getValue();
                    Object object3 = object = nameValuePair3 != null ? nameValuePair3.getValue() : TransformationStatisticsState.UNBOUNDED;
                    Double d4 = object2.equals(TransformationStatisticsState.NO_LOWER_BOUND) ? null : (d3 = object2 instanceof String ? Double.valueOf(object2.toString()) : (Double)object2);
                    Double d5 = object.equals(TransformationStatisticsState.UNBOUNDED) ? null : (d2 = object instanceof String ? Double.valueOf(object.toString()) : (Double)object);
                    if (d3 != null && d2 != null) {
                        if (d <= d3 || d >= d2) {
                            BinningCustomNumeric.this.invalidRange = true;
                        }
                    } else if (d3 == null && d2 != null) {
                        if (d >= d2) {
                            BinningCustomNumeric.this.invalidRange = true;
                        }
                    } else if (d3 != null && d2 == null && d <= d3) {
                        BinningCustomNumeric.this.invalidRange = true;
                    }
                    if (BinningCustomNumeric.this.invalidRange) {
                        TableColumn tableColumn = BinningCustomNumeric.this._jAttributesTable.getColumnModel().getColumn(BinningCustomBase._BIN_VALUE);
                        AbstractCellEditor abstractCellEditor = (AbstractCellEditor)((Object)tableColumn.getCellEditor());
                        abstractCellEditor.cancelCellEditing();
                        return;
                    }
                    boolean bl2 = !BinningCustomNumeric.this.labelsBtn.isSelected();
                    boolean bl3 = bl = null != ((TransformationType.Binning.CustomNumeric)BinningCustomNumeric.this.customBinning).getBinLabels().getNumberSequence();
                    if (!bl) {
                        if (bl2) {
                            nameValuePair.setName(d + TransformationStatisticsState.DASH + (d2 != null ? d2 : TransformationStatisticsState.UNBOUNDED));
                        } else {
                            nameValuePair.setEditedName(nameValuePair.getName());
                        }
                        boolean bl4 = true;
                        if (object2.equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                            object2 = TransformationStatisticsState.UNBOUNDED;
                            bl4 = false;
                        }
                        if (bl2) {
                            String string = object2 + (bl4 ? TransformationStatisticsState.DASH : "") + d;
                            nameValuePair2.setName(string);
                        }
                    }
                    nameValuePair.setValue(d.toString());
                    BinningCustomNumeric.this.loadCustomNumericBinning(vector);
                }
            }
        });
        NumberCellEditor numberCellEditor = new NumberCellEditor(numberTextField);
        if (this._jAttributesTable.getColumnModel().getColumnCount() > _BIN_VALUE) {
            TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(_BIN_VALUE);
            tableColumn.setCellEditor(numberCellEditor);
        }
    }

    @Override
    protected NullBinsSelectionPanel getLabelExplanation() {
        return this.jLabelExplanation;
    }

    private static class NumberCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        NumberTextField component;

        NumberCellEditor(NumberTextField numberTextField) {
            this.component = numberTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof String) {
                Double d = Double.parseDouble((String)object);
                this.component.setNumber((Number)d);
            } else if (object instanceof Number) {
                this.component.setNumber((Number)object);
            }
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return this.component.getNumber();
        }
    }
}

