/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.tests;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.workflow.dialog.tests.DialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class PartitionColumnDetailsPanel
extends DialogDisplayer {
    private static final Logger LOGGER = Logger.getLogger(PartitionColumnDetailsPanel.class.getName());
    private List<PartitionExpressionType> _partitionExpressions;
    private ModelTableModel _tableModels;
    private JPanel jTablePanel;
    private DataMinerTablePanel tablePanel;

    public PartitionColumnDetailsPanel(List<PartitionExpressionType> list) {
        this._partitionExpressions = list;
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jTablePanel = new JPanel();
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(500, 300));
        this.jTablePanel.setName("jTablePanel");
        GroupLayout groupLayout = new GroupLayout(this.jTablePanel);
        this.jTablePanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 480, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 287, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jTablePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jTablePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("TEST_PARTITION_COLUMN_DIALOG_TITLE");
    }

    @Override
    protected int getDialogButtonMask() {
        return 16;
    }

    @Override
    protected String getHelpTopic() {
        return null;
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this._tableModels = new ModelTableModel(this._partitionExpressions);
        this.tablePanel = new DataMinerTablePanel();
        this.jTablePanel.setLayout(new BorderLayout());
        this.jTablePanel.add(this.tablePanel);
        this.tablePanel.setup((TableModel)((Object)this._tableModels), DialogsLrb.get("TEST_PARTITION_TABLE"), 0, true);
        DataMinerTable dataMinerTable = this.tablePanel.getTable();
        dataMinerTable.setAutoResizeMode(2);
        dataMinerTable.setShowToolTips(true);
        int n = 0;
        for (int n2 : ModelTableModel._columnWidths) {
            dataMinerTable.getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        dataMinerTable.setSorted(false);
    }

    static class ModelTableModel
    extends GenericBaseTableModel {
        static final String TEST_PARTITION_COLUMN_SRC_COLUMN = DialogsLrb.get("TEST_PARTITION_COLUMN_SRC_COLUMN");
        static final String TEST_PARTITION_COLUMN_SRC_EXPRESSION = DialogsLrb.get("TEST_PARTITION_COLUMN_SRC_EXPRESSION");
        static String[] _columnNames = new String[]{DialogsLrb.get("TEST_PARTITION_COLUMN_NAME"), DialogsLrb.get("TEST_PARTITION_COLUMN_DATATYPE"), DialogsLrb.get("TEST_PARTITION_COLUMN_SOURCE")};
        static int[] _columnWidths = new int[]{150, 150, 150};
        static final int TEST_PARTITION_COLUMN_NAME = 0;
        static final int TEST_PARTITION_COLUMN_DATATYPE = 1;
        static final int TEST_PARTITION_COLUMN_SOURCE = 2;
        static final int COLUMN_COUNT = 3;
        private List<PartitionExpressionType> _srcData;

        public ModelTableModel(List<PartitionExpressionType> list) {
            this._srcData = list;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            PartitionExpressionType partitionExpressionType = this._srcData.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = partitionExpressionType.getPartitionAttribute().getName();
                    break;
                }
                case 1: {
                    string = partitionExpressionType.getPartitionAttribute().getDataType();
                    break;
                }
                case 2: {
                    string = partitionExpressionType.getSQLExpression() != null ? TEST_PARTITION_COLUMN_SRC_EXPRESSION : TEST_PARTITION_COLUMN_SRC_COLUMN;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }
    }
}

