/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.test;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.RowColumnValue;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;
import oracle.ide.Context;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class CostMatrixTabState {
    private SharedTestEditorState _parentTestViewerState;
    private Context _context;
    private List<TestResult> _testResults;
    private Vector<Object> _targetValues;
    private Object _selectedTargetValue;
    private String _selectedTestResult;
    private CostMatrixInfo _cInfo;
    private TreeMap<String, CostData> _costdata;
    private CostTuneTableModel _costTableModel;

    public SharedTestEditorState getParentTestViewerState() {
        return this._parentTestViewerState;
    }

    public CostMatrixTabState(SharedTestEditorState sharedTestEditorState, Context context) {
        this._parentTestViewerState = sharedTestEditorState;
        this._context = context;
        this._targetValues = new Vector();
        this._costdata = new TreeMap();
        this._costTableModel = null;
        this._testResults = this._parentTestViewerState.getTestResults();
    }

    public void load() throws Exception {
        TuneState tuneState = (TuneState)this._context.getProperty("TUNE_STATE");
        this._targetValues.clear();
        this._testResults = this._parentTestViewerState.getTestResults();
        for (TestResult testResult : this._testResults) {
            Vector<String> vector = ((ClassTestResult)testResult).getTargetValues();
            for (String string : vector) {
                if (this._targetValues.contains(string)) continue;
                this._targetValues.add(string);
            }
        }
        if (this._targetValues == null || this._targetValues.size() == 0) {
            this._targetValues = tuneState.getModelTargetValues();
        }
        if (this._targetValues == null || this._targetValues.size() == 0) {
            this._targetValues = tuneState.getInputDataTargetValues();
        }
        this.setSelectedTargetValue(this._targetValues.get(0));
        CostMatrixType costMatrixType = tuneState.getDefaultTuningCost();
        this._cInfo = this.convertToCostMatrixInfo(costMatrixType);
        this.loadCostData();
    }

    private void loadCostData() throws Exception {
        TuneState tuneState = (TuneState)this._context.getProperty("TUNE_STATE");
        for (TestResult testResult : this._testResults) {
            String string = testResult.getName();
            CostMatrixType costMatrixType = tuneState.getTuningCost(string);
            CostData costData = new CostData(testResult.getMiningAlgorithm(), testResult.getCreationTime(), costMatrixType);
            this._costdata.put(string, costData);
        }
        this._costTableModel = new CostTuneTableModel(tuneState, this._costdata);
    }

    private CostMatrixInfo convertToCostMatrixInfo(CostMatrixType costMatrixType) {
        CostMatrixInfo costMatrixInfo = new CostMatrixInfo(CostMatrixInfo._NONE);
        List list = costMatrixType.getItem();
        if (list != null && list.size() > 0) {
            for (CostMatrixType.Item item : list) {
                String string = item.getActual();
                String string2 = item.getPredict();
                double d = item.getCost();
                costMatrixInfo.put(string, string2, BigDecimal.valueOf(d));
            }
        }
        return costMatrixInfo;
    }

    private CostMatrixType convertToCostMatrixType(CostMatrixInfo costMatrixInfo) {
        CostMatrixType costMatrixType = new CostMatrixType();
        List list = costMatrixType.getItem();
        for (int i = 0; i < costMatrixInfo.getRowCount(); ++i) {
            for (int j = 0; j < costMatrixInfo.geColumnCount(); ++j) {
                RowColumnValue rowColumnValue = costMatrixInfo.getRowColumnValue(i, j);
                CostMatrixType.Item item = new CostMatrixType.Item();
                item.setActual((String)rowColumnValue._row);
                item.setPredict((String)rowColumnValue._col);
                item.setCost(rowColumnValue._value.doubleValue());
                list.add(item);
            }
        }
        return costMatrixType;
    }

    public void setSelectedTargetValue(Object object) {
        this._selectedTargetValue = object;
    }

    public Object getSelectedTargetValue() {
        return this._selectedTargetValue;
    }

    public CostTuneTableModel getLoadingCostTableModel() {
        return new CostTuneTableModel();
    }

    public CostTuneTableModel getCostTuneTableModel() {
        return this._costTableModel;
    }

    public Vector<Object> getTargetValues() {
        return this._targetValues;
    }

    public void setSelectedTestResult(String string) {
        this._selectedTestResult = string;
    }

    public String getSelectedTestResult() {
        return this._selectedTestResult;
    }

    public Context getContext() {
        return this._context;
    }

    public TestResult getSelectedTestResultObj() {
        for (TestResult testResult : this._testResults) {
            if (!testResult.getName().equals(this.getSelectedTestResult())) continue;
            return testResult;
        }
        return null;
    }

    public void setTuneCostMatrix(String string, CostMatrixInfo costMatrixInfo) {
        CostData costData = this._costdata.get(string);
        costData.setCostMatrix(this.convertToCostMatrixType(costMatrixInfo));
        costData.setModified(true);
    }

    public CostMatrixInfo getTuneCostMatrixInfo(String string) {
        return this.convertToCostMatrixInfo(this.getTuneCostMatrix(string));
    }

    public CostMatrixType getTuneCostMatrix(String string) {
        CostData costData = this._costdata.get(string);
        return costData.getCostMatrix();
    }

    public void setCostMatrixInfo(String string, boolean bl, double d) {
        if (bl) {
            this._cInfo.updateColumn(string, new BigDecimal(d));
        } else {
            this._cInfo.updateRow(string, new BigDecimal(d));
        }
    }

    public CostMatrixInfo getCostMatrixInfo() {
        return this._cInfo;
    }

    public static class CostTuneTableModel
    extends GenericBaseTableModel {
        public static final int RESULT_NAME = 0;
        public static final int TUNE = 1;
        public static final int ALGORITHM = 2;
        public static final int CREATION_DATE = 3;
        protected Vector<String> _colNames;
        protected Map<String, CostData> _costdata = null;
        private TuneState _tuneState;
        private final String LOADING = TestViewerLrb.get("LOADING");
        private String TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
        private String TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
        private String TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
        private String TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
        private String TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
        private String TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");

        public CostTuneTableModel() {
            this(null, null);
        }

        public CostTuneTableModel(TuneState tuneState, Map<String, CostData> map) {
            this._colNames = new Vector();
            this._colNames.add(TestViewerLrb.get("RESULT_NAME"));
            this._colNames.add(PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"));
            this._colNames.add(TestViewerLrb.get("ALGORITHM"));
            this._colNames.add(TestViewerLrb.get("CREATION_DATE"));
            this.setColumnIdentifiers(this._colNames);
            this._costdata = map;
            this.setRowCount(this._costdata == null ? 1 : map.size());
            this.setColumnCount(this._colNames.size());
            this._tuneState = tuneState;
        }

        public String getColumnName(int n) {
            return this._colNames.get(n);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._costdata == null) {
                if (n2 == 0) {
                    return this.LOADING;
                }
                return null;
            }
            Object[] objectArray = this._costdata.keySet().toArray();
            String string = (String)objectArray[n];
            CostData costData = this._costdata.get(objectArray[n]);
            if (n2 == 0) {
                return string;
            }
            if (n2 == 2) {
                return costData._algorithm;
            }
            if (n2 == 3) {
                return costData._creation_date;
            }
            if (n2 == 1) {
                if (this._tuneState.isTuningNone(string)) {
                    return this.TUNE_NONE;
                }
                if (this._tuneState.isTuningBenefit(string)) {
                    return this.TUNE_BENEFIT;
                }
                if (this._tuneState.isTuningCost(string)) {
                    return this.TUNE_COST;
                }
                if (this._tuneState.isTuningCustomROC(string)) {
                    return this.TUNE_ROC;
                }
                if (this._tuneState.isTuningCustomLift(string)) {
                    return this.TUNE_LIFT;
                }
                if (this._tuneState.isTuningCustomProfit(string)) {
                    return this.TUNE_PROFIT;
                }
            }
            return null;
        }
    }

    public static class CostData
    implements Element {
        private String _algorithm;
        private Date _creation_date;
        private CostMatrixType _costMatrix = null;
        private boolean _modified = false;
        private String _label;

        public CostData(String string, Date date, CostMatrixType costMatrixType) {
            this._algorithm = string;
            this._creation_date = date;
            this._costMatrix = costMatrixType;
        }

        public void setLabel(String string) {
            this._label = string;
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return null;
        }

        public Object getData() {
            return null;
        }

        public String getShortLabel() {
            return this._label;
        }

        public String getLongLabel() {
            return "";
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return "";
        }

        public String toString() {
            return "";
        }

        public String getAlgorithm() {
            return this._algorithm;
        }

        public Date getCreationDate() {
            return this._creation_date;
        }

        public CostMatrixType getCostMatrix() {
            return this._costMatrix;
        }

        public void setCostMatrix(CostMatrixType costMatrixType) {
            this._costMatrix = costMatrixType;
        }

        public void setModified(boolean bl) {
            this._modified = bl;
        }

        public boolean isModified() {
            return this._modified;
        }
    }
}

