/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic;

import java.util.HashMap;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterDetailsType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterDistanceType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterIdType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterProbabilityType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterSetType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumns;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureDetailsType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureIdType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureSetType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureValueType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionDetailsType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionProbabilityType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionType;

public class DynamicApplyOutputColumnNameGenerator {
    public static final String OUTPUT_CLUSTER_ID = "CLID";
    public static final String OUTPUT_CLUSTER_PROB = "PROB";
    public static final String OUTPUT_CLUSTER_SET = "CSET";
    public static final String OUTPUT_CLUSTER_DETAILS = "CDET";
    public static final String OUTPUT_CLUSTER_DISTANCE = "CDST";
    public static final String OUTPUT_FEATURE_ID = "FEID";
    public static final String OUTPUT_FEATURE_SET = "FSET";
    public static final String OUTPUT_FEATURE_VALUE = "FVAL";
    public static final String OUTPUT_FEATURE_DETAILS = "FDET";
    public static final String OUTPUT_PREDICTION = "PRED";
    public static final String OUTPUT_PREDICTION_BOUNDS = "PBND";
    public static final String OUTPUT_PREDICTION_BOUNDS_UPPER = "PBUP";
    public static final String OUTPUT_PREDICTION_BOUNDS_LOWER = "PBLW";
    public static final String OUTPUT_PREDICTION_COSTS = "PCST";
    public static final String OUTPUT_PREDICTION_DETAILS = "PDET";
    public static final String OUTPUT_PREDICTION_PROB = "PROB";
    public static final String OUTPUT_PREDICTION_SET = "PSET";
    private HashMap<String, Boolean> _columnNames = new HashMap();
    private int MAX_COLUMN_LEN = 30;

    public DynamicApplyOutputColumnNameGenerator(DynamicApplyOutputColumns dynamicApplyOutputColumns) {
        if (dynamicApplyOutputColumns == null) {
            return;
        }
        for (DynamicApplyOutputColumnType dynamicApplyOutputColumnType : dynamicApplyOutputColumns.getDynamicApplyOutputColumn()) {
            FeatureDetailsType featureDetailsType;
            FeatureSetType featureSetType;
            FeatureValueType featureValueType;
            FeatureIdType featureIdType;
            ClusterDistanceType clusterDistanceType;
            ClusterSetType clusterSetType;
            ClusterDetailsType clusterDetailsType;
            ClusterProbabilityType clusterProbabilityType;
            ClusterIdType clusterIdType;
            Object object;
            PredictionProbabilityType predictionProbabilityType;
            PredictionDetailsType predictionDetailsType;
            PredictionType predictionType = dynamicApplyOutputColumnType.getPrediction();
            if (predictionType != null) {
                this._columnNames.put(predictionType.getColumn().getName(), Boolean.TRUE);
            }
            if ((predictionDetailsType = dynamicApplyOutputColumnType.getPredictionDetails()) != null) {
                this._columnNames.put(predictionDetailsType.getColumn().getName(), Boolean.TRUE);
            }
            if ((predictionProbabilityType = dynamicApplyOutputColumnType.getPredictionProbability()) != null && (object = predictionProbabilityType.getColumn().getName()) != null) {
                this._columnNames.put((String)object, Boolean.TRUE);
            }
            if ((object = dynamicApplyOutputColumnType.getPredictionSet()) != null) {
                this._columnNames.put(object.getColumn().getName(), Boolean.TRUE);
            }
            if ((clusterIdType = dynamicApplyOutputColumnType.getClusterId()) != null) {
                this._columnNames.put(clusterIdType.getColumn().getName(), Boolean.TRUE);
            }
            if ((clusterProbabilityType = dynamicApplyOutputColumnType.getClusterProbability()) != null) {
                this._columnNames.put(clusterProbabilityType.getColumn().getName(), Boolean.TRUE);
            }
            if ((clusterDetailsType = dynamicApplyOutputColumnType.getClusterDetails()) != null) {
                this._columnNames.put(clusterDetailsType.getColumn().getName(), Boolean.TRUE);
            }
            if ((clusterSetType = dynamicApplyOutputColumnType.getClusterSet()) != null) {
                this._columnNames.put(clusterSetType.getColumn().getName(), Boolean.TRUE);
            }
            if ((clusterDistanceType = dynamicApplyOutputColumnType.getClusterDistance()) != null) {
                this._columnNames.put(clusterDistanceType.getColumn().getName(), Boolean.TRUE);
            }
            if ((featureIdType = dynamicApplyOutputColumnType.getFeatureId()) != null) {
                this._columnNames.put(featureIdType.getColumn().getName(), Boolean.TRUE);
            }
            if ((featureValueType = dynamicApplyOutputColumnType.getFeatureValue()) != null) {
                this._columnNames.put(featureValueType.getColumn().getName(), Boolean.TRUE);
            }
            if ((featureSetType = dynamicApplyOutputColumnType.getFeatureSet()) != null) {
                this._columnNames.put(featureSetType.getColumn().getName(), Boolean.TRUE);
            }
            if ((featureDetailsType = dynamicApplyOutputColumnType.getFeatureDetails()) == null) continue;
            this._columnNames.put(featureDetailsType.getColumn().getName(), Boolean.TRUE);
        }
    }

    public boolean doesNameExist(String string) {
        Boolean bl = this._columnNames.get(string);
        return bl != null;
    }

    public void addUniqueName(String string) {
        this._columnNames.put(string, Boolean.TRUE);
    }

    public void removeUniqueName(String string) {
        this._columnNames.remove(string);
    }

    public void removeUniqueName(DynamicApplyOutputColumnType dynamicApplyOutputColumnType) {
        String string = null;
        if (dynamicApplyOutputColumnType.getPrediction() != null) {
            string = dynamicApplyOutputColumnType.getPrediction().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getPredictionCost() != null) {
            string = dynamicApplyOutputColumnType.getPredictionCost().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getPredictionDetails() != null) {
            string = dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getPredictionProbability() != null) {
            string = dynamicApplyOutputColumnType.getPredictionProbability().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getPredictionSet() != null) {
            string = dynamicApplyOutputColumnType.getPredictionSet().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getClusterId() != null) {
            string = dynamicApplyOutputColumnType.getClusterId().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getClusterProbability() != null) {
            string = dynamicApplyOutputColumnType.getClusterProbability().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getClusterSet() != null) {
            string = dynamicApplyOutputColumnType.getClusterSet().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getClusterDistance() != null) {
            string = dynamicApplyOutputColumnType.getClusterDistance().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getClusterDetails() != null) {
            string = dynamicApplyOutputColumnType.getClusterDetails().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getFeatureId() != null) {
            string = dynamicApplyOutputColumnType.getFeatureId().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getFeatureValue() != null) {
            string = dynamicApplyOutputColumnType.getFeatureValue().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getFeatureSet() != null) {
            string = dynamicApplyOutputColumnType.getFeatureSet().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getFeatureDetails() != null) {
            string = dynamicApplyOutputColumnType.getFeatureDetails().getColumn().getName();
        }
        if (string != null) {
            this.removeUniqueName(string);
        }
    }

    public void removeAllUniqueNames() {
        this._columnNames.clear();
    }

    private String getUniqueName(String string) {
        return this.getUniqueName(string, null);
    }

    private String getUniqueName(String string, String string2) {
        String string3 = string2 != null ? string + "_" + string2 + "_" : string + "_";
        int n = 1;
        StringBuilder stringBuilder = this._generateName(string3, n);
        String string4 = stringBuilder.toString();
        while (this._columnNames.containsKey(string4)) {
            stringBuilder = this._generateName(string4, ++n);
            string4 = stringBuilder.toString();
        }
        return string4;
    }

    private StringBuilder _generateName(String string, int n) {
        String string2;
        int n2;
        int n3 = string.lastIndexOf("_");
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n3 + 1));
        int n4 = stringBuilder.length();
        int n5 = n4 + (n2 = (string2 = String.valueOf(n)).length());
        if (n5 > this.MAX_COLUMN_LEN) {
            int n6 = n5 - this.MAX_COLUMN_LEN;
            stringBuilder = new StringBuilder(stringBuilder.substring(0, n4 - n6 - 1));
        }
        stringBuilder.append(string2);
        return stringBuilder;
    }

    public String generatePredictionColumnName(String string, boolean bl) {
        return this.generateColumnName(string, OUTPUT_PREDICTION, bl);
    }

    public String generatePredictionDetailsColumnName(String string, boolean bl) {
        return this.generateColumnName(string, OUTPUT_PREDICTION_DETAILS, bl);
    }

    public String generatePredictionProbabilityColumnName(String string, boolean bl) {
        return this.generateColumnName(string, "PROB", bl);
    }

    public String generatePredictionSetColumnName(String string, boolean bl) {
        return this.generateColumnName(string, OUTPUT_PREDICTION_SET, bl);
    }

    public String generateClusterIdColumnName(boolean bl) {
        return this.generateColumnName(null, OUTPUT_CLUSTER_ID, bl);
    }

    public String generateClusterProbabilityColumnName(String string, boolean bl) {
        return this.generateColumnName(string, "PROB", bl);
    }

    public String generateClusterDetailsColumnName(boolean bl) {
        return this.generateColumnName(null, OUTPUT_CLUSTER_DETAILS, bl);
    }

    public String generateClusterDistanceColumnName(String string, boolean bl) {
        return this.generateColumnName(string, OUTPUT_CLUSTER_DISTANCE, bl);
    }

    public String generateClusterSetColumnName(boolean bl) {
        return this.generateColumnName(null, OUTPUT_CLUSTER_SET, bl);
    }

    public String generateFeatureIdColumnName(boolean bl) {
        return this.generateColumnName(null, OUTPUT_FEATURE_ID, bl);
    }

    public String generateFeatureValueColumnName(boolean bl) {
        return this.generateColumnName(null, OUTPUT_FEATURE_VALUE, bl);
    }

    public String generateFeatureDetailsColumnName(boolean bl) {
        return this.generateColumnName(null, OUTPUT_FEATURE_DETAILS, bl);
    }

    public String generateFeatureSetColumnName(boolean bl) {
        return this.generateColumnName(null, OUTPUT_FEATURE_SET, bl);
    }

    public String generateColumnName(String string, String string2, boolean bl) {
        String string3 = null;
        if (string2.compareTo(OUTPUT_PREDICTION) == 0) {
            string3 = this.getUniqueName(OUTPUT_PREDICTION, string);
        } else if (string2.compareTo(OUTPUT_PREDICTION_DETAILS) == 0) {
            string3 = this.getUniqueName(OUTPUT_PREDICTION_DETAILS, string);
        } else if (string2.compareTo("PROB") == 0) {
            string3 = this.getUniqueName("PROB", string);
        } else if (string2.compareTo(OUTPUT_PREDICTION_SET) == 0) {
            string3 = this.getUniqueName(OUTPUT_PREDICTION_SET, string);
        } else if (string2.compareTo(OUTPUT_CLUSTER_ID) == 0) {
            string3 = this.getUniqueName(OUTPUT_CLUSTER_ID);
        } else if (string2.compareTo("PROB") == 0) {
            string3 = this.getUniqueName("PROB", string);
        } else if (string2.compareTo(OUTPUT_CLUSTER_DETAILS) == 0) {
            string3 = this.getUniqueName(OUTPUT_CLUSTER_DETAILS);
        } else if (string2.compareTo(OUTPUT_CLUSTER_DISTANCE) == 0) {
            string3 = this.getUniqueName(OUTPUT_CLUSTER_DISTANCE, string);
        } else if (string2.compareTo(OUTPUT_CLUSTER_SET) == 0) {
            string3 = this.getUniqueName(OUTPUT_CLUSTER_SET);
        } else if (string2.compareTo(OUTPUT_FEATURE_ID) == 0) {
            string3 = this.getUniqueName(OUTPUT_FEATURE_ID);
        } else if (string2.compareTo(OUTPUT_FEATURE_DETAILS) == 0) {
            string3 = this.getUniqueName(OUTPUT_FEATURE_DETAILS);
        } else if (string2.compareTo(OUTPUT_FEATURE_SET) == 0) {
            string3 = this.getUniqueName(OUTPUT_FEATURE_SET);
        } else if (string2.compareTo(OUTPUT_FEATURE_VALUE) == 0) {
            string3 = this.getUniqueName(OUTPUT_FEATURE_VALUE, string);
        }
        if (bl) {
            this._columnNames.put(string3, Boolean.TRUE);
        }
        return string3;
    }
}

