/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.common.vo.TableVO;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.UpdateTableEditAttributesPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTargetSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.help.HelpSystem;

public class UpdateTableEditAttributesDialog
extends DataConsumerAttributesDialog<UpdateTableNode> {
    private static final Logger theLogger = Logger.getLogger(UpdateTableEditAttributesDialog.class.getName());
    private UpdateTableEditAttributesPanel content;
    private List<MapTargetSourceType> originalColumns;

    public UpdateTableEditAttributesDialog() {
        this.wizName = "Edit update table node";
    }

    @Override
    protected JEWTDialog buildDialog(Context context, UpdateTableNode updateTableNode, AbstractDataNode abstractDataNode) {
        this.content = new UpdateTableEditAttributesPanel(context, updateTableNode, this.getAvailableAttributes(abstractDataNode), this.originalColumns);
        return super.buildDialog(context, (JPanel)((Object)this.content));
    }

    public void setOriginalData(List<MapTargetSourceType> list) {
        this.originalColumns = list;
    }

    public List<MapTargetSourceType> getResultTargetSourceType() {
        return this.content.getResultTargetSourceType();
    }

    @Override
    protected List<AttributeType> getAvailableAttributes(final AbstractDataNode abstractDataNode) {
        final ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        class GetAttrs
        extends ProgressRunnable {
            GetAttrs() {
            }

            protected Object doWork() throws Exception {
                UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)abstractDataNode.getData();
                TableType tableType = updateTableNodeType.getUpdateTargetTable();
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(UpdateTableEditAttributesDialog.this.context);
                TableVO tableVO = new TableVO(tableType);
                return DatabaseMetadataUtils.getColumnDetails(connectionFolder, tableVO);
            }

            protected void finish(Object object) {
                List list = (List)object;
                if (list != null && !list.isEmpty()) {
                    for (List list2 : list) {
                        AttributeType attributeType = new AttributeType();
                        attributeType.setName((String)list2.get(0));
                        attributeType.setDataType((String)list2.get(1));
                        attributeType.setStatus(AttributeStatus.VALID);
                        arrayList.add(attributeType);
                    }
                }
            }
        }
        GetAttrs getAttrs = new GetAttrs();
        getAttrs.setTitle(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS"));
        getAttrs.setMessage(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS_DESCR"));
        getAttrs.setCancelable(false);
        try {
            getAttrs.start(true);
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return arrayList;
    }

    @Override
    protected void registerHelp(JEWTDialog jEWTDialog) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "dm_update_table_create_new_table");
    }
}

