/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JSplitPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.common.vo.TableVO;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.TableChooserPane;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.teditor.data.DataViewerPanel;
import oracle.dmt.dataminer.teditor.structure.ColumnDataRow;
import oracle.dmt.dataminer.teditor.structure.StructureViewPanel;
import oracle.dmt.dataminer.teditor.structure.StructureViewState;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardModel;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardPage;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JTabbedPane2;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;

public class TableChooserAndViewerPane
extends DataSourceWizardPage
implements DataminerGUIPanel {
    private static final Logger LOGGER = Logger.getLogger(TableChooserAndViewerPane.class.getName());
    private JSplitPane _jTableSplitPane = new JSplitPane();
    private boolean _isInitialized = false;
    private Context _context;
    private AbstractDataNode _node;
    private TableChooserPane _chooser;
    private JTabbedPane2 _viewerTabPane;
    private DataViewerPanel _dataViewerPane;
    private StructureViewPanel _structureViewPane;
    private TableVO _selectedTable;
    private GenericTable _table;
    private boolean _loading = true;
    private final String SHOW_GRANT_NOT_DIRECT_WARNING = this.getClass().getName() + ":showgrantwarning";

    public TableChooserAndViewerPane() {
        this.initRes();
    }

    @Override
    public void initRes() {
    }

    public void setLoading(boolean bl) {
        this._loading = bl;
        this.updateWizardButtons();
    }

    @Override
    public boolean canFinish() {
        return !this.isLoading();
    }

    public boolean isLoading() {
        return this._loading;
    }

    @Override
    public boolean isComplete() {
        return !this.isLoading();
    }

    private void initUIWizard() {
        DataSourceWizardModel dataSourceWizardModel = this.getModel(this.getTraversableContext());
        dataSourceWizardModel.setTableSelectionStep(this);
        this._context = dataSourceWizardModel.getContext();
        this._node = dataSourceWizardModel.getNode();
        this.getTraversableContext().getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
    }

    private void layoutUIWizard() {
        this.setLayout(new BorderLayout());
        this.add(this._jTableSplitPane, "Center");
    }

    @Override
    public void initUI() {
        this.initUIWizard();
        this._chooser = new TableChooserPane(this._context, this._node, this.getModel(this.getTraversableContext()));
        this._jTableSplitPane.setTopComponent(this._chooser);
        this._jTableSplitPane.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                TableChooserAndViewerPane.this._jTableSplitPane.setDividerLocation(0.55);
            }
        });
        this._jTableSplitPane.setOneTouchExpandable(true);
        this._jTableSplitPane.setOrientation(0);
        this._viewerTabPane = new JTabbedPane2(1);
        this._jTableSplitPane.setBottomComponent((Component)this._viewerTabPane);
        this._dataViewerPane = new DataViewerPanel(this._context, false);
        DataSourceWizardModel dataSourceWizardModel = this.getModel(this.getTraversableContext());
        this._structureViewPane = new StructureViewPanel(this._context, dataSourceWizardModel, false);
        this._viewerTabPane.addTab(DataDialogsLrb.get("TABLE_CHOOSER_COLUMNS_TAB"), (Component)this._structureViewPane);
        this._viewerTabPane.addTab(DataDialogsLrb.get("TABLE_CHOOSER_DATA_TAB"), (Component)this._dataViewerPane);
        this._table = this._chooser.getTableComponent();
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                TableChooserAndViewerPane.this._selectedTable = TableChooserAndViewerPane.this._chooser.getSelectedTable();
                if (TableChooserAndViewerPane.this._selectedTable != null) {
                    if (TableChooserAndViewerPane.this._selectedTable.getName().length() != 0) {
                        TableChooserAndViewerPane.this.setLoading(false);
                    } else {
                        TableChooserAndViewerPane.this.setLoading(true);
                    }
                    TableChooserAndViewerPane.this._structureViewPane.loadTable(TableChooserAndViewerPane.this._selectedTable);
                    TableChooserAndViewerPane.this._dataViewerPane.loadTable(TableChooserAndViewerPane.this._selectedTable);
                } else {
                    TableChooserAndViewerPane.this._structureViewPane.loadTable((TableVO)null);
                    TableChooserAndViewerPane.this._dataViewerPane.loadTable((TableVO)null);
                    TableChooserAndViewerPane.this.setLoading(true);
                }
            }
        });
        this._chooser.initUI();
        this.layoutUIWizard();
        this._isInitialized = true;
    }

    @Override
    public String getPageDirtyKey() {
        return "tableDirty";
    }

    @Override
    public Component getInitialFocus() {
        return null;
    }

    public void close() {
        try {
            if (this._structureViewPane != null) {
                this._structureViewPane.close();
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        try {
            if (this._dataViewerPane != null) {
                this._dataViewerPane.close();
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        ValidateWriteThread validateWriteThread = new ValidateWriteThread(traversableContext);
        validateWriteThread.setTitle(DataDialogsLrb.get("DATA_SOURCE_VALIDATE_TITLE"));
        validateWriteThread.setMessage(DataDialogsLrb.get("DATA_SOURCE_VALIDATE_TABLE_SELECTION"));
        try {
            validateWriteThread.start(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("TABLE_CHOOSER_FAILURE_MESSAGE"), null);
        }
        return validateWriteThread.isCanceled() ? false : validateWriteThread.getValidation();
    }

    public TableVO getSelectedTable() {
        if (this._chooser != null) {
            return this._chooser.getSelectedTable();
        }
        return null;
    }

    class ValidateWriteThread
    extends ProgressRunnable {
        Boolean _validated = false;
        private boolean _canceled = false;
        private boolean _forceUpdate = false;
        private Exception _exception = null;
        private TraversableContext _tctx;

        ValidateWriteThread(TraversableContext traversableContext) {
            this._tctx = traversableContext;
        }

        public boolean getForceUpdate() {
            return this._forceUpdate;
        }

        public void setForceUpdate(boolean bl) {
            this._forceUpdate = bl;
        }

        public boolean getValidation() {
            return this._validated;
        }

        protected Object doWork() throws Exception {
            try {
                Object object;
                DataSourceWizardModel dataSourceWizardModel = TableChooserAndViewerPane.this.getModel(this._tctx);
                if (this._tctx.getDirection() == 2) {
                    this._validated = true;
                    return this._validated;
                }
                TableChooserAndViewerPane.this._chooser.refreshSelectedTable();
                if (TableChooserAndViewerPane.this._chooser.getSelectedTable() == null) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("TABLE_CHOOSER_ERROR_MESG_NO_TABLE"), (String)DataDialogsLrb.get("TABLE_CHOOSER_ERROR_TITLE"), null);
                    this._validated = false;
                    return this._validated;
                }
                if (!this.hasDataAccess()) {
                    this._validated = false;
                    return this._validated;
                }
                if (TableChooserAndViewerPane.this._chooser.getModel().getOwnerSchema().compareTo(TableChooserAndViewerPane.this._chooser.getSelectedTable().getSchema()) != 0 && !DatabaseMetadataUtils.isTableOrViewGrantedDirectly((ConnectionManager)(object = ConnectionFolder.getConnectionFolder(TableChooserAndViewerPane.this._context)), TableChooserAndViewerPane.this._chooser.getSelectedTable().getSynonymSchema(), TableChooserAndViewerPane.this._chooser.getSelectedTable().getSynonymName(), ConnectionFolder.getUserAccountName(TableChooserAndViewerPane.this._context))) {
                    MessageDialog.optionalInformation((String)TableChooserAndViewerPane.this.SHOW_GRANT_NOT_DIRECT_WARNING, (Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("TABLE_CHOOSER_WARNING_MESG_GRANT"), (String)DataDialogsLrb.get("TABLE_CHOOSER_ERROR_TITLE"), null);
                }
                object = new StructureViewState(TableChooserAndViewerPane.this._context, false);
                TableVO tableVO = TableChooserAndViewerPane.this._chooser.getSelectedTable();
                ((StructureViewState)object).setTableName(tableVO.getSynonymSchema(), tableVO.getSynonymName());
                ((StructureViewState)object).load();
                dataSourceWizardModel.setSelectedTable(TableChooserAndViewerPane.this._chooser.getSelectedTable());
                TableType tableType = new TableType();
                tableType.setName(TableChooserAndViewerPane.this._chooser.getSelectedTable().getName());
                tableType.setSchema(TableChooserAndViewerPane.this._chooser.getSelectedTable().getSchema());
                TableChooserAndViewerPane.this._chooser.setExistingSelectedTable(tableType);
                dataSourceWizardModel.setAvailableColumns(ColumnDataRow.generateAttributeTypes(((StructureViewState)object).load()));
                dataSourceWizardModel.loadDefaultSelectedColumns();
                TableChooserAndViewerPane.this.setDirty(true, "columnsDirty");
                this._validated = true;
            }
            catch (Exception exception) {
                this._exception = exception;
                this._validated = false;
            }
            return this._validated;
        }

        protected void finish(Object object) {
            if (this._exception != null) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)this._exception, (String)DataDialogsLrb.get("TABLE_CHOOSER_ERROR_TITLE"), (String)DataDialogsLrb.get("TABLE_CHOOSER_FAILURE_MESSAGE"));
            }
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }

        private boolean hasDataAccess() {
            try {
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(TableChooserAndViewerPane.this._context);
                DatabaseMetadataUtils.hasDataAccess(connectionFolder, TableChooserAndViewerPane.this._chooser.getSelectedTable().getSchema(), TableChooserAndViewerPane.this._chooser.getSelectedTable().getName());
            }
            catch (SQLException sQLException) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)sQLException, (String)DataDialogsLrb.get("DATA_SOURCE_FAILURE_TITLE"), (String)DataDialogsLrb.get("DATA_SOURCE_NOT_ENOUGH_PRIVILEGES"), null);
                return false;
            }
            return true;
        }
    }
}

