/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Font;
import java.awt.FontMetrics;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.utils.HTMLStringUtils;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataProfileStatisticsTableModel;
import oracle.dmt.dataminer.workflow.dialog.data.StatsisticSelection;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.RolloverTableRenderer;

public class StatisticsSelectionObject {
    public static final String PERCENT_DISTINCT = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_COUNT");
    public static final String PERCENT_NULL = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_NULL");
    public static final String MAX = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_MAX");
    public static final String MIN = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_MIN");
    public static final String AVG = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_AVG");
    public static final String STDDEV = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_STDDEV");
    public static final String VARIANCE = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_VAR");
    public static final String KURTOSIS = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_KURT");
    public static final String MEDIAN = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_MED");
    public static final String MODE_SAMPLED = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_MODE_SAMPLED");
    public static final String MODE_ALL = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_MODE_ALL");
    public static final String SKEWNESS = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_SKEW");
    public static final String MODE_FUNCTION = "MODE_FUNCTION";
    public static final String HISTOGRAM = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_HISTOGRAM");
    private static final String DESCRIPTION_COUNT = DataDialogsLrb.get("DATA_EXPLORE_STATS_DESCRIPTION_COUNT");
    private static final String DESCRIPTION_NULLS = DataDialogsLrb.get("DATA_EXPLORE_STATS_DESCRIPTION_NULL");
    private static final String DESCRIPTION_MAX = DataDialogsLrb.get("DATA_EXPLORE_STATS_DESCRIPTION_MAX");
    private static final String DESCRIPTION_AVG = DataDialogsLrb.get("DATA_EXPLORE_STATS_DESCRIPTION_AVG");
    private static final String DESCRIPTION_STDDEV = DataDialogsLrb.get("DATA_EXPLORE_STATS_DESCRIPTION_STDDEV");
    private static final String DESCRIPTION_VARIANCE = DataDialogsLrb.get("DATA_EXPLORE_STATS_DESCRIPTION_VAR");
    private static final String DESCRIPTION_KURTOSIS = DataDialogsLrb.get("DATA_EXPLORE_STATS_DESCRIPTION_KURT");
    private static final String DESCRIPTION_MEDIAN = DataDialogsLrb.get("DATA_EXPLORE_STATS_VALUE_MED");
    private static final String DESCRIPTION_MODE = DataDialogsLrb.get("DATA_EXPLORE_STATS_DESCRIPTION_MODE");
    private static final String DESCRIPTION_SKEWNESS = DataDialogsLrb.get("DATA_EXPLORE_STATS_DESCRIPTION_SKEW");
    private static final String DESCRIPTION_HISTOGRAM = DataDialogsLrb.get("DATA_EXPLORE_STATS_DESCRIPTION_HISTOGRAM");
    private static final String LOW_COST = DataDialogsLrb.get("DATA_EXPLORE_STATS_COST_LOW");
    private static final String MEDIUM_COST = DataDialogsLrb.get("DATA_EXPLORE_STATS_COST_MEDIUM");
    private static final String HIGH_COST = DataDialogsLrb.get("DATA_EXPLORE_STATS_COST_HIGH");
    private static final String VERY_HIGH_COST = DataDialogsLrb.get("DATA_EXPLORE_STATS_COST_VERY_HIGH");
    private static final String COMP_WITH_TOOLBAR_HEADER = DataDialogsLrb.get("DATA_EXPLORE_STATS_HEADER");
    public static final String RESTORE_DEFAULTS_LINK = DataDialogsLrb.get("DATA_EXPLORE_RESTORE_DEFAULTS");
    public static final String RESTORE_DEFAULTS_LINK_TOOLTIP = DataDialogsLrb.get("DATA_EXPLORE_RESTORE_DEFAULTS_TOOL_TOP");
    public static final String RESTORE_DEFAULT_SETTINGS_CONFIRM_MSG = DataDialogsLrb.get("DATA_EXPLORE_DEFAULT_SETTINGS_CONFIRM");
    public static final String RESTORE_DEFAULT_SETTINGS_CONFIRM_TITLE = DataDialogsLrb.get("DATA_EXPLORE_DEFAULT_SETTINGS_WARNING_TITLE");
    private static final String COLUMN_STATISTICS_NAME = DataDialogsLrb.get("DATA_EXPLORE_STATS_TAB_GRID_COLUMN_STATS_VALUE");
    private static final String COLUMN_STATISTICS_DESCRIPTION = DataDialogsLrb.get("DATA_EXPLORE_STATS_TAB_GRID_COLUMN_DESCRIPTION");
    private static final String COLUMN_STATISTICS_COST = DataDialogsLrb.get("DATA_EXPLORE_STATS_TAB_GRID_COLUMN_COST");
    public static final int COLUMN_STATS_SELECTED = 0;
    public static final int COLUMN_STATS_VALUE = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    public static final int COLUMN_COST = 3;
    public static final int FILTER_STATS_NAME = 0;
    public static final int FILTER_STATS_DESCRIPTION = 1;
    public static final int FILTER_STATS_COST = 2;
    private static Vector<String> _colNames = new Vector();
    private static Map<String, Boolean> defaultStatsSelectionMap;
    private static SearchCategory[] _searchCategories;
    private static String[] _searchStrings;
    private static final CostComparator _costComparator;
    private static final HypelinkComparator _htmlComparator;
    private DataMinerTablePanel parentPanel;
    private StatsisticSelection parent;
    private Map<Integer, String> _maxStringMap = new HashMap<Integer, String>();
    private Map<String, Object[]> _statsMap = new HashMap<String, Object[]>();

    public static Boolean getDefaultStatsValue(String string) {
        return defaultStatsSelectionMap.get(string);
    }

    public static HypelinkComparator getHtmlComparator() {
        return _htmlComparator;
    }

    public static CostComparator getCostComparator() {
        return _costComparator;
    }

    public static SearchCategory[] getSearchCategories() {
        return _searchCategories;
    }

    public static Vector<String> getColNames() {
        return _colNames;
    }

    public static String[] getSearchStrings() {
        return _searchStrings;
    }

    public StatisticsSelectionObject(StatsisticSelection statsisticSelection) {
        this.parent = statsisticSelection;
        this.parentPanel = statsisticSelection.getDataMinerTablePanel();
    }

    private DataMinerTable getTable() {
        assert (this.parentPanel != null);
        return this.parentPanel.getTable();
    }

    public SearchField getSearchField() {
        return this.parentPanel.getSearchField();
    }

    public static synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (searchCategory.getLabel().equals(COLUMN_STATISTICS_NAME)) {
            n = 0;
        } else if (searchCategory.getLabel().equals(COLUMN_STATISTICS_DESCRIPTION)) {
            n = 1;
        } else if (searchCategory.getLabel().equals(COLUMN_STATISTICS_COST)) {
            n = 2;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    public static StatsSelection createDefaultStatsSelection() {
        StatsSelection statsSelection = new StatsSelection();
        statsSelection.setHistogram(StatisticsSelectionObject.getDefaultStatsValue(HISTOGRAM));
        statsSelection.setPercentdistinct(StatisticsSelectionObject.getDefaultStatsValue(PERCENT_DISTINCT));
        statsSelection.setPercentnull(StatisticsSelectionObject.getDefaultStatsValue(PERCENT_NULL));
        statsSelection.setMax(StatisticsSelectionObject.getDefaultStatsValue(MAX));
        statsSelection.setMin(StatisticsSelectionObject.getDefaultStatsValue(MIN));
        statsSelection.setAvg(StatisticsSelectionObject.getDefaultStatsValue(AVG));
        statsSelection.setStd(StatisticsSelectionObject.getDefaultStatsValue(STDDEV));
        statsSelection.setVar(StatisticsSelectionObject.getDefaultStatsValue(VARIANCE));
        statsSelection.setKurtosis(StatisticsSelectionObject.getDefaultStatsValue(KURTOSIS));
        statsSelection.setMedian(StatisticsSelectionObject.getDefaultStatsValue(MEDIAN));
        statsSelection.setMode(StatisticsSelectionObject.getDefaultStatsValue(MODE_FUNCTION));
        statsSelection.setModesampled(StatisticsSelectionObject.getDefaultStatsValue(MODE_SAMPLED));
        statsSelection.setModeall(StatisticsSelectionObject.getDefaultStatsValue(MODE_ALL));
        statsSelection.setSkewness(StatisticsSelectionObject.getDefaultStatsValue(SKEWNESS));
        statsSelection.setRowcount(BigInteger.ZERO);
        return statsSelection;
    }

    public void createStatsDescriptionMap() {
        if (!this._statsMap.isEmpty()) {
            this._statsMap.clear();
        }
        this._statsMap.put(HISTOGRAM, new Object[]{this.parent.isStatsSelected(HISTOGRAM), HISTOGRAM, DESCRIPTION_HISTOGRAM, HIGH_COST});
        this._statsMap.put(PERCENT_DISTINCT, new Object[]{this.parent.isStatsSelected(PERCENT_DISTINCT), PERCENT_DISTINCT, DESCRIPTION_COUNT, MEDIUM_COST});
        this._statsMap.put(PERCENT_NULL, new Object[]{this.parent.isStatsSelected(PERCENT_NULL), PERCENT_NULL, DESCRIPTION_NULLS, LOW_COST});
        this._statsMap.put(MAX, new Object[]{this.parent.isStatsSelected(MAX), MAX, DESCRIPTION_MAX, LOW_COST});
        this._statsMap.put(MIN, new Object[]{this.parent.isStatsSelected(MIN), MIN, DESCRIPTION_AVG, LOW_COST});
        this._statsMap.put(AVG, new Object[]{this.parent.isStatsSelected(AVG), AVG, DESCRIPTION_AVG, LOW_COST});
        this._statsMap.put(STDDEV, new Object[]{this.parent.isStatsSelected(STDDEV), STDDEV, DESCRIPTION_STDDEV, LOW_COST});
        this._statsMap.put(VARIANCE, new Object[]{this.parent.isStatsSelected(VARIANCE), VARIANCE, DESCRIPTION_VARIANCE, LOW_COST});
        this._statsMap.put(KURTOSIS, new Object[]{this.parent.isStatsSelected(KURTOSIS), KURTOSIS, DESCRIPTION_KURTOSIS, HIGH_COST});
        this._statsMap.put(MEDIAN, new Object[]{this.parent.isStatsSelected(MEDIAN), MEDIAN, DESCRIPTION_MEDIAN, MEDIUM_COST});
        if (this.parent.isStatsSelected(MODE_SAMPLED)) {
            this._statsMap.put(MODE_SAMPLED, new Object[]{this.parent.isStatsSelected(MODE_FUNCTION), HTMLStringUtils.wrapInHtml(MODE_SAMPLED), DESCRIPTION_MODE, LOW_COST});
        } else {
            this._statsMap.put(MODE_ALL, new Object[]{this.parent.isStatsSelected(MODE_FUNCTION), HTMLStringUtils.wrapInHtml(MODE_ALL), DESCRIPTION_MODE, VERY_HIGH_COST});
        }
        this._statsMap.put(SKEWNESS, new Object[]{this.parent.isStatsSelected(SKEWNESS), SKEWNESS, DESCRIPTION_SKEWNESS, HIGH_COST});
    }

    public Vector<Vector<Object>> getStatistics() {
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HISTOGRAM);
        arrayList.add(PERCENT_DISTINCT);
        arrayList.add(PERCENT_NULL);
        arrayList.add(MAX);
        arrayList.add(MIN);
        arrayList.add(AVG);
        arrayList.add(STDDEV);
        arrayList.add(VARIANCE);
        arrayList.add(KURTOSIS);
        arrayList.add(MEDIAN);
        arrayList.add(this.parent.isStatsSelected(MODE_SAMPLED) ? HTMLStringUtils.wrapInHtml(MODE_SAMPLED) : HTMLStringUtils.wrapInHtml(MODE_ALL));
        arrayList.add(SKEWNESS);
        for (String string : arrayList) {
            Vector<Object> vector2 = new Vector<Object>();
            Object[] objectArray = this._statsMap.get(HTMLStringUtils.unWrapInHtml(string));
            if (objectArray != null) {
                for (Object object : objectArray) {
                    vector2.add(object);
                }
            }
            vector.add(vector2);
        }
        return vector;
    }

    public String getMaxString(int n) {
        String string = this._maxStringMap.get(n);
        if (string != null) {
            return string;
        }
        for (String string2 : this._statsMap.keySet()) {
            Object[] objectArray = this._statsMap.get(string2);
            String string3 = (String)objectArray[n];
            string3 = HTMLStringUtils.unWrapInHtml(string3);
            if (string == null) {
                string = string3;
                continue;
            }
            if (string.length() >= string3.length()) continue;
            string = string3;
        }
        this._maxStringMap.put(n, string);
        return string;
    }

    public void setupSearchField() {
        this.getSearchField().clearCategories();
        for (int i = 0; i < StatisticsSelectionObject.getSearchStrings().length; ++i) {
            String string = StatisticsSelectionObject.getSearchStrings()[i];
            SearchCategory searchCategory = new SearchCategory(string);
            this.getSearchField().addCategory(searchCategory);
            if (i != 0) continue;
            this.getSearchField().setSelectedCategory(searchCategory);
        }
        this.getSearchField().addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                StatisticsSelectionObject.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                StatisticsSelectionObject.this.processFilter(string);
            }
        });
    }

    private void processFilter(String string) {
        this.createStatsDescriptionMap();
        this.createFilteredStatisticsTableModel(string, this.getStatistics());
    }

    public void createFilteredStatisticsTableModel(String string, Vector<Vector<Object>> vector) {
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Vector<Vector<Object>> vector2 = new Vector<Vector<Object>>();
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        int n = StatisticsSelectionObject.translateSearchCategoryToConstant(this.getSearchField().getSelectedCategory());
        for (Vector<Object> vector3 : vector) {
            String string2 = "";
            if (bl) {
                bl2 = true;
            } else {
                switch (n) {
                    case 0: {
                        string2 = (String)vector3.elementAt(1);
                        break;
                    }
                    case 1: {
                        string2 = (String)vector3.elementAt(2);
                        break;
                    }
                    case 2: {
                        string2 = (String)vector3.elementAt(3);
                        break;
                    }
                    default: {
                        assert (false) : "Invalid item filter category.";
                        break;
                    }
                }
                bl2 = string2 == null ? false : searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector2.add(vector3);
        }
        Object object = new DataProfileStatisticsTableModel(vector2, StatisticsSelectionObject.getColNames(), this.parent);
        this.setupStatisticsTable((DataProfileStatisticsTableModel)((Object)object));
    }

    public void setupStatisticsTable(DataProfileStatisticsTableModel dataProfileStatisticsTableModel) {
        int n = this.getTable().getSortColumn();
        boolean bl = true;
        if (n != -1) {
            bl = this.getTable().isSortAscending();
        } else {
            n = 1;
        }
        this.getTable().setModel((TableModel)((Object)dataProfileStatisticsTableModel));
        this.getTable().setSorted(true);
        if (n != -1) {
            this.getTable().setSortColumn(n, bl);
        }
        this.getTable().setSelectionMode(0);
        this.parentPanel.setTitle(COMP_WITH_TOOLBAR_HEADER);
        TableColumnModel tableColumnModel = this.getTable().getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth(5);
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellRenderer(new DefaultTableCellRenderer());
        RolloverTableRenderer rolloverTableRenderer = (RolloverTableRenderer)tableColumn.getCellRenderer();
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)rolloverTableRenderer.getBaseRenderer();
        Font font = defaultTableCellRenderer.getFont();
        FontMetrics fontMetrics = defaultTableCellRenderer.getFontMetrics(font);
        String string = this.getMaxString(1);
        int n2 = fontMetrics.stringWidth(string) + 5;
        tableColumn.setPreferredWidth(n2);
        string = this.getMaxString(2);
        n2 = fontMetrics.stringWidth(string) + 5;
        tableColumnModel.getColumn(2).setPreferredWidth(n2);
        string = this.getMaxString(3);
        n2 = fontMetrics.stringWidth(string) + 5;
        tableColumnModel.getColumn(3).setPreferredWidth(n2);
    }

    static {
        _colNames.add("");
        _colNames.add(COLUMN_STATISTICS_NAME);
        _colNames.add(COLUMN_STATISTICS_DESCRIPTION);
        _colNames.add(COLUMN_STATISTICS_COST);
        defaultStatsSelectionMap = new HashMap<String, Boolean>();
        defaultStatsSelectionMap.put(HISTOGRAM, Boolean.TRUE);
        defaultStatsSelectionMap.put(PERCENT_DISTINCT, Boolean.TRUE);
        defaultStatsSelectionMap.put(PERCENT_NULL, Boolean.TRUE);
        defaultStatsSelectionMap.put(MAX, Boolean.TRUE);
        defaultStatsSelectionMap.put(MIN, Boolean.TRUE);
        defaultStatsSelectionMap.put(AVG, Boolean.TRUE);
        defaultStatsSelectionMap.put(STDDEV, Boolean.TRUE);
        defaultStatsSelectionMap.put(VARIANCE, Boolean.TRUE);
        defaultStatsSelectionMap.put(KURTOSIS, Boolean.FALSE);
        defaultStatsSelectionMap.put(MEDIAN, Boolean.TRUE);
        defaultStatsSelectionMap.put(MODE_FUNCTION, Boolean.TRUE);
        defaultStatsSelectionMap.put(MODE_SAMPLED, Boolean.TRUE);
        defaultStatsSelectionMap.put(MODE_ALL, Boolean.FALSE);
        defaultStatsSelectionMap.put(SKEWNESS, Boolean.FALSE);
        _searchCategories = new SearchCategory[]{new SearchCategory(COLUMN_STATISTICS_NAME), new SearchCategory(COLUMN_STATISTICS_DESCRIPTION), new SearchCategory(COLUMN_STATISTICS_COST)};
        _searchStrings = new String[]{COLUMN_STATISTICS_NAME, COLUMN_STATISTICS_DESCRIPTION, COLUMN_STATISTICS_COST};
        _costComparator = new CostComparator();
        _htmlComparator = new HypelinkComparator();
    }

    public static class HypelinkComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = HTMLStringUtils.unWrapInHtml(object.toString());
            String string2 = HTMLStringUtils.unWrapInHtml(object2.toString());
            return string.compareTo(string2);
        }
    }

    public static class CostComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            int n2 = CostComparator.costValue(object.toString());
            int n3 = n2 < (n = CostComparator.costValue(object2.toString())) ? -1 : (n2 > n ? 1 : 0);
            return n3;
        }

        private static int costValue(String string) {
            int n = -1;
            if (string.equals(LOW_COST)) {
                n = 1;
            } else if (string.equals(MEDIUM_COST)) {
                n = 2;
            } else if (string.equals(HIGH_COST)) {
                n = 3;
            } else if (string.equals(VERY_HIGH_COST)) {
                n = 4;
            } else assert (false);
            return n;
        }
    }
}

