/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistWizard;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingPage;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingPanel;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.preferences.BuildTextPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.combo.CheckComboModel;
import oracle.javatools.ui.combo.JCheckCombo;
import oracle.javatools.util.Version;

public class TextTransColumnSettingTokenPanel
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(TextTransColumnSettingTokenPanel.class.getName());
    private JPanel _parent;
    private String _sourceAttributeName = null;
    private TextNodeType.Stoplists _stoplists = null;
    private AbstractTextNode _node;
    private Context _context;
    private PropertyModel _propertyModel;
    private TextTransformationOutputAttributeType _textTransformationOutputAttribute;
    private TextTransformationType _textTransformation;
    private boolean _isAdjusting = false;
    private boolean _isAllSelected = false;
    private boolean _isNoneSelected = false;
    private static Icon _editIcon;
    private boolean _isReadOnly;
    private boolean _dirty;
    private boolean _is12gDB;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JButton jEditStoplistButton;
    private JLabel jFrequencyLabel;
    private JLabel jLanguageLabel;
    private JLabel jMaxNumAllDocsLabel;
    private JSpinner jMaxNumAllDocsSpinner;
    private JLabel jMaxNumPerDocLabel;
    private JSpinner jMaxNumPerDocSpinner;
    private JButton jNewStoplistButton;
    private JComboBox jSelectedStoplistComboBox;
    private JCheckCombo jSingleBtyeComboBox;
    private JCheckBox jStemmingCheckBox;
    private JLabel jStoplistLabel;
    private JRadioButton jTermFrequencyIDFRadioButton;
    private JRadioButton jTermFrequencyRadioButton;
    private JLabel jTokensLabel;

    public TextTransColumnSettingTokenPanel(PropertyModel propertyModel, Context context, JPanel jPanel, AbstractTextNode abstractTextNode, String string, TextTransformationOutputAttributeType textTransformationOutputAttributeType) {
        this._propertyModel = propertyModel;
        this._node = abstractTextNode;
        this._context = context;
        this._parent = jPanel;
        if (jPanel instanceof TextTransColumnSettingPanel) {
            this._stoplists = ((TextTransColumnSettingPanel)jPanel).getStoplists();
        } else if (jPanel instanceof TextTransColumnSettingPage) {
            this._stoplists = ((TextTransColumnSettingPage)((Object)jPanel)).getStoplists();
        }
        this._sourceAttributeName = string;
        this._textTransformationOutputAttribute = textTransformationOutputAttributeType;
        this._textTransformation = textTransformationOutputAttributeType == null ? null : textTransformationOutputAttributeType.getTransformationElement();
        this._isReadOnly = !(abstractTextNode instanceof BuildTextNode);
        this._dirty = false;
        Version version = null;
        try {
            version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
        this._is12gDB = ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initUI() {
        ServerConstants.StoplistLanguage.BASIC_LEXER_LANG bASIC_LEXER_LANG2;
        this.jEditStoplistButton.setText(null);
        this.jEditStoplistButton.setIcon(_editIcon);
        this.jEditStoplistButton.setToolTipText(DialogsLrb.get("BUILDTEXT_EDIT_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setText(null);
        this.jNewStoplistButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.jNewStoplistButton.setToolTipText(DialogsLrb.get("BUILDTEXT_ADD_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setEnabled(!this._isReadOnly);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("All"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("None"));
        for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG bASIC_LEXER_LANG2 : ServerConstants.StoplistLanguage.BASIC_LEXER_LANG.values()) {
            defaultListModel.addElement(bASIC_LEXER_LANG2.value());
        }
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.addSelectionInterval(1, 1);
        CheckComboModel checkComboModel = new CheckComboModel(defaultListModel, (ListSelectionModel)defaultListSelectionModel);
        this.jSingleBtyeComboBox.setModel(checkComboModel);
        ListSelectionModel listSelectionModel = this.jSingleBtyeComboBox.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    TextTransColumnSettingTokenPanel.this.jSingleByteLanguageValueChanged(listSelectionEvent);
                }
            }
        });
        bASIC_LEXER_LANG2 = Preferences.getPreferences();
        BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)bASIC_LEXER_LANG2);
        this.initStoplists(ServerConstants.StoplistLanguage.toHuman(buildTextPreferencesPanelSettings.getTokenStoplist()));
        this.jMaxNumPerDocSpinner.setModel(new SpinnerNumberModel(50, 1, 10000, 100));
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(300, 1, 100000, 1000));
        this.refreshUI(this._textTransformation);
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLanguageLabel, (Component)this.jSingleBtyeComboBox, (String)DialogsLrb.get("BUILDTEXT_LANGUAGES"));
        ResourceUtils.resButton((AbstractButton)this.jStemmingCheckBox, (String)DialogsLrb.get("STEMMING"));
        ResourceUtils.resLabel((JLabel)this.jStoplistLabel, (Component)this.jSelectedStoplistComboBox, (String)DialogsLrb.get("BUILDTEXT_STOPLIST"));
        ResourceUtils.resLabel((JLabel)this.jTokensLabel, null, (String)DialogsLrb.get("BUILDTEXT_TOKENS"));
        ResourceUtils.resSpinner((JLabel)this.jMaxNumPerDocLabel, (JSpinner)this.jMaxNumPerDocSpinner, (String)DialogsLrb.get("BUILDTEXT_MAX_NUM_PER_DOC"));
        ResourceUtils.resSpinner((JLabel)this.jMaxNumAllDocsLabel, (JSpinner)this.jMaxNumAllDocsSpinner, (String)DialogsLrb.get("BUILDTEXT_MAX_NUM_ALL_DOCS"));
        ResourceUtils.resLabel((JLabel)this.jFrequencyLabel, null, (String)DialogsLrb.get("BUILDTEXT_FREQUENCY"));
        ResourceUtils.resButton((AbstractButton)this.jTermFrequencyRadioButton, (String)DialogsLrb.get("BUILDTEXT_FREQUENCY_TERM"));
        ResourceUtils.resButton((AbstractButton)this.jTermFrequencyIDFRadioButton, (String)DialogsLrb.get("BUILDTEXT_FREQUENCY_TERM_IDF"));
        _editIcon = InspectorArb.getIcon((int)24);
    }

    private void initStoplists(String string) {
        List list = null;
        list = this._stoplists.getStoplist();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StoplistType stoplistType : list) {
            arrayList.add(stoplistType.getName());
        }
        Collections.sort(arrayList);
        arrayList.add(0, ServerConstants.StoplistLanguage.toHuman("None"));
        this.jSelectedStoplistComboBox.removeAllItems();
        this.jSelectedStoplistComboBox.setModel(new DefaultComboBoxModel<String>(arrayList.toArray(new String[arrayList.size()])));
        if (string != null) {
            this.jSelectedStoplistComboBox.setSelectedItem(string);
        }
    }

    public void refreshUI(TextTransformationType textTransformationType) {
        this._textTransformation = textTransformationType;
        if (textTransformationType != null && textTransformationType.getToken() != null) {
            Object object2;
            List list = null;
            list = this._textTransformation.getToken().getToken().getLanguages().getLanguage();
            this._isAdjusting = true;
            ListSelectionModel listSelectionModel = this.jSingleBtyeComboBox.getSelectionModel();
            listSelectionModel.clearSelection();
            CheckComboModel checkComboModel = this.jSingleBtyeComboBox.getCheckModel();
            boolean bl = false;
            for (Object object2 : list) {
                for (int i = 0; i < checkComboModel.getSize(); ++i) {
                    String string = (String)checkComboModel.getElementAt(i);
                    if (!string.equals(ServerConstants.StoplistLanguage.toHuman(object2.getName()))) continue;
                    listSelectionModel.addSelectionInterval(i, i);
                    bl = true;
                }
            }
            if (!bl) {
                listSelectionModel.addSelectionInterval(1, 1);
            }
            this._isAdjusting = false;
            Object object3 = null;
            object2 = textTransformationType.getToken().getToken().getStoplistId();
            if (object2 != null) {
                for (String string : this._stoplists.getStoplist()) {
                    if (!string.getId().equals(object2)) continue;
                    object3 = string;
                    break;
                }
            }
            if (object3 != null) {
                this.jSelectedStoplistComboBox.setSelectedItem(object3.getName());
            } else {
                this.jSelectedStoplistComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman("None"));
            }
            int n = textTransformationType.getToken().getToken().getMaxNumberPerDoc().intValue();
            this.jMaxNumPerDocSpinner.setValue(n);
            int n2 = textTransformationType.getToken().getToken().getMaxNumberAllDocs().intValue();
            this.jMaxNumAllDocsSpinner.setValue(n2);
            String string = textTransformationType.getToken().getToken().getFrequency();
            this.jTermFrequencyRadioButton.setSelected(string.equals("Terms"));
            this.jTermFrequencyIDFRadioButton.setSelected(string.equals("IDF"));
            boolean bl2 = false;
            for (LexerType.Settings.Attribute attribute : textTransformationType.getToken().getToken().getLexer().getSettings().getAttribute()) {
                if (!attribute.getName().equals("index_stems")) continue;
                bl2 = true;
                break;
            }
            this.jStemmingCheckBox.setSelected(bl2);
        } else {
            Preferences preferences = Preferences.getPreferences();
            BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
            ArrayList<String> arrayList = buildTextPreferencesPanelSettings.getTokenLanguages();
            this._isAdjusting = true;
            ListSelectionModel listSelectionModel = this.jSingleBtyeComboBox.getSelectionModel();
            listSelectionModel.clearSelection();
            CheckComboModel checkComboModel = this.jSingleBtyeComboBox.getCheckModel();
            boolean bl = false;
            for (int i = 0; i < checkComboModel.getSize(); ++i) {
                String string = (String)checkComboModel.getElementAt(i);
                if (!arrayList.contains(ServerConstants.StoplistLanguage.toSchema(string))) continue;
                listSelectionModel.addSelectionInterval(i, i);
                bl = true;
            }
            if (!bl) {
                listSelectionModel.addSelectionInterval(1, 1);
            }
            this._isAdjusting = false;
            this.jMaxNumPerDocSpinner.setValue(buildTextPreferencesPanelSettings.getTokenMaxNumPerDoc());
            this.jMaxNumAllDocsSpinner.setValue(buildTextPreferencesPanelSettings.getTokenMaxNumAllDocs());
            this.jTermFrequencyIDFRadioButton.setSelected(true);
            this.jStemmingCheckBox.setSelected(buildTextPreferencesPanelSettings.useStemming());
        }
        this.enableControls();
    }

    /*
     * WARNING - void declaration
     */
    public boolean copySettings(TextTransformationType textTransformationType, TextNodeType.Stoplists stoplists) throws ValidationException {
        List list;
        List<String> list2;
        String string;
        Object object;
        Object object2;
        void var13_17;
        String string2;
        Object object32;
        Object[] objectArray;
        boolean bl = false;
        StoplistType stoplistType = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Integer n = (Integer)this.jMaxNumPerDocSpinner.getValue();
        Integer n2 = (Integer)this.jMaxNumAllDocsSpinner.getValue();
        if (n > n2) {
            throw new ValidationException(DialogsLrb.get("BUILDTEXT_MAX_NUM_PER_DOC_ERROR"));
        }
        TransformationTokenType.Token token = new TransformationTokenType.Token();
        TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
        TransformationTokenType.Token.Languages.Language language = null;
        CheckComboModel checkComboModel = this.jSingleBtyeComboBox.getCheckModel();
        for (Object object32 : objectArray = checkComboModel.getSelectedItem()) {
            string2 = (String)object32;
            if (ServerConstants.StoplistLanguage.isALL(ServerConstants.StoplistLanguage.toSchema(string2)) || ServerConstants.StoplistLanguage.isNone(ServerConstants.StoplistLanguage.toSchema(string2))) continue;
            language = new TransformationTokenType.Token.Languages.Language();
            language.setName(ServerConstants.StoplistLanguage.toSchema(string2));
            if (ServerConstants.StoplistLanguage.isTraditionalChinese(ServerConstants.StoplistLanguage.toSchema(string2)) || ServerConstants.StoplistLanguage.isSimplifiedChinese(ServerConstants.StoplistLanguage.toSchema(string2)) || ServerConstants.StoplistLanguage.isJapanese(ServerConstants.StoplistLanguage.toSchema(string2)) || ServerConstants.StoplistLanguage.isKorean(ServerConstants.StoplistLanguage.toSchema(string2))) {
                language.setType("MultiByte");
            } else {
                language.setType("SingleByte");
            }
            languages.getLanguage().add(language);
            arrayList.add(ServerConstants.StoplistLanguage.toSchema(string2));
        }
        if (arrayList.size() == 0) {
            throw new ValidationException(DialogsLrb.get("BUILDTEXT_NO_LANGUAGE_ERROR"));
        }
        token.setLanguages(languages);
        Object var13_14 = null;
        String string3 = null;
        if (textTransformationType.getToken() != null) {
            String string4 = textTransformationType.getToken().getToken().getPolicy();
            string3 = textTransformationType.getToken().getToken().getStatisticTable().getName();
        } else {
            bl = true;
            try {
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
                String string5 = DatabaseMetadataUtils.createUniqueTableName("ODMR$", connectionFolder, "_PL");
                string3 = DatabaseMetadataUtils.createUniqueTableName("ODMR$", connectionFolder, "_FT");
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        }
        token.setPolicy((String)var13_17);
        ResultType resultType = new ResultType();
        resultType.setCreationDate(null);
        resultType.setName(string3);
        token.setStatisticTable(resultType);
        object32 = new LexerType();
        if (languages.getLanguage().size() <= 1) {
            object32.setType("Basic");
        } else {
            object32.setType("Auto");
        }
        token.setLexer((LexerType)object32);
        string2 = new LexerType.Settings();
        if (this.jStemmingCheckBox.isSelected()) {
            object2 = new LexerType.Settings.Attribute();
            object2 = new LexerType.Settings.Attribute();
            if (languages.getLanguage().size() <= 1) {
                object2 = new LexerType.Settings.Attribute();
                object2.setName("index_stems");
                object2.setType("String");
                object2.setValueString(((TransformationTokenType.Token.Languages.Language)languages.getLanguage().get(0)).getName());
            } else {
                object2 = new LexerType.Settings.Attribute();
                object2.setName("index_stems");
                object2.setType("String");
                object2.setValueString("TRUE");
            }
            string2.getAttribute().add(object2);
        }
        object32.setSettings((LexerType.Settings)string2);
        token.setStoplistId(null);
        object2 = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        if (object2 != null) {
            if (ServerConstants.StoplistLanguage.isDefault(ServerConstants.StoplistLanguage.toSchema((String)object2))) {
                object = null;
                object = languages.getLanguage().size() <= 1 ? ((TransformationTokenType.Token.Languages.Language)languages.getLanguage().get(0)).getName() : "Multi";
                string = null;
                stoplistType = AbstractTextNode.findDefaultStoplist(stoplists, (String)object);
                string = stoplistType.getId();
                token.setStoplistId(string);
            } else {
                token.setStoplistId(AbstractTextNode.findStoplistId(stoplists, (String)object2));
            }
        }
        object = (Integer)this.jMaxNumPerDocSpinner.getValue();
        token.setMaxNumberPerDoc(BigInteger.valueOf(((Integer)object).intValue()));
        object = (Integer)this.jMaxNumAllDocsSpinner.getValue();
        token.setMaxNumberAllDocs(BigInteger.valueOf(((Integer)object).intValue()));
        string = this.jTermFrequencyRadioButton.isSelected() ? "Terms" : "IDF";
        token.setFrequency(string);
        TransformationTokenType transformationTokenType = new TransformationTokenType();
        transformationTokenType.setToken(token);
        boolean bl2 = false;
        if (stoplistType != null) {
            boolean bl3;
            list2 = AbstractTextNode.findStoplistLanguages(stoplistType, "Word");
            list = new ArrayList();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string6 : arrayList) {
                bl3 = false;
                for (String string7 : list2) {
                    if (!string6.equals(string7)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                ((ArrayList)list).add((String)string6);
                bl2 = true;
            }
            for (String string8 : list2) {
                bl3 = false;
                for (String string7 : arrayList) {
                    if (!string8.equals(string7)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                arrayList2.add(string8);
                bl2 = true;
            }
            if (((ArrayList)list).size() > 0) {
                int n3 = AbstractTextNode.stoplistAddDefaultTokens(this._context, stoplistType, "Word", list);
            }
            if (arrayList2.size() > 0) {
                TextNodeType textNodeType = ((TextTransColumnSettingPanel)this._parent).getTextNodeType();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                if (this._textTransformationOutputAttribute != null) {
                    AbstractTextNode.stoplistCheckLanguagesUsed(this._textTransformationOutputAttribute.getName(), textNodeType.getTransformedAttributes(), stoplistType, "Word", arrayList2, arrayList3);
                }
                if (arrayList3.size() == 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string7 : arrayList2) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(ServerConstants.StoplistLanguage.toHuman(string7));
                    }
                    String string9 = MessageFormat.format(DialogsLrb.get("BUILDTEXT_REMOVE_WORDS_FOR_LANG"), stringBuffer.toString());
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string9, (String)DialogsLrb.get("BUILD_TEXT_DIALOG_TITLE"), null, (boolean)true)) {
                        int n4 = AbstractTextNode.stoplistRemoveTokens(stoplistType, "Word", arrayList2);
                    }
                }
            }
        }
        if (!bl) {
            if (textTransformationType.getToken().getToken().getLanguages().getLanguage().size() != transformationTokenType.getToken().getLanguages().getLanguage().size()) {
                this._dirty = true;
            } else {
                list2 = textTransformationType.getToken().getToken().getLanguages().getLanguage();
                list = transformationTokenType.getToken().getLanguages().getLanguage();
                for (int i = 0; i < list2.size(); ++i) {
                    void var27_47;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    while (var27_47 < list.size()) {
                        if (((TransformationTokenType.Token.Languages.Language)list2.get(i)).getName().equals(((TransformationTokenType.Token.Languages.Language)list.get((int)var27_47)).getName())) {
                            bl4 = true;
                            break;
                        }
                        ++var27_47;
                    }
                    if (bl4) continue;
                    this._dirty = true;
                    break;
                }
            }
            if (textTransformationType.getToken().getToken().getLexer().getSettings().getAttribute().size() != transformationTokenType.getToken().getLexer().getSettings().getAttribute().size()) {
                this._dirty = true;
            } else {
                list2 = textTransformationType.getToken().getToken().getLexer().getSettings().getAttribute();
                list = transformationTokenType.getToken().getLexer().getSettings().getAttribute();
                for (int i = 0; i < list2.size(); ++i) {
                    void var27_49;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    while (var27_49 < list.size()) {
                        if (((LexerType.Settings.Attribute)list2.get(i)).getName().equals(((LexerType.Settings.Attribute)list.get((int)var27_49)).getName())) {
                            if (((LexerType.Settings.Attribute)list2.get(i)).getType().equals("String")) {
                                if (((LexerType.Settings.Attribute)list2.get(i)).getValueString().equals(((LexerType.Settings.Attribute)list.get((int)var27_49)).getValueString())) {
                                    bl6 = true;
                                    break;
                                }
                            } else if (((LexerType.Settings.Attribute)list2.get(i)).getValueNumber().equals(((LexerType.Settings.Attribute)list.get((int)var27_49)).getValueNumber())) {
                                bl6 = true;
                                break;
                            }
                        }
                        ++var27_49;
                    }
                    if (bl6) continue;
                    this._dirty = true;
                    break;
                }
            }
            if (!textTransformationType.getToken().getToken().getFrequency().equals(transformationTokenType.getToken().getFrequency())) {
                this._dirty = true;
            }
            if (!textTransformationType.getToken().getToken().getMaxNumberAllDocs().equals(transformationTokenType.getToken().getMaxNumberAllDocs())) {
                this._dirty = true;
            }
            if (!textTransformationType.getToken().getToken().getMaxNumberPerDoc().equals(transformationTokenType.getToken().getMaxNumberPerDoc())) {
                this._dirty = true;
            }
            if (!(this._dirty || textTransformationType.getToken().getToken().getStoplistId() == null && transformationTokenType.getToken().getStoplistId() == null)) {
                this._dirty = textTransformationType.getToken().getToken().getStoplistId() == null && transformationTokenType.getToken().getStoplistId() != null ? true : (textTransformationType.getToken().getToken().getStoplistId() != null && transformationTokenType.getToken().getStoplistId() == null ? true : (!textTransformationType.getToken().getToken().getStoplistId().equals(transformationTokenType.getToken().getStoplistId()) ? true : bl2));
            }
        }
        textTransformationType.setToken(transformationTokenType);
        textTransformationType.setTheme(null);
        return this._dirty;
    }

    private void enableControls() {
        for (Component component : this.getComponents()) {
            component.setEnabled(!this._isReadOnly);
        }
        if (this.jSelectedStoplistComboBox.getItemCount() > 0) {
            String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
            this.jEditStoplistButton.setEnabled(!ServerConstants.StoplistLanguage.isNone(ServerConstants.StoplistLanguage.toSchema(string)));
        } else {
            this.jEditStoplistButton.setEnabled(false);
        }
        this.jStemmingCheckBox.setVisible(this._is12gDB);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.jLanguageLabel = new JLabel();
        this.jSingleBtyeComboBox = new JCheckCombo();
        this.jStoplistLabel = new JLabel();
        this.jSelectedStoplistComboBox = new JComboBox();
        this.jEditStoplistButton = new JButton();
        this.jNewStoplistButton = new JButton();
        this.jTokensLabel = new JLabel();
        this.jMaxNumPerDocLabel = new JLabel();
        this.jMaxNumPerDocSpinner = new JSpinner();
        this.jMaxNumAllDocsLabel = new JLabel();
        this.jMaxNumAllDocsSpinner = new JSpinner();
        this.jFrequencyLabel = new JLabel();
        this.jTermFrequencyRadioButton = new JRadioButton();
        this.jTermFrequencyIDFRadioButton = new JRadioButton();
        this.jStemmingCheckBox = new JCheckBox();
        this.jLanguageLabel.setText("Languages:");
        this.jSingleBtyeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"English", "German", "French"}));
        this.jSingleBtyeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jSingleBtyeComboBoxActionPerformed(actionEvent);
            }
        });
        this.jStoplistLabel.setText("Stoplist:");
        this.jSelectedStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSelectedStoplistComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jSelectedStoplistComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistButton.setText("---");
        this.jEditStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jEditStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jEditStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jNewStoplistButton.setText("+");
        this.jNewStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jNewStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jNewStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jTokensLabel.setText("Tokens:");
        this.jMaxNumPerDocLabel.setLabelFor(this.jMaxNumPerDocSpinner);
        this.jMaxNumPerDocLabel.setText("Max number per document");
        this.jMaxNumPerDocSpinner.setModel(new SpinnerNumberModel(50, 1, 10000, 10));
        this.jMaxNumAllDocsLabel.setLabelFor(this.jMaxNumAllDocsSpinner);
        this.jMaxNumAllDocsLabel.setText("Max number across all documents");
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(3000, 1, 100000, 100));
        this.jFrequencyLabel.setText("Frequency:");
        this.buttonGroup3.add(this.jTermFrequencyRadioButton);
        this.jTermFrequencyRadioButton.setText("Term Frequency");
        this.buttonGroup3.add(this.jTermFrequencyIDFRadioButton);
        this.jTermFrequencyIDFRadioButton.setText("Term Frequency - IDF");
        this.jStemmingCheckBox.setText("Stemming");
        this.jStemmingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jStemmingCheckBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jStemmingCheckBox, -2, 94, -2)).addComponent(this.jTokensLabel).addComponent(this.jFrequencyLabel).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jMaxNumPerDocLabel).addComponent(this.jMaxNumAllDocsLabel)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMaxNumPerDocSpinner, -2, -1, -2).addComponent(this.jMaxNumAllDocsSpinner, -2, -1, -2))).addComponent(this.jTermFrequencyRadioButton).addComponent(this.jTermFrequencyIDFRadioButton)))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLanguageLabel, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jSingleBtyeComboBox, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jStoplistLabel, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectedStoplistComboBox, 0, 217, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEditStoplistButton, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNewStoplistButton, -2, 26, -2))).addContainerGap()));
        groupLayout.linkSize(0, this.jMaxNumAllDocsSpinner, this.jMaxNumPerDocSpinner);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent((Component)this.jSingleBtyeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jStemmingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedStoplistComboBox, -2, -1, -2).addComponent(this.jNewStoplistButton).addComponent(this.jEditStoplistButton).addComponent(this.jStoplistLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokensLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumPerDocLabel).addComponent(this.jMaxNumPerDocSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumAllDocsLabel).addComponent(this.jMaxNumAllDocsSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jFrequencyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTermFrequencyRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTermFrequencyIDFRadioButton).addContainerGap(38, Short.MAX_VALUE)));
    }

    private void jSelectedStoplistComboBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jEditStoplistButtonActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        StoplistType stoplistType = null;
        boolean bl = false;
        for (StoplistType stoplistType2 : this._stoplists.getStoplist()) {
            if (!stoplistType2.getName().equals(string)) continue;
            stoplistType = stoplistType2;
            break;
        }
        bl = !this._isReadOnly;
        Object object = null;
        boolean bl2 = false;
        if (this._propertyModel != null) {
            object = new StoplistDetailsPanel(this._propertyModel, this, stoplistType, bl);
            bl2 = ((DialogDisplayer)object).showAsDialog(this);
        } else {
            object = new StoplistDetailsPanel(this._context, this._node, this, stoplistType, bl);
            bl2 = ((DialogDisplayer)object).showAsDialog(this);
        }
        if (bl2 && ((StoplistDetailsPanel)object).isDirty()) {
            StoplistType stoplistType3 = ((StoplistDetailsPanel)object).getStoplist();
            for (int i = 0; i < this._stoplists.getStoplist().size(); ++i) {
                if (!((StoplistType)this._stoplists.getStoplist().get(i)).getId().equals(stoplistType3.getId())) continue;
                this._stoplists.getStoplist().set(i, stoplistType3);
                break;
            }
            this._dirty = true;
            this.initStoplists(stoplistType3.getName());
        }
    }

    private void jNewStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistWizard stoplistWizard = new StoplistWizard();
        if (stoplistWizard.runWizard(this, this._propertyModel, this._context, (BuildTextNode)this._node, this._sourceAttributeName)) {
            StoplistType stoplistType = stoplistWizard.getModel().getStoplist();
            String string = AbstractTextNode.getStoplistNextId(this._stoplists) + "";
            stoplistType.setId(string);
            this._stoplists.getStoplist().add(stoplistType);
            this.initStoplists(stoplistType.getName());
        }
    }

    private void jSingleBtyeComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jStemmingCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jSingleByteLanguageValueChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray;
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        CheckComboModel checkComboModel = this.jSingleBtyeComboBox.getCheckModel();
        for (Object object : objectArray = checkComboModel.getSelectedItem()) {
            String string = (String)object;
            if (!this._isNoneSelected && ServerConstants.StoplistLanguage.isNone(ServerConstants.StoplistLanguage.toSchema(string))) {
                listSelectionModel.clearSelection();
                listSelectionModel.addSelectionInterval(1, 1);
                this._isNoneSelected = true;
                this._isAllSelected = false;
                break;
            }
            if (!this._isAllSelected && ServerConstants.StoplistLanguage.isALL(ServerConstants.StoplistLanguage.toSchema(string))) {
                listSelectionModel.removeSelectionInterval(1, 1);
                listSelectionModel.addSelectionInterval(2, checkComboModel.getSize() - 1);
                this._isAllSelected = true;
                this._isNoneSelected = false;
                break;
            }
            listSelectionModel.removeSelectionInterval(0, 0);
            this._isAllSelected = false;
            listSelectionModel.removeSelectionInterval(1, 1);
            this._isNoneSelected = false;
        }
        this._isAdjusting = false;
    }

    public void setSourceAttributeName(String string) {
        this._sourceAttributeName = string;
    }

    public void setReadOnly(boolean bl) {
        this._isReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public TextNodeType.Stoplists getStoplists() {
        return this._stoplists;
    }

    public boolean isTokenTransformType() {
        if (this._textTransformation != null) {
            TransformationTokenType transformationTokenType = this._textTransformation.getToken();
            return transformationTokenType != null;
        }
        return false;
    }

    public boolean isThemeTransformType() {
        if (this._textTransformation != null) {
            TextTransformationType.Theme theme = this._textTransformation.getTheme();
            return theme != null;
        }
        return false;
    }
}

