/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.wizard.AbstractWizardPage;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.TransformWizardModel;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class TextTransColumnOutputPage
extends AbstractWizardPage
implements DataminerGUIPanel {
    private TransformWizardModel _wizModel;
    private OutputTableModel _model;
    private DataMinerTablePanel columnNameTablePanel;
    private JScrollPane jDescScrollPane;
    private JButton jRevertButton;
    private String[] _outputColumnNames = new String[]{DialogsLrb.get("TRANSFORM_WIZ_OUTPUT_SOURCE"), DialogsLrb.get("TRANSFORM_WIZ_OUTPUT_ORIGINAL"), DialogsLrb.get("TRANSFORM_WIZ_OUTPUT_NEW")};
    private static final int OUTPUT_SOURCE = 0;
    private static final int OUTPUT_ORIGINAL = 1;
    private static final int OUTPUT_NEW = 2;

    public TextTransColumnOutputPage() {
        this.initComponents();
        this.initRes();
    }

    @Override
    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this.jRevertButton, (String)DialogsLrb.get("TRANSFORM_WIZ_REVERT_ORG_NAMES"));
    }

    @Override
    public void initUI() {
        this._wizModel = (TransformWizardModel)this.getTraversableContext().get("wizardModel");
        this.jDescScrollPane.setVisible(false);
        this._model = new OutputTableModel();
        if (this._wizModel.isEdit()) {
            this._model.setEditAttributes(this._wizModel.getEditAttributes());
        } else {
            this._model.setNewAttributes(this._wizModel.getNewAttributes());
        }
        this.columnNameTablePanel.setup((TableModel)((Object)this._model), DialogsLrb.get("STOPLIST_STOPLIST_TABLE_TITLE"), 0, true);
        this.columnNameTablePanel.getTable().setAutoResizeMode(4);
        this.columnNameTablePanel.getTable().setColumnSelectorAvailable(true);
        this.columnNameTablePanel.getTable().setShowToolTips(true);
        this.columnNameTablePanel.getTable().setUpdateSelectionOnSort(true);
        this.columnNameTablePanel.getTable().setRowSelectionAllowed(true);
        TableColumn tableColumn = this.columnNameTablePanel.getTable().getColumnModel().getColumn(2);
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor(this._wizModel.getContext());
        dBObjectNameEditor.setDocument(new TextFieldLimit(32));
        tableColumn.setCellEditor(dBObjectNameEditor);
        if (!this._wizModel.isEdit()) {
            tableColumn = this.columnNameTablePanel.getTable().getColumnModel().getColumn(1);
            this.columnNameTablePanel.getTable().removeColumn(tableColumn);
            this.jRevertButton.setVisible(false);
        }
        this.columnNameTablePanel.getTable().autoSizeColumnsToFit();
    }

    private void revertToOriginalOutputNames() {
        for (TransformationSourceAttribute transformationSourceAttribute : this._wizModel.getEditAttributes()) {
            transformationSourceAttribute.setAlias(transformationSourceAttribute.getName());
        }
        this._model.fireTableDataChanged();
    }

    @Override
    public String getPageDirtyKey() {
        return "NewColumnDirty";
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        return this.validateAndWriteToState(this._wizModel);
    }

    public boolean validateAndWriteToState(TransformWizardModel transformWizardModel) {
        boolean bl = true;
        ValidateWriteThread validateWriteThread = new ValidateWriteThread(transformWizardModel);
        validateWriteThread.setMessage(MessageFormat.format(GroupLrb.get("VALIDATING_GROUP_TABLES_DETAILS"), new Object[]{null}));
        validateWriteThread.setCancelable(false);
        try {
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
        return bl;
    }

    private void initComponents() {
        this.jDescScrollPane = new JScrollPane();
        this.jRevertButton = new JButton();
        this.columnNameTablePanel = new DataMinerTablePanel();
        this.jDescScrollPane.setBorder(null);
        this.jRevertButton.setText("Revert to Original Names");
        this.jRevertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnOutputPage.this.jRevertButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap(237, Short.MAX_VALUE).addComponent(this.jRevertButton).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.columnNameTablePanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addComponent(this.jDescScrollPane, -1, 374, Short.MAX_VALUE).addGap(16, 16, 16)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jDescScrollPane, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRevertButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnNameTablePanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jRevertButtonActionPerformed(ActionEvent actionEvent) {
        this.revertToOriginalOutputNames();
    }

    private class OutputTableModel
    extends GenericBaseTableModel {
        private List<TransformationSourceAttribute> _editAttributes;
        private List<MapTextTransformedSourceType> _newAttributes;
        private Boolean _isEdit = null;

        public OutputTableModel() {
            this.setColumnIdentifiers(TextTransColumnOutputPage.this._outputColumnNames);
            this.setRowCount(this.getRowCount());
        }

        public void setEditAttributes(List<TransformationSourceAttribute> list) {
            this._editAttributes = list;
            this._isEdit = Boolean.TRUE;
        }

        public void setNewAttributes(List<MapTextTransformedSourceType> list) {
            this._newAttributes = list;
            this._isEdit = Boolean.FALSE;
        }

        public int getRowCount() {
            if (this._isEdit == null) {
                return 0;
            }
            return this._isEdit != false ? this._editAttributes.size() : this._newAttributes.size();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this.getRowCount() == 0) {
                return "Loading...";
            }
            String string = null;
            switch (n2) {
                case 0: {
                    if (this._isEdit.booleanValue()) {
                        string = this._editAttributes.get(n).getName();
                        break;
                    }
                    string = this._newAttributes.get(n).getKey().getSource();
                    break;
                }
                case 1: {
                    if (this._isEdit.booleanValue()) {
                        string = this._editAttributes.get(n).getName();
                        break;
                    }
                    string = null;
                    break;
                }
                case 2: {
                    if (this._isEdit.booleanValue()) {
                        string = this._editAttributes.get(n).getAlias();
                        break;
                    }
                    string = this._newAttributes.get(n).getKey().getName();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            switch (n2) {
                case 2: {
                    String string = null;
                    String string2 = null;
                    string2 = this._isEdit != false ? this._editAttributes.get(n).getAlias() : this._newAttributes.get(n).getKey().getName();
                    if (object != null) {
                        string = ((String)object).trim();
                    }
                    if (string2 != null && StringUtils.isDoubleQuotedString(string)) {
                        string2 = StringUtils.addDoubleQuotes(string2);
                    }
                    if (string.length() != 0) {
                        if (!StringUtils.isDoubleQuotedString(string)) {
                            string = string.toUpperCase();
                        }
                        if (!this.validateOutputName(n, string, TextTransColumnOutputPage.this._wizModel.getContext(), true)) {
                            return;
                        }
                    }
                    if (string2 != null && string2.compareTo(string) == 0) {
                        return;
                    }
                    string = StringUtils.trimDoubleQuotes(string);
                    if (this._isEdit.booleanValue()) {
                        this._editAttributes.get(n).setAlias(string);
                        break;
                    }
                    this._newAttributes.get(n).getKey().setName(string);
                }
            }
        }

        private boolean validateOutputName(int n, String string, Context context, boolean bl) {
            boolean bl2 = true;
            if (string.length() != 0) {
                if (!StringUtils.isDoubleQuotedString(string) && !AttributeNameValidator.isNameValidNonQuoted(string, bl)) {
                    return false;
                }
                if (!AttributeNameValidator.isNameValid(string = !StringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : StringUtils.trimDoubleQuotes(string), bl)) {
                    return false;
                }
                if (!this.isNameUnique(n, string)) {
                    return false;
                }
                if (!AttributeNameValidator.isNameLengthValidInDB(context, string, false)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("ADD_BUILDTEXT_DIALOG_ERROR_NAME_LONG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    return false;
                }
            }
            return bl2;
        }

        private boolean isNameUnique(int n, String string) {
            Object object = null;
            object = this._isEdit != false ? this._editAttributes.get(n) : this._newAttributes.get(n).getKey();
            for (MapTextTransformedSourceType mapTextTransformedSourceType : TextTransColumnOutputPage.this._wizModel.getTransformedAttributes().getMapTextTransformedSource()) {
                if (object == mapTextTransformedSourceType.getKey()) continue;
                String string2 = null;
                string2 = this._isEdit != false ? mapTextTransformedSourceType.getKey().getAlias() : mapTextTransformedSourceType.getKey().getName();
                if (string2 == null || string2.compareTo(string) != 0) continue;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("ADD_BUILDTEXT_DIALOG_ERROR_DUPLICATE_NAME"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            return true;
        }
    }

    private static class ValidateWriteThread
    extends ProgressRunnable {
        private TransformWizardModel _model;
        boolean _validated = true;
        private boolean _canceled = false;
        private boolean _forceUpdate = false;

        public ValidateWriteThread(TransformWizardModel transformWizardModel) {
            this._model = transformWizardModel;
        }

        public boolean getForceUpdate() {
            return this._forceUpdate;
        }

        public void setForceUpdate(boolean bl) {
            this._forceUpdate = bl;
        }

        public boolean getValidation() {
            return this._validated;
        }

        protected Object doWork() throws Exception {
            try {
                this._validated = true;
            }
            catch (Exception exception) {
                this._validated = false;
            }
            return null;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

