/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;

public class ModelSVDPCABuildSettingsPanel
extends AbstractPropertiesPanel {
    private String SYSTEM_DETERMINED = AlgSettingsLrb.get("SYSTEM_DETERMINED");
    private ButtonGroup buttonGroup1;
    private JComboBox jApproxComputationComboBox;
    private JLabel jApproxComputationLabel;
    private JLabel jNumOfFeaturesLabel;
    private JCheckBox jPersistUMatrixCheckBox;
    private JScrollPane jScrollPane1;
    private JRadioButton jSystemDeterminedRadioButton;
    private JRadioButton jUserSpecifiedRadioButton;
    private JTextField jUserSpecifiedTextField;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public ModelSVDPCABuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this.initComponents();
        this.intRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jNumOfFeaturesLabel = new JLabel();
        this.jSystemDeterminedRadioButton = new JRadioButton();
        this.jUserSpecifiedRadioButton = new JRadioButton();
        this.jUserSpecifiedTextField = new NumberTextField();
        this.jApproxComputationLabel = new JLabel();
        this.jApproxComputationComboBox = new JComboBox();
        this.jPersistUMatrixCheckBox = new JCheckBox();
        this.jScrollPane1.setBorder(null);
        this.jNumOfFeaturesLabel.setText("Number of Features");
        this.buttonGroup1.add(this.jSystemDeterminedRadioButton);
        this.jSystemDeterminedRadioButton.setText("System determined");
        this.jSystemDeterminedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelSVDPCABuildSettingsPanel.this.jSystemDeterminedRadioButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.jUserSpecifiedRadioButton);
        this.jUserSpecifiedRadioButton.setText("User specified:");
        this.jUserSpecifiedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelSVDPCABuildSettingsPanel.this.jUserSpecifiedRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jApproxComputationLabel.setText("Approximate Computation:");
        this.jApproxComputationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"System Determined"}));
        this.jPersistUMatrixCheckBox.setText("Persist the U Matrix");
        this.jPersistUMatrixCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 394, Short.MAX_VALUE).addGap(16, 16, 16)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNumOfFeaturesLabel).addComponent(this.jPersistUMatrixCheckBox).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jApproxComputationLabel).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jUserSpecifiedRadioButton).addComponent(this.jSystemDeterminedRadioButton)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jUserSpecifiedTextField).addComponent(this.jApproxComputationComboBox, -2, -1, -2)))).addContainerGap(159, Short.MAX_VALUE)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 52, -2).addGap(18, 18, 18).addComponent(this.jNumOfFeaturesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSystemDeterminedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jUserSpecifiedRadioButton).addComponent(this.jUserSpecifiedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jApproxComputationLabel).addComponent(this.jApproxComputationComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPersistUMatrixCheckBox).addContainerGap(109, Short.MAX_VALUE)));
    }

    private void jUserSpecifiedRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.jUserSpecifiedTextField.setEnabled(this.jUserSpecifiedRadioButton.isSelected());
    }

    private void jSystemDeterminedRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.jUserSpecifiedTextField.setEnabled(this.jUserSpecifiedRadioButton.isSelected());
    }

    private void intRes() {
        ResourceUtils.resLabel((JLabel)this.jNumOfFeaturesLabel, null, (String)AlgSettingsLrb.get("FEAT_NUM_FEATURES"));
        ResourceUtils.resButton((AbstractButton)this.jSystemDeterminedRadioButton, (String)AlgSettingsLrb.get("SVD_SYSTEM_DETERMINED"));
        ResourceUtils.resButton((AbstractButton)this.jUserSpecifiedRadioButton, (String)AlgSettingsLrb.get("SVD_USER_SPECIFIED"));
        ResourceUtils.resLabel((JLabel)this.jApproxComputationLabel, (Component)this.jApproxComputationComboBox, (String)AlgSettingsLrb.get("SVD_APPROXIMATE_COMPUTATION"));
        ResourceUtils.resButton((AbstractButton)this.jPersistUMatrixCheckBox, (String)AlgSettingsLrb.get("SVD_PROJECTIONS"));
    }

    private void initUI() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.loadDescription(this._jDescription, this.jScrollPane1);
        this.setDataType(this.jUserSpecifiedTextField, Integer.class);
        this.setSigned(this.jUserSpecifiedTextField, false);
        this.setLocale(this.jUserSpecifiedTextField, commonSettingDataObject.getLocale());
        this.jUserSpecifiedTextField.setToolTipText(AlgSettingsLrb.get("FEAT_NUM_FEATURES_TOOLTIP"));
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("FEAT_NUM_FEATURES");
        commonSettingDataObject.setBackupValue("FEAT_NUM_FEATURES", bigDecimal);
        this.jSystemDeterminedRadioButton.setEnabled(true);
        this.jUserSpecifiedRadioButton.setEnabled(true);
        if (bigDecimal != null) {
            this.jUserSpecifiedRadioButton.setSelected(true);
            this.setNumber(this.jUserSpecifiedTextField, bigDecimal);
        } else {
            this.jSystemDeterminedRadioButton.setSelected(true);
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{this.SYSTEM_DETERMINED, ServerConstants.NMFSettings.toHuman("ODMS_APPR_COMP_ENABLE"), ServerConstants.NMFSettings.toHuman("ODMS_APPR_COMP_DISABLE")});
        this.jApproxComputationComboBox.setModel(defaultComboBoxModel);
        String string = commonSettingDataObject.getModelSettingStringValue("ODMS_APPROXIMATE_COMPUTATION");
        commonSettingDataObject.setBackupValue("ODMS_APPROXIMATE_COMPUTATION", string);
        if (string == null || string.isEmpty()) {
            this.jApproxComputationComboBox.setSelectedItem(this.SYSTEM_DETERMINED);
        } else {
            this.jApproxComputationComboBox.setSelectedItem(ServerConstants.NMFSettings.toHuman(string));
        }
        this.jApproxComputationLabel.setLabelFor(this.jApproxComputationComboBox);
        string = commonSettingDataObject.getModelSettingStringValue("SVDS_U_MATRIX_OUTPUT");
        commonSettingDataObject.setBackupValue("SVDS_U_MATRIX_OUTPUT", string);
        boolean bl = string.equals("SVDS_U_MATRIX_ENABLE");
        this.jPersistUMatrixCheckBox.setSelected(bl);
        this.jUserSpecifiedTextField.setEnabled(this.jUserSpecifiedRadioButton.isSelected());
    }

    @Override
    public void processInput() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        Number number = null;
        if (this.jSystemDeterminedRadioButton.isSelected()) {
            this.setObjectValue("FEAT_NUM_FEATURES", null);
        } else {
            number = this.getNumber(this.jUserSpecifiedTextField);
            if (null == number || 1 > number.intValue() || number.intValue() > 2500) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVD_NUM_FEATURES_INVALID"));
                return;
            }
            this.setObjectValue("FEAT_NUM_FEATURES", number);
        }
        String string = (String)this.jApproxComputationComboBox.getSelectedItem();
        string = string.equals(ServerConstants.NMFSettings.ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_ENABLE.value()) ? "ODMS_APPR_COMP_ENABLE" : (string.equals(ServerConstants.NMFSettings.ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_DISABLE.value()) ? "ODMS_APPR_COMP_DISABLE" : null);
        this.setObjectValue("ODMS_APPROXIMATE_COMPUTATION", string);
        if (this.jPersistUMatrixCheckBox.isSelected()) {
            this.setObjectValue("SVDS_U_MATRIX_OUTPUT", "SVDS_U_MATRIX_ENABLE");
        } else {
            this.setObjectValue("SVDS_U_MATRIX_OUTPUT", "SVDS_U_MATRIX_DISABLE");
        }
    }
}

