/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;

public class ModelOCBuildSettingsPanel
extends AbstractPropertiesPanel {
    private JLabel jBufferSizeLabel;
    private JTextField jBufferSizeTextField;
    private JLabel jNumClustersLabel;
    private JTextField jNumClustersTextField;
    private JScrollPane jScrollPaneTitle;
    private JLabel jSensitivityLabel;
    private JTextField jSensitivityTextField;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public ModelOCBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jScrollPaneTitle = new JScrollPane();
        this.jNumClustersLabel = new JLabel();
        this.jNumClustersTextField = new NumberTextField();
        this.jBufferSizeLabel = new JLabel();
        this.jBufferSizeTextField = new NumberTextField();
        this.jSensitivityLabel = new JLabel();
        this.jSensitivityTextField = new NumberTextField();
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        this.jScrollPaneTitle.setName("jScrollPaneTitle");
        this.jNumClustersLabel.setLabelFor(this.jNumClustersTextField);
        this.jNumClustersLabel.setText("Number of Clusters:");
        this.jNumClustersLabel.setName("jNumClustersLabel");
        this.jNumClustersTextField.setName("jNumClustersTextField");
        this.jBufferSizeLabel.setLabelFor(this.jBufferSizeTextField);
        this.jBufferSizeLabel.setText("Buffer Size:");
        this.jBufferSizeLabel.setName("jBufferSizeLabel");
        this.jBufferSizeTextField.setName("jBufferSizeTextField");
        this.jSensitivityLabel.setLabelFor(this.jSensitivityTextField);
        this.jSensitivityLabel.setText("Sensitivity:");
        this.jSensitivityLabel.setName("jSensitivityLabel");
        this.jSensitivityTextField.setName("jSensitivityTextField");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jNumClustersLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jBufferSizeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jSensitivityLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jNumClustersTextField, -1, 105, Short.MAX_VALUE).addComponent(this.jBufferSizeTextField).addComponent(this.jSensitivityTextField)).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPaneTitle, -1, 437, Short.MAX_VALUE).addContainerGap(10, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNumClustersLabel).addComponent(this.jNumClustersTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBufferSizeLabel).addComponent(this.jBufferSizeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSensitivityLabel).addComponent(this.jSensitivityTextField, -2, -1, -2)).addContainerGap(165, Short.MAX_VALUE)));
    }

    private void initUI() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        ResourceUtils.resLabel((JLabel)this.jNumClustersLabel, (Component)this.jNumClustersTextField, (String)AlgSettingsLrb.get("CLUS_NUM_CLUSTERS"));
        ResourceUtils.resLabel((JLabel)this.jBufferSizeLabel, (Component)this.jBufferSizeTextField, (String)AlgSettingsLrb.get("OCLT_MAX_BUFFER"));
        ResourceUtils.resLabel((JLabel)this.jSensitivityLabel, (Component)this.jSensitivityTextField, (String)AlgSettingsLrb.get("OCLT_SENSITIVITY"));
        this.jNumClustersTextField.setToolTipText(AlgSettingsLrb.get("CLUS_NUM_CLUSTERS_TOOLTIP"));
        this.setDataType(this.jNumClustersTextField, Integer.class);
        this.setSigned(this.jNumClustersTextField, false);
        this.setLocale(this.jNumClustersTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("CLUS_NUM_CLUSTERS");
        commonSettingDataObject.setBackupValue("CLUS_NUM_CLUSTERS", bigDecimal);
        this.setNumber(this.jNumClustersTextField, bigDecimal);
        this.jBufferSizeTextField.setToolTipText(AlgSettingsLrb.get("OCLT_MAX_BUFFER_TIP"));
        this.setDataType(this.jBufferSizeTextField, Integer.class);
        this.setSigned(this.jBufferSizeTextField, false);
        this.setLocale(this.jBufferSizeTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal2 = commonSettingDataObject.getModelSettingNumValue("OCLT_MAX_BUFFER");
        commonSettingDataObject.setBackupValue("OCLT_MAX_BUFFER", bigDecimal2);
        this.setNumber(this.jBufferSizeTextField, bigDecimal2);
        this.jSensitivityTextField.setToolTipText(AlgSettingsLrb.get("OCLT_SENSITIVITY_TIP"));
        this.setDataType(this.jSensitivityTextField, Double.class);
        ((NumberTextField)this.jSensitivityTextField).setDecimal(true, 4);
        this.setSigned(this.jSensitivityTextField, false);
        this.setLocale(this.jSensitivityTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal3 = commonSettingDataObject.getModelSettingNumValue("OCLT_SENSITIVITY");
        commonSettingDataObject.setBackupValue("OCLT_SENSITIVITY", bigDecimal3);
        this.setNumber(this.jSensitivityTextField, bigDecimal3);
    }

    @Override
    public void processInput() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        Number number = this.getNumber(this.jNumClustersTextField);
        if (null == number || 1 > number.intValue()) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("CLUS_NUM_CLUSTERS_INVALID"));
            return;
        }
        this.setObjectValue("CLUS_NUM_CLUSTERS", number);
        number = this.getNumber(this.jBufferSizeTextField);
        if (null == number || 0 >= number.intValue()) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("OCLT_MAX_BUFFER_INVALID"));
            return;
        }
        this.setObjectValue("OCLT_MAX_BUFFER", number);
        number = this.getNumber(this.jSensitivityTextField);
        if (null == number || !(0.0 <= number.doubleValue()) || !(number.doubleValue() <= 1.0)) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("OCLT_SENSITIVITY_INVALID"));
            return;
        }
        this.setObjectValue("OCLT_SENSITIVITY", number);
    }
}

