/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelEMBuildSettingsPanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class ModelEMBuildDataPrepAnalysisPanel
extends DialogDisplayer<AbstractNode> {
    private HashMap<String, Object> _cacheSettings;
    private static final String SYSTEM_DETERMINED = AlgSettingsLrb.get("SYSTEM_DETERMINED");
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JComboBox jIncludeUncorrelated2DAttributesComboBox;
    private JLabel jIncludeUncorrelated2DAttributesLabel;
    private JLabel jMaxNumOfCorrelated2DAttributesLabel;
    private JTextField jMaxNumOfCorrelated2DAttributesTextField;
    private JLabel jNumOfProjectionsPerNestedColumnLabel;
    private JTextField jNumOfProjectionsPerNestedColumnTextField;
    private JRadioButton jNumQuantileBinsSystemDeterminedButton;
    private JRadioButton jNumQuantileBinsUserSpecifiedButton;
    private JTextField jNumQuantileBinsUserSpecifiedTextField;
    private JLabel jNumberOfEquiwidthBinsLabel;
    private JTextField jNumberOfEquiwidthBinsTextField;
    private JTextField jNumberOfEquiwidthBinsUserSpecifiedTextField;
    private JLabel jNumberOfQuantileBinsLabel;
    private JLabel jNumberOfTopNBinsLabel;
    private JRadioButton jNumberOfTopNBinsSystemDeterminedButton;
    private JRadioButton jNumberOfTopNBinsUserSpecifiedButton;

    public ModelEMBuildDataPrepAnalysisPanel(ModelEMBuildSettingsPanel modelEMBuildSettingsPanel) {
        this._cacheSettings = modelEMBuildSettingsPanel.getCacheSettings();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jMaxNumOfCorrelated2DAttributesLabel, (Component)this.jMaxNumOfCorrelated2DAttributesTextField, (String)AlgSettingsLrb.get("EMCS_MAX_NUM_ATTR_2D"));
        ResourceUtils.resLabel((JLabel)this.jNumOfProjectionsPerNestedColumnLabel, (Component)this.jNumOfProjectionsPerNestedColumnTextField, (String)AlgSettingsLrb.get("EMCS_NUM_PROJECTIONS"));
        ResourceUtils.resLabel((JLabel)this.jNumberOfQuantileBinsLabel, null, (String)AlgSettingsLrb.get("EMCS_NUM_QUANTILE_BINS"));
        ResourceUtils.resButton((AbstractButton)this.jNumQuantileBinsSystemDeterminedButton, (String)AlgSettingsLrb.get("EMCS_SYSTEM_DETERMINED"));
        ResourceUtils.resButton((AbstractButton)this.jNumQuantileBinsUserSpecifiedButton, (String)AlgSettingsLrb.get("EMCS_USER_SPECIFIED"));
        ResourceUtils.resLabel((JLabel)this.jNumberOfTopNBinsLabel, null, (String)AlgSettingsLrb.get("EMCS_NUM_TOPN_BINS"));
        ResourceUtils.resButton((AbstractButton)this.jNumberOfTopNBinsSystemDeterminedButton, (String)AlgSettingsLrb.get("EMCS_SYSTEM_DETERMINED"));
        ResourceUtils.resButton((AbstractButton)this.jNumberOfTopNBinsUserSpecifiedButton, (String)AlgSettingsLrb.get("EMCS_USER_SPECIFIED"));
        ResourceUtils.resLabel((JLabel)this.jNumberOfEquiwidthBinsLabel, (Component)this.jNumberOfEquiwidthBinsTextField, (String)AlgSettingsLrb.get("EMCS_NUM_EQUIWIDTH_BINS"));
        ResourceUtils.resLabel((JLabel)this.jIncludeUncorrelated2DAttributesLabel, (Component)this.jIncludeUncorrelated2DAttributesComboBox, (String)AlgSettingsLrb.get("EMCS_ATTRIBUTE_FILTER"));
    }

    @Override
    public void initUI() {
        this.jMaxNumOfCorrelated2DAttributesTextField.setToolTipText(AlgSettingsLrb.get("EMCS_MAX_NUM_ATTR_2D_TOOLTIP"));
        ((NumberTextField)this.jMaxNumOfCorrelated2DAttributesTextField).setDataType(Integer.class);
        ((NumberTextField)this.jMaxNumOfCorrelated2DAttributesTextField).setSigned(true);
        this.jMaxNumOfCorrelated2DAttributesTextField.setLocale(Locale.getDefault());
        Number number = (Number)this._cacheSettings.get("EMCS_MAX_NUM_ATTR_2D");
        ((NumberTextField)this.jMaxNumOfCorrelated2DAttributesTextField).setNumber(number);
        this.jNumOfProjectionsPerNestedColumnTextField.setToolTipText(AlgSettingsLrb.get("EMCS_MAX_NUM_ATTR_2D_TOOLTIP"));
        ((NumberTextField)this.jNumOfProjectionsPerNestedColumnTextField).setDataType(Integer.class);
        ((NumberTextField)this.jNumOfProjectionsPerNestedColumnTextField).setSigned(true);
        this.jNumOfProjectionsPerNestedColumnTextField.setLocale(Locale.getDefault());
        number = (Number)this._cacheSettings.get("EMCS_NUM_PROJECTIONS");
        ((NumberTextField)this.jNumOfProjectionsPerNestedColumnTextField).setNumber(number);
        this.jNumQuantileBinsUserSpecifiedTextField.setToolTipText(AlgSettingsLrb.get("EMCS_NUM_QUANTILE_BINS_TOOLTIP"));
        ((NumberTextField)this.jNumQuantileBinsUserSpecifiedTextField).setDataType(Integer.class);
        ((NumberTextField)this.jNumQuantileBinsUserSpecifiedTextField).setSigned(true);
        this.jNumQuantileBinsUserSpecifiedTextField.setLocale(Locale.getDefault());
        number = (Number)this._cacheSettings.get("EMCS_NUM_QUANTILE_BINS");
        this.jNumQuantileBinsSystemDeterminedButton.setEnabled(true);
        this.jNumQuantileBinsUserSpecifiedButton.setEnabled(true);
        if (number != null) {
            this.jNumQuantileBinsUserSpecifiedButton.setSelected(true);
            ((NumberTextField)this.jNumQuantileBinsUserSpecifiedTextField).setNumber(number);
        } else {
            this.jNumQuantileBinsSystemDeterminedButton.setSelected(true);
        }
        this.jNumberOfEquiwidthBinsUserSpecifiedTextField.setToolTipText(AlgSettingsLrb.get("EMCS_NUM_TOPN_BINS_TOOLTIP"));
        ((NumberTextField)this.jNumberOfEquiwidthBinsUserSpecifiedTextField).setDataType(Integer.class);
        ((NumberTextField)this.jNumberOfEquiwidthBinsUserSpecifiedTextField).setSigned(true);
        this.jNumberOfEquiwidthBinsUserSpecifiedTextField.setLocale(Locale.getDefault());
        number = (Number)this._cacheSettings.get("EMCS_NUM_TOPN_BINS");
        this.jNumberOfTopNBinsSystemDeterminedButton.setEnabled(true);
        this.jNumberOfTopNBinsUserSpecifiedButton.setEnabled(true);
        if (number != null) {
            this.jNumberOfTopNBinsUserSpecifiedButton.setSelected(true);
            ((NumberTextField)this.jNumberOfEquiwidthBinsUserSpecifiedTextField).setNumber(number);
        } else {
            this.jNumberOfTopNBinsSystemDeterminedButton.setSelected(true);
        }
        this.jNumberOfEquiwidthBinsTextField.setToolTipText(AlgSettingsLrb.get("EMCS_NUM_EQUIWIDTH_BINS_TOOLTIP"));
        ((NumberTextField)this.jNumberOfEquiwidthBinsTextField).setDataType(Integer.class);
        ((NumberTextField)this.jNumberOfEquiwidthBinsTextField).setSigned(true);
        this.jNumberOfEquiwidthBinsTextField.setLocale(Locale.getDefault());
        number = (Number)this._cacheSettings.get("EMCS_NUM_EQUIWIDTH_BINS");
        ((NumberTextField)this.jNumberOfEquiwidthBinsTextField).setNumber(number);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{SYSTEM_DETERMINED, ServerConstants.ClusteringSetings.toHuman("EMCS_ATTR_FILTER_ENABLE"), ServerConstants.ClusteringSetings.toHuman("EMCS_ATTR_FILTER_DISABLE")});
        this.jIncludeUncorrelated2DAttributesComboBox.setModel(defaultComboBoxModel);
        String string = (String)this._cacheSettings.get("EMCS_ATTRIBUTE_FILTER");
        if (string == null || string.isEmpty()) {
            this.jIncludeUncorrelated2DAttributesComboBox.setSelectedItem(SYSTEM_DETERMINED);
        } else {
            this.jIncludeUncorrelated2DAttributesComboBox.setSelectedItem(ServerConstants.ClusteringSetings.toHuman(string));
        }
        this.jIncludeUncorrelated2DAttributesLabel.setLabelFor(this.jIncludeUncorrelated2DAttributesComboBox);
        this.enableControls();
    }

    private void enableControls() {
        this.jNumQuantileBinsUserSpecifiedTextField.setEnabled(this.jNumQuantileBinsUserSpecifiedButton.isSelected());
        this.jNumberOfEquiwidthBinsUserSpecifiedTextField.setEnabled(this.jNumberOfTopNBinsUserSpecifiedButton.isSelected());
    }

    @Override
    public boolean doWork() {
        Number number = ((NumberTextField)this.jMaxNumOfCorrelated2DAttributesTextField).getNumber();
        if (number == null || 1 > number.intValue()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)AlgSettingsLrb.get("EMCS_MAX_NUM_ATTR_2D_INVALID"), (String)AlgSettingsLrb.get("EMCS_DATA_PREP_ANALYSIS_OPTION_DIALOG_TITLE"), null);
            return false;
        }
        this._cacheSettings.put("EMCS_MAX_NUM_ATTR_2D", number);
        number = ((NumberTextField)this.jNumOfProjectionsPerNestedColumnTextField).getNumber();
        if (number == null || 1 >= number.intValue()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)AlgSettingsLrb.get("EMCS_NUM_PROJECTIONS_INVALID"), (String)AlgSettingsLrb.get("EMCS_DATA_PREP_ANALYSIS_OPTION_DIALOG_TITLE"), null);
            return false;
        }
        this._cacheSettings.put("EMCS_NUM_PROJECTIONS", number);
        if (this.jNumQuantileBinsUserSpecifiedButton.isSelected()) {
            number = ((NumberTextField)this.jNumQuantileBinsUserSpecifiedTextField).getNumber();
            if (number == null || 1 >= number.intValue() || number.intValue() > 255) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)AlgSettingsLrb.get("EMCS_NUM_QUANTILE_BINS_INVALID"), (String)AlgSettingsLrb.get("EMCS_DATA_PREP_ANALYSIS_OPTION_DIALOG_TITLE"), null);
                return false;
            }
            this._cacheSettings.put("EMCS_NUM_QUANTILE_BINS", number);
        } else {
            this._cacheSettings.put("EMCS_NUM_QUANTILE_BINS", null);
        }
        if (this.jNumberOfTopNBinsUserSpecifiedButton.isSelected()) {
            number = ((NumberTextField)this.jNumberOfEquiwidthBinsUserSpecifiedTextField).getNumber();
            if (number == null || 1 >= number.intValue() || number.intValue() > 255) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)AlgSettingsLrb.get("EMCS_NUM_TOPN_BINS_INVALID"), (String)AlgSettingsLrb.get("EMCS_DATA_PREP_ANALYSIS_OPTION_DIALOG_TITLE"), null);
                return false;
            }
            this._cacheSettings.put("EMCS_NUM_TOPN_BINS", number);
        } else {
            this._cacheSettings.put("EMCS_NUM_TOPN_BINS", null);
        }
        number = ((NumberTextField)this.jNumberOfEquiwidthBinsTextField).getNumber();
        if (number == null || 1 >= number.intValue() || number.intValue() > 255) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)AlgSettingsLrb.get("EMCS_NUM_EQUIWIDTH_BINS_INVALID"), (String)AlgSettingsLrb.get("EMCS_DATA_PREP_ANALYSIS_OPTION_DIALOG_TITLE"), null);
            return false;
        }
        this._cacheSettings.put("EMCS_NUM_EQUIWIDTH_BINS", number);
        String string = (String)this.jIncludeUncorrelated2DAttributesComboBox.getSelectedItem();
        this._cacheSettings.put("EMCS_ATTRIBUTE_FILTER", SYSTEM_DETERMINED.equals(string) ? null : ServerConstants.ClusteringSetings.toAlgorithm(string));
        return true;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jMaxNumOfCorrelated2DAttributesLabel = new JLabel();
        this.jMaxNumOfCorrelated2DAttributesTextField = new NumberTextField();
        this.jNumOfProjectionsPerNestedColumnLabel = new JLabel();
        this.jNumOfProjectionsPerNestedColumnTextField = new NumberTextField();
        this.jNumberOfQuantileBinsLabel = new JLabel();
        this.jNumQuantileBinsSystemDeterminedButton = new JRadioButton();
        this.jNumQuantileBinsUserSpecifiedButton = new JRadioButton();
        this.jNumQuantileBinsUserSpecifiedTextField = new NumberTextField();
        this.jNumberOfTopNBinsLabel = new JLabel();
        this.jNumberOfTopNBinsSystemDeterminedButton = new JRadioButton();
        this.jNumberOfTopNBinsUserSpecifiedButton = new JRadioButton();
        this.jNumberOfEquiwidthBinsUserSpecifiedTextField = new NumberTextField();
        this.jNumberOfEquiwidthBinsLabel = new JLabel();
        this.jNumberOfEquiwidthBinsTextField = new NumberTextField();
        this.jIncludeUncorrelated2DAttributesLabel = new JLabel();
        this.jIncludeUncorrelated2DAttributesComboBox = new JComboBox();
        this.jMaxNumOfCorrelated2DAttributesLabel.setText("Max Number of Correlated 2D Attributes:");
        this.jNumOfProjectionsPerNestedColumnLabel.setText("Number of Projections per Nested Column:");
        this.jNumberOfQuantileBinsLabel.setText("Number of Quantile Bins (Numerical Columns)");
        this.buttonGroup1.add(this.jNumQuantileBinsSystemDeterminedButton);
        this.jNumQuantileBinsSystemDeterminedButton.setText("System determined");
        this.jNumQuantileBinsSystemDeterminedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildDataPrepAnalysisPanel.this.jNumQuantileBinsSystemDeterminedButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.jNumQuantileBinsUserSpecifiedButton);
        this.jNumQuantileBinsUserSpecifiedButton.setText("User specified:");
        this.jNumQuantileBinsUserSpecifiedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildDataPrepAnalysisPanel.this.jNumQuantileBinsUserSpecifiedButtonActionPerformed(actionEvent);
            }
        });
        this.jNumberOfTopNBinsLabel.setText("Number of Top-N Bins (Categorical Columns)");
        this.buttonGroup2.add(this.jNumberOfTopNBinsSystemDeterminedButton);
        this.jNumberOfTopNBinsSystemDeterminedButton.setText("System determined");
        this.jNumberOfTopNBinsSystemDeterminedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildDataPrepAnalysisPanel.this.jNumberOfTopNBinsSystemDeterminedButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup2.add(this.jNumberOfTopNBinsUserSpecifiedButton);
        this.jNumberOfTopNBinsUserSpecifiedButton.setText("User specified:");
        this.jNumberOfTopNBinsUserSpecifiedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildDataPrepAnalysisPanel.this.jNumberOfTopNBinsUserSpecifiedButtonActionPerformed(actionEvent);
            }
        });
        this.jNumberOfEquiwidthBinsLabel.setText("Number of Equi-width Bins (Numerical Columns):");
        this.jNumberOfEquiwidthBinsTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildDataPrepAnalysisPanel.this.jNumberOfEquiwidthBinsTextFieldActionPerformed(actionEvent);
            }
        });
        this.jIncludeUncorrelated2DAttributesLabel.setText("Include uncorrelated 2D Attributes:");
        this.jIncludeUncorrelated2DAttributesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"<System Determined>"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNumberOfQuantileBinsLabel).addComponent(this.jNumberOfTopNBinsLabel).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNumberOfEquiwidthBinsLabel).addComponent(this.jMaxNumOfCorrelated2DAttributesLabel).addComponent(this.jNumOfProjectionsPerNestedColumnLabel).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNumQuantileBinsUserSpecifiedButton).addComponent(this.jNumQuantileBinsSystemDeterminedButton))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNumberOfTopNBinsUserSpecifiedButton).addComponent(this.jNumberOfTopNBinsSystemDeterminedButton))).addComponent(this.jIncludeUncorrelated2DAttributesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jNumberOfEquiwidthBinsUserSpecifiedTextField).addComponent(this.jNumQuantileBinsUserSpecifiedTextField).addComponent(this.jNumOfProjectionsPerNestedColumnTextField).addComponent(this.jMaxNumOfCorrelated2DAttributesTextField).addComponent(this.jNumberOfEquiwidthBinsTextField).addComponent(this.jIncludeUncorrelated2DAttributesComboBox, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumOfCorrelated2DAttributesLabel).addComponent(this.jMaxNumOfCorrelated2DAttributesTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNumOfProjectionsPerNestedColumnLabel).addComponent(this.jNumOfProjectionsPerNestedColumnTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNumberOfQuantileBinsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNumQuantileBinsSystemDeterminedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNumQuantileBinsUserSpecifiedButton).addComponent(this.jNumQuantileBinsUserSpecifiedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jNumberOfTopNBinsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNumberOfTopNBinsSystemDeterminedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNumberOfTopNBinsUserSpecifiedButton)).addComponent(this.jNumberOfEquiwidthBinsUserSpecifiedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNumberOfEquiwidthBinsLabel).addComponent(this.jNumberOfEquiwidthBinsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jIncludeUncorrelated2DAttributesLabel).addComponent(this.jIncludeUncorrelated2DAttributesComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jNumQuantileBinsSystemDeterminedButtonActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jNumQuantileBinsUserSpecifiedButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jNumQuantileBinsUserSpecifiedButton.isSelected();
        this.jNumQuantileBinsUserSpecifiedTextField.setEnabled(bl);
        this.enableControls();
    }

    private void jNumberOfTopNBinsSystemDeterminedButtonActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jNumberOfEquiwidthBinsTextFieldActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jNumberOfTopNBinsUserSpecifiedButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jNumberOfTopNBinsUserSpecifiedButton.isSelected();
        this.jNumberOfEquiwidthBinsUserSpecifiedTextField.setEnabled(bl);
        this.enableControls();
    }

    @Override
    protected String getDialogTitle() {
        return AlgSettingsLrb.get("EMCS_DATA_PREP_ANALYSIS_OPTION_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return null;
    }
}

