/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class ApplyPredictionDetailsPanel
extends DialogDisplayer<AbstractNode> {
    private ApplyNode.DefaultPredictionDetails _predictionDetails;
    private JCheckBox jMaxLengthCheckBox;
    private NumberTextField jMaxLengthTextField;
    private JLabel jSortByWeightLabel;
    private JComboBox<String> jSortComboBox;
    private JLabel jjMaxLengthLabel;

    public ApplyPredictionDetailsPanel(Context context, ApplyNode.DefaultPredictionDetails defaultPredictionDetails) {
        super(context, null);
        this._predictionDetails = defaultPredictionDetails;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jSortByWeightLabel, this.jSortComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_SORT"));
        ResourceUtils.resButton((AbstractButton)this.jMaxLengthCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_MAX_ATTRS"));
        ResourceUtils.resLabel((JLabel)this.jjMaxLengthLabel, (Component)this.jMaxLengthTextField, (String)DialogsLrb.get("APPLY_OUTPUT_MAX_ATTRS_VALUE"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        Vector<String> vector = this._predictionDetails.getSortValues();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(vector);
        this.jSortComboBox.setModel(defaultComboBoxModel);
        String string = this._predictionDetails.getSort();
        if (string == null) {
            this.jSortComboBox.setSelectedItem(ServerConstants.ApplyPredictionDetailsSort.toHuman("ABS"));
        } else {
            this.jSortComboBox.setSelectedItem(string);
        }
        BigInteger bigInteger = this._predictionDetails.getTopN();
        this.jMaxLengthCheckBox.setSelected(bigInteger != null && bigInteger.intValue() > 0);
        this.jMaxLengthTextField.setNumber((Number)bigInteger);
        this.jMaxLengthTextField.setDataType(Integer.class);
        this.jMaxLengthTextField.setSigned(false);
        this.jMaxLengthTextField.setNumber((Number)bigInteger);
        this.jMaxLengthTextField.setEnabled(this.jMaxLengthCheckBox.isSelected());
        this.jMaxLengthTextField.setToolTipText(DialogsLrb.get("APPLY_OUTPUT_MAX_ATTRS_TIP"));
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        try {
            String string = (String)this.jSortComboBox.getSelectedItem();
            this._predictionDetails.setSort(string);
            Number number = null;
            boolean bl2 = this.jMaxLengthCheckBox.isSelected();
            if (bl2) {
                number = this.jMaxLengthTextField.getNumber();
            }
            this._predictionDetails.setUseTopN(bl2);
            this._predictionDetails.setTopN(bl2 && number != null ? BigInteger.valueOf(number.longValue()) : null);
            this._predictionDetails.validate();
        }
        catch (ValidationException validationException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    private void initComponents() {
        this.jSortByWeightLabel = new JLabel();
        this.jSortComboBox = new JComboBox();
        this.jMaxLengthCheckBox = new JCheckBox();
        this.jjMaxLengthLabel = new JLabel();
        this.jMaxLengthTextField = new NumberTextField();
        this.jSortByWeightLabel.setLabelFor(this.jSortComboBox);
        this.jSortByWeightLabel.setText("Sort by Weight:");
        this.jMaxLengthCheckBox.setText("Maximum Length of Ranked Attribute List:");
        this.jMaxLengthCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyPredictionDetailsPanel.this.jMaxLengthCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jjMaxLengthLabel.setLabelFor((Component)this.jMaxLengthTextField);
        this.jjMaxLengthLabel.setText("Length:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSortByWeightLabel, -2, 82, -2).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jjMaxLengthLabel, -2, 60, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSortComboBox, -2, 148, -2).addComponent((Component)this.jMaxLengthTextField, -2, 139, -2))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jMaxLengthCheckBox))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(0, new Component[]{this.jMaxLengthTextField, this.jSortComboBox});
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSortByWeightLabel).addComponent(this.jSortComboBox, -2, -1, -2)).addGap(7, 7, 7).addComponent(this.jMaxLengthCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jMaxLengthTextField, -2, -1, -2).addComponent(this.jjMaxLengthLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jMaxLengthCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.jMaxLengthTextField.setEnabled(this.jMaxLengthCheckBox.isSelected());
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("APPLY_PREDICTION_DETAILS_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "apply_prediction_details";
    }
}

