/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.apply.SuppAttrsPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.inspect.ApplyNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowApplyNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ApplyDataPanel
extends AbstractPanel<ApplyNode> {
    private WorkflowApplyNodePropertyProxyModel _propertyModel;
    private AttrsTableModel _models;
    private SupplementalAttributesType _supplementalAttributes;
    private boolean _dirty;
    boolean allAutomatic = false;
    private JToggleButton jToggleAutomatic;
    private JButton _addBtn;
    private JButton _removeBtn;
    private ComponentWithTitlebar<JComponent> componentWithTitlebar;
    private JCheckBox jAutoSettingsCheckBox;
    private DataMinerTablePanel tablePanel;

    public ApplyDataPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for apply node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.addAncestorListener(new PIAncestorListener(this));
        this.init((ApplyNode)this._data, propertyModel);
    }

    public ApplyDataPanel(Context context, ApplyNode applyNode, PropertyModel propertyModel) {
        super(context, applyNode);
        assert (context != null) : "Context must not be null.";
        assert (applyNode != null) : "Apply node must not be null.";
        this.init(applyNode, propertyModel);
    }

    private void init(ApplyNode applyNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
        this._supplementalAttributes = (SupplementalAttributesType)MetaDataHelper.copyMetadataObject(applyNodeType.getSupplementalAttributes());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowApplyNodePropertyProxyModel workflowApplyNodePropertyProxyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ApplyNode applyNode = (ApplyNode)workflowNodeInspectorElement.getNode();
        if (applyNode == null) {
            return;
        }
        this._propertyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = applyNode;
        this._dirty = false;
        ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
        this._supplementalAttributes = (SupplementalAttributesType)MetaDataHelper.copyMetadataObject(applyNodeType.getSupplementalAttributes());
        if (this._supplementalAttributes.getAutoSpec() == AutoSpecType.YES) {
            this.replaceSupplementalAtts();
        }
        this.reload();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowApplyNodePropertyProxyModel)) {
            return null;
        }
        WorkflowApplyNodePropertyProxyModel workflowApplyNodePropertyProxyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private ApplyNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowApplyNodePropertyProxyModel)) {
            return null;
        }
        WorkflowApplyNodePropertyProxyModel workflowApplyNodePropertyProxyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ApplyNodeType) {
            return (ApplyNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void updateNode() {
        if (this._dirty && this._propertyModel != null) {
            ApplyNode applyNode = (ApplyNode)this.getData();
            ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
            ComplexProperty complexProperty = new ComplexProperty("applySupplementalColumns", this._supplementalAttributes);
            SupplementalAttributesType supplementalAttributesType = (SupplementalAttributesType)MetaDataHelper.copyMetadataObject(applyNodeType.getSupplementalAttributes());
            complexProperty.setOldData(supplementalAttributesType);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ApplyNodePropertyModel.RowIndex.APPLY_SUPPLEMENTAL_COLUMNS), null, complexProperty, null, null));
            this._propertyModel.setValueAt(PropertyLrb.get("PI_APPLY_GROUP_SUPPLEMENTAL_COLUMNS"), applyNode, arrayList);
        }
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("APPLY_AUTO_SETTING"), this.jAutoSettingsCheckBox);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        final ApplyDataPanel applyDataPanel = this;
        this.jAutoSettingsCheckBox.setVisible(false);
        this.allAutomatic = "Yes".equals(this._supplementalAttributes.getAutoSpec().value());
        this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
        this._removeBtn.setEnabled(false);
        this.jToggleAutomatic = new JToggleButton();
        this.tablePanel.addControlBarComponents(this._addBtn, this._removeBtn, this.jToggleAutomatic);
        this.jToggleAutomatic.setIcon(DataMinerIcons.get(Icons.AUTO_USAGE));
        if (this.allAutomatic) {
            this.jToggleAutomatic.setToolTipText(DynamicNodesLrb.get("SUPPLEMENTAL_SETTINGS_SET_TO_AUTO"));
        } else {
            this.jToggleAutomatic.setToolTipText(DynamicNodesLrb.get("SUPPLEMENTAL_SETTINGS_SET_TO_MANUAL"));
        }
        this.jToggleAutomatic.setText(DialogsLrb.get("PREF_AUTOMATE_MODEL_SETTING_ON"));
        this.jToggleAutomatic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                boolean bl2 = bl = !ApplyDataPanel.this.allAutomatic && jToggleButton.isSelected();
                if (bl && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DynamicNodesLrb.get("SUPPLEMENTAL_SETTINGS_WARNING"), (String)DynamicNodesLrb.get("SUPPLEMENTAL_SETTINGS_WARNING_TITLE"), null)) {
                    jToggleButton.doClick();
                    return;
                }
                ApplyDataPanel.this.allAutomatic = jToggleButton.isSelected();
                if (bl) {
                    ApplyDataPanel.this._supplementalAttributes.setAutoSpec(AutoSpecType.fromValue((String)"Yes"));
                    ApplyDataPanel.this.replaceSupplementalAtts();
                    ApplyDataPanel.this._models = new AttrsTableModel(ApplyDataPanel.this._context, applyDataPanel, ApplyDataPanel.this._supplementalAttributes.getAttribute());
                    ApplyDataPanel.this.tablePanel.getTable().setModel((TableModel)((Object)ApplyDataPanel.this._models));
                    ApplyDataPanel.this._dirty = true;
                    if (ApplyDataPanel.this._propertyModel != null) {
                        ApplyDataPanel.this.updateNode();
                    }
                } else {
                    ApplyDataPanel.this._supplementalAttributes.setAutoSpec(AutoSpecType.fromValue((String)"No"));
                }
                if (ApplyDataPanel.this.allAutomatic) {
                    ApplyDataPanel.this.jToggleAutomatic.setToolTipText(DynamicNodesLrb.get("SUPPLEMENTAL_SETTINGS_SET_TO_AUTO"));
                } else {
                    ApplyDataPanel.this.jToggleAutomatic.setToolTipText(DynamicNodesLrb.get("SUPPLEMENTAL_SETTINGS_SET_TO_MANUAL"));
                }
                ApplyDataPanel.this.enableControls();
            }
        });
        this.tablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("APPLY_DATA_TABLE_TITLE"), 0, true);
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyDataPanel.this.processAdd();
            }
        });
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_DATA_REMOVE_ATTRIBUTE"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                    return;
                }
                ApplyDataPanel.this.processRemove();
            }
        });
        this.tablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ApplyDataPanel.this.handleModelSelectionChanged();
            }
        });
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                AttributeType attributeType = (AttributeType)ApplyDataPanel.this._supplementalAttributes.getAttribute().get(n);
                ApplyNodeType applyNodeType = (ApplyNodeType)((ApplyNode)ApplyDataPanel.this._data).getData();
                if (applyNodeType.getCaseAttributes() != null && !applyNodeType.getCaseAttributes().getAttribute().isEmpty() && ((AttributeType)applyNodeType.getCaseAttributes().getAttribute().get(0)).getName().equals(attributeType.getName())) {
                    return OracleIcons.getIcon((String)"key.png");
                }
                AttributeStatus attributeStatus = attributeType.getStatus();
                return attributeStatus == AttributeStatus.VALID ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png");
            }
        });
        TableColumn tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
        tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(1);
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor(this._context);
        tableColumn.setCellEditor(dBObjectNameEditor);
        this.enableControls();
    }

    public void reload() {
        this.jAutoSettingsCheckBox.setVisible(false);
        this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
        this.tablePanel.getTable().setModel((TableModel)((Object)this._models));
        this.enableControls();
    }

    public void replaceSupplementalAtts() {
        this._supplementalAttributes.getAttribute().clear();
        ApplyNodeType applyNodeType = (ApplyNodeType)((ApplyNode)this._data).getData();
        CaseAttributes caseAttributes = applyNodeType.getCaseAttributes();
        if (caseAttributes != null && caseAttributes.getAttribute() != null && caseAttributes.getAttribute().size() > 0 && this._supplementalAttributes.getAttribute() != null && !this._supplementalAttributes.getAttribute().contains(caseAttributes.getAttribute().get(0))) {
            this._supplementalAttributes.getAttribute().add(caseAttributes.getAttribute().get(0));
        }
    }

    private void enableControls() {
        ApplyNode applyNode = (ApplyNode)this.getData();
        DataProvider dataProvider = (DataProvider)((Object)applyNode.findApplyDataNode(applyNode.getModel()));
        this.allAutomatic = "Yes".equals(this._supplementalAttributes.getAutoSpec().value());
        this.jToggleAutomatic.setSelected(this.allAutomatic);
        this.jAutoSettingsCheckBox.setSelected(this.allAutomatic);
        this.jAutoSettingsCheckBox.setEnabled(this.isWritable());
        int n = this.tablePanel.getTable().getSelectedRowCount();
        this._addBtn.setEnabled(this.isWritable() && !this.allAutomatic && dataProvider != null);
        this._removeBtn.setEnabled(this.isWritable() && !this.allAutomatic && n > 0);
    }

    private void processAdd() {
        ApplyNode applyNode = (ApplyNode)this.getData();
        DataProvider dataProvider = (DataProvider)((Object)applyNode.findApplyDataNode(applyNode.getModel()));
        SuppAttrsPanel suppAttrsPanel = new SuppAttrsPanel(this.getContext(), this, dataProvider, this._supplementalAttributes);
        if (suppAttrsPanel.showAsDialog(this) && suppAttrsPanel.isDirty()) {
            List<AttributeType> list = suppAttrsPanel.getSelectedAttrsCache();
            this._supplementalAttributes.getAttribute().clear();
            this._supplementalAttributes.getAttribute().addAll(list);
            this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
            this.tablePanel.getTable().setModel((TableModel)((Object)this._models));
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
    }

    private void processRemove() {
        int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            AttributeType attributeType = (AttributeType)this._supplementalAttributes.getAttribute().get(n);
            arrayList.add(attributeType);
        }
        for (AttributeType attributeType : arrayList) {
            this._supplementalAttributes.getAttribute().remove(attributeType);
        }
        this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
        this.tablePanel.getTable().setModel((TableModel)((Object)this._models));
        this._dirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        }
    }

    private void processRemoveAll() {
        this._supplementalAttributes.getAttribute().clear();
        this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
        this.tablePanel.getTable().setModel((TableModel)((Object)this._models));
        this._dirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        }
    }

    private void handleModelSelectionChanged() {
        this.enableControls();
    }

    private void initComponents() {
        this.componentWithTitlebar = new ComponentWithTitlebar();
        this._removeBtn = new JButton();
        this._addBtn = new JButton();
        this.jAutoSettingsCheckBox = new JCheckBox();
        this.tablePanel = new DataMinerTablePanel();
        this.componentWithTitlebar.setAutoscrolls(true);
        this.componentWithTitlebar.setName("componentWithTitlebar");
        this._removeBtn.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(DialogsLrb.get("APPLY_DATA_DELETE_OUTPUT_COLUMNS"));
        this._removeBtn.setName("_removeBtn");
        this._addBtn.setIcon(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(DialogsLrb.get("APPLY_DATA_EDIT_OUTPUT_COLUMNS"));
        this._addBtn.setName("_addBtn");
        this.setPreferredSize(new Dimension(950, 400));
        this.jAutoSettingsCheckBox.setText("Automatic Settings");
        this.jAutoSettingsCheckBox.setName("jAutoSettingsCheckBox");
        this.jAutoSettingsCheckBox.setOpaque(false);
        this.jAutoSettingsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyDataPanel.this.jAutoSettingsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.tablePanel.setName("tablePanel");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablePanel, -1, 930, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jAutoSettingsCheckBox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jAutoSettingsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 357, Short.MAX_VALUE).addContainerGap()));
    }

    private void jAutoSettingsCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jAutoSettingsCheckBox.isSelected();
        if (bl) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_DATA_AUTO_SETTING_ON"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                this.jAutoSettingsCheckBox.setSelected(false);
                return;
            }
            if (this._propertyModel != null) {
                this._supplementalAttributes.setAutoSpec(AutoSpecType.fromValue((String)"Yes"));
                this._supplementalAttributes.getAttribute().clear();
                this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
                this.tablePanel.getTable().setModel((TableModel)((Object)this._models));
                ApplyNode.addSupplAttrs(this._supplementalAttributes, (ApplyNode)this.getData());
                this._dirty = true;
                this.updateNode();
            } else {
                this.processRemoveAll();
                this._supplementalAttributes.setAutoSpec(AutoSpecType.fromValue((String)"Yes"));
                ApplyNode.addSupplAttrs(this._supplementalAttributes, (ApplyNode)this.getData());
                this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
                this.tablePanel.getTable().setModel((TableModel)((Object)this._models));
            }
        } else {
            this._supplementalAttributes.setAutoSpec(AutoSpecType.fromValue((String)"No"));
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
        this.enableControls();
    }

    public SupplementalAttributesType getSupplementalAttributes() {
        return this._supplementalAttributes;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    private static class AttrsTableModel
    extends GenericBaseTableModel {
        private static final String[] _columnNames = new String[]{DialogsLrb.get("APPLY_MODEL_COLUMN"), DialogsLrb.get("APPLY_DATA_ALIAS"), DialogsLrb.get("APPLY_DATA_TYPE")};
        private static final int MODEL_COLUMN = 0;
        private static final int DATA_ALIAS = 1;
        private static final int DATA_TYPE = 2;
        private static final int COLUMN_COUNT = 3;
        private Context _context;
        private ApplyDataPanel _parent;
        private List<AttributeType> _srcData;

        public AttrsTableModel(Context context, ApplyDataPanel applyDataPanel, List<AttributeType> list) {
            this._context = context;
            this._parent = applyDataPanel;
            this._srcData = list;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                return this._parent.isWritable();
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            AttributeType attributeType = this._srcData.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = attributeType.getName();
                    break;
                }
                case 1: {
                    string = attributeType.getAlias();
                    break;
                }
                case 2: {
                    string = DatabaseMetadataUtils.getJSONDataType(attributeType.getDataType(), attributeType.getDataTypeQualifier());
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            AttributeType attributeType = this._srcData.get(n);
            String string = null;
            String string2 = attributeType.getAlias();
            if (object != null) {
                string = ((String)object).trim();
            }
            if (string2 != null && StringUtils.isDoubleQuotedString(string)) {
                string2 = StringUtils.addDoubleQuotes(string2);
            }
            if (string.length() != 0) {
                if (!StringUtils.isDoubleQuotedString(string)) {
                    string = string.toUpperCase();
                }
                if (!AttributeNameValidator.validateAttributeName(string, this._srcData, this._context, true)) {
                    return;
                }
            }
            if (string2 != null && string2.compareTo(string) == 0) {
                return;
            }
            string = StringUtils.trimDoubleQuotes(string);
            attributeType.setAlias(string);
            this._parent.setDirty(true);
            this._parent.updateNode();
        }
    }
}

