/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.wizard.WizardModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElements;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;

public class AggregationWizardModel
extends WizardModel {
    private volatile boolean _wizardIsCancelled;
    private Context _context;
    private Component _parent;
    private AbstractDataNode _parentNode;
    private AggregationNodeType _nodedata;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private List<String> selectedNumericFunctions;
    private List<String> selectedCharFunctions;
    private List<AttributeType> selectedAttrs;
    private GroupingElementType subGroupBy;

    public AggregationWizardModel(Component component, Context context, AggregationNodeType aggregationNodeType, AbstractDataNode abstractDataNode) {
        this._context = context;
        this._parent = component;
        this._nodedata = aggregationNodeType;
        this._parentNode = abstractDataNode;
        this.subGroupBy = new GroupingElementType();
        this.subGroupBy.setAttributes(new Attributes());
    }

    public void setWizardCancelled(boolean bl) {
        boolean bl2 = this._wizardIsCancelled;
        this._wizardIsCancelled = bl;
        this._changeSupport.firePropertyChange("wizardCancelled", bl2, bl);
    }

    public void close() {
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    public AggregationNodeType getNodeData() {
        return this._nodedata;
    }

    public Component getParent() {
        return this._parent;
    }

    public void validateSelectedAttributes(Vector<ValidationMessage> vector) {
    }

    public void setSelectedNumericFunctions(List<String> list) {
        this.selectedNumericFunctions = list;
    }

    public List<String> getSelectedNumericFunctions() {
        return this.selectedNumericFunctions;
    }

    public void setSelectedCharFunctions(List<String> list) {
        this.selectedCharFunctions = list;
    }

    public List<String> getSelectedCharFunctions() {
        return this.selectedCharFunctions;
    }

    public void setSelectedAttrs(List<AttributeType> list) {
        this.selectedAttrs = list;
    }

    public List<AttributeType> getSelectedAttrs() {
        return this.selectedAttrs;
    }

    public void setSubGroupBy(GroupingElementType groupingElementType) {
        this.subGroupBy = groupingElementType;
    }

    public GroupingElementType getSubGroupBy() {
        return this.subGroupBy;
    }

    public List<AggregationElementType> getNewAggregationElements() {
        ArrayList<AggregationElementType> arrayList = new ArrayList<AggregationElementType>();
        this.addAggregationElements(arrayList, this.selectedCharFunctions, "VARCHAR2");
        this.addAggregationElements(arrayList, this.selectedNumericFunctions, "NUMBER");
        return arrayList;
    }

    public List<AggregationElementType> getAggregationElements() {
        AggregationElements aggregationElements = this._nodedata.getAggregationElements();
        List list = null;
        ArrayList<AggregationElementType> arrayList = new ArrayList<AggregationElementType>();
        if (null != aggregationElements && null != (list = aggregationElements.getAggregationElement()) && !list.isEmpty()) {
            AttributeTypeHelper.copyAttributes(arrayList, list);
        }
        this.addAggregationElements(arrayList, this.selectedCharFunctions, "VARCHAR2");
        this.addAggregationElements(arrayList, this.selectedNumericFunctions, "NUMBER");
        return arrayList;
    }

    private void addAggregationElements(List<AggregationElementType> list, List<String> list2, String string) {
        if (list2 != null && !list2.isEmpty()) {
            for (String string2 : list2) {
                for (AttributeType attributeType : this.selectedAttrs) {
                    if (!attributeType.getDataType().equals(string)) continue;
                    String string3 = AttributeTypeHelper.createUniqueAggregationOutputName(attributeType.getName(), DatabaseMetadataUtils.AggregateFunctions.toAggregateName(string2), list);
                    AggregationElementType aggregationElementType = new AggregationElementType();
                    list.add(aggregationElementType);
                    GroupingElementType groupingElementType = new GroupingElementType();
                    Attributes attributes = new Attributes();
                    attributes.getAttribute().add(attributeType);
                    groupingElementType.setAttributes(attributes);
                    aggregationElementType.setSource(groupingElementType);
                    aggregationElementType.setAggregationFunction(string2);
                    aggregationElementType.setSubGroupBy(this.subGroupBy);
                    AttributeTypeHelper.setOutputAttributeType(this._context, string3, aggregationElementType);
                }
            }
        }
    }
}

