/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.codegen;

import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinition;
import oracle.dmt.dataminer.workflow.codegen.SourceDefinition;
import oracle.dmt.dataminer.workflow.model.AbstractNode;

public class SQLDefinition {
    private int _dsCount = 0;
    private int _modelCount = 0;
    private int _txtSettingCount = 0;
    private int _otherCount = 0;
    private static final String DATA_SOURCE = "DATA_SOURCE";
    private static final String MODEL = "MODEL";
    private static final String TEXT_SETTING = "TEXT_SETTING";
    private static final String OTHER = "OTHER";
    private ArrayList<ParameterizedSourceDefinition> _parmSourceDefinitions = new ArrayList();
    private StringBuffer _sql = new StringBuffer(32000);
    private static final String SQL_PLUS_COMMANDS = "SET VERIFY ON\nSET CONCAT .\nSET TERMOUT ON\n";
    private static final String DEFINE_COMMAND_HEADER = " -- From Node: \"<NODE_NAME>\"\n";
    private static final String DEFINE_COMMAND = "DEFINE <PARM_NAME> = '\"<USER_NAME>\".\"<OBJECT_NAME>\"'\n";
    private final String DEFINE_SUBSTITUTION_HEADER = "-- Subsitution Variable Definition Section: Override default object names here.\n";
    private final String SQL_PLUS_COMMANDS_HEADER = "-- SQL Plus Script Commands Section:\n";

    public SQLDefinition() {
    }

    public SQLDefinition(String string, ArrayList<ParameterizedSourceDefinition> arrayList) {
        this._sql = this._sql.append(string);
        this._parmSourceDefinitions = arrayList;
    }

    public void setSourceDefinitions(ArrayList<ParameterizedSourceDefinition> arrayList) {
        this._parmSourceDefinitions = arrayList;
    }

    public List<ParameterizedSourceDefinition> getSourceDefinitions() {
        return this._parmSourceDefinitions;
    }

    public void addSourceDefinitions(ArrayList<SourceDefinition> arrayList) {
        for (SourceDefinition sourceDefinition : arrayList) {
            this._parmSourceDefinitions.add(this.addParmName(sourceDefinition));
        }
    }

    public String replaceSourceNamesWithParms(String string, AbstractNode abstractNode) {
        for (ParameterizedSourceDefinition parameterizedSourceDefinition : this._parmSourceDefinitions) {
            if (parameterizedSourceDefinition.getNode() != abstractNode) continue;
            string = StringUtils.getReplacedString(string, this.createSearchUserAndName(parameterizedSourceDefinition), parameterizedSourceDefinition.getParmNameWithAmpersand());
            if (parameterizedSourceDefinition.getDbObjectType().compareTo(DatabaseObjectType.TABLE_OR_VIEW) != 0 && parameterizedSourceDefinition.getDbObjectType().compareTo(DatabaseObjectType.TEXT_SETTING) != 0) continue;
            string = StringUtils.getReplacedString(string, this.createSearchName(parameterizedSourceDefinition), this.createReplaceName(parameterizedSourceDefinition));
        }
        return string;
    }

    public String getParameterNameForObject(AbstractNode abstractNode, String string, DatabaseObjectType databaseObjectType, boolean bl) {
        String string2 = null;
        for (ParameterizedSourceDefinition parameterizedSourceDefinition : this._parmSourceDefinitions) {
            if (parameterizedSourceDefinition.getNode() != abstractNode || parameterizedSourceDefinition.getObjectName().compareTo(string) != 0 || parameterizedSourceDefinition.getDbObjectType().compareTo(databaseObjectType) != 0) continue;
            string2 = bl ? parameterizedSourceDefinition.getParmNameWithAmpersand() : parameterizedSourceDefinition.getParmName();
            break;
        }
        return string2;
    }

    public ArrayList<ParameterizedSourceDefinition> getSourceDefinitionsForNode(AbstractNode abstractNode) {
        ArrayList<ParameterizedSourceDefinition> arrayList = new ArrayList<ParameterizedSourceDefinition>();
        for (ParameterizedSourceDefinition parameterizedSourceDefinition : this._parmSourceDefinitions) {
            if (parameterizedSourceDefinition.getNode() != abstractNode) continue;
            arrayList.add(parameterizedSourceDefinition);
        }
        return arrayList;
    }

    private String createSearchUserAndName(ParameterizedSourceDefinition parameterizedSourceDefinition) {
        return "\"" + parameterizedSourceDefinition.getUserName() + "\".\"" + parameterizedSourceDefinition.getObjectName() + "\"";
    }

    private String createSearchName(ParameterizedSourceDefinition parameterizedSourceDefinition) {
        return "\"" + parameterizedSourceDefinition.getObjectName() + "\".";
    }

    private String createReplaceName(ParameterizedSourceDefinition parameterizedSourceDefinition) {
        return parameterizedSourceDefinition.getParmNameWithAmpersand() + "..";
    }

    private ParameterizedSourceDefinition addParmName(SourceDefinition sourceDefinition) {
        String string = "";
        string = sourceDefinition.getDbObjectType().compareTo(DatabaseObjectType.TABLE_OR_VIEW) == 0 ? "DATA_SOURCE_" + ++this._dsCount : (sourceDefinition.getDbObjectType().compareTo(DatabaseObjectType.TEXT_SETTING) == 0 ? "TEXT_SETTING_" + ++this._txtSettingCount : (sourceDefinition.getDbObjectType().compareTo(DatabaseObjectType.MODEL) == 0 ? "MODEL_" + ++this._modelCount : "OTHER_" + ++this._otherCount));
        return new ParameterizedSourceDefinition(sourceDefinition, string);
    }

    public void setSql(String string) {
        this._sql.setLength(0);
        this._sql.trimToSize();
        this._sql.append(string);
    }

    public StringBuffer getSql() {
        return this._sql;
    }

    public String generateSQLScript() {
        return this.getSQLScriptHeader() + this.getSql() + ";";
    }

    private String getSQLScriptHeader() {
        return "\n-- Subsitution Variable Definition Section: Override default object names here.\n" + this.getDefineParameters() + "\n" + "-- SQL Plus Script Commands Section:\n" + this.getSQLPlusCommands() + "\n";
    }

    private String getDefineParameters() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (ParameterizedSourceDefinition parameterizedSourceDefinition : this._parmSourceDefinitions) {
            String string2 = "";
            if (parameterizedSourceDefinition.getNodeName().compareTo(string) != 0) {
                string2 = StringUtils.getReplacedString(DEFINE_COMMAND_HEADER, "<NODE_NAME>", parameterizedSourceDefinition.getNodeName());
                string = parameterizedSourceDefinition.getNodeName();
            }
            string2 = string2 + StringUtils.getReplacedString(DEFINE_COMMAND, "<PARM_NAME>", parameterizedSourceDefinition.getParmName());
            string2 = StringUtils.getReplacedString(string2, "<USER_NAME>", parameterizedSourceDefinition.getUserName());
            string2 = StringUtils.getReplacedString(string2, "<OBJECT_NAME>", parameterizedSourceDefinition.getObjectName());
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String getSQLPlusCommands() {
        return SQL_PLUS_COMMANDS;
    }
}

