/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.ConnectionProperties;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQNotificationRegistration;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.sql.ARRAY;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.DATE;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

public class ReusableConnection
implements Connection,
oracle.jdbc.OracleConnection {
    private static ConnectionProperties[] emptyProperties = new ConnectionProperties[0];
    private long startTime;
    private Connection connection;
    private oracle.jdbc.OracleConnection oraConnection;
    private ConnectionManager manager;
    private ConnectionProperties[] properties;
    private String defaultNlsNumericCharacters;
    private Version dbVersion;
    public Boolean isDB12AndUp;

    public ReusableConnection(Connection connection, ConnectionManager connectionManager, ConnectionProperties[] connectionPropertiesArray) {
        this.connection = connection;
        this.oraConnection = (oracle.jdbc.OracleConnection)connection;
        this.manager = connectionManager;
        this.properties = connectionPropertiesArray != null ? connectionPropertiesArray : emptyProperties;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return this.connection.createStatement(n, n2);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return this.connection.createStatement(n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.connection.prepareStatement(string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.connection.prepareStatement(string, n, n2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.connection.prepareStatement(string, n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.connection.prepareStatement(string, n);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.connection.prepareStatement(string, nArray);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.connection.prepareStatement(string, stringArray);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.connection.prepareCall(string);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.connection.prepareCall(string, n, n2);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return this.connection.prepareCall(string, n, n2, n3);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return this.connection.nativeSQL(string);
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.connection.setAutoCommit(bl);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback(savepoint);
    }

    @Override
    public void close() throws SQLException {
        if (this.manager != null) {
            this.manager.releaseConnection(this);
        } else {
            this.connection.close();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.connection.setReadOnly(bl);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.connection.setCatalog(string);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.connection.setTransactionIsolation(n);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.connection.setHoldability(n);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        return this.connection.setSavepoint(string);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connection.createSQLXML();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        return this.connection.isValid(n);
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        this.connection.setClientInfo(string, string2);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        return this.connection.getClientInfo(string);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        return this.connection.createArrayOf(string, objectArray);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        return this.connection.createStruct(string, objectArray);
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.connection.setSchema(string);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.connection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.connection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.connection.setNetworkTimeout(executor, n);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.connection.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return this.connection.unwrap(clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return this.connection.isWrapperFor(clazz);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public ConnectionProperties[] getConnectionProperties() {
        return this.properties;
    }

    public String getDefaultNlsNumericCharacters() {
        return this.defaultNlsNumericCharacters;
    }

    public void setDefaultNlsNumericCharacters(String string) {
        this.defaultNlsNumericCharacters = string;
    }

    public void reuseConnection(Connection connection, ConnectionProperties ... connectionPropertiesArray) {
        this.connection = connection;
        this.oraConnection = (oracle.jdbc.OracleConnection)connection;
        this.properties = connectionPropertiesArray != null ? connectionPropertiesArray : emptyProperties;
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version getDatabaseVersion() throws SQLException {
        if (this.dbVersion == null) {
            try (SQLHelper sQLHelper = new SQLHelper();){
                String string = "SELECT VERSION FROM PRODUCT_COMPONENT_VERSION WHERE PRODUCT like 'Oracle Database 1%' OR PRODUCT like 'Personal Oracle Database 1%'";
                sQLHelper.stmt = this.getConnection().createStatement();
                sQLHelper.rs = sQLHelper.stmt.executeQuery(string);
                if (sQLHelper.rs.next()) {
                    String string2 = sQLHelper.rs.getString("VERSION");
                    this.dbVersion = new Version(string2);
                }
            }
        }
        return this.dbVersion;
    }

    public boolean isDB12_1AndUp() {
        if (this.isDB12AndUp == null) {
            Version version;
            try {
                version = this.getDatabaseVersion();
            }
            catch (SQLException sQLException) {
                return Boolean.FALSE;
            }
            this.isDB12AndUp = ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_2, version, true);
        }
        return this.isDB12AndUp;
    }

    public void commit(EnumSet<OracleConnection.CommitOption> enumSet) throws SQLException {
        this.oraConnection.commit(enumSet);
    }

    public void archive(int n, int n2, String string) throws SQLException {
        this.oraConnection.archive(n, n2, string);
    }

    public void openProxySession(int n, Properties properties) throws SQLException {
        this.oraConnection.openProxySession(n, properties);
    }

    public boolean getAutoClose() throws SQLException {
        return this.oraConnection.getAutoClose();
    }

    public int getDefaultExecuteBatch() {
        return this.oraConnection.getDefaultExecuteBatch();
    }

    public int getDefaultRowPrefetch() {
        return this.oraConnection.getDefaultRowPrefetch();
    }

    public Object getDescriptor(String string) {
        return this.oraConnection.getDescriptor(string);
    }

    public String[] getEndToEndMetrics() throws SQLException {
        return this.oraConnection.getEndToEndMetrics();
    }

    public short getEndToEndECIDSequenceNumber() throws SQLException {
        return this.oraConnection.getEndToEndECIDSequenceNumber();
    }

    public boolean getIncludeSynonyms() {
        return this.oraConnection.getIncludeSynonyms();
    }

    public boolean getRestrictGetTables() {
        return this.oraConnection.getRestrictGetTables();
    }

    public Object getJavaObject(String string) throws SQLException {
        return this.oraConnection.getJavaObject(string);
    }

    public boolean getRemarksReporting() {
        return this.oraConnection.getRemarksReporting();
    }

    public String getSQLType(Object object) throws SQLException {
        return this.oraConnection.getSQLType(object);
    }

    public int getStmtCacheSize() {
        return this.oraConnection.getStmtCacheSize();
    }

    public short getStructAttrCsId() throws SQLException {
        return this.oraConnection.getStructAttrCsId();
    }

    public String getUserName() throws SQLException {
        return this.oraConnection.getUserName();
    }

    public String getCurrentSchema() throws SQLException {
        return this.oraConnection.getCurrentSchema();
    }

    public boolean getUsingXAFlag() {
        return this.oraConnection.getUsingXAFlag();
    }

    public boolean getXAErrorFlag() {
        return this.oraConnection.getXAErrorFlag();
    }

    public int pingDatabase() throws SQLException {
        return this.oraConnection.pingDatabase();
    }

    public int pingDatabase(int n) throws SQLException {
        return this.oraConnection.pingDatabase(n);
    }

    public void putDescriptor(String string, Object object) throws SQLException {
        this.oraConnection.putDescriptor(string, object);
    }

    public void registerSQLType(String string, Class clazz) throws SQLException {
        this.oraConnection.registerSQLType(string, clazz);
    }

    public void registerSQLType(String string, String string2) throws SQLException {
        this.oraConnection.registerSQLType(string, string2);
    }

    public void setAutoClose(boolean bl) throws SQLException {
        this.oraConnection.setAutoClose(bl);
    }

    public void setDefaultExecuteBatch(int n) throws SQLException {
        this.oraConnection.setDefaultExecuteBatch(n);
    }

    public void setDefaultRowPrefetch(int n) throws SQLException {
        this.oraConnection.setDefaultRowPrefetch(n);
    }

    public void setEndToEndMetrics(String[] stringArray, short s) throws SQLException {
        this.oraConnection.setEndToEndMetrics(stringArray, s);
    }

    public void setIncludeSynonyms(boolean bl) {
        this.oraConnection.setIncludeSynonyms(bl);
    }

    public void setRemarksReporting(boolean bl) {
        this.oraConnection.setRemarksReporting(bl);
    }

    public void setRestrictGetTables(boolean bl) {
        this.oraConnection.setRestrictGetTables(bl);
    }

    public void setStmtCacheSize(int n) throws SQLException {
        this.oraConnection.setStmtCacheSize(n);
    }

    public void setStmtCacheSize(int n, boolean bl) throws SQLException {
        this.oraConnection.setStmtCacheSize(n, bl);
    }

    public void setStatementCacheSize(int n) throws SQLException {
        this.oraConnection.setStatementCacheSize(n);
    }

    public int getStatementCacheSize() throws SQLException {
        return this.oraConnection.getStatementCacheSize();
    }

    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        this.oraConnection.setImplicitCachingEnabled(bl);
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.oraConnection.getImplicitCachingEnabled();
    }

    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        this.oraConnection.setExplicitCachingEnabled(bl);
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.oraConnection.getExplicitCachingEnabled();
    }

    public void purgeImplicitCache() throws SQLException {
        this.oraConnection.purgeImplicitCache();
    }

    public void purgeExplicitCache() throws SQLException {
        this.oraConnection.purgeExplicitCache();
    }

    public PreparedStatement getStatementWithKey(String string) throws SQLException {
        return this.oraConnection.getStatementWithKey(string);
    }

    public CallableStatement getCallWithKey(String string) throws SQLException {
        return this.oraConnection.getCallWithKey(string);
    }

    public void setUsingXAFlag(boolean bl) {
        this.oraConnection.setUsingXAFlag(bl);
    }

    public void setXAErrorFlag(boolean bl) {
        this.oraConnection.setXAErrorFlag(bl);
    }

    public void shutdown(OracleConnection.DatabaseShutdownMode databaseShutdownMode) throws SQLException {
        this.oraConnection.shutdown(databaseShutdownMode);
    }

    public void startup(String string, int n) throws SQLException {
        this.oraConnection.startup(string, n);
    }

    public void startup(OracleConnection.DatabaseStartupMode databaseStartupMode) throws SQLException {
        this.oraConnection.startup(databaseStartupMode);
    }

    public PreparedStatement prepareStatementWithKey(String string) throws SQLException {
        return this.oraConnection.prepareStatementWithKey(string);
    }

    public CallableStatement prepareCallWithKey(String string) throws SQLException {
        return this.oraConnection.getCallWithKey(string);
    }

    public void setCreateStatementAsRefCursor(boolean bl) {
        this.oraConnection.setCreateStatementAsRefCursor(bl);
    }

    public boolean getCreateStatementAsRefCursor() {
        return this.oraConnection.getCreateStatementAsRefCursor();
    }

    public void setSessionTimeZone(String string) throws SQLException {
        this.oraConnection.setSessionTimeZone(string);
    }

    public String getSessionTimeZone() {
        return this.oraConnection.getSessionTimeZone();
    }

    public String getSessionTimeZoneOffset() throws SQLException {
        return this.oraConnection.getSessionTimeZoneOffset();
    }

    public Properties getProperties() {
        return this.oraConnection.getProperties();
    }

    public Connection _getPC() {
        return this.oraConnection._getPC();
    }

    public boolean isLogicalConnection() {
        return this.oraConnection.isLogicalConnection();
    }

    public void registerTAFCallback(OracleOCIFailover oracleOCIFailover, Object object) throws SQLException {
        this.oraConnection.registerTAFCallback(oracleOCIFailover, object);
    }

    public oracle.jdbc.OracleConnection unwrap() {
        return this.oraConnection.unwrap();
    }

    public void setWrapper(oracle.jdbc.OracleConnection oracleConnection) {
        this.oraConnection.setWrapper(oracleConnection);
    }

    public OracleConnection physicalConnectionWithin() {
        return this.oraConnection.physicalConnectionWithin();
    }

    public OracleSavepoint oracleSetSavepoint() throws SQLException {
        return this.oraConnection.oracleSetSavepoint();
    }

    public OracleSavepoint oracleSetSavepoint(String string) throws SQLException {
        return this.oraConnection.oracleSetSavepoint(string);
    }

    public void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        this.oraConnection.oracleRollback(oracleSavepoint);
    }

    public void oracleReleaseSavepoint(OracleSavepoint oracleSavepoint) throws SQLException {
        this.oraConnection.oracleReleaseSavepoint(oracleSavepoint);
    }

    public void close(Properties properties) throws SQLException {
        this.oraConnection.close(properties);
    }

    public void close(int n) throws SQLException {
        this.oraConnection.close(n);
    }

    public boolean isProxySession() {
        return this.oraConnection.isProxySession();
    }

    public void applyConnectionAttributes(Properties properties) throws SQLException {
        this.oraConnection.applyConnectionAttributes(properties);
    }

    public Properties getConnectionAttributes() throws SQLException {
        return this.oraConnection.getConnectionAttributes();
    }

    public Properties getUnMatchedConnectionAttributes() throws SQLException {
        return this.oraConnection.getUnMatchedConnectionAttributes();
    }

    public void registerConnectionCacheCallback(OracleConnectionCacheCallback oracleConnectionCacheCallback, Object object, int n) throws SQLException {
        this.oraConnection.registerConnectionCacheCallback(oracleConnectionCacheCallback, object, n);
    }

    public void setConnectionReleasePriority(int n) throws SQLException {
        this.oraConnection.setConnectionReleasePriority(n);
    }

    public int getConnectionReleasePriority() throws SQLException {
        return this.oraConnection.getConnectionReleasePriority();
    }

    public void setPlsqlWarnings(String string) throws SQLException {
        this.oraConnection.setPlsqlWarnings(string);
    }

    public AQNotificationRegistration[] registerAQNotification(String[] stringArray, Properties[] propertiesArray, Properties properties) throws SQLException {
        return this.oraConnection.registerAQNotification(stringArray, propertiesArray, properties);
    }

    public void unregisterAQNotification(AQNotificationRegistration aQNotificationRegistration) throws SQLException {
        this.oraConnection.unregisterAQNotification(aQNotificationRegistration);
    }

    public AQMessage dequeue(String string, AQDequeueOptions aQDequeueOptions, byte[] byArray) throws SQLException {
        return this.oraConnection.dequeue(string, aQDequeueOptions, string);
    }

    public AQMessage dequeue(String string, AQDequeueOptions aQDequeueOptions, String string2) throws SQLException {
        return this.oraConnection.dequeue(string, aQDequeueOptions, string2);
    }

    public void enqueue(String string, AQEnqueueOptions aQEnqueueOptions, AQMessage aQMessage) throws SQLException {
        this.oraConnection.enqueue(string, aQEnqueueOptions, aQMessage);
    }

    public DatabaseChangeRegistration registerDatabaseChangeNotification(Properties properties) throws SQLException {
        return this.oraConnection.registerDatabaseChangeNotification(properties);
    }

    public DatabaseChangeRegistration getDatabaseChangeRegistration(int n) throws SQLException {
        return this.oraConnection.getDatabaseChangeRegistration(n);
    }

    public void unregisterDatabaseChangeNotification(DatabaseChangeRegistration databaseChangeRegistration) throws SQLException {
        this.oraConnection.unregisterDatabaseChangeNotification(databaseChangeRegistration);
    }

    public void unregisterDatabaseChangeNotification(int n, String string, int n2) throws SQLException {
        this.oraConnection.unregisterDatabaseChangeNotification(n, string, n2);
    }

    public void unregisterDatabaseChangeNotification(int n) throws SQLException {
        this.oraConnection.unregisterDatabaseChangeNotification(n);
    }

    public void unregisterDatabaseChangeNotification(long l, String string) throws SQLException {
        this.oraConnection.unregisterDatabaseChangeNotification(l, string);
    }

    public ARRAY createARRAY(String string, Object object) throws SQLException {
        return this.oraConnection.createARRAY(string, object);
    }

    public Array createOracleArray(String string, Object object) throws SQLException {
        return this.oraConnection.createOracleArray(string, object);
    }

    public BINARY_DOUBLE createBINARY_DOUBLE(double d) throws SQLException {
        return this.oraConnection.createBINARY_DOUBLE(d);
    }

    public BINARY_FLOAT createBINARY_FLOAT(float f) throws SQLException {
        return this.oraConnection.createBINARY_FLOAT(f);
    }

    public DATE createDATE(Date date) throws SQLException {
        return this.oraConnection.createDATE(date);
    }

    public DATE createDATE(Time time) throws SQLException {
        return this.oraConnection.createDATE(time);
    }

    public DATE createDATE(Timestamp timestamp) throws SQLException {
        return this.oraConnection.createDATE(timestamp);
    }

    public DATE createDATE(Date date, Calendar calendar) throws SQLException {
        return this.oraConnection.createDATE(date, calendar);
    }

    public DATE createDATE(Time time, Calendar calendar) throws SQLException {
        return this.oraConnection.createDATE(time, calendar);
    }

    public DATE createDATE(Timestamp timestamp, Calendar calendar) throws SQLException {
        return this.oraConnection.createDATE(timestamp, calendar);
    }

    public DATE createDATE(String string) throws SQLException {
        return this.oraConnection.createDATE(string);
    }

    public INTERVALDS createINTERVALDS(String string) throws SQLException {
        return this.oraConnection.createINTERVALDS(string);
    }

    public INTERVALYM createINTERVALYM(String string) throws SQLException {
        return this.oraConnection.createINTERVALYM(string);
    }

    public NUMBER createNUMBER(boolean bl) throws SQLException {
        return this.oraConnection.createNUMBER(bl);
    }

    public NUMBER createNUMBER(byte by) throws SQLException {
        return this.oraConnection.createNUMBER(by);
    }

    public NUMBER createNUMBER(short s) throws SQLException {
        return this.oraConnection.createNUMBER(s);
    }

    public NUMBER createNUMBER(int n) throws SQLException {
        return this.oraConnection.createNUMBER(n);
    }

    public NUMBER createNUMBER(long l) throws SQLException {
        return this.oraConnection.createNUMBER(l);
    }

    public NUMBER createNUMBER(float f) throws SQLException {
        return this.oraConnection.createNUMBER(false);
    }

    public NUMBER createNUMBER(double d) throws SQLException {
        return this.oraConnection.createNUMBER(d);
    }

    public NUMBER createNUMBER(BigDecimal bigDecimal) throws SQLException {
        return this.oraConnection.createNUMBER(bigDecimal);
    }

    public NUMBER createNUMBER(BigInteger bigInteger) throws SQLException {
        return this.oraConnection.createNUMBER(bigInteger);
    }

    public NUMBER createNUMBER(String string, int n) throws SQLException {
        return this.oraConnection.createNUMBER(string, n);
    }

    public TIMESTAMP createTIMESTAMP(Date date) throws SQLException {
        return this.oraConnection.createTIMESTAMP(date);
    }

    public TIMESTAMP createTIMESTAMP(DATE dATE) throws SQLException {
        return this.oraConnection.createTIMESTAMP(dATE);
    }

    public TIMESTAMP createTIMESTAMP(Time time) throws SQLException {
        return this.oraConnection.createTIMESTAMP(time);
    }

    public TIMESTAMP createTIMESTAMP(Timestamp timestamp) throws SQLException {
        return this.oraConnection.createTIMESTAMP(timestamp);
    }

    public TIMESTAMP createTIMESTAMP(String string) throws SQLException {
        return this.oraConnection.createTIMESTAMP(string);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Date date) throws SQLException {
        return this.oraConnection.createTIMESTAMPTZ(date);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Date date, Calendar calendar) throws SQLException {
        return this.oraConnection.createTIMESTAMPTZ(date, calendar);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Time time) throws SQLException {
        return this.oraConnection.createTIMESTAMPTZ(time);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Time time, Calendar calendar) throws SQLException {
        return this.oraConnection.createTIMESTAMPTZ(time, calendar);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp timestamp) throws SQLException {
        return this.oraConnection.createTIMESTAMPTZ(timestamp);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp timestamp, Calendar calendar) throws SQLException {
        return this.oraConnection.createTIMESTAMPTZ(timestamp, calendar);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(String string) throws SQLException {
        return this.oraConnection.createTIMESTAMPTZ(string);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(String string, Calendar calendar) throws SQLException {
        return this.oraConnection.createTIMESTAMPTZ(string, calendar);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(DATE dATE) throws SQLException {
        return this.oraConnection.createTIMESTAMPTZ(dATE);
    }

    public TIMESTAMPLTZ createTIMESTAMPLTZ(Date date, Calendar calendar) throws SQLException {
        return this.oraConnection.createTIMESTAMPLTZ(date, calendar);
    }

    public TIMESTAMPLTZ createTIMESTAMPLTZ(Time time, Calendar calendar) throws SQLException {
        return this.oraConnection.createTIMESTAMPLTZ(time, calendar);
    }

    public TIMESTAMPLTZ createTIMESTAMPLTZ(Timestamp timestamp, Calendar calendar) throws SQLException {
        return this.oraConnection.createTIMESTAMPLTZ(timestamp, calendar);
    }

    public TIMESTAMPLTZ createTIMESTAMPLTZ(String string, Calendar calendar) throws SQLException {
        return this.oraConnection.createTIMESTAMPLTZ(string, calendar);
    }

    public TIMESTAMPLTZ createTIMESTAMPLTZ(DATE dATE, Calendar calendar) throws SQLException {
        return this.oraConnection.createTIMESTAMPLTZ(dATE, calendar);
    }

    public void cancel() throws SQLException {
        this.oraConnection.cancel();
    }

    public void abort() throws SQLException {
        this.oraConnection.abort();
    }

    public TypeDescriptor[] getAllTypeDescriptorsInCurrentSchema() throws SQLException {
        return this.oraConnection.getAllTypeDescriptorsInCurrentSchema();
    }

    public TypeDescriptor[] getTypeDescriptorsFromListInCurrentSchema(String[] stringArray) throws SQLException {
        return this.oraConnection.getTypeDescriptorsFromListInCurrentSchema(stringArray);
    }

    public TypeDescriptor[] getTypeDescriptorsFromList(String[][] stringArray) throws SQLException {
        return this.oraConnection.getTypeDescriptorsFromList(stringArray);
    }

    public String getDataIntegrityAlgorithmName() throws SQLException {
        return this.oraConnection.getDataIntegrityAlgorithmName();
    }

    public String getEncryptionAlgorithmName() throws SQLException {
        return this.oraConnection.getEncryptionAlgorithmName();
    }

    public String getAuthenticationAdaptorName() throws SQLException {
        return this.oraConnection.getAuthenticationAdaptorName();
    }

    public boolean isUsable() {
        return this.oraConnection.isUsable();
    }

    public void setDefaultTimeZone(TimeZone timeZone) throws SQLException {
        this.oraConnection.setDefaultTimeZone(timeZone);
    }

    public TimeZone getDefaultTimeZone() throws SQLException {
        return this.oraConnection.getDefaultTimeZone();
    }

    public void setApplicationContext(String string, String string2, String string3) throws SQLException {
        this.oraConnection.setApplicationContext(string, string2, string3);
    }

    public void clearAllApplicationContext(String string) throws SQLException {
        this.oraConnection.clearAllApplicationContext(string);
    }

    public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener logicalTransactionIdEventListener) throws SQLException {
        this.oraConnection.addLogicalTransactionIdEventListener(logicalTransactionIdEventListener);
    }

    public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener logicalTransactionIdEventListener, Executor executor) throws SQLException {
        this.oraConnection.addLogicalTransactionIdEventListener(logicalTransactionIdEventListener, executor);
    }

    public void removeLogicalTransactionIdEventListener(LogicalTransactionIdEventListener logicalTransactionIdEventListener) throws SQLException {
        this.oraConnection.removeLogicalTransactionIdEventListener(logicalTransactionIdEventListener);
    }

    public LogicalTransactionId getLogicalTransactionId() throws SQLException {
        return this.oraConnection.getLogicalTransactionId();
    }

    public boolean isDRCPEnabled() throws SQLException {
        return this.oraConnection.isDRCPEnabled();
    }

    public boolean attachServerConnection() throws SQLException {
        return this.oraConnection.attachServerConnection();
    }

    public void detachServerConnection(String string) throws SQLException {
        this.oraConnection.detachServerConnection(string);
    }

    public boolean needToPurgeStatementCache() throws SQLException {
        return this.oraConnection.needToPurgeStatementCache();
    }

    @Override
    public void beginRequest() throws SQLException {
        this.oraConnection.beginRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        this.oraConnection.endRequest();
    }
}

