/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.awt.Window;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.TableMessages;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.SwingUtils;

public abstract class ODMrSwingWorker<T, V>
extends SwingWorker<T, V> {
    private static final Logger LOGGER = Logger.getLogger(ODMrSwingWorker.class.getName());
    private JComponent component;
    private DataMinerTable table;
    private BlockingComponent overlayPanel;

    public ODMrSwingWorker(JComponent jComponent) {
        this.component = jComponent;
    }

    public ODMrSwingWorker(JComponent jComponent, DataMinerTable dataMinerTable) {
        this(jComponent, dataMinerTable, null);
    }

    public ODMrSwingWorker(JComponent jComponent, DataMinerTable dataMinerTable, BlockingComponent blockingComponent) {
        this.component = jComponent;
        this.table = dataMinerTable;
        this.overlayPanel = blockingComponent;
        if (blockingComponent != null) {
            blockingComponent.setState(BlockingComponent.State.BLOCKED);
        }
        this.setTableMessage(TableMessages.LOADING);
    }

    @Override
    protected void done() {
        try {
            this.setTableMessage(TableMessages.SUCCESS);
            this.preSuccess();
            this.onSuccess(this.get());
        }
        catch (InterruptedException | ExecutionException exception) {
            this.onFailure((Exception)exception.getCause());
        }
        catch (Exception exception) {
            this.onSuccessFailure(exception);
        }
        finally {
            this.onFinally();
        }
    }

    protected void onFailure(Exception exception) {
        this.setTableMessage(TableMessages.ERROR);
        ExceptionDialog.showExceptionDialog((Window)this.getParentWindow(), (Exception)exception, (String)CommonLrb.get("ERROR_TITLE"), (String)CommonLrb.get("EXCEPTION_MSG"));
    }

    protected void onSuccessFailure(Exception exception) {
        this.onFailure(exception);
    }

    protected void onFinally() {
        if (this.overlayPanel != null) {
            this.overlayPanel.setState(BlockingComponent.State.UNBLOCKED);
        }
    }

    protected void preSuccess() {
    }

    protected abstract void onSuccess(T var1) throws Exception;

    protected void setTableMessage(TableMessages tableMessages) {
        this.setTableMessage(tableMessages.getMessage());
    }

    protected void setTableMessage(String string) {
        if (this.table == null) {
            return;
        }
        this.table.setNoEntryInstructionText(string);
        TableModel tableModel = this.table.getModel();
        if (tableModel instanceof ODMrTableModel) {
            ((ODMrTableModel)((Object)tableModel)).clear();
        } else if (tableModel instanceof GenericBaseTableModel) {
            ((GenericBaseTableModel)tableModel).setRowCount(0);
        } else if (ConfigUtils.isDebugBuild()) {
            LOGGER.warning("Model should be a subclass of GenericBaseTableModel or ODMrTableModel for this to work");
        }
    }

    protected Window getParentWindow() {
        Window window = null;
        if (this.component instanceof DialogDisplayer) {
            window = ((DialogDisplayer)this.component).getParentWindow();
        } else {
            window = SwingUtils.getAncestorFrame((Component)this.component);
            if (window == null) {
                window = SwingUtils.getAncestorDialog((Component)this.component);
            }
            if (window == null) {
                window = Ide.getMainWindow();
            }
        }
        return window;
    }
}

