/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.ConfigurationSettingsDialog;
import oracle.dmt.dataminer.utils.ConfigurationWorkerDialog;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.ExceptionHelper;
import oracle.dmt.dataminer.utils.ReusableConnection;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public final class ConfigUtils {
    private static boolean DEBUG = Boolean.getBoolean("sqldev.debug");
    private static final String CD$ROOT = "CD$ROOT";
    private static final Version INITITAL_BINARY_XML_REPOSITORY_RELEASE_VERSION = new Version("11.2.2.1.1");
    private static final Version CURRENT_WF_SCHEMA_IN_CLIENT = new Version("12.1.0.2.3");
    private static final Logger LOGGER = Logger.getLogger(ConfigUtils.class.getName());
    private static final Version KNOWN_RELEASE_COMPATIBLE = new Version("12.1.0.2.6");
    private static final Version[] KNOWN_RELEASES_REQUIRE_UPGRADE = new Version[]{new Version("11.2.0.1.9"), new Version("11.2.0.1.10"), new Version("11.2.0.1.11"), new Version("11.2.0.1.12"), new Version("11.2.0.1.13"), new Version("11.2.1.1.1"), new Version("11.2.1.1.2"), new Version("11.2.1.1.3"), new Version("11.2.1.1.4"), new Version("11.2.1.1.5"), new Version("11.2.1.1.6"), new Version("11.2.2.1.1"), new Version("12.1.0.1.1"), new Version("12.1.0.1.2"), new Version("12.1.0.1.3"), new Version("12.1.0.1.4"), new Version("12.1.0.1.5"), new Version("12.1.0.2.1"), new Version("12.1.0.2.2"), new Version("12.1.0.2.3"), new Version("12.1.0.2.4"), new Version("12.1.0.2.5")};
    private static final Version[] KNOWN_RELEASES_REQUIRE_MIGRATION = new Version[0];
    private static final Version[] KNOWN_ALPHA_RELEASES = new Version[]{new Version("11.2.0.1.0"), new Version("11.2.0.1.1"), new Version("11.2.0.1.2"), new Version("11.2.0.1.3"), new Version("11.2.0.1.4"), new Version("11.2.0.1.5"), new Version("11.2.0.1.6"), new Version("11.2.0.1.7"), new Version("11.2.0.1.8")};
    private static final String KB_FILES_CHECK = "DECLARE\n v_policy VARCHAR2(30);\n rtab ctx_doc.theme_tab;\n v_del BOOLEAN := FALSE;\n\nFUNCTION generateUniqueName RETURN VARCHAR2 IS\n v_uniqueName VARCHAR2(30);\n BEGIN\n   SELECT 'ODMR$'||TO_CHAR(SYSTIMESTAMP,'HH24_MI_SS_FF')||dbms_random.string(NULL, 7) INTO v_uniqueName FROM dual;\n RETURN v_uniqueName;\nEND;\n\nBEGIN\n v_policy := generateUniqueName;\n ctx_ddl.CREATE_POLICY(policy_name => v_policy);\n v_del := TRUE;\n ctx_doc.policy_themes(v_policy, 'this is a test for Oracle Text theme generation', rtab);\nfor i in 1..rtab.count loop\n dbms_output.put_line(rtab(i).theme||':'||rtab(i).weight);\nend loop;\nIF (v_del) THEN\n ctx_ddl.DROP_POLICY(policy_name => v_policy);\nEND IF;\nEXCEPTION WHEN OTHERS THEN\n IF (v_del) THEN\n   ctx_ddl.DROP_POLICY(policy_name => v_policy);\n END IF;\n RAISE_APPLICATION_ERROR(-20999, 'Oracle Text Error: '||DBMS_UTILITY.FORMAT_ERROR_BACKTRACE());\nEND;";
    public static final String ODMRSYS_NOT_LOADED = "NOT_LOADED";
    public static final String ODMRSYS_LOADED = "LOADED";
    public static final String ODMRSYS_SCHEMA_NAME = "ODMRSYS";

    public static boolean isDebugBuild() {
        return DEBUG;
    }

    public static Version getDatabaseVersion(Context context) throws Exception {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        return connectionFolder.getDbVersion();
    }

    public static boolean isCompatibleDatabase(Context context) throws SQLException {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        Version version = connectionFolder.getDbVersion();
        if (version == null) {
            return false;
        }
        return ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_0, version, false, 2) || ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, false, 1);
    }

    public static boolean isDatabaseVersion(DBVersions dBVersions, Version version) {
        return ConfigUtils.isDatabaseVersion(dBVersions, version, false, 0);
    }

    public static boolean isDatabaseVersion(DBVersions dBVersions, Version version, boolean bl) {
        return ConfigUtils.isDatabaseVersion(dBVersions, version, bl, 0);
    }

    public static boolean isDatabaseVersion(DBVersions dBVersions, Version version, boolean bl, int n) {
        assert (n < 5 && n >= 0);
        if (dBVersions == null || version == null) {
            return false;
        }
        if (n == 0) {
            int n2 = dBVersions.get().compareTo((Object)version);
            return bl ? n2 <= 0 : n2 == 0;
        }
        int[] nArray = version.toIntArray();
        int[] nArray2 = dBVersions.get().toIntArray();
        for (int i = 0; i < n; ++i) {
            if (bl && nArray2[i] < nArray[i]) {
                return true;
            }
            if (!bl ? nArray2[i] == nArray[i] : nArray2[i] <= nArray[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatiblePasteOperation(Map<VersionInfoType, Version> map, Map<VersionInfoType, Version> map2) {
        Version version = map.get((Object)VersionInfoType.DatabaseVersion);
        Version version2 = map.get((Object)VersionInfoType.XmlSchemaVersion);
        Version version3 = map2.get((Object)VersionInfoType.DatabaseVersion);
        Version version4 = map2.get((Object)VersionInfoType.XmlSchemaVersion);
        if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, false, 2) && version.compareTo((Object)version3) > 0) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("PASTE_FROM_12.1_RESTRICTION"), (String)UtilsLrb.get("PASTE_FROM_12.1_RESTRICTION_TITLE"), null);
            return false;
        }
        if (version2.compareTo((Object)new Version("11.2.2.1.1")) == 0 && version2.compareTo((Object)version4) > 0) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("PASTE_FROM_3.2_SCHEMA_TO_OLDER"), (String)UtilsLrb.get("PASTE_FROM_3.2_SCHEMA_TO_OLDER_TITLE"), null);
            return false;
        }
        return true;
    }

    public static boolean isCompatibleXmlSchemaVersion(Context context, Version version) throws Exception {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        Version version2 = connectionFolder.getSchemaVersion();
        if (version.toCanonicalString().startsWith("11.2.0.1.9")) {
            return true;
        }
        if (version2.toCanonicalString().startsWith("11.2.0.1.9") && version.toCanonicalString().startsWith("11.2.1.1.1")) {
            return true;
        }
        if (version2.toCanonicalString().startsWith("11.2.1.1.1") && (version.toCanonicalString().startsWith("11.2.0.1.9") || version.toCanonicalString().startsWith("11.2.1.1.1"))) {
            return true;
        }
        if (version2.toCanonicalString().startsWith("11.2.2.1.1") && (version.toCanonicalString().startsWith("11.2.0.1.9") || version.toCanonicalString().startsWith("11.2.1.1.1") || version.toCanonicalString().startsWith("11.2.2.1.1"))) {
            return true;
        }
        if (version2.toCanonicalString().startsWith("12.1.0.1.1") && (version.toCanonicalString().startsWith("11.2.0.1.9") || version.toCanonicalString().startsWith("11.2.1.1.1") || version.toCanonicalString().startsWith("11.2.2.1.1") || version.toCanonicalString().startsWith("12.1.0.1.1"))) {
            return true;
        }
        if (version2.toCanonicalString().startsWith("12.1.0.1.2") && (version.toCanonicalString().startsWith("11.2.0.1.9") || version.toCanonicalString().startsWith("11.2.1.1.1") || version.toCanonicalString().startsWith("11.2.2.1.1") || version.toCanonicalString().startsWith("12.1.0.1.1") || version.toCanonicalString().startsWith("12.1.0.1.2"))) {
            return true;
        }
        if (version2.toCanonicalString().startsWith("12.1.0.1.3") && (version.toCanonicalString().startsWith("11.2.0.1.9") || version.toCanonicalString().startsWith("11.2.1.1.1") || version.toCanonicalString().startsWith("11.2.2.1.1") || version.toCanonicalString().startsWith("12.1.0.1.1") || version.toCanonicalString().startsWith("12.1.0.1.2") || version.toCanonicalString().startsWith("12.1.0.1.3"))) {
            return true;
        }
        if (version2.toCanonicalString().startsWith("12.1.0.1.4") && (version.toCanonicalString().startsWith("11.2.0.1.9") || version.toCanonicalString().startsWith("11.2.1.1.1") || version.toCanonicalString().startsWith("11.2.2.1.1") || version.toCanonicalString().startsWith("12.1.0.1.1") || version.toCanonicalString().startsWith("12.1.0.1.2") || version.toCanonicalString().startsWith("12.1.0.1.3") || version.toCanonicalString().startsWith("12.1.0.1.4"))) {
            return true;
        }
        if (version2.toCanonicalString().startsWith("12.1.0.2.1") && (version.toCanonicalString().startsWith("11.2.0.1.9") || version.toCanonicalString().startsWith("11.2.1.1.1") || version.toCanonicalString().startsWith("11.2.2.1.1") || version.toCanonicalString().startsWith("12.1.0.1.1") || version.toCanonicalString().startsWith("12.1.0.1.2") || version.toCanonicalString().startsWith("12.1.0.1.3") || version.toCanonicalString().startsWith("12.1.0.1.4") || version.toCanonicalString().startsWith("12.1.0.2.1"))) {
            return true;
        }
        if (version2.toCanonicalString().startsWith("12.1.0.2.2") && (version.toCanonicalString().startsWith("11.2.0.1.9") || version.toCanonicalString().startsWith("11.2.1.1.1") || version.toCanonicalString().startsWith("11.2.2.1.1") || version.toCanonicalString().startsWith("12.1.0.1.1") || version.toCanonicalString().startsWith("12.1.0.1.2") || version.toCanonicalString().startsWith("12.1.0.1.3") || version.toCanonicalString().startsWith("12.1.0.1.4") || version.toCanonicalString().startsWith("12.1.0.2.1") || version.toCanonicalString().startsWith("12.1.0.2.2"))) {
            return true;
        }
        return version2.toCanonicalString().startsWith("12.1.0.2.3") && (version.toCanonicalString().startsWith("11.2.0.1.9") || version.toCanonicalString().startsWith("11.2.1.1.1") || version.toCanonicalString().startsWith("11.2.2.1.1") || version.toCanonicalString().startsWith("12.1.0.1.1") || version.toCanonicalString().startsWith("12.1.0.1.2") || version.toCanonicalString().startsWith("12.1.0.1.3") || version.toCanonicalString().startsWith("12.1.0.1.4") || version.toCanonicalString().startsWith("12.1.0.2.1") || version.toCanonicalString().startsWith("12.1.0.2.2") || version.toCanonicalString().startsWith("12.1.0.2.3"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDataMiningOptionInstalled(ConnectionManager connectionManager) throws SQLException {
        boolean bl = false;
        String string = "select value from v$option where parameter = 'Data Mining'";
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string2;
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next() && (string2 = sQLHelper.rs.getString(1)) != null && string2.equalsIgnoreCase("TRUE")) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDataMinerSchemaInstalled(Connection connection) throws SQLException {
        boolean bl = false;
        String string = "select OWNER from ALL_XML_SCHEMAS where SCHEMA_URL like '%odmr.xsd'";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next() && sQLHelper.rs.getString(1) != null) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextAndXMLDBState isTextAndXMLDBInstalled(ConnectionManager connectionManager) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        TextAndXMLDBState textAndXMLDBState = null;
        String string = "select username from ALL_USERS\nwhere username in ('XDB','CTXSYS')";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            String string2 = "";
            while (sQLHelper.rs.next()) {
                string2 = sQLHelper.rs.getString(1);
                if ("XDB".equals(string2)) {
                    bl2 = true;
                    continue;
                }
                if (!"CTXSYS".equals(string2)) continue;
                bl = true;
            }
            textAndXMLDBState = bl2 && bl ? TextAndXMLDBState.BOTH : (!bl2 && !bl ? TextAndXMLDBState.NONE : (bl2 && !bl ? TextAndXMLDBState.XML_DB_ONLY : (!bl2 && bl ? TextAndXMLDBState.TEXT_ONLY : TextAndXMLDBState.NONE)));
        }
        return textAndXMLDBState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextAndXMLDBState validateTextAndXMLDB(Connection connection) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        TextAndXMLDBState textAndXMLDBState = null;
        String string = "SELECT COMP_ID, STATUS FROM DBA_REGISTRY WHERE COMP_ID IN ('XDB','CONTEXT')";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            String string2 = "";
            String string3 = "";
            while (sQLHelper.rs.next()) {
                string2 = sQLHelper.rs.getString(1);
                string3 = sQLHelper.rs.getString(2);
                if ("XDB".equals(string2) && "VALID".equals(string3)) {
                    bl2 = true;
                    continue;
                }
                if (!"CONTEXT".equals(string2) || !"VALID".equals(string3)) continue;
                bl = true;
            }
            textAndXMLDBState = bl2 && bl ? TextAndXMLDBState.BOTH : (!bl2 && !bl ? TextAndXMLDBState.NONE : (bl2 && !bl ? TextAndXMLDBState.XML_DB_ONLY : (!bl2 && bl ? TextAndXMLDBState.TEXT_ONLY : TextAndXMLDBState.NONE)));
        }
        return textAndXMLDBState;
    }

    public static boolean isKnowledgeBaseFilesAvailble(Connection connection) throws SQLException {
        sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall(KB_FILES_CHECK);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.cstmt.execute();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isODMPrivsPresent(Connection connection) throws SQLException {
        boolean bl = false;
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string = "SELECT COUNT (DISTINCT (\n  CASE\n    WHEN privilege = 'ODMRUSER' THEN 'ODMRUSER'\n    ELSE NULL\n  END)) PRIVILEGE FROM (\n          SELECT ROLE AS PRIVILEGE FROM (         select role as ROLE from role_role_privs\n         UNION\n         select granted_role as ROLE from role_role_privs         UNION\n         select granted_role as ROLE from user_role_privs )         ROLES_QUERY \n      WHERE ROLE IN ('ODMRUSER'))";
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next() && sQLHelper.rs.getInt(1) == 1) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> isODMUserPrivsPresent(ConnectionManager connectionManager) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string = "select OWNER, TABLE_NAME from (\nselect 'ODMRSYS' OWNER, 'AGGREGATION_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'ANOMALY_BUILD_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'APPLYTEXT_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'APPLY_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'ASSOC_BUILD_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'BUILDTEXT_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'BUILDTEXT_REF_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'CLASS_BUILD_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'CLEANUP_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'CLUST_BUILD_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'COLUMNFILTER_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'CREATETABLE_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'DATAPROFILE_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'DATASOURCE_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'FEATURE_BUILD_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'FILTERDETAILS_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'JOIN_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'MODELDETAILS_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'MODEL_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'ODMR_ENGINE_TEXT' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'REGRESS_BUILD_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'ROWFILTER_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'SAMPLE_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'START_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'SUBFLOW_CLEANUP_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'SUBFLOW_START_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'TEST_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'TRANSFORMATIONS_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'UPDATETABLE_PROG' TABLE_NAME from dual\nUNION\nselect 'CTXSYS' OWNER, 'CTX_DDL' TABLE_NAME from dual)\nMINUS\nselect OWNER, TABLE_NAME from user_tab_privs where grantor = 'ODMRSYS' OR grantor = 'CTXSYS'\n";
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                arrayList.add(sQLHelper.rs.getString("OWNER") + "." + sQLHelper.rs.getString("TABLE_NAME"));
            }
        }
        return arrayList;
    }

    public static Boolean isValidUserConnection(String string) throws ConnectionException {
        Boolean bl = true;
        Properties properties = DatabaseConnections.getInstance().getProperties(string);
        Properties properties2 = (Properties)properties.clone();
        String string2 = (String)properties2.get("role");
        String string3 = (String)properties2.get("user");
        if (string2 != null && string2.equalsIgnoreCase("SYSDBA") || string3.equalsIgnoreCase(ODMRSYS_SCHEMA_NAME)) {
            bl = false;
        }
        return bl;
    }

    public static Version getClientVersion() {
        Extension extension = ExtensionRegistry.getExtensionRegistry().findExtension("oracle.dmt.dataminer");
        int[] nArray = extension.getVersion().toIntArray();
        return new Version(nArray);
    }

    public static String getCurrentRepositoryVersion() {
        return KNOWN_RELEASE_COMPATIBLE.toString();
    }

    public static String getCurrentXMLSchemaInClient() {
        return CURRENT_WF_SCHEMA_IN_CLIENT.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<VersionInfoType, Version> getVersionInfo(Connection connection) throws SQLException {
        EnumMap<VersionInfoType, Version> enumMap;
        block12: {
            enumMap = new EnumMap<VersionInfoType, Version>(VersionInfoType.class);
            try (SQLHelper sQLHelper = new SQLHelper();){
                String string = "SELECT DISTINCT DB.VERSION, ODMR.PROPERTY_STR_VALUE, ODMR.PROPERTY_NAME FROM ODMR_REPOSITORY_PROPERTIES ODMR, PRODUCT_COMPONENT_VERSION DB WHERE PROPERTY_NAME='VERSION' OR PROPERTY_NAME='WF_VERSION'";
                sQLHelper.pstmt = connection.prepareStatement(string);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    String string2 = sQLHelper.rs.getString(1);
                    String string3 = sQLHelper.rs.getString(2);
                    String string4 = sQLHelper.rs.getString(3);
                    if ("VERSION".equals(string4)) {
                        enumMap.put(VersionInfoType.RepositoryVersion, new Version(string3));
                    } else if ("WF_VERSION".equals(string4)) {
                        if (string3 == null) {
                            string3 = "11.2.0.1.9";
                        }
                        enumMap.put(VersionInfoType.XmlSchemaVersion, new Version(string3));
                    }
                    if (enumMap.containsKey((Object)VersionInfoType.DatabaseVersion)) continue;
                    enumMap.put(VersionInfoType.DatabaseVersion, new Version(string2));
                }
                if (!enumMap.containsKey((Object)VersionInfoType.XmlSchemaVersion)) {
                    enumMap.put(VersionInfoType.XmlSchemaVersion, new Version("11.2.0.1.9"));
                }
            }
        }
        return enumMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean isExtendedTypeEnabled(ConnectionManager connectionManager) {
        int n = 0;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("{? = call ODMR_UTIL.is_extended_type()}");
            sQLHelper.cstmt.registerOutParameter(1, 2);
            sQLHelper.cstmt.execute();
            n = sQLHelper.cstmt.getInt(1);
        }
        return n == 1;
    }

    public static void closeConnectionFolder(Context context) {
        if (context != null) {
            ConnectionFolder connectionFolder = (ConnectionFolder)context.getNode();
            try {
                connectionFolder.disconnect();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
                return;
            }
        }
    }

    public static boolean displayDisconnectSessionWarning(Connection connection) {
        try {
            List<DBSessionInfo> list = ConfigUtils.getSessionsRequiringDisconnect(connection);
            if (!list.isEmpty()) {
                DBSessionInfo dBSessionInfo2;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("username:module:program:type:sid:serial:status\n\n");
                for (DBSessionInfo dBSessionInfo2 : list) {
                    stringBuffer.append(dBSessionInfo2.getUserName() + ":" + dBSessionInfo2.getModule() + ":" + dBSessionInfo2.getProgram() + ":" + dBSessionInfo2.getType() + ":" + dBSessionInfo2.getSid() + ":" + dBSessionInfo2.getSerial() + ":" + dBSessionInfo2.getStatus() + "\n");
                }
                DetailDialog detailDialog = DetailDialog.createDetailDialog((Component)Ide.getMainWindow(), (String)UtilsLrb.get("WIZARD_TITLE"), (int)19);
                dBSessionInfo2 = new MessagePanel();
                dBSessionInfo2.setMessageText(UtilsLrb.get("SESSIONS_MUST_BE_DISCONNECTED"));
                dBSessionInfo2.setMessageType(4);
                JTextArea jTextArea = new JTextArea();
                jTextArea.setText(stringBuffer.toString());
                jTextArea.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                detailDialog.setContent((Component)((Object)dBSessionInfo2));
                detailDialog.setDetailContent((Component)jScrollPane);
                jTextArea.setCaretPosition(0);
                detailDialog.setDetailsButtonEnabled(true);
                detailDialog.setButtonTextWhenDetailsShown(UtilsLrb.get("SESSION_DETAILS") + " <<", true);
                detailDialog.setButtonTextWhenDetailsHidden(UtilsLrb.get("SESSION_DETAILS") + " >>", true);
                detailDialog.setDetailVisible(true);
                if (!detailDialog.runDialog()) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            ExceptionHelper.displayException(exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean configureConnection(Context context, String string, RunMode runMode) {
        if (context != null && !(context.getNode() instanceof ConnectionFolder)) {
            throw new IllegalArgumentException("Unexpected Node Type");
        }
        Connection connection = null;
        boolean bl = false;
        Properties properties = new Properties();
        ConnectionFolder connectionFolder = (ConnectionFolder)context.getNode();
        connectionFolder.setConfiguring(true);
        try {
            ConfigurationWorkerDialog configurationWorkerDialog;
            block69: {
                block71: {
                    String string2;
                    block70: {
                        block68: {
                            configurationWorkerDialog = null;
                            connection = ConfigUtils.getSysConnection(string, properties);
                            if (connection == null) {
                                boolean bl2 = false;
                                return bl2;
                            }
                            if (runMode != RunMode.GRANTS) break block68;
                            configurationWorkerDialog = new ConfigurationWorkerDialog(connection, string, runMode, null, null, false, null, context);
                            break block69;
                        }
                        if (runMode != RunMode.INSTALLSCHEMA_OR && runMode != RunMode.INSTALLSCHEMA_BINARY) break block70;
                        try {
                            if (ConfigUtils.isCD$ROOTDatabase(connection)) {
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("NOT_ALLOWED_TO_INSTALL_IN_CDROOT"), (String)UtilsLrb.get("WIZARD_TITLE"), null);
                                boolean bl3 = false;
                                return bl3;
                            }
                        }
                        catch (Exception exception) {
                            ExceptionHelper.displayException(exception, UtilsLrb.get("WIZARD_TITLE"), UtilsLrb.get("ATTEMPTING_TO_VALIDATE_CDROOT"));
                            boolean bl4 = false;
                            return bl4;
                        }
                        if (ConfigUtils.dbHasSchema(connection, ODMRSYS_SCHEMA_NAME) && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("REPOSITORY_PRESENT_MSG"), (String)DataminerNavigatorLrb.get("REPOSITORY_PRESENT_TITLE"), null)) {
                            boolean bl5 = false;
                            return bl5;
                        }
                        Object object = ConfigUtils.validateTextAndXMLDB(connection);
                        if (object != TextAndXMLDBState.BOTH) {
                            String string3 = "";
                            switch (object) {
                                case NONE: {
                                    string3 = DataminerNavigatorLrb.get("NO_TEXT_OR_XMLDB_OPTION");
                                    break;
                                }
                                case XML_DB_ONLY: {
                                    string3 = DataminerNavigatorLrb.get("NO_TEXT_OPTION");
                                    break;
                                }
                                case TEXT_ONLY: {
                                    string3 = DataminerNavigatorLrb.get("NO_XMLDB_OPTION");
                                    break;
                                }
                                default: {
                                    string3 = DataminerNavigatorLrb.get("NO_DATAMINING_OPTION");
                                }
                            }
                            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string3, (String)DataminerNavigatorLrb.get("CONNECTION_ERROR"), null)) {
                                boolean bl6 = false;
                                return bl6;
                            }
                        }
                        if (!ConfigUtils.isKnowledgeBaseFilesAvailble(connection) && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("KNOWLEDGE_FILES_MISSING"), (String)DataminerNavigatorLrb.get("KNOWLEDGE_FILES_MISSING_TITTLE"), null)) {
                            boolean bl7 = false;
                            return bl7;
                        }
                        object = new ConfigurationSettingsDialog(connection, context, ConfigurationSettingsDialog.SettingOption.INSTALL_SETTINGS, runMode == RunMode.INSTALLSCHEMA_BINARY);
                        if (!((ConfigurationSettingsDialog)object).invoke()) {
                            boolean bl8 = false;
                            return bl8;
                        }
                        configurationWorkerDialog = new ConfigurationWorkerDialog(((ConfigurationSettingsDialog)object).getConnection(), string, runMode, ((ConfigurationSettingsDialog)object).getDefaultTablespaceName(), ((ConfigurationSettingsDialog)object).getDefaultTempTablespaceName(), false, null, context);
                        break block69;
                    }
                    if (runMode != RunMode.UPGRADE_REPOS_OR && runMode != RunMode.UPGRADE_REPOS_BINARY && runMode != RunMode.MIGRATE_REPOS) break block71;
                    if (!ConfigUtils.areWorkflowsInactive(connection)) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("WORKFLOWS_ARE_NOT_ALL_INACTIVE"), (String)UtilsLrb.get("WIZARD_TITLE"), null);
                        boolean bl9 = false;
                        return bl9;
                    }
                    Object object = ConfigUtils.validateTextAndXMLDB(connection);
                    if (object != TextAndXMLDBState.BOTH) {
                        string2 = "";
                        switch (object) {
                            case NONE: {
                                string2 = DataminerNavigatorLrb.get("NO_TEXT_OR_XMLDB_OPTION");
                                break;
                            }
                            case XML_DB_ONLY: {
                                string2 = DataminerNavigatorLrb.get("NO_TEXT_OPTION");
                                break;
                            }
                            case TEXT_ONLY: {
                                string2 = DataminerNavigatorLrb.get("NO_XMLDB_OPTION");
                                break;
                            }
                            default: {
                                string2 = DataminerNavigatorLrb.get("NO_DATAMINING_OPTION");
                            }
                        }
                        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string2, (String)DataminerNavigatorLrb.get("CONNECTION_ERROR"), null)) {
                            boolean bl10 = false;
                            return bl10;
                        }
                    }
                    object = null;
                    try {
                        try {
                            object = Compatibility.getConfigCompatibility(connection, true);
                        }
                        catch (Exception exception) {
                            ExceptionHelper.displayException(exception);
                            boolean bl11 = false;
                            connectionFolder.setConfiguring(false);
                            SQLHelper.close(connection);
                            connectionFolder.refreshNode();
                            properties.clear();
                            return bl11;
                        }
                    }
                    catch (Exception exception) {
                        ExceptionHelper.displayException(exception, "Unexpected Exception", "Attempting to determine if xml migration is supported by existing xmlschema and db");
                        boolean bl12 = false;
                        return bl12;
                    }
                    if (((Compatibility)object).compatibilityLevel == 8) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("REPOSITORY_NOT_FULLY_INSTALLED"), (String)UtilsLrb.get("WIZARD_TITLE"), null);
                        boolean bl13 = false;
                        return bl13;
                    }
                    if (!ConfigUtils.doesXMLSchemaSupportMigrationForOR(connection, (Compatibility)object)) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("CAN_NOT_MIGRATE_SCHEMA"), (String)UtilsLrb.get("WIZARD_TITLE"), null);
                        boolean bl14 = false;
                        return bl14;
                    }
                    if (!ConfigUtils.isDatabaseCompatibilityLevelAcceptable(context, connection, ((Compatibility)object).getDBVersion(), true)) {
                        boolean bl15 = false;
                        return bl15;
                    }
                    if (!ConfigUtils.displayDisconnectSessionWarning(connection)) {
                        boolean bl16 = false;
                        return bl16;
                    }
                    if (runMode == RunMode.UPGRADE_REPOS_BINARY && ((Compatibility)object).isORToBinaryConversionRequired() && !((Compatibility)object).isODMRSYSDefaultTableSpaceASM()) {
                        string2 = null;
                        if (((Compatibility)object).isORToBinaryConversionRequired() && !((Compatibility)object).isODMRSYSDefaultTableSpaceASM()) {
                            ConfigurationSettingsDialog configurationSettingsDialog = new ConfigurationSettingsDialog(connection, context, ConfigurationSettingsDialog.SettingOption.MIGRATION_SETTINGS, true);
                            if (!configurationSettingsDialog.invoke()) {
                                boolean bl17 = false;
                                return bl17;
                            }
                            string2 = configurationSettingsDialog.getDefaultTablespaceName();
                        }
                        configurationWorkerDialog = new ConfigurationWorkerDialog(connection, string, runMode, null, null, ((Compatibility)object).isORToBinaryConversionRequired(), string2, context);
                    } else {
                        configurationWorkerDialog = runMode == RunMode.UPGRADE_REPOS_BINARY && ((Compatibility)object).isORToBinaryConversionRequired() && ((Compatibility)object).isODMRSYSDefaultTableSpaceASM() ? new ConfigurationWorkerDialog(connection, string, runMode, null, null, ((Compatibility)object).isORToBinaryConversionRequired(), null, context) : new ConfigurationWorkerDialog(connection, string, runMode, null, null, false, null, context);
                    }
                    break block69;
                }
                if (runMode == RunMode.DROP_REPOS) {
                    if (!ConfigUtils.areWorkflowsInactive(connection)) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("WORKFLOWS_ARE_NOT_ALL_INACTIVE"), (String)UtilsLrb.get("WIZARD_TITLE"), null);
                        boolean bl18 = false;
                        return bl18;
                    }
                    if (!ConfigUtils.displayDisconnectSessionWarning(connection)) {
                        boolean bl19 = false;
                        return bl19;
                    }
                    configurationWorkerDialog = new ConfigurationWorkerDialog(connection, string, runMode, null, null, false, null, context);
                }
            }
            bl = configurationWorkerDialog.getResult();
        }
        finally {
            connectionFolder.setConfiguring(false);
            SQLHelper.close(connection);
            connectionFolder.refreshNode();
            properties.clear();
        }
        return bl;
    }

    public static boolean isDatabaseCompatibilityLevelAcceptable(Context context, Connection connection, Version version, boolean bl) throws SQLException {
        boolean bl2 = Compatibility.checkCompatibilityLevel(context, connection);
        if (!bl2) {
            if (!ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_0, ConfigUtils.getCompatibleLevel(connection), true) && ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_4, version, true)) {
                MessageDialog.critical((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("COMPATIBLE_LEVEL_INSTALLATION_11204_ABOVE"), (String)DataminerNavigatorLrb.get("COMPATIBLE_LEVEL_TITLE"), null);
                return false;
            }
            if (!bl && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("COMPATIBLE_LEVEL_INSTALLATION"), (String)DataminerNavigatorLrb.get("COMPATIBLE_LEVEL_TITLE"), null)) {
                return false;
            }
        }
        return true;
    }

    private static Connection getSysConnection(String string, Properties properties) {
        Connection connection = null;
        try {
            connection = ConnectionFolder.getSYSDBAConnection(string, "SYS", properties);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_TITLE"), (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_MSG"), null);
        }
        return connection;
    }

    public static boolean dbHasSchema(Connection connection, String string) {
        boolean bl = false;
        if (connection == null) {
            return bl;
        }
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement("select username from  dba_users where username = '" + string + "'");
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                bl = true;
            }
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
        }
        return bl;
    }

    public static boolean checkSHTableExistance(Connection connection) {
        int n = 0;
        if (connection == null) {
            throw new RuntimeException("Null connection not expected");
        }
        String string = "Select COUNT(*) VALUE from dba_all_tables where OWNER='SH' and Table_Name in ('CUSTOMERS','SALES','CAL_MONTH_SALES_MV','PRODUCTS','SUPPLEMENTARY_DEMOGRAPHICS','COUNTRIES','CHANNELS','COSTS','FWEEK_PSCAT_SALES_MV','PROMOTIONS','TIMES')";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            sQLHelper.rs.next();
            n = sQLHelper.rs.getInt("VALUE");
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return 11 == n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ODMRSYS_STATUS getODMRSYSRepositoryStatus(ConnectionManager connectionManager) throws SQLException {
        Object object;
        ODMRSYS_STATUS oDMRSYS_STATUS = ODMRSYS_STATUS.UNKNOWN;
        boolean bl = false;
        String string = "SELECT PROPERTY_STR_VALUE FROM ODMR_REPOSITORY_PROPERTIES WHERE PROPERTY_NAME = 'REPOSITORY_STATUS'";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next() && (bl = true)) {
                object = sQLHelper.rs.getString(1);
                oDMRSYS_STATUS = ODMRSYS_LOADED.equals(object) ? ODMRSYS_STATUS.LOADED : (ODMRSYS_NOT_LOADED.equals(object) ? ODMRSYS_STATUS.NOT_LOADED : ODMRSYS_STATUS.DETECT_ODMRSYS_PRESENT_BUT_NO_STATUS);
            }
        }
        if (!bl) {
            object = DatabaseMetadataUtils.getAccessibleSchemas(connectionManager, null);
            Iterator<String> iterator = ((Vector)object).iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                if (!string2.equals(ODMRSYS_SCHEMA_NAME)) continue;
                oDMRSYS_STATUS = ODMRSYS_STATUS.DETECT_ODMRSYS_PRESENT_BUT_NO_STATUS;
                break;
            }
        }
        return oDMRSYS_STATUS;
    }

    public static boolean isODMRSYSLoaded(Connection connection) {
        boolean bl = false;
        if (connection == null) {
            throw new RuntimeException("Null connection not expected");
        }
        String string = "SELECT PROPERTY_STR_VALUE FROM ODMR_REPOSITORY_PROPERTIES WHERE PROPERTY_NAME = 'REPOSITORY_STATUS' AND PROPERTY_STR_VALUE = 'LOADED'";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                bl = true;
            }
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCD$ROOTDatabase(Connection connection) throws SQLException {
        boolean bl;
        block7: {
            bl = false;
            String string = "SELECT SYS_CONTEXT ('USERENV', 'CON_NAME') AS NAME FROM DUAL ";
            String string2 = "";
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.pstmt = connection.prepareStatement(string);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                if (sQLHelper.rs.next() && CD$ROOT.equals(string2 = sQLHelper.rs.getString("NAME"))) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPARALLEL_QUERY_ALLOWED(ConnectionManager connectionManager, String string) {
        boolean bl = false;
        String string2 = null;
        String string3 = "SELECT PROPERTY_STR_VALUE FROM ODMR_REPOSITORY_PROPERTIES WHERE PROPERTY_NAME = :1";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string2 = sQLHelper.rs.getString(1);
                string2 = string2.toUpperCase();
            }
        }
        bl = "TRUE".equals(string2);
        return bl;
    }

    public static boolean isPARALLEL_QUERY_ON_ALLOWED(ConnectionManager connectionManager) {
        return ConfigUtils.isPARALLEL_QUERY_ALLOWED(connectionManager, "PARALLEL_QUERY_ON_ALLOWED");
    }

    public static boolean isPARALLEL_QUERY_OFF_ALLOWED(ConnectionManager connectionManager) {
        return ConfigUtils.isPARALLEL_QUERY_ALLOWED(connectionManager, "PARALLEL_QUERY_OFF_ALLOWED");
    }

    public static Version getCompatibleLevel(Connection connection) {
        String string = "";
        if (connection == null) {
            throw new RuntimeException("Null connection not expected");
        }
        String string2 = "select VALUE from database_compatible_level";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            sQLHelper.rs.next();
            string = sQLHelper.rs.getString("VALUE");
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
        }
        return new Version(string);
    }

    public static boolean isODMRSYSNotLoaded(Connection connection) {
        boolean bl = false;
        if (connection == null) {
            throw new RuntimeException("Null connection not expected");
        }
        String string = "SELECT PROPERTY_STR_VALUE FROM ODMR_REPOSITORY_PROPERTIES WHERE PROPERTY_NAME = 'REPOSITORY_STATUS' AND PROPERTY_STR_VALUE = 'NOT_LOADED'";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                bl = true;
            }
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
        }
        return bl;
    }

    public static boolean isBinaryInstallationRequired(Version version) {
        return ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_4, version, true);
    }

    public static boolean doesODMRSYSDefaultTableSpaceSupportBinary(Connection connection) throws Exception {
        String string = ConfigUtils.getODMRSYSDefaultTableSpace(connection);
        if (ConfigUtils.isTableSpaceASMBased(connection, string, true)) {
            return ConfigUtils.isExtentSizeCorrect(connection, string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isWorkflowDataColumnBinaryStorage(Connection connection, boolean bl) {
        boolean bl2 = false;
        String string = "select odmrsys.odmr_util.is_binary_xml from dual";
        String string2 = "select STORAGE_TYPE from ALL_XML_TAB_COLS WHERE TABLE_NAME='ODMR$WORKFLOWS' AND OWNER = 'ODMRSYS'  AND COLUMN_NAME='WORKFLOW_DATA'";
        if (connection == null) {
            throw new RuntimeException("Null connection not expected");
        }
        String string3 = bl ? string2 : string;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            sQLHelper.rs.next();
            bl2 = bl ? sQLHelper.rs.getString(1).compareTo("BINARY") == 0 : sQLHelper.rs.getBoolean(1);
            sQLHelper.close();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExtentSizeCorrect(Connection connection, String string) {
        boolean bl = false;
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string2;
            sQLHelper.pstmt = connection.prepareStatement("SELECT value FROM v$parameter WHERE name = 'db_securefile'");
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next() && (string2 = sQLHelper.rs.getString(1)).compareTo("ALWAYS") == 0) {
                bl = true;
            }
        }
        if (bl) {
            try {
                sQLHelper.pstmt = connection.prepareStatement("SELECT block_size, initial_extent FROM dba_tablespaces WHERE tablespace_name = ?");
                sQLHelper.pstmt.setString(1, string);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                if (sQLHelper.rs.next()) {
                    int n = sQLHelper.rs.getInt(1);
                    int n2 = sQLHelper.rs.getInt(2);
                    if (n2 <= n * 14) {
                        boolean bl2 = false;
                        return bl2;
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(ConfigUtils.class.getName()).log(Level.WARNING, sQLException.getMessage(), sQLException);
            }
            finally {
                sQLHelper.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getODMRSYSDefaultTableSpace(Connection connection) throws Exception {
        String string = "";
        if (connection == null) {
            throw new RuntimeException("Null connection not expected");
        }
        String string2 = "select DEFAULT_TABLESPACE from DBA_USERS where username = 'ODMRSYS'";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.pstmt = connection.prepareStatement(string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            sQLHelper.rs.next();
            string = sQLHelper.rs.getString("DEFAULT_TABLESPACE");
            sQLHelper.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTableSpaceASMBased(Connection connection, String string, boolean bl) throws Exception {
        boolean bl2 = false;
        if (connection == null) {
            throw new RuntimeException("Null connection not expected");
        }
        String string2 = "SELECT SEGMENT_SPACE_MANAGEMENT FROM" + (bl ? " dba_tablespaces " : " user_tablespaces ") + "  WHERE tablespace_name = ?";
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string3 = "";
            sQLHelper.pstmt = connection.prepareStatement(string2);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            sQLHelper.rs.next();
            string3 = sQLHelper.rs.getString("SEGMENT_SPACE_MANAGEMENT");
            bl2 = string3.compareTo("AUTO") == 0;
            sQLHelper.close();
        }
        return bl2;
    }

    public static boolean areWorkflowsInactive(Connection connection) {
        boolean bl = false;
        if (connection == null) {
            throw new IllegalArgumentException("Null connection not expected");
        }
        String string = "SELECT count(*) WORKFLOWS_NOT_INACTIVE FROM ALL_SCHEDULER_JOBS WHERE JOB_TYPE = 'CHAIN' AND ENABLED='TRUE' AND JOB_ACTION like 'ODMR$WFCHAIN%'";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            int n = 0;
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            sQLHelper.rs.next();
            n = sQLHelper.rs.getInt("WORKFLOWS_NOT_INACTIVE");
            bl = n == 0;
            sQLHelper.close();
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 942) {
                bl = true;
            }
            sQLHelper.close();
        }
        return bl;
    }

    public static boolean doesXMLSchemaSupportMigrationForOR(Connection connection, Compatibility compatibility) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        if (connection == null) {
            throw new RuntimeException("Null connection not expected");
        }
        if (compatibility.getXmlSchemaVersion().compareTo((Object)CURRENT_WF_SCHEMA_IN_CLIENT) == 0) {
            return true;
        }
        if (ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_3, compatibility.getDBVersion(), true)) {
            return true;
        }
        String string = "SELECT INSTR(XMLSerialize(CONTENT SCHEMA AS CLOB), 'xdb:maintainDOM=\"false\"', 1, 1)  AS MAINTAIN_DOM  \n       FROM DBA_XML_SCHEMAS WHERE schema_url = 'http://xmlns.oracle.com/odmr11/odmr.xsd' AND owner = 'ODMRSYS'";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            int n = 0;
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            sQLHelper.rs.next();
            n = sQLHelper.rs.getInt("MAINTAIN_DOM");
            bl = n == 0;
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
            throw exception;
        }
        if (bl) {
            return true;
        }
        string = "SELECT PROPERTY_STR_VALUE AS MAINTAIN_DOM_PATCH FROM ODMRSYS.ODMR$REPOSITORY_PROPERTIES WHERE PROPERTY_NAME = 'MAINTAIN_DOM_PATCH_INSTALLED'";
        sQLHelper = new SQLHelper();
        try {
            String string2 = null;
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string2 = sQLHelper.rs.getString("MAINTAIN_DOM_PATCH");
            }
            bl2 = string2 == null ? false : string2.compareTo("TRUE") == 0;
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
            throw exception;
        }
        return bl2;
    }

    public static boolean setODMRSYSStatus(Connection connection, String string) {
        boolean bl = false;
        if (connection == null) {
            return bl;
        }
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string2 = "UPDATE ODMRSYS.ODMR$REPOSITORY_PROPERTIES\n   SET PROPERTY_STR_VALUE = '" + string + "' " + "   WHERE PROPERTY_NAME = 'REPOSITORY_STATUS'";
            sQLHelper.pstmt = connection.prepareStatement(string2);
            int n = sQLHelper.pstmt.executeUpdate(string2);
            if (n == 1) {
                bl = true;
            }
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
        }
        return bl;
    }

    public static List<DBSessionInfo> getSessionsRequiringDisconnect(Connection connection) throws Exception {
        ArrayList<DBSessionInfo> arrayList = new ArrayList<DBSessionInfo>();
        if (connection == null) {
            return arrayList;
        }
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string = "select v.sid, v.serial#, v.username, v.status, v.program, v.type , v.module from v$session v, dba_role_privs r\nwhere v.type = 'USER'\nAND v.username not in ('SYS', 'sys', 'SYSTEM', 'system')\nAND v.username = r.grantee\nAND r.granted_role = 'ODMRUSER'\nUNION \nselect v.sid, v.serial#, v.username, v.status, v.program, v.type , v.module from v$session v\nwhere v.type = 'USER'\nand v.username = 'ODMRSYS'";
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                DBSessionInfo dBSessionInfo = new DBSessionInfo(sQLHelper.rs.getString("USERNAME"), sQLHelper.rs.getString("STATUS"), sQLHelper.rs.getString("TYPE"), sQLHelper.rs.getString("PROGRAM"), sQLHelper.rs.getString("MODULE"), sQLHelper.rs.getInt("SID"), sQLHelper.rs.getInt("SERIAL#"));
                arrayList.add(dBSessionInfo);
            }
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
            throw exception;
        }
        return arrayList;
    }

    public static boolean setDBRestricted(Connection connection, boolean bl) {
        boolean bl2 = false;
        if (connection == null) {
            return bl2;
        }
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string = bl ? "alter system enable restricted session" : "alter system disable restricted session";
            sQLHelper.pstmt = connection.prepareStatement(string);
            int n = sQLHelper.pstmt.executeUpdate(string);
            if (n == 0) {
                bl2 = true;
            }
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
        }
        return bl2;
    }

    public static Boolean isReleaseWithNoMigration(Version version) {
        Version version2;
        Boolean bl = Boolean.FALSE;
        int[] nArray = version.toIntArray();
        if (nArray.length > 5) {
            int[] nArray2 = Arrays.copyOf(nArray, 5);
            version2 = new Version(nArray2);
        } else {
            version2 = version;
        }
        for (int i = 0; i < KNOWN_RELEASES_REQUIRE_UPGRADE.length; ++i) {
            if (!version2.equals((Object)KNOWN_RELEASES_REQUIRE_UPGRADE[i])) continue;
            bl = Boolean.TRUE;
            break;
        }
        return bl;
    }

    public static Boolean isAlphaRelease(Version version) {
        Version version2;
        Boolean bl = Boolean.FALSE;
        int[] nArray = version.toIntArray();
        if (nArray.length > 5) {
            int[] nArray2 = Arrays.copyOf(nArray, 5);
            version2 = new Version(nArray2);
        } else {
            version2 = version;
        }
        for (int i = 0; i < KNOWN_ALPHA_RELEASES.length; ++i) {
            if (!version2.equals((Object)KNOWN_ALPHA_RELEASES[i])) continue;
            bl = Boolean.TRUE;
            break;
        }
        return bl;
    }

    public static boolean isExtendedDataType(Connection connection) {
        block3: {
            StringBuilder stringBuilder = new StringBuilder(4100);
            stringBuilder.append("SELECT '");
            for (int i = 0; i < 4005; ++i) {
                stringBuilder.append('a');
            }
            stringBuilder.append("' FROM dual");
            SQLHelper sQLHelper = new SQLHelper();
            try {
                sQLHelper.pstmt = connection.prepareStatement(stringBuilder.toString());
                sQLHelper.pstmt.execute();
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 1704) break block3;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean privsForTablespace(ConnectionManager connectionManager) {
        String string = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            string = "Select * from user_ts_quotas where tablespace_name = (select default_tablespace from user_users)";
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            if (sQLHelper.rs.next()) {
                sQLHelper.rs.getString("tablespace_name");
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJSONSchemaGeneratorInstalled(ConnectionManager connectionManager) {
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement("select count(*) from all_objects where owner='ODMRSYS' and object_type='JAVA CLASS' and object_name='odmr/JSONSchemaGenerator'");
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                int n = sQLHelper.rs.getInt(1);
                boolean bl = n > 0;
                return bl;
            }
        }
        return false;
    }

    public static void writeToInstallLog(BufferedOutputStream bufferedOutputStream, String string) {
        string = string + "\n";
        try {
            bufferedOutputStream.write(string.getBytes(Charset.forName("UTF-8")));
        }
        catch (IOException iOException) {
            Logger.getLogger(ConfigUtils.class.getName()).log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
        }
    }

    public static class DBSessionInfo {
        String _userName;
        String _status;
        String _type;
        String _program;
        String _module;
        Integer _sid;
        Integer _serial;

        public DBSessionInfo(String string, String string2, String string3, String string4, String string5, Integer n, Integer n2) {
            this._userName = string;
            this._status = string2;
            this._type = string3;
            this._program = string4;
            this._module = string5;
            this._sid = n;
            this._serial = n2;
        }

        public String getUserName() {
            return this._userName;
        }

        public String getStatus() {
            return this._status;
        }

        public String getType() {
            return this._type;
        }

        public String getModule() {
            return this._module;
        }

        public Integer getSid() {
            return this._sid;
        }

        public Integer getSerial() {
            return this._serial;
        }

        public String getProgram() {
            return this._program;
        }
    }

    public static class Compatibility {
        public static final int COMPATIBLE = 1;
        public static final int NOT_COMPATIBLE_OLD_CLIENT = 2;
        public static final int NOT_COMPATIBLE_UPGRADABLE = 3;
        public static final int NOT_COMPATIBLE_MIGRATABLE = 4;
        public static final int NOT_COMPATIBLE_OVERWRITE = 5;
        public static final int NOT_COMPATIBLE = 6;
        public static final int DB_NOT_COMPATIBLE_XML_SCHEMA_112019 = 7;
        public static final int REPOSITORY_NOT_INSTALLED_COMPLETELY = 8;
        public static final int DB_UPGRADE_DETECTED_MUST_UPGRADE_TO_BINARY_XML = 9;
        private Version clientVersion = null;
        private Version reposVersion = null;
        private Version xmlSchemaVersion = null;
        private Version dbVersion = null;
        private int compatibilityLevel;
        private boolean isORToBinaryConversionRequired = false;
        private boolean isWorkflowDataColumnBinary = false;
        private boolean isODMRSYSDefaultTableSpaceASM = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Compatibility getCompatibility(Context context) throws Exception {
            Compatibility compatibility = new Compatibility();
            compatibility.clientVersion = ConfigUtils.getClientVersion();
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
            compatibility.reposVersion = connectionFolder.getReposVersion();
            compatibility.xmlSchemaVersion = connectionFolder.getSchemaVersion();
            compatibility.dbVersion = connectionFolder.getDbVersion();
            if (ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_4, compatibility.dbVersion, true) && compatibility.reposVersion.compareTo((Object)INITITAL_BINARY_XML_REPOSITORY_RELEASE_VERSION) >= 0) {
                Connection connection = ConnectionFolder.getConnection(context);
                try {
                    compatibility.isWorkflowDataColumnBinary = ConfigUtils.isWorkflowDataColumnBinaryStorage(connection, false);
                }
                finally {
                    SQLHelper.close(connection);
                }
            } else {
                compatibility.isWorkflowDataColumnBinary = false;
            }
            Compatibility.initCompatibilityLevel(compatibility, compatibility.reposVersion);
            return compatibility;
        }

        public static Compatibility getConfigCompatibility(Connection connection, boolean bl) throws Exception {
            Compatibility compatibility = new Compatibility();
            Map<VersionInfoType, Version> map = ConfigUtils.getVersionInfo(connection);
            compatibility.clientVersion = ConfigUtils.getClientVersion();
            compatibility.reposVersion = map.get((Object)VersionInfoType.RepositoryVersion);
            compatibility.xmlSchemaVersion = map.get((Object)VersionInfoType.XmlSchemaVersion);
            compatibility.dbVersion = map.get((Object)VersionInfoType.DatabaseVersion);
            Compatibility.initCompatibilityLevel(compatibility, compatibility.reposVersion);
            if (compatibility.reposVersion.compareTo((Object)INITITAL_BINARY_XML_REPOSITORY_RELEASE_VERSION) >= 0) {
                compatibility.isWorkflowDataColumnBinary = ConfigUtils.isWorkflowDataColumnBinaryStorage(connection, bl);
            }
            compatibility.isODMRSYSDefaultTableSpaceASM = ConfigUtils.doesODMRSYSDefaultTableSpaceSupportBinary(connection);
            Compatibility.isORtoBinaryMigrationRequired(compatibility);
            return compatibility;
        }

        private static boolean isORtoBinaryMigrationRequired(Compatibility compatibility) throws Exception {
            compatibility.isORToBinaryConversionRequired = false;
            if (compatibility.reposVersion.compareTo((Object)INITITAL_BINARY_XML_REPOSITORY_RELEASE_VERSION) < 0 && ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_4, compatibility.getDBVersion(), true)) {
                compatibility.isORToBinaryConversionRequired = true;
            } else if (compatibility.reposVersion.compareTo((Object)INITITAL_BINARY_XML_REPOSITORY_RELEASE_VERSION) >= 0 && ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_4, compatibility.getDBVersion(), true) && !compatibility.isWorkflowDataColumnBinary) {
                compatibility.isORToBinaryConversionRequired = true;
            }
            return compatibility.isORToBinaryConversionRequired;
        }

        public static boolean checkCompatibilityLevel(Context context, Connection connection) throws SQLException {
            int[] nArray = ConfigUtils.getCompatibleLevel(connection).toIntArray();
            int[] nArray2 = ((ReusableConnection)connection).getDatabaseVersion().toIntArray();
            if (nArray != null && nArray2 != null) {
                if (nArray2[0] == 12 && nArray2[1] == 1) {
                    return nArray[0] == 12 && nArray[1] == 1 || nArray[0] == 12 && nArray[1] == 0;
                }
                if (nArray[0] != nArray2[0]) {
                    return false;
                }
                return nArray[1] == nArray2[1];
            }
            return false;
        }

        private static void initCompatibilityLevel(Compatibility compatibility, Version version) throws Exception {
            if (compatibility.getReposVersion() == null) {
                compatibility.compatibilityLevel = 8;
                return;
            }
            if (version.equals((Object)KNOWN_RELEASE_COMPATIBLE)) {
                compatibility.compatibilityLevel = 1;
                if (Compatibility.detectedDBUpgradeAndXMLSchemaBug(compatibility)) {
                    compatibility.compatibilityLevel = 7;
                } else if (Compatibility.isORtoBinaryMigrationRequired(compatibility)) {
                    compatibility.compatibilityLevel = 9;
                }
                return;
            }
            for (Version version2 : KNOWN_RELEASES_REQUIRE_UPGRADE) {
                if (!version.equals((Object)version2)) continue;
                compatibility.compatibilityLevel = 3;
                return;
            }
            for (Version version2 : KNOWN_RELEASES_REQUIRE_MIGRATION) {
                if (!version.equals((Object)version2)) continue;
                compatibility.compatibilityLevel = 4;
                return;
            }
            for (Version version2 : KNOWN_ALPHA_RELEASES) {
                if (!version.equals((Object)version2)) continue;
                compatibility.compatibilityLevel = 5;
                return;
            }
            if (version.compareTo((Object)KNOWN_RELEASE_COMPATIBLE) > 0) {
                compatibility.compatibilityLevel = 2;
                return;
            }
            compatibility.compatibilityLevel = 6;
        }

        private static boolean detectedDBUpgradeAndXMLSchemaBug(Compatibility compatibility) {
            boolean bl = false;
            Version version = new Version("11.2.0.1.9");
            Version version2 = compatibility.getXmlSchemaVersion();
            if (version.equals((Object)version2)) {
                Version version3 = compatibility.getDBVersion();
                bl = !ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_1, version3) && !ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_2, version3);
            }
            return bl;
        }

        public int getCompatibilityLevel() {
            return this.compatibilityLevel;
        }

        public Version getClientVersion() {
            return this.clientVersion;
        }

        public Version getReposVersion() {
            return this.reposVersion;
        }

        public Version getXmlSchemaVersion() {
            return this.xmlSchemaVersion;
        }

        public Version getDBVersion() {
            return this.dbVersion;
        }

        public boolean isORToBinaryConversionRequired() {
            return this.isORToBinaryConversionRequired;
        }

        public boolean isWorkflowDataColumnBinary() {
            return this.isWorkflowDataColumnBinary;
        }

        public boolean isODMRSYSDefaultTableSpaceASM() {
            return this.isODMRSYSDefaultTableSpaceASM;
        }
    }

    public static enum VersionInfoType {
        DatabaseVersion,
        RepositoryVersion,
        XmlSchemaVersion;

    }

    public static enum ODMRSYS_STATUS {
        LOADED,
        NOT_LOADED,
        DETECT_ODMRSYS_PRESENT_BUT_NO_STATUS,
        UNKNOWN;

    }

    public static enum TextAndXMLDBState {
        NONE,
        TEXT_ONLY,
        XML_DB_ONLY,
        BOTH;

    }

    public static enum RunMode {
        INSTALLSCHEMA_OR,
        INSTALLSCHEMA_BINARY,
        GRANTS,
        UPGRADE_REPOS_OR,
        UPGRADE_REPOS_BINARY,
        MIGRATE_REPOS,
        DROP_REPOS;

    }
}

