/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataDisplay;
import oracle.dmt.dataminer.controls.GraphPanel2;
import oracle.dmt.dataminer.controls.Reloadable;
import oracle.dmt.dataminer.controls.renderers.ColorCellRenderer;
import oracle.dmt.dataminer.controls.renderers.DateCellRenderer2;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestResultsSelectorPanel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.TestViewerPartitionToolbar;
import oracle.dmt.dataminer.tviewer.roc.ROCDetailPanel;
import oracle.dmt.dataminer.tviewer.roc.ROCEditor;
import oracle.dmt.dataminer.tviewer.roc.ROCTabPanelState;
import oracle.dmt.dataminer.tviewer.roc.ThresholdPanel;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class ROCTabPanel
extends DataMinerViewGUI
implements GraphDataDisplay,
Reloadable {
    private GraphPanel2 _graphPanel;
    private ROCTabPanelState _state;
    private boolean _loading = true;
    private BlockingComponent overLayPanel = null;
    private DataMinerTablePanel dataMinerTablePanel;
    private JButton jCustomROCButton;
    private JPanel jRocGraphPanel;
    private JSplitPane jSplitPane1;
    private JComboBox<String> jTargetComb;
    private JLabel jTargetLbl;
    private TestViewerPartitionToolbar testViewerPartitionToolbar1;
    private JButton jDetailBtn;
    private JButton _jBT_AddOrRemove;

    public ROCTabPanel(ROCEditor rOCEditor, Context context) {
        super(rOCEditor, context);
        this._state = new ROCTabPanelState((SharedTestEditorState)rOCEditor.getCachedLegendState(), context);
        boolean bl = false;
        List<TestResult> list = this._state.getParentTestViewerState().getTestResults();
        for (TestResult testResult : list) {
            if (!((ClassTestResult)testResult).rocResultExists()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.initComponents();
            this.initGraph();
            this.initRes();
            this.initUI();
        }
    }

    private void initGraph() {
        this._graphPanel = new GraphPanel2(this, new DefaultGraphDataModel(null, null, null, null, null));
        this.jRocGraphPanel.add((Component)new JTextArea(CommonLrb.get("COMMON_LOADING")), "Center");
        this.jRocGraphPanel.updateUI();
    }

    private boolean isEnabledPartitioning() {
        ROCEditor rOCEditor = (ROCEditor)this.getEditor();
        return ((SharedTestEditorState)rOCEditor.getCachedLegendState()).isEnabledPartitioning();
    }

    public void setSelectedPartition() {
        if (!this.testViewerPartitionToolbar1.isVisible()) {
            return;
        }
        String string = this.testViewerPartitionToolbar1.getSelectedPartitionID();
        ROCEditor rOCEditor = (ROCEditor)this.getEditor();
        ((SharedTestEditorState)rOCEditor.getCachedLegendState()).setSelectedPartition(string);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLbl, this.jTargetComb, (String)TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TARGET_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jCustomROCButton, (String)TestViewerLrb.get("ROC_CUSTOM_BTN"));
        this.jCustomROCButton.getAccessibleContext().setAccessibleName(TestViewerLrb.get("ROC_CUSTOM_BTN"));
        this.jCustomROCButton.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("ROC_CUSTOM_BTN_ADA"));
    }

    @Override
    public void initUI() {
        this._loading = true;
        this.dataMinerTablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int[] nArray = ROCTabPanel.this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
                    String string = (String)ROCTabPanel.this._state.getRocTableModel().getValueAt(nArray[0], ROCTabPanel.this._state.getMODEL());
                    ROCDetailPanel rOCDetailPanel = new ROCDetailPanel(ROCTabPanel.this.getContext(), string, ROCTabPanel.this._state.getROCData().get(string));
                    rOCDetailPanel.showAsDialog(ROCTabPanel.this);
                }
            }
        });
        this.installROCSummaryActions();
        this.dataMinerTablePanel.setTitle(CommonLrb.get("COMMON_MODELS"));
        this.initializeControls();
        this.jSplitPane1.setDividerLocation(0.75);
        this.jSplitPane1.setResizeWeight(0.75);
        if (this.isEnabledPartitioning()) {
            this.testViewerPartitionToolbar1.setEditor(this.getEditor());
            this.setSelectedPartition();
        } else {
            this.testViewerPartitionToolbar1.setVisible(false);
        }
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    private void enableControls(boolean bl) {
        this.jTargetComb.setEnabled(bl);
        this.jCustomROCButton.setEnabled(bl);
        this.jDetailBtn.setEnabled(bl && this.dataMinerTablePanel.getTable().getSelectedRowCount() > 0);
    }

    private void initializeControls() {
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        ROCTabPanelState rOCTabPanelState = new ROCTabPanelState(this._state.getParentTestViewerState(), this.getContext());
        rOCTabPanelState.getClass();
        dataMinerTable.setModel((TableModel)((Object)new ROCTabPanelState.ROCTableModel(rOCTabPanelState, this.isEnabledPartitioning())));
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{CommonLrb.get("COMMON_LOADING")}));
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        ListSelectionModel listSelectionModel = this.dataMinerTablePanel.getTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ROCTabPanel.this._loading) {
                    return;
                }
                ROCTabPanel.this.jROCSummaryTableValueChanged(listSelectionEvent);
                ROCTabPanel.this.getEditor().updateSelection();
            }
        });
        this.enableControls(false);
    }

    public void jROCSummaryTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            String string = (String)this._state.getRocTableModel().getValueAt(nArray[0], this._state.getMODEL());
            this._state.setSelectedTestResult(string);
            this.enableControls(true);
            this.fireViewPropertySelectionChange(this, string);
        }
    }

    public ROCTabPanelState.ROCData getROCData() {
        String string = this._state.getSelectedTestResult();
        if (string == null) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            if (nArray.length > 0 && -1 != nArray[0]) {
                string = (String)this._state.getRocTableModel().getValueAt(nArray[0], this._state.getMODEL());
                this._state.setSelectedTestResult(string);
            }
            if (string == null) {
                return null;
            }
        }
        int n = this._state.getStatisticsData().get(string).getMaxOverallAccuracyIdx();
        ROCTabPanelState.ROCData rOCData = this._state.getROCData().get(string).get(n);
        rOCData.setLabel(string);
        return rOCData;
    }

    private void initComponents() {
        this.jTargetLbl = new JLabel();
        this.jTargetComb = new JComboBox();
        this.jCustomROCButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jRocGraphPanel = new JPanel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.testViewerPartitionToolbar1 = new TestViewerPartitionToolbar();
        this.jTargetLbl.setText("Target Value:");
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        this.jCustomROCButton.setText("Edit Custom Operating Point...");
        this.jCustomROCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jCustomROCActionPerformed(actionEvent);
            }
        });
        this.jSplitPane1.setDividerLocation(390);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jRocGraphPanel.setMinimumSize(new Dimension(100, 100));
        this.jRocGraphPanel.setPreferredSize(new Dimension(652, 389));
        this.jRocGraphPanel.setLayout(new BorderLayout());
        this.jSplitPane1.setTopComponent(this.jRocGraphPanel);
        this.jSplitPane1.setRightComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -2, 0, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTargetLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetComb, 0, 144, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 95, Short.MAX_VALUE).addComponent(this.jCustomROCButton, -1, 267, Short.MAX_VALUE)).addComponent(this.testViewerPartitionToolbar1, GroupLayout.Alignment.TRAILING, -1, 575, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.testViewerPartitionToolbar1, -2, -1, -2).addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLbl).addComponent(this.jCustomROCButton).addComponent(this.jTargetComb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 468, Short.MAX_VALUE).addContainerGap()));
    }

    private void installROCSummaryActions() {
        this.dataMinerTablePanel.removeSearchField();
        this.jDetailBtn = new JButton(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setDisabledIcon(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setToolTipText(TestViewerLrb.get("ROC_DETAIL_DIALOG"));
        this.jDetailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jDetailBtnActionPerformed(actionEvent);
            }
        });
        if (this._state.getParentTestViewerState().getAllTestResults().size() > 1) {
            this._jBT_AddOrRemove = new JButton(OracleIcons.getIcon((String)"compare.png"));
            this._jBT_AddOrRemove.setDisabledIcon(OracleIcons.getIcon((String)"compare.png"));
            this._jBT_AddOrRemove.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this._jBT_AddOrRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ROCTabPanel.this._jBT_Compare_AddOrRemove_actionPerformed(actionEvent);
                }
            });
            this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn, this._jBT_AddOrRemove);
        } else {
            this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn);
        }
    }

    private void _jBT_Compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        TestResultsSelectorPanel testResultsSelectorPanel = new TestResultsSelectorPanel(this._state.getParentTestViewerState());
        if (testResultsSelectorPanel.showAsDialog(this)) {
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            }
            List<TestResult> list = testResultsSelectorPanel.getSelectedTestResults();
            this._state.getParentTestViewerState().setTestResults(list);
            this.jRocGraphPanel.removeAll();
            this.jRocGraphPanel.add((Component)new JTextArea(CommonLrb.get("COMMON_LOADING")), "Center");
            DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
            ROCTabPanelState rOCTabPanelState = new ROCTabPanelState(this._state.getParentTestViewerState(), this.getContext());
            rOCTabPanelState.getClass();
            dataMinerTable.setModel((TableModel)((Object)new ROCTabPanelState.ROCTableModel(rOCTabPanelState, this.isEnabledPartitioning())));
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(false);
            loadUI.execute();
        }
    }

    private void jEditCustOPBtnActionPerformed(ActionEvent actionEvent) {
        ThresholdPanel thresholdPanel = new ThresholdPanel(this._state);
        if (thresholdPanel.showAsDialog(this)) {
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            }
            this._state.refreshCustomThresholdData();
            this.jRocGraphPanel.removeAll();
            this.jRocGraphPanel.add((Component)new JTextArea(CommonLrb.get("COMMON_LOADING")), "Center");
            DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
            ROCTabPanelState rOCTabPanelState = new ROCTabPanelState(this._state.getParentTestViewerState(), this.getContext());
            rOCTabPanelState.getClass();
            dataMinerTable.setModel((TableModel)((Object)new ROCTabPanelState.ROCTableModel(rOCTabPanelState, this.isEnabledPartitioning())));
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(true);
            loadUI.execute();
        }
    }

    @Override
    public void reload() {
        ROCEditor rOCEditor = (ROCEditor)this.getEditor();
        this._state = new ROCTabPanelState((SharedTestEditorState)rOCEditor.getCachedLegendState(), this.getContext());
        this._context = rOCEditor.getContext();
        this._state.setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        this.enableControls(false);
        this.setSelectedPartition();
        LoadUI loadUI = new LoadUI(true);
        loadUI.execute();
    }

    private void jDetailBtnActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        String string = (String)this._state.getRocTableModel().getValueAt(nArray[0], this._state.getMODEL());
        ROCDetailPanel rOCDetailPanel = new ROCDetailPanel(this.getContext(), string, this._state.getROCData().get(string));
        rOCDetailPanel.showAsDialog(this);
    }

    private void jTargetCombActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this._state.setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        this._loading = true;
        this.jRocGraphPanel.removeAll();
        this.jRocGraphPanel.add((Component)new JTextArea(CommonLrb.get("COMMON_LOADING")), "Center");
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        ROCTabPanelState rOCTabPanelState = new ROCTabPanelState(this._state.getParentTestViewerState(), this.getContext());
        rOCTabPanelState.getClass();
        dataMinerTable.setModel((TableModel)((Object)new ROCTabPanelState.ROCTableModel(rOCTabPanelState, this.isEnabledPartitioning())));
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(true);
        loadUI.execute();
    }

    private void jCustomROCActionPerformed(ActionEvent actionEvent) {
        this.jEditCustOPBtnActionPerformed(actionEvent);
    }

    public void setCachedPropertyState(Object object) {
    }

    public Object getCachedPropertyState() {
        return this._state;
    }

    @Override
    public void showData(Object object) {
        this.jDetailBtnActionPerformed(null);
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        protected Object doInBackground() throws Exception {
            try {
                if (this._reload) {
                    ROCTabPanel.this._state.refreshROCStatData(ROCTabPanel.this.isEnabledPartitioning());
                } else {
                    ROCTabPanel.this._state.load(ROCTabPanel.this.isEnabledPartitioning());
                }
                ROCTabPanel.this._graphPanel.initGraph(ROCTabPanel.this._state.getRocGraphModel());
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return ROCTabPanel.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    ROCTabPanel.this.jRocGraphPanel.removeAll();
                    ROCTabPanel.this.jRocGraphPanel.add((Component)ROCTabPanel.this._graphPanel, "Center");
                    ROCTabPanel.this.jRocGraphPanel.updateUI();
                    String string = ROCTabPanel.this._state.getSelectedTestResult();
                    ROCTabPanel.this.dataMinerTablePanel.getTable().setFixedColumns(1, 165);
                    ROCTabPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)ROCTabPanel.this._state.getRocTableModel()));
                    ROCTabPanel.this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
                    ROCTabPanel.this.dataMinerTablePanel.getTable().setSorted(true);
                    NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
                    ColorCellRenderer colorCellRenderer = new ColorCellRenderer(new ColorCellRenderer.ColorChooser(){

                        @Override
                        public Color getColorFor(Object object) {
                            String string = (String)object;
                            return ROCTabPanel.this._state.getParentTestViewerState().getTestResultGraphColor(string);
                        }
                    });
                    TableColumnModel tableColumnModel = ROCTabPanel.this.dataMinerTablePanel.getTable().getFullColumnModel();
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getMODEL()).setCellRenderer(colorCellRenderer);
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getAREA_UNDER_CURVE()).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getCURRENT()).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getCUSTOM()).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getMAX_AVG()).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getMAX_OVERALL()).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getCREATION_DATE()).setCellRenderer(new DateCellRenderer2());
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getAREA_UNDER_CURVE()).setPreferredWidth(120);
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getMAX_OVERALL()).setPreferredWidth(150);
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getMAX_AVG()).setPreferredWidth(150);
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getCUSTOM()).setPreferredWidth(125);
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getCURRENT()).setPreferredWidth(120);
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getALGORITHM()).setPreferredWidth(135);
                    tableColumnModel.getColumn(ROCTabPanel.this._state.getCREATION_DATE()).setPreferredWidth(135);
                    int n = 0;
                    if (string == null) {
                        double d = 0.0;
                        double d2 = 0.0;
                        for (int i = 0; i < ROCTabPanel.this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                            d = (Double)ROCTabPanel.this._state.getRocTableModel().getValueAt(i, ROCTabPanel.this._state.getAREA_UNDER_CURVE());
                            if (!(d2 < d)) continue;
                            d2 = d;
                            n = i;
                        }
                    } else {
                        for (int i = 0; i < ROCTabPanel.this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                            Object object = ROCTabPanel.this._state.getRocTableModel().getValueAt(i, ROCTabPanel.this._state.getMODEL());
                            if (!string.equals(object)) continue;
                            n = i;
                        }
                    }
                    ROCTabPanel.this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
                    if (!this._reload) {
                        ROCTabPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(ROCTabPanel.this._state.getTargetValues()));
                        ROCTabPanel.this.jTargetComb.setSelectedItem(ROCTabPanel.this._state.getSelectedTargetValue());
                    }
                }
                ROCTabPanel.this.enableControls(true);
                ROCTabPanel.this.getEditor().updateSelection();
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            finally {
                if (this._ex != null) {
                    DataMinerEditor.handleEditorException(ROCTabPanel.this.getEditor().getContext(), this._ex, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
                }
                ROCTabPanel.this._loading = false;
                if (ROCTabPanel.this.overLayPanel != null) {
                    ROCTabPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

