/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.partitions;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.partition.PartitionColumn;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.partition.Rule;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.partitions.Sorting;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.ide.Context;

public class ModelPartitionsState {
    private static final String COMMON_MODEL_NAME = "MODEL_NAME";
    private static final String COMMON_PARTITION_ID = "PARTITION_NAME";
    private static final String COMMON_PARTITION_NAME = "PART_VALUES";
    private static final String COMMON_PRED_CONF = "PREDICTIVE_CONFIDENCE";
    private static final String COMMON_TEST_ROWS = "TEST_ROWS";
    private static final String CLAS_ACCURACY = "ACCURACY";
    private static final String CLAS_AVG_ACCURACY = "AVG_ACCURACY";
    private static final String REG_MEAN_ABSOLUTE_ERROR = "MEAN_ABSOLUTE_ERROR";
    private static final String REG_MEAN_ACTUAL_VALUE = "MEAN_ACTUAL_VALUE";
    private static final String REG_MEAN_PREDICATED_VALUE = "MEAN_PREDICATED_VALUE";
    private static final String REG_MEAN_RMS_ERROR = "MEAN_RMS_ERROR";
    private static final String SQL_TEST_ROWS_QUERY = "SELECT metric_num_value \nFROM {PERFORMANCE_TABLE} \nWHERE metric_name = 'TEST_ROWS' AND partition_name IS NULL";
    private static final String SQL_BASE_QUERY = "WITH\nModelPartitionsTable AS\n  (SELECT mp.owner, mp.model_name, mp.partition_name, mp.position, ma.attribute_name, \n          ma.data_type, NVL(mp.column_value, '(null)') AS column_value \n   FROM all_mining_model_partitions mp\n   INNER JOIN all_mining_model_attributes ma \n    ON  mp.owner       = ma.owner\n    AND mp.model_name  = ma.model_name\n    AND mp.column_name = ma.attribute_name\n   WHERE mp.model_name IN ({0})\n   ORDER BY mp.owner, mp.model_name, mp.partition_name, mp.position),\n{1}\nTopValuesTable AS\n  (SELECT DISTINCT model_name, partition_name \n   FROM \n     ({2}) \n  WHERE ROWNUM <= {3}),\nModelPartInfoTable AS\n  (SELECT DISTINCT p.owner, p.model_name, p.partition_name, p.position, p.attribute_name, p.data_type, \n          NVL(p.column_value, '(null)') AS column_value \n   FROM ModelPartitionsTable p \n   INNER JOIN TopValuesTable t ON p.partition_name = t.partition_name\n    AND p.model_name = t.model_name\n   ORDER BY p.partition_name, p.position),\n{4}\n   \nSELECT owner, model_name, partition_name, position, attribute_name, data_type, column_value,\n       LISTAGG(metric_name,      chr(0)) WITHIN GROUP(ORDER BY owner, model_name, partition_name, position, metric_name) AS metrics,\n       LISTAGG(metric_num_value, chr(0)) WITHIN GROUP(ORDER BY owner, model_name, partition_name, position, metric_name) AS metrics_values\nFROM PartMetricsTable\nGROUP BY owner, model_name, partition_name, position, attribute_name, data_type, column_value\nORDER BY owner, model_name, partition_name";
    private static final String SQL_RULE_FILTER = "SELECT DISTINCT model_name, partition_name\n     FROM ModelPartitionsTable\n     WHERE model_name = ";
    private Context context;
    private String[] models;
    private Map<String, String> mapPerformanceTables;
    private Map<String, Date> mapModelDates;
    private Map<String, String> mapModelAlgo;
    private SharedTestEditorState parentTestViewerState;
    private List<PartitionTestResult> testResultsData;
    private List<String> testResultsColumns;
    private boolean isClassification;

    public ModelPartitionsState(SharedTestEditorState sharedTestEditorState, Context context) {
        this.context = context;
        this.parentTestViewerState = sharedTestEditorState;
        this.mapPerformanceTables = new HashMap<String, String>();
        this.mapModelDates = new HashMap<String, Date>();
        this.mapModelAlgo = new HashMap<String, String>();
        this.testResultsData = new ArrayList<PartitionTestResult>();
        List<TestResult> list = sharedTestEditorState.getAllTestResults();
        ArrayList<String> arrayList = new ArrayList<String>(4);
        for (TestResult testResult : list) {
            this.mapPerformanceTables.put(testResult.getModelName(), testResult.getPerformanceMatrixTable());
            this.mapModelDates.put(testResult.getModelName(), testResult.getCreationTime());
            this.mapModelAlgo.put(testResult.getModelName(), testResult.getMiningAlgorithm());
            arrayList.add(testResult.getModelName());
            this.isClassification = testResult.getBuild() instanceof ClassificationBuildNodeType;
        }
        this.models = arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(LoadPartitionsConfig loadPartitionsConfig) throws SQLException {
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string = this.mapPerformanceTables.entrySet().iterator().next().getValue();
            String string2 = StringUtils.getReplacedString(SQL_TEST_ROWS_QUERY, "{PERFORMANCE_TABLE}", string);
            sQLHelper.conn = ConnectionFolder.getConnection(this.context);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            sQLHelper.rs.next();
            double d = sQLHelper.rs.getDouble(1);
            sQLHelper.close();
            string2 = this.generateSQL(loadPartitionsConfig);
            sQLHelper.conn = ConnectionFolder.getConnection(this.context);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string2);
            int n = 1;
            for (int i = 0; i < this.models.length; ++i) {
                block10: for (Rule rule : loadPartitionsConfig.filterRules) {
                    String string3 = rule.getValue().toUpperCase(Locale.getDefault());
                    switch (rule.getOperator()) {
                        case GREATER_THAN: 
                        case LESS_THAN: {
                            sQLHelper.pstmt.setDouble(n++, Double.valueOf(rule.getValue()));
                            continue block10;
                        }
                        case CONTAINS: 
                        case NOT_CONTAINS: {
                            sQLHelper.pstmt.setString(n++, "%" + string3 + "%");
                            continue block10;
                        }
                        case STARTS: 
                        case NOT_START: {
                            sQLHelper.pstmt.setString(n++, string3 + "%");
                            continue block10;
                        }
                        case ENDS: 
                        case NOT_END: {
                            sQLHelper.pstmt.setString(n++, "%" + string3);
                            continue block10;
                        }
                    }
                    sQLHelper.pstmt.setString(n++, string3);
                }
            }
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            this.processResult(sQLHelper.rs, d);
        }
    }

    private String generateSQL(LoadPartitionsConfig loadPartitionsConfig) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        StringBuilder stringBuilder5 = new StringBuilder("PartMetricsTable AS\n  (");
        for (int i = 0; i < this.models.length; ++i) {
            bl = i == this.models.length - 1;
            stringBuilder.append("'");
            stringBuilder.append(this.models[i]);
            stringBuilder.append("',");
            String string = "'" + this.models[i] + "'";
            String string2 = "FilteredPartitionsTable" + i;
            String string3 = this.mapPerformanceTables.get(this.models[i]);
            stringBuilder2.append(string2);
            stringBuilder2.append(" AS \n");
            stringBuilder2.append("  (SELECT DISTINCT model_name, partition_name FROM\n");
            stringBuilder2.append("    (");
            StringBuilder stringBuilder6 = new StringBuilder();
            if (loadPartitionsConfig.filterRules.isEmpty()) {
                stringBuilder6.append(SQL_RULE_FILTER);
                stringBuilder6.append(string);
                stringBuilder6.append("\n");
            } else {
                for (int j = 0; j < loadPartitionsConfig.filterRules.size(); ++j) {
                    Rule rule = (Rule)loadPartitionsConfig.filterRules.get(j);
                    stringBuilder6.append(SQL_RULE_FILTER);
                    stringBuilder6.append(string);
                    stringBuilder6.append("\n     AND attribute_name = '");
                    stringBuilder6.append(rule.getPartitionKey());
                    stringBuilder6.append("' AND ");
                    if (rule.getOperator().isStringOperator()) {
                        stringBuilder6.append("UPPER(column_value)");
                    } else {
                        stringBuilder6.append("TO_NUMBER(column_value)");
                    }
                    Rule.addOperatorSQL(stringBuilder6, rule.getOperator());
                    if (j >= loadPartitionsConfig.filterRules.size() - 1) continue;
                    if (loadPartitionsConfig.matchAllRules) {
                        stringBuilder6.append(" \n       INTERSECT \n     ");
                        continue;
                    }
                    stringBuilder6.append(" \n       UNION \n     ");
                }
            }
            stringBuilder2.append(stringBuilder6.toString());
            stringBuilder2.append("\n");
            stringBuilder2.append("     ORDER BY partition_name)\n");
            stringBuilder2.append("   WHERE partition_name IN (SELECT DISTINCT partition_name FROM ");
            stringBuilder2.append(string3);
            stringBuilder2.append(")),\n");
            if (loadPartitionsConfig.sortColumn == null) {
                stringBuilder3.append("SELECT model_name, partition_name FROM ");
                stringBuilder3.append(string2);
            } else {
                String string4 = this.translateColumn(loadPartitionsConfig.sortColumn);
                if (COMMON_MODEL_NAME.equals(string4)) {
                    stringBuilder3.append("SELECT model_name, partition_name \n");
                    stringBuilder3.append("      FROM ");
                    stringBuilder3.append(string2);
                    if (bl) {
                        stringBuilder3.append("\n      ORDER BY model_name ");
                        stringBuilder3.append((Object)loadPartitionsConfig.sortOrder);
                    }
                } else if (COMMON_PARTITION_ID.equals(string4)) {
                    stringBuilder3.append("SELECT model_name, partition_name \n");
                    stringBuilder3.append("      FROM ");
                    stringBuilder3.append(string2);
                    if (bl) {
                        stringBuilder3.append("\n      ORDER BY partition_name ");
                        stringBuilder3.append((Object)loadPartitionsConfig.sortOrder);
                    }
                } else if (COMMON_PARTITION_NAME.equals(string4)) {
                    stringBuilder3.append("SELECT model_name, partition_name, \n");
                    stringBuilder3.append("             LISTAGG(column_value, '_') WITHIN GROUP(ORDER BY owner, model_name, partition_name, position) AS partition_gui_name \n");
                    stringBuilder3.append("      FROM ModelPartitionsTable \n");
                    stringBuilder3.append("      WHERE partition_name IN ( SELECT partition_name FROM ");
                    stringBuilder3.append(string2);
                    stringBuilder3.append(" )\n");
                    stringBuilder3.append("      GROUP BY owner, model_name, partition_name");
                    if (bl) {
                        stringBuilder3.append("\n      ORDER BY partition_gui_name ");
                        stringBuilder3.append((Object)loadPartitionsConfig.sortOrder);
                    }
                } else {
                    stringBuilder3.append("SELECT ");
                    stringBuilder3.append(string);
                    stringBuilder3.append(" AS model_name, partition_name, metric_num_value \n");
                    stringBuilder3.append("      FROM ");
                    stringBuilder3.append(string3);
                    stringBuilder3.append("\n      WHERE metric_name = ");
                    stringBuilder3.append("'");
                    stringBuilder3.append(string4);
                    stringBuilder3.append("' \n");
                    stringBuilder3.append("      AND partition_name IN ( SELECT partition_name FROM ");
                    stringBuilder3.append(string2);
                    stringBuilder3.append(" )");
                    if (bl) {
                        stringBuilder3.append("\n      ORDER BY metric_num_value ");
                        stringBuilder3.append((Object)loadPartitionsConfig.sortOrder);
                    }
                }
            }
            if (!bl) {
                stringBuilder3.append("\n       UNION\n      ");
            }
            String string5 = "PartMetricsTable" + i;
            stringBuilder4.append(string5);
            stringBuilder4.append(" AS \n");
            stringBuilder4.append("  (SELECT p.owner, p.model_name, p.partition_name, p.position, p.attribute_name, \n");
            stringBuilder4.append("          p.data_type, p.column_value, m.metric_name, m.metric_num_value \n");
            stringBuilder4.append("   FROM ModelPartInfoTable p \n");
            stringBuilder4.append("   INNER JOIN ");
            stringBuilder4.append(string3);
            stringBuilder4.append(" m ON p.partition_name = m.partition_name \n");
            stringBuilder4.append("    AND p.model_name = ");
            stringBuilder4.append(string);
            stringBuilder4.append("\n   ORDER BY p.owner, p.partition_name, p.position, m.metric_name)");
            stringBuilder4.append(",\n");
            stringBuilder5.append("SELECT * FROM ");
            stringBuilder5.append(string5);
            if (bl) continue;
            stringBuilder5.append("\n    UNION\n   ");
        }
        stringBuilder5.append(")\n");
        stringBuilder4.append("\n");
        stringBuilder4.append(stringBuilder5.toString());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder4.deleteCharAt(stringBuilder4.length() - 1);
        String string = MessageFormat.format(SQL_BASE_QUERY, stringBuilder.toString(), stringBuilder2.toString(), stringBuilder3.toString(), loadPartitionsConfig.fetchSize, stringBuilder4.toString());
        return string;
    }

    private void processResult(ResultSet resultSet, double d) throws SQLException {
        PartitionVO partitionVO;
        Object object;
        Object object2;
        ArrayList<PartitionTestResult> arrayList = new ArrayList<PartitionTestResult>();
        boolean bl = true;
        String string = null;
        PartitionTestResult partitionTestResult = new PartitionTestResult();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<PartitionColumn> arrayList2 = new ArrayList<PartitionColumn>();
        while (resultSet.next()) {
            String[] stringArray;
            int n = resultSet.getInt("POSITION");
            if (n == 1) {
                if (!bl) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    partitionTestResult.partitionInfo = object2 = new PartitionVO(string, stringBuilder.toString(), arrayList2);
                    partitionTestResult = new PartitionTestResult();
                    stringBuilder = new StringBuilder();
                    arrayList2 = new ArrayList();
                }
                bl = false;
                partitionTestResult.modelName = resultSet.getString(COMMON_MODEL_NAME);
                string = resultSet.getString(COMMON_PARTITION_ID);
                object2 = resultSet.getString("METRICS_VALUES");
                stringArray = ((String)object2).split(Character.toString('\u0000'));
                if (this.isClassification) {
                    partitionTestResult.classOverallAccuracy = Double.parseDouble(stringArray[0]);
                    partitionTestResult.classAverageAccuracy = Double.parseDouble(stringArray[1]);
                    partitionTestResult.predictiveConfidence = Double.parseDouble(stringArray[2]);
                    partitionTestResult.testRows = Integer.parseInt(stringArray[3]);
                } else {
                    partitionTestResult.regMeanAbsoluteError = Double.parseDouble(stringArray[0]);
                    partitionTestResult.regMeanActualValue = Double.parseDouble(stringArray[1]);
                    partitionTestResult.regMeanPredictedValue = Double.parseDouble(stringArray[2]);
                    partitionTestResult.regRootMeanSquareError = Double.parseDouble(stringArray[3]);
                    partitionTestResult.predictiveConfidence = Double.parseDouble(stringArray[4]);
                    partitionTestResult.testRows = Integer.parseInt(stringArray[5]);
                }
                partitionTestResult.testRowsPercent = (double)partitionTestResult.testRows.intValue() / d * 100.0;
                partitionTestResult.algorithmType = this.mapModelAlgo.get(partitionTestResult.modelName);
                partitionTestResult.creationDate = this.mapModelDates.get(partitionTestResult.modelName);
                arrayList.add(partitionTestResult);
            }
            object2 = resultSet.getString("ATTRIBUTE_NAME");
            stringArray = resultSet.getString("DATA_TYPE");
            object = resultSet.getString("COLUMN_VALUE");
            PartitionColumn partitionColumn = new PartitionColumn((String)object2, (String)stringArray, (String)object);
            arrayList2.add(partitionColumn);
            stringBuilder.append((String)object);
            stringBuilder.append("_");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        partitionTestResult.partitionInfo = partitionVO = new PartitionVO(string, stringBuilder.toString(), arrayList2);
        object2 = new String[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = (PartitionColumn)arrayList2.get(i);
            object2[i] = ((PartitionColumn)object).getColumnName();
        }
        this.testResultsData = arrayList;
        this.testResultsColumns = Arrays.asList(object2);
    }

    private String translateColumn(String string) {
        if (string.equals(CommonLrb.get("COMMON_MODEL"))) {
            return COMMON_MODEL_NAME;
        }
        if (string.equals(TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_ID"))) {
            return COMMON_PARTITION_ID;
        }
        if (string.equals(TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_NAME"))) {
            return COMMON_PARTITION_NAME;
        }
        if (string.equals(TestViewerLrb.get(COMMON_PRED_CONF))) {
            return COMMON_PRED_CONF;
        }
        if (string.equals(TestViewerLrb.get(COMMON_TEST_ROWS))) {
            return COMMON_TEST_ROWS;
        }
        if (string.equals(TestViewerLrb.get("OVERALL_ACCURACY_COL"))) {
            return CLAS_ACCURACY;
        }
        if (string.equals(TestViewerLrb.get("AVG_ACCURACY_COL"))) {
            return CLAS_AVG_ACCURACY;
        }
        if (string.equals(TestViewerLrb.get(REG_MEAN_ABSOLUTE_ERROR))) {
            return REG_MEAN_ABSOLUTE_ERROR;
        }
        if (string.equals(TestViewerLrb.get(REG_MEAN_ACTUAL_VALUE))) {
            return REG_MEAN_ACTUAL_VALUE;
        }
        if (string.equals(TestViewerLrb.get("MEAN_PREDICTED_VALUE"))) {
            return REG_MEAN_PREDICATED_VALUE;
        }
        if (string.equals(TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"))) {
            return REG_MEAN_RMS_ERROR;
        }
        assert (false) : "Missing column";
        return null;
    }

    public String[] getModels() {
        return this.models;
    }

    public void setModels(String[] stringArray) {
        this.models = stringArray;
    }

    public String getDiagramNodeName() {
        return this.parentTestViewerState.getAllTestResults().get(0).getBuild().getName();
    }

    public List<PartitionTestResult> getTestResultsData() {
        return this.testResultsData;
    }

    public List<String> getTestResultsColumns() {
        return this.testResultsColumns;
    }

    public SharedTestEditorState getParentState() {
        return this.parentTestViewerState;
    }

    public boolean isClassification() {
        return this.isClassification;
    }

    static class LoadPartitionsConfig {
        private int fetchSize;
        private List<Rule> filterRules;
        private boolean matchAllRules;
        private String sortColumn;
        private Sorting sortOrder;

        LoadPartitionsConfig() {
        }

        LoadPartitionsConfig setFetchSize(int n) {
            this.fetchSize = n;
            return this;
        }

        LoadPartitionsConfig setFilter(List<Rule> list, boolean bl) {
            this.filterRules = list;
            this.matchAllRules = bl;
            return this;
        }

        LoadPartitionsConfig setSorting(String string, Sorting sorting) {
            this.sortColumn = string;
            this.sortOrder = sorting;
            return this;
        }

        String getSortColumn() {
            return this.sortColumn;
        }

        Sorting getSortOrder() {
            return this.sortOrder;
        }
    }

    static class PartitionTestResult {
        String classCost;
        Double classOverallAccuracy;
        Double classAverageAccuracy;
        Double regMeanAbsoluteError;
        Double regRootMeanSquareError;
        Double regMeanPredictedValue;
        Double regMeanActualValue;
        PartitionVO partitionInfo;
        String modelName;
        String algorithmType;
        Integer buildRows;
        Integer testRows;
        Double testRowsPercent;
        Double buildRowsPercent;
        Double predictiveConfidence;
        Date creationDate;

        PartitionTestResult() {
        }
    }
}

