/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.lift;

import java.awt.Color;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.ide.Context;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class LiftTabState {
    private static final Logger theLogger = Logger.getLogger(LiftTabState.class.getName());
    private SharedTestEditorState _parentTestViewerState;
    private Context _context;
    private List<TestResult> _testResults;
    private Vector<String> _targetValues;
    private String _selectedTargetValue;
    private String _selectedTestResult;
    private HashMap<String, Map<String, List<LiftData>>> _liftdata;
    public static final String DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES = "DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES";
    public static final String DISPLAY_OPTION_CUMULATIVE_LIFT = "DISPLAY_OPTION_CUMULATIVE_LIFT";
    private String _selectedDisplayOption;
    private int _selectedQuantileValue;
    private double _customThresholdValue;
    private LiftTableModel _liftTableModel;
    private DefaultGraphDataModel _liftGraphModel;
    private int _thresholdSeries;
    private double _maxCumLift;
    private int _maxQuantileCnt;
    private int _numPosTargets;
    private int _totNumRows;
    private static String QRY_CM_RESULTS = "WITH pos as (SELECT sum(value) numPosTargets FROM {0} WHERE actual_target_value = :1), tot as (SELECT sum(value) totNumRows FROM {0}) SELECT numPosTargets, totNumRows FROM pos, tot";
    private static String QRY_CM_RESULTS_PARTITIONED = "WITH partitioned_data as (select * from {0} where <partition_clause>),pos as (SELECT sum(value) numPosTargets FROM partitioned_data WHERE actual_target_value = ?), tot as (SELECT sum(value) totNumRows FROM partitioned_data) SELECT numPosTargets, totNumRows FROM pos, tot";

    public int getRESULT_NAME() {
        return this._liftTableModel.getRESULT_NAME();
    }

    public int getTUNE() {
        return ((LiftTuneTableModel)this._liftTableModel).getTUNE();
    }

    public int getLIFT_CUMULATIVE() {
        return this._liftTableModel.getLIFT_CUMULATIVE();
    }

    public int getGAIN_CUMULATIVE() {
        return this._liftTableModel.getGAIN_CUMULATIVE();
    }

    public int getPERCENTAGE_RECORDS_CUMULATIVE() {
        return this._liftTableModel.getPERCENTAGE_RECORDS_CUMULATIVE();
    }

    public int getTARGET_DENSITY_CUMULATIVE() {
        return this._liftTableModel.getTARGET_DENSITY_CUMULATIVE();
    }

    public int getALGORITHM() {
        return this._liftTableModel.getALGORITHM();
    }

    public int getBUILD_ROWS() {
        return this._liftTableModel.getBUILD_ROWS();
    }

    public int getTEST_ROWS() {
        return this._liftTableModel.getTEST_ROWS();
    }

    public int getCREATION_DATE() {
        return this._liftTableModel.getCREATION_DATE();
    }

    public SharedTestEditorState getParentTestViewerState() {
        return this._parentTestViewerState;
    }

    public LiftTabState(SharedTestEditorState sharedTestEditorState, Context context) {
        this._parentTestViewerState = sharedTestEditorState;
        this._context = context;
        this._targetValues = new Vector();
        this._liftdata = new HashMap();
        this._selectedDisplayOption = DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES;
        this._selectedQuantileValue = 20;
        this._liftTableModel = null;
        this._testResults = this._parentTestViewerState.getTestResults();
        this._liftGraphModel = new DefaultGraphDataModel(null, 61, null, null, null);
    }

    public void load(boolean bl) throws SQLException {
        this._targetValues.clear();
        this._testResults = this._parentTestViewerState.getTestResults();
        try {
            this.setSelectedDisplayOption(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES);
            for (TestResult testResult : this._testResults) {
                Vector<String> vector = ((ClassTestResult)testResult).getTargetValues();
                for (String string : vector) {
                    if (this._targetValues.contains(string)) continue;
                    this._targetValues.add(string);
                }
            }
            Object object = ((ClassTestResult)this._testResults.get(0)).getLeastTargetValue(bl, this._parentTestViewerState.getSelectedPartitionName());
            if (object == null || !this._targetValues.contains(object)) {
                object = this._targetValues.get(0);
            }
            this.setSelectedTargetValue((String)object);
            this.loadLiftData(bl);
            this.loadLiftGraph();
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
    }

    public void refreshLiftData(boolean bl) throws SQLException {
        try {
            this.loadLiftData(bl);
            this.loadLiftGraph();
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
    }

    private void loadLiftData(boolean bl) throws SQLException {
        String string = this.getSelectedTargetValue();
        SQLHelper sQLHelper = new SQLHelper();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        TreeMap<String, List<LiftData>> treeMap = new TreeMap<String, List<LiftData>>();
        try {
            String string2 = ((ClassTestResult)this._testResults.get(0)).getPerformanceMatrixTable();
            String string3 = ConnectionFolder.getUserAccountName(this._context);
            String string4 = "SELECT METRIC_VARCHAR_VALUE FROM " + string2 + " where METRIC_NAME = 'MODEL_SCHEMA'";
            sQLHelper.conn = ConnectionFolder.getConnection(this.getContext());
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string4);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string3 = sQLHelper.rs.getString("METRIC_VARCHAR_VALUE");
            }
            sQLHelper.close();
            String string5 = "WITH target as (SELECT metric_varchar_value target_attr FROM " + string2 + " where metric_name = 'TARGET_ATTRIBUTE'), " + "model as (SELECT replace(metric_varchar_value,'\"') model_name FROM " + string2 + " where metric_name = 'MODEL_NAME') " + "SELECT a.data_type FROM all_mining_model_attributes a, target b, model c  " + "WHERE a.owner = '" + string3 + "' AND a.model_name = c.model_name AND a.attribute_name = b.target_attr";
            sQLHelper.conn = ConnectionFolder.getConnection(this.getContext());
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string5);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            String string6 = "VARCHAR2";
            if (sQLHelper.rs.next()) {
                string6 = sQLHelper.rs.getString("data_type");
            }
            sQLHelper.close();
            String string7 = ((ClassTestResult)this._testResults.get(0)).getConfusionMatrixTable();
            Object[] objectArray = new Object[]{string7};
            String string8 = bl ? MessageFormat.format(QRY_CM_RESULTS_PARTITIONED, objectArray) : MessageFormat.format(QRY_CM_RESULTS, objectArray);
            String string9 = this._parentTestViewerState.getSelectedPartitionName();
            string8 = SharedTestEditorState.setPartitionClause(string8, string9);
            int n4 = 1;
            sQLHelper.conn = ConnectionFolder.getConnection(this.getContext());
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string8);
            if (string9 != null) {
                sQLHelper.pstmt.setString(n4, string9);
                ++n4;
            }
            if ("NUMBER".equals(string6)) {
                sQLHelper.pstmt.setDouble(n4, Double.parseDouble(string));
            } else {
                sQLHelper.pstmt.setString(n4, string);
            }
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                this._numPosTargets = sQLHelper.rs.getInt("numPosTargets");
                this._totNumRows = sQLHelper.rs.getInt("totNumRows");
            }
            sQLHelper.close();
            for (TestResult testResult : this._testResults) {
                Object object;
                List<LiftData> list;
                String string10;
                ClassTestResult classTestResult = testResult instanceof ClassTestResult ? (ClassTestResult)testResult : null;
                if (classTestResult == null || (string10 = classTestResult.geLiftResultTable(string)) == null) continue;
                String string11 = testResult.toString();
                Map<String, List<LiftData>> map = this._liftdata.get(string);
                if (map == null) {
                    map = new HashMap<String, List<LiftData>>();
                    this._liftdata.put(string, map);
                }
                if ((list = map.get(string11)) == null) {
                    list = new ArrayList<LiftData>();
                    d = 0.0;
                    d2 = 0.0;
                    object = "SELECT * FROM " + string10 + " ORDER BY QUANTILE_NUMBER";
                    sQLHelper.conn = ConnectionFolder.getConnection(this.getContext());
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement((String)object);
                    sQLHelper.pstmt.setFetchSize(100);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    int n5 = 0;
                    LiftData liftData = null;
                    while (sQLHelper.rs.next()) {
                        double d4;
                        n5 = sQLHelper.rs.getInt("QUANTILE_NUMBER");
                        try {
                            d4 = sQLHelper.rs.getDouble("PROBABILITY_THRESHOLD");
                        }
                        catch (SQLException sQLException) {
                            d4 = sQLHelper.rs.getDouble("COST_THRESHOLD");
                        }
                        double d5 = sQLHelper.rs.getDouble("GAIN_CUMULATIVE");
                        int n6 = sQLHelper.rs.getInt("QUANTILE_TOTAL_COUNT");
                        double d6 = sQLHelper.rs.getDouble("QUANTILE_TARGET_COUNT");
                        double d7 = sQLHelper.rs.getDouble("PERCENTAGE_RECORDS_CUMULATIVE");
                        double d8 = sQLHelper.rs.getDouble("LIFT_CUMULATIVE");
                        double d9 = sQLHelper.rs.getDouble("TARGET_DENSITY_CUMULATIVE");
                        double d10 = sQLHelper.rs.getDouble("TARGETS_CUMULATIVE");
                        double d11 = sQLHelper.rs.getDouble("NON_TARGETS_CUMULATIVE");
                        double d12 = sQLHelper.rs.getDouble("LIFT_QUANTILE");
                        double d13 = sQLHelper.rs.getDouble("TARGET_DENSITY");
                        d3 += (double)n6;
                        if (n3 == 0) {
                            if (d3 > (double)this._numPosTargets && n5 > 0) {
                                n3 = n5 - 1;
                            } else if (d3 == (double)this._numPosTargets) {
                                n3 = n5;
                            }
                        }
                        liftData = new LiftData(n5, d4, d5, n6, d6, d7, d8, d9, d10, d11, d12, d13, testResult.getMiningAlgorithm(), testResult.getCreationTime(), classTestResult != null ? classTestResult.getTestRows(bl, string9) : null);
                        if (d < d5) {
                            d = d5;
                            n = n5;
                        }
                        if (d2 < d8) {
                            d2 = d8;
                            n2 = n5;
                        }
                        list.add(liftData);
                    }
                    sQLHelper.close();
                    while (n5 < 100) {
                        LiftData liftData2 = new LiftData(++n5, liftData._threshold, liftData._gainCum, liftData._quantileTotalCnt, liftData._quantileTargetCnt, liftData._percentRecordsCum / 100.0, liftData._liftCum, liftData._targetDensityCum, liftData._targetCum, liftData._nonTargetCum, liftData._liftQuantile, liftData._targetDensity, liftData._algorithm, liftData._creation_date, liftData._testRows);
                        list.add(liftData2);
                    }
                    LiftData liftData3 = new LiftData(n5, 0.0, 0.0, n, Double.valueOf(n2), 0.0, list.get((int)1)._liftCum, d, d2, 0.0, 0.0, 0.0, null, null, null);
                    liftData3._idealQuantile = Math.max(1, n3);
                    list.add(0, liftData3);
                    map.put(string11, list);
                }
                object = map.get(string11);
                treeMap.put(string11, (List<LiftData>)object);
            }
            TuneState tuneState = (TuneState)this._context.getProperty("TUNE_STATE");
            this._liftTableModel = tuneState == null ? new LiftTableModel(treeMap, bl) : new LiftTuneTableModel(tuneState, treeMap, bl);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
    }

    private void loadLiftGraph() {
        TestResult testResult;
        List<LiftData> list;
        double d;
        double d2;
        Map<String, List<LiftData>> map = this._liftdata.get(this.getSelectedTargetValue());
        this._liftGraphModel.clear();
        this._maxCumLift = 0.0;
        this._maxQuantileCnt = 0;
        ArrayList<Color> arrayList = new ArrayList<Color>();
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        for (TestResult testResult2 : this._testResults) {
            String string = testResult2.toString();
            List<LiftData> object = map.get(string);
            if (object == null) continue;
            int d22 = object.size();
            if (this._maxQuantileCnt < d22) {
                this._maxQuantileCnt = d22;
            }
            int n3 = object.get((int)0)._idealQuantile;
            n2 = Math.min(n2, n3);
            ++n;
        }
        Object[][] objectArray = new Object[this._maxQuantileCnt * 2][n + (n == 1 ? 3 : 3)];
        Object[] objectArray2 = new Object[n + (n == 1 ? 3 : 3)];
        Object[] objectArray3 = new Object[n + (n == 1 ? 3 : 3)];
        int n5 = 0;
        int n6 = 0;
        for (TestResult testResult2 : this._testResults) {
            String string = testResult2.toString();
            List<LiftData> list2 = map.get(string);
            if (list2 == null) continue;
            n6 = 0;
            for (int i = 0; i < list2.size(); ++i) {
                objectArray[n6++][n5] = (double)i;
                if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
                    objectArray[n6++][n5] = list2.get((int)i)._gainCum;
                    continue;
                }
                objectArray[n6++][n5] = list2.get((int)i)._liftCum;
                this._maxCumLift = (double)this._totNumRows / (double)this._numPosTargets;
            }
            if (list2.get((int)0)._targetCum > this._maxCumLift) {
                this._maxCumLift = list2.get((int)0)._targetCum;
            }
            objectArray2[n5] = "Lift: " + string;
            objectArray3[n5] = 0;
            ++n5;
            Color d4 = this._parentTestViewerState.getTestResultGraphColor(string);
            arrayList.add(d4);
        }
        n6 = 0;
        double d3 = this._selectedQuantileValue;
        double d4 = this._selectedQuantileValue;
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            d2 = 0.0;
            d = 1.0;
        } else {
            d2 = 0.0;
            d = this._maxCumLift;
        }
        objectArray[n6++][n5] = d3;
        objectArray[n6++][n5] = d2;
        objectArray[n6++][n5] = d4;
        objectArray[n6++][n5] = d;
        objectArray2[n5] = TestViewerLrb.get("LIFT_GRAPH_DATA_THRESHOLD");
        objectArray3[n5] = 0;
        this._thresholdSeries = n5++;
        n6 = 0;
        d3 = 0.0;
        d4 = this._maxQuantileCnt - 1;
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            d2 = 0.0;
            d = 1.0;
        } else {
            d2 = 1.0;
            d = 1.0;
        }
        objectArray[n6++][n5] = d3;
        objectArray[n6++][n5] = d2;
        objectArray[n6++][n5] = d4;
        objectArray[n6++][n5] = d;
        objectArray2[n5] = TestViewerLrb.get("LIFT_GRAPH_DATA_RANDOM");
        objectArray3[n5] = 0;
        ++n5;
        n6 = 0;
        String string = null;
        Iterator<TestResult> iterator = this._testResults.iterator();
        while (iterator.hasNext() && (list = map.get(string = (testResult = iterator.next()).toString())) == null) {
        }
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            objectArray[n6++][n5] = 0.0;
            objectArray[n6++][n5] = 0.0;
            objectArray[n6++][n5] = (double)n2;
            objectArray[n6++][n5] = 1.0;
            objectArray[n6++][n5] = (double)(this._maxQuantileCnt - 1);
            objectArray[n6++][n5] = 1.0;
        } else {
            objectArray[n6++][n5] = 0.0;
            objectArray[n6++][n5] = (double)this._totNumRows / (double)this._numPosTargets;
            objectArray[n6++][n5] = (double)n2;
            objectArray[n6++][n5] = (double)this._totNumRows / (double)this._numPosTargets;
            objectArray[n6++][n5] = (double)n2;
            objectArray[n6++][n5] = 1.0;
            objectArray[n6++][n5] = (double)(this._maxQuantileCnt - 1);
            objectArray[n6++][n5] = 1.0;
        }
        objectArray2[n5] = TestViewerLrb.get("LIFT_GRAPH_DATA_IDEAL");
        objectArray3[n5] = 0;
        this._liftGraphModel.addRowLabels(objectArray2);
        this._liftGraphModel.addRowMarkerShapes(objectArray3);
        this._liftGraphModel.addGraphData(objectArray);
        this._liftGraphModel.setLegendVisible(true);
        this._liftGraphModel.setLegendSeriesStart(n);
        this._liftGraphModel.setLegendSeriesCount(n == 1 ? 3 : 3);
        Object[] objectArray4 = new Object[this._maxQuantileCnt * 2];
        for (int i = 0; i < objectArray4.length; ++i) {
            objectArray4[i] = "";
        }
        this._liftGraphModel.addColumnLabels(objectArray4);
        arrayList.add(SharedTestEditorState.LIFT_QUANTILE_LINE);
        arrayList.add(SharedTestEditorState.LIFT_RANDOM_LINE);
        arrayList.add(SharedTestEditorState.LIFT_IDEAL_LINE);
        this._liftGraphModel.addRowColors(arrayList.toArray(new Color[arrayList.size()]));
        this._liftGraphModel.setX1(TestViewerLrb.get("QUANTILE"), this._maxQuantileCnt - 1);
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            this._liftGraphModel.setY1(TestViewerLrb.get("CUMULATIVE_POSITIVE_CASES"), 0.0, 1.0);
        } else {
            this._liftGraphModel.setY1(TestViewerLrb.get("CUMULATIVE_LIFT"), 0.0, this._maxCumLift);
        }
    }

    public void refreshCustomThresholdData() {
        double d;
        double d2;
        Object[][] objectArray = this._liftGraphModel.getGraphData();
        this._liftGraphModel.clearGraphData();
        int n = 0;
        double d3 = this.getSelectedQuantileValue();
        double d4 = this.getSelectedQuantileValue();
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            d2 = 0.0;
            d = 1.0;
        } else {
            d2 = 0.0;
            d = this._maxCumLift;
        }
        objectArray[n++][this._thresholdSeries] = d3;
        objectArray[n++][this._thresholdSeries] = d2;
        objectArray[n++][this._thresholdSeries] = d4;
        objectArray[n][this._thresholdSeries] = d;
        this._liftGraphModel.addGraphData(objectArray);
    }

    public void setSelectedTargetValue(String string) {
        this._selectedTargetValue = string;
    }

    public String getSelectedTargetValue() {
        return this._selectedTargetValue;
    }

    public Map<String, List<LiftData>> getLiftData() {
        return this._liftdata.get(this.getSelectedTargetValue());
    }

    public LiftTableModel getLoadingLiftTableModel() {
        return new LiftTableModel();
    }

    public LiftTableModel getLiftTableModel() {
        return this._liftTableModel;
    }

    public Vector<String> getTargetValues() {
        return this._targetValues;
    }

    public DefaultGraphDataModel getLiftGraphModel() {
        return this._liftGraphModel;
    }

    public void setSelectedTestResult(String string) {
        this._selectedTestResult = string;
    }

    public String getSelectedTestResult() {
        return this._selectedTestResult;
    }

    public Context getContext() {
        return this._context;
    }

    public TestResult getSelectedTestResultObj() {
        for (TestResult testResult : this._testResults) {
            if (!testResult.toString().equals(this.getSelectedTestResult())) continue;
            return testResult;
        }
        return null;
    }

    public void setSelectedDisplayOption(String string) {
        this._selectedDisplayOption = string;
    }

    public String getSelectedDisplayOption() {
        return this._selectedDisplayOption;
    }

    public void setSelectedQuantileValue(int n) {
        this._selectedQuantileValue = n;
    }

    public int getSelectedQuantileValue() {
        return this._selectedQuantileValue;
    }

    public void setCustomThresholdValue(double d) {
        this._customThresholdValue = d;
    }

    public double getCustomThresholdValue() {
        return this._customThresholdValue;
    }

    public double getMaxCumLift() {
        return this._maxCumLift;
    }

    public int getMaxQuantileCnt() {
        return this._maxQuantileCnt;
    }

    public class LiftTuneTableModel
    extends LiftTableModel {
        private int _start;
        private int RESULT_NAME;
        private int TUNE;
        private int LIFT_CUMULATIVE;
        private int GAIN_CUMULATIVE;
        private int PERCENTAGE_RECORDS_CUMULATIVE;
        private int TARGET_DENSITY_CUMULATIVE;
        private int ALGORITHM;
        private int BUILD_ROWS;
        private int TEST_ROWS;
        private int CREATION_DATE;
        private TuneState _tuneState;
        private String TUNE_NONE;
        private String TUNE_BENEFIT;
        private String TUNE_COST;
        private String TUNE_ROC;
        private String TUNE_LIFT;
        private String TUNE_PROFIT;

        public int getRESULT_NAME() {
            return this.RESULT_NAME;
        }

        public int getTUNE() {
            return this.TUNE;
        }

        public int getLIFT_CUMULATIVE() {
            return this.LIFT_CUMULATIVE;
        }

        public int getGAIN_CUMULATIVE() {
            return this.GAIN_CUMULATIVE;
        }

        public int getPERCENTAGE_RECORDS_CUMULATIVE() {
            return this.PERCENTAGE_RECORDS_CUMULATIVE;
        }

        public int getTARGET_DENSITY_CUMULATIVE() {
            return this.TARGET_DENSITY_CUMULATIVE;
        }

        public int getALGORITHM() {
            return this.ALGORITHM;
        }

        public int getBUILD_ROWS() {
            return this.BUILD_ROWS;
        }

        public int getTEST_ROWS() {
            return this.TEST_ROWS;
        }

        public int getCREATION_DATE() {
            return this.CREATION_DATE;
        }

        protected void createColumns(boolean bl) {
            if (bl) {
                this._colNames = new Vector();
                this._colNames.add(TestViewerLrb.get("RESULT_NAME"));
                this._colNames.add(PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"));
                this._colNames.add(TestViewerLrb.get("LIFT_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("GAIN_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("ALGORITHM"));
                this._colNames.add(TestViewerLrb.get("BUILD_ROWS"));
                this._colNames.add(TestViewerLrb.get("TEST_ROWS"));
                this._colNames.add(TestViewerLrb.get("CREATION_DATE"));
                this.BUILD_ROWS = this._start++;
                this.TEST_ROWS = this._start++;
            } else {
                this._colNames = new Vector();
                this._colNames.add(TestViewerLrb.get("RESULT_NAME"));
                this._colNames.add(PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"));
                this._colNames.add(TestViewerLrb.get("LIFT_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("GAIN_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("ALGORITHM"));
                this._colNames.add(TestViewerLrb.get("CREATION_DATE"));
            }
            this.CREATION_DATE = this._start;
        }

        public LiftTuneTableModel(TuneState tuneState, Map<String, List<LiftData>> map, boolean bl) {
            super(map, bl);
            this._start = 0;
            this.RESULT_NAME = this._start++;
            this.TUNE = this._start++;
            this.LIFT_CUMULATIVE = this._start++;
            this.GAIN_CUMULATIVE = this._start++;
            this.PERCENTAGE_RECORDS_CUMULATIVE = this._start++;
            this.TARGET_DENSITY_CUMULATIVE = this._start++;
            this.ALGORITHM = this._start++;
            this.TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
            this.TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
            this.TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
            this.TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
            this.TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
            this.TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");
            this._tuneState = tuneState;
        }

        @Override
        public String getColumnName(int n) {
            return (String)this._colNames.get(n);
        }

        @Override
        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == this.RESULT_NAME) {
                return super.getValueAt(n, this.RESULT_NAME);
            }
            if (n2 == this.GAIN_CUMULATIVE) {
                return super.getValueAt(n, this.GAIN_CUMULATIVE);
            }
            if (n2 == this.PERCENTAGE_RECORDS_CUMULATIVE) {
                return super.getValueAt(n, this.PERCENTAGE_RECORDS_CUMULATIVE);
            }
            if (n2 == this.LIFT_CUMULATIVE) {
                return super.getValueAt(n, this.LIFT_CUMULATIVE);
            }
            if (n2 == this.TARGET_DENSITY_CUMULATIVE) {
                return super.getValueAt(n, this.TARGET_DENSITY_CUMULATIVE);
            }
            if (n2 == this.ALGORITHM) {
                return super.getValueAt(n, this.ALGORITHM);
            }
            if (n2 == this.CREATION_DATE) {
                return super.getValueAt(n, this.CREATION_DATE);
            }
            if (n2 == this.TUNE) {
                if (this._liftData != null) {
                    Object[] objectArray = this._liftData.keySet().toArray();
                    String string = (String)objectArray[n];
                    if (this._tuneState.isTuningNone(string)) {
                        return this.TUNE_NONE;
                    }
                    if (this._tuneState.isTuningBenefit(string)) {
                        return this.TUNE_BENEFIT;
                    }
                    if (this._tuneState.isTuningCost(string)) {
                        return this.TUNE_COST;
                    }
                    if (this._tuneState.isTuningCustomROC(string)) {
                        return this.TUNE_ROC;
                    }
                    if (this._tuneState.isTuningCustomLift(string)) {
                        return this.TUNE_LIFT;
                    }
                    if (this._tuneState.isTuningCustomProfit(string)) {
                        return this.TUNE_PROFIT;
                    }
                }
            } else {
                if (n2 == this.BUILD_ROWS) {
                    return "TODO";
                }
                if (n2 == this.TEST_ROWS) {
                    return "TODO";
                }
            }
            return null;
        }
    }

    public class LiftTableModel
    extends GenericBaseTableModel {
        private int _start = 0;
        private int RESULT_NAME = this._start++;
        private int LIFT_CUMULATIVE = this._start++;
        private int GAIN_CUMULATIVE = this._start++;
        private int PERCENTAGE_RECORDS_CUMULATIVE = this._start++;
        private int TARGET_DENSITY_CUMULATIVE = this._start++;
        private int ALGORITHM = this._start++;
        private int BUILD_ROWS;
        private int TEST_ROWS;
        private int CREATION_DATE;
        protected Vector<String> _colNames;
        protected Map<String, List<LiftData>> _liftData = null;
        private final String LOADING = TestViewerLrb.get("LOADING");

        private int getRESULT_NAME() {
            return this.RESULT_NAME;
        }

        private int getLIFT_CUMULATIVE() {
            return this.LIFT_CUMULATIVE;
        }

        private int getGAIN_CUMULATIVE() {
            return this.GAIN_CUMULATIVE;
        }

        private int getPERCENTAGE_RECORDS_CUMULATIVE() {
            return this.PERCENTAGE_RECORDS_CUMULATIVE;
        }

        private int getTARGET_DENSITY_CUMULATIVE() {
            return this.TARGET_DENSITY_CUMULATIVE;
        }

        private int getALGORITHM() {
            return this.ALGORITHM;
        }

        private int getBUILD_ROWS() {
            return this.BUILD_ROWS;
        }

        private int getTEST_ROWS() {
            return this.TEST_ROWS;
        }

        private int getCREATION_DATE() {
            return this.CREATION_DATE;
        }

        public LiftTableModel() {
            this(null, false);
        }

        private void createColumns(boolean bl) {
            if (bl) {
                this._colNames = new Vector();
                this._colNames.add(TestViewerLrb.get("RESULT_NAME"));
                this._colNames.add(TestViewerLrb.get("LIFT_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("GAIN_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("ALGORITHM"));
                this._colNames.add(TestViewerLrb.get("BUILD_ROWS"));
                this._colNames.add(TestViewerLrb.get("TEST_ROWS"));
                this._colNames.add(TestViewerLrb.get("CREATION_DATE"));
                this.BUILD_ROWS = this._start++;
                this.TEST_ROWS = this._start++;
            } else {
                this._colNames = new Vector();
                this._colNames.add(TestViewerLrb.get("RESULT_NAME"));
                this._colNames.add(TestViewerLrb.get("LIFT_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("GAIN_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("ALGORITHM"));
                this._colNames.add(TestViewerLrb.get("CREATION_DATE"));
            }
            this.CREATION_DATE = this._start;
        }

        public LiftTableModel(Map<String, List<LiftData>> map, boolean bl) {
            this.createColumns(bl);
            this.setColumnIdentifiers(this._colNames);
            this._liftData = map;
            this.setRowCount(this._liftData == null ? 1 : map.size());
            this.setColumnCount(this._colNames.size());
        }

        public String getColumnName(int n) {
            return this._colNames.get(n);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._liftData == null) {
                if (n2 == 0) {
                    return this.LOADING;
                }
                return null;
            }
            Object[] objectArray = this._liftData.keySet().toArray();
            List<LiftData> list = this._liftData.get(objectArray[n]);
            int n3 = LiftTabState.this._selectedQuantileValue;
            if (n2 == this.RESULT_NAME) {
                return objectArray[n];
            }
            if (n2 == this.GAIN_CUMULATIVE) {
                return list.get((int)n3)._gainCum * 100.0;
            }
            if (n2 == this.PERCENTAGE_RECORDS_CUMULATIVE) {
                return list.get((int)n3)._percentRecordsCum;
            }
            if (n2 == this.LIFT_CUMULATIVE) {
                return list.get((int)n3)._liftCum;
            }
            if (n2 == this.TARGET_DENSITY_CUMULATIVE) {
                return list.get((int)n3)._targetDensityCum;
            }
            if (n2 == this.ALGORITHM) {
                return list.get((int)n3)._algorithm;
            }
            if (n2 == this.CREATION_DATE) {
                return list.get((int)n3)._creation_date;
            }
            if (n2 == this.BUILD_ROWS) {
                return "TODO";
            }
            if (n2 == this.TEST_ROWS) {
                return list.get((int)n3)._testRows;
            }
            return "Undefined";
        }
    }

    public static class LiftData
    implements Element {
        public Integer _quantile;
        public Double _threshold;
        public Double _gainCum;
        public Integer _quantileTotalCnt;
        public Double _quantileTargetCnt;
        public Double _percentRecordsCum;
        public Double _liftCum;
        public Double _targetDensityCum;
        public Double _targetCum;
        public Double _nonTargetCum;
        public Double _liftQuantile;
        public Double _targetDensity;
        public String _algorithm;
        public Date _creation_date;
        public Integer _idealQuantile;
        private String _label;
        public Integer _testRows;

        public LiftData(Integer n, Double d, Double d2, Integer n2, Double d3, Double d4, Double d5, Double d6, Double d7, Double d8, Double d9, Double d10, String string, Date date, Integer n3) {
            this._quantile = n;
            this._threshold = d;
            this._gainCum = d2;
            this._quantileTotalCnt = n2;
            this._quantileTargetCnt = d3;
            this._percentRecordsCum = d4 * 100.0;
            this._liftCum = d5;
            this._targetDensityCum = d6;
            this._targetCum = d7;
            this._nonTargetCum = d8;
            this._liftQuantile = d9;
            this._targetDensity = d10;
            this._algorithm = string;
            this._creation_date = date;
            this._testRows = n3;
        }

        public void setLabel(String string) {
            this._label = string;
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return null;
        }

        public Object getData() {
            return null;
        }

        public String getShortLabel() {
            return this._label;
        }

        public String getLongLabel() {
            return "";
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return "";
        }

        public String toString() {
            return "";
        }
    }
}

