/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.lift;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.lift.LiftTabState;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class LiftDetailPanel
extends DialogDisplayer {
    private Context _context;
    private String _testResult;
    private List<LiftTabState.LiftData> _data;
    private boolean _useCost = false;
    private DataMinerTable LiftDetailTable;
    private JScrollPane jScrollPane1;

    public LiftDetailPanel(Context context, String string, List<LiftTabState.LiftData> list) {
        this._context = context;
        this._testResult = string;
        this._data = list;
        this.initComponents();
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.LiftDetailTable = new DataMinerTable();
        this.setPreferredSize(new Dimension(600, 400));
        this.LiftDetailTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)((Object)this.LiftDetailTable));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 556, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 345, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    protected String getDialogTitle() {
        return TestViewerLrb.get("LIFT_DETAIL_DIALOG") + this._testResult;
    }

    @Override
    protected String getHelpTopic() {
        return "lift_detail";
    }

    @Override
    protected int getDialogButtonMask() {
        return 5;
    }

    private static class LiftDetailModel
    extends GenericBaseTableModel {
        private static final int COLUMN_COUNT = 12;
        private static final int QUANTILE_NUMBER = 0;
        private static final int PROBABILITY_THRESHOLD = 1;
        private static final int GAIN_CUMULATIVE = 2;
        private static final int QUANTILE_TOTAL_COUNT = 3;
        private static final int QUANTILE_TARGET_COUNT = 4;
        private static final int PERCENTAGE_RECORDS_CUMULATIVE = 5;
        private static final int LIFT_CUMULATIVE = 6;
        private static final int TARGET_DENSITY_CUMULATIVE = 7;
        private static final int TARGETS_CUMULATIVE = 8;
        private static final int NON_TARGETS_CUMULATIVE = 9;
        private static final int LIFT_QUANTILE = 10;
        private static final int TARGET_DENSITY = 11;
        private List<LiftTabState.LiftData> _liftdata = null;
        private String[] _columnNames = new String[]{TestViewerLrb.get("QUANTILE_NUMBER"), TestViewerLrb.get("PROBABILITY_THRESHOLD"), TestViewerLrb.get("GAIN_CUMULATIVE"), TestViewerLrb.get("QUANTILE_TOTAL_COUNT"), TestViewerLrb.get("QUANTILE_TARGET_COUNT"), TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE"), TestViewerLrb.get("LIFT_CUMULATIVE"), TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"), TestViewerLrb.get("TARGETS_CUMULATIVE"), TestViewerLrb.get("NON_TARGETS_CUMULATIVE"), TestViewerLrb.get("LIFT_QUANTILE"), TestViewerLrb.get("TARGET_DENSITY")};

        public LiftDetailModel(boolean bl, List<LiftTabState.LiftData> list) {
            this._columnNames[1] = TestViewerLrb.get(bl ? "COST" : "PROB_THRESHOLD");
            this.setColumnIdentifiers(this._columnNames);
            this._liftdata = list;
            this.setRowCount(this._liftdata.size() - 1);
            this.setColumnCount(12);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._liftdata == null) {
                return CommonLrb.get("COMMON_LOADING");
            }
            LiftTabState.LiftData liftData = this._liftdata.get(n + 1);
            if (n2 == 0) {
                return liftData._quantile;
            }
            if (n2 == 1) {
                return liftData._threshold;
            }
            if (n2 == 2) {
                return liftData._gainCum * 100.0;
            }
            if (n2 == 3) {
                return liftData._quantileTotalCnt;
            }
            if (n2 == 4) {
                return liftData._quantileTargetCnt;
            }
            if (n2 == 5) {
                return liftData._percentRecordsCum;
            }
            if (n2 == 6) {
                return liftData._liftCum;
            }
            if (n2 == 7) {
                return liftData._targetDensityCum;
            }
            if (n2 == 8) {
                return liftData._targetCum;
            }
            if (n2 == 9) {
                return liftData._nonTargetCum;
            }
            if (n2 == 10) {
                return liftData._liftQuantile;
            }
            if (n2 == 11) {
                return liftData._targetDensity;
            }
            return "Undefined";
        }
    }

    private class LoadUI
    extends SwingWorker<Boolean, Void> {
        private LoadUI() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            String[] stringArray = LiftDetailPanel.this._testResult.split("\\.");
            String string = null;
            String string2 = null;
            if (stringArray.length == 2) {
                string = stringArray[0];
                string2 = stringArray[1];
            } else {
                string = ConnectionFolder.getUserAccountName(LiftDetailPanel.this._context);
                string2 = LiftDetailPanel.this._testResult;
            }
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(LiftDetailPanel.this._context);
            CostMatrixInfo costMatrixInfo = Model.getModelCostMatrix(connectionFolder, string, string2);
            LiftDetailPanel.this._useCost = costMatrixInfo != CostMatrixInfo._NONE;
            return Boolean.TRUE;
        }

        @Override
        protected void done() {
            try {
                if (((Boolean)this.get()).booleanValue()) {
                    LiftDetailPanel.this.LiftDetailTable.setModel((TableModel)((Object)new LiftDetailModel(LiftDetailPanel.this._useCost, LiftDetailPanel.this._data)));
                    LiftDetailPanel.this.LiftDetailTable.setShowToolTips(true);
                    LiftDetailPanel.this.LiftDetailTable.setSorted(true);
                    LiftDetailPanel.this.LiftDetailTable.setUpdateSelectionOnSort(true);
                    LiftDetailPanel.this.LiftDetailTable.setRowSelectionAllowed(true);
                    LiftDetailPanel.this.LiftDetailTable.setColumnSelectionAllowed(false);
                    LiftDetailPanel.this.LiftDetailTable.setAutoResizeMode(0);
                    LiftDetailPanel.this.LiftDetailTable.autoSizeColumnsToFit();
                    NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
                    TableColumn tableColumn = LiftDetailPanel.this.LiftDetailTable.getColumnModel().getColumn(0);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    tableColumn = LiftDetailPanel.this.LiftDetailTable.getColumnModel().getColumn(1);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    tableColumn = LiftDetailPanel.this.LiftDetailTable.getColumnModel().getColumn(2);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    tableColumn = LiftDetailPanel.this.LiftDetailTable.getColumnModel().getColumn(3);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    tableColumn = LiftDetailPanel.this.LiftDetailTable.getColumnModel().getColumn(4);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    tableColumn = LiftDetailPanel.this.LiftDetailTable.getColumnModel().getColumn(5);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    tableColumn = LiftDetailPanel.this.LiftDetailTable.getColumnModel().getColumn(6);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    tableColumn = LiftDetailPanel.this.LiftDetailTable.getColumnModel().getColumn(7);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    tableColumn = LiftDetailPanel.this.LiftDetailTable.getColumnModel().getColumn(8);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    tableColumn = LiftDetailPanel.this.LiftDetailTable.getColumnModel().getColumn(9);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    tableColumn = LiftDetailPanel.this.LiftDetailTable.getColumnModel().getColumn(10);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    tableColumn = LiftDetailPanel.this.LiftDetailTable.getColumnModel().getColumn(11);
                    tableColumn.setCellRenderer(numberCellRenderer);
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
        }
    }
}

