/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;

public class TestResultsSelectorState {
    private Map<String, Boolean> selectedMap = new HashMap<String, Boolean>();
    private List<TestResult> checkedTestResults;
    private SharedTestEditorState parentTestViewerState;
    private List<TestResult> latestCompatibleTestResults;
    private final boolean initialMultipleSelection;

    public TestResultsSelectorState(SharedTestEditorState sharedTestEditorState) {
        this.parentTestViewerState = sharedTestEditorState;
        this.checkedTestResults = sharedTestEditorState.getTestResults();
        for (TestResult testResult : this.checkedTestResults) {
            this.selectedMap.put(testResult.getResultName(), Boolean.TRUE);
        }
        this.initialMultipleSelection = this.checkedTestResults.size() > 1;
        this.latestCompatibleTestResults = sharedTestEditorState.getAllTestResults();
    }

    public boolean isSelected(TestResult testResult) {
        Boolean bl = this.selectedMap.get(testResult.getResultName());
        return bl != null ? bl : false;
    }

    public void selectTestResult(TestResult testResult, boolean bl) {
        this.selectedMap.put(testResult.getResultName(), bl);
    }

    public List<TestResult> getLatestCompatibleTestResults() {
        return this.latestCompatibleTestResults;
    }

    public boolean isInitialMultipleSelection() {
        return this.initialMultipleSelection;
    }

    public String getSelectedResultName() {
        return this.checkedTestResults.get(0) != null ? this.checkedTestResults.get(0).getResultName() : "";
    }

    public SharedTestEditorState getParentTestViewerState() {
        return this.parentTestViewerState;
    }

    public List<TestResult> getSelectedTestResults() {
        ArrayList<TestResult> arrayList = new ArrayList<TestResult>(this.latestCompatibleTestResults.size());
        for (TestResult testResult : this.latestCompatibleTestResults) {
            Boolean bl = this.selectedMap.get(testResult.getName());
            if (bl == null || !bl.booleanValue()) continue;
            arrayList.add(testResult);
        }
        return arrayList;
    }
}

