/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.teditor.graph.GroupByValuesDialog;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.SwingUtils;

class XYPlotPanel
extends JPanel {
    private boolean isComplete;
    private Context context;
    private GraphSettingsType settings;
    private List<AttributeType> availableAttributes;
    private JRadioButton binnedListBtn;
    private JLabel editSettingsLbl;
    private JRadioButton filteredListBtn;
    private ButtonGroup groupByBtnGrp;
    private JCheckBox groupByChk;
    private JLabel groupByHandlingLabel;
    private JComboBox jGroupByAttributeSelector;
    private JComboBox jXAttributeSelector;
    private JComboBox jYAttributeSelector;
    private JLabel lblX;
    private JLabel lblY;

    public XYPlotPanel(Context context, List<AttributeType> list, GraphSettingsType graphSettingsType) {
        this.context = context;
        this.availableAttributes = list;
        this.settings = graphSettingsType;
        this.isComplete = false;
        this.initComponents();
        this.initUI();
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    private void initComponents() {
        this.groupByBtnGrp = new ButtonGroup();
        this.lblX = new JLabel();
        this.jXAttributeSelector = new JComboBox();
        this.lblY = new JLabel();
        this.jYAttributeSelector = new JComboBox();
        this.editSettingsLbl = new JLabel();
        this.groupByChk = new JCheckBox();
        this.jGroupByAttributeSelector = new JComboBox();
        this.filteredListBtn = new JRadioButton();
        this.groupByHandlingLabel = new JLabel();
        this.binnedListBtn = new JRadioButton();
        this.lblX.setText("X Axis:");
        this.jXAttributeSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1"}));
        this.lblY.setText("Y Axis:");
        this.jYAttributeSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1"}));
        this.editSettingsLbl.setText("Edit Settings...");
        this.groupByChk.setText("Group By:");
        this.jGroupByAttributeSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.groupByBtnGrp.add(this.filteredListBtn);
        this.filteredListBtn.setSelected(true);
        this.filteredListBtn.setText("Filtered List of Values");
        this.groupByHandlingLabel.setText("Group By Attribute Handling:");
        this.groupByBtnGrp.add(this.binnedListBtn);
        this.binnedListBtn.setText("Binned List of Values");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblX).addComponent(this.lblY)).addComponent(this.groupByChk)).addGap(16, 16, 16).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jGroupByAttributeSelector, 0, -1, Short.MAX_VALUE).addComponent(this.jYAttributeSelector, 0, -1, Short.MAX_VALUE).addComponent(this.jXAttributeSelector, 0, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGap(99, 99, 99).addComponent(this.groupByHandlingLabel, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10)).addGroup(groupLayout.createSequentialGroup().addGap(101, 101, 101).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.editSettingsLbl, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addComponent(this.filteredListBtn, -1, 131, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binnedListBtn, -1, 127, Short.MAX_VALUE).addGap(45, 45, 45)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblX).addComponent(this.jXAttributeSelector, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblY).addComponent(this.jYAttributeSelector, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jGroupByAttributeSelector, -2, -1, -2).addComponent(this.groupByChk)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.groupByHandlingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filteredListBtn).addComponent(this.binnedListBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editSettingsLbl).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void initUI() {
        Object object;
        Object object2;
        this.editSettingsLbl.setText(GraphLrb.get("EDIT_SETTINGS_TEXT"));
        this.jXAttributeSelector.removeAllItems();
        this.jYAttributeSelector.removeAllItems();
        this.jGroupByAttributeSelector.removeAllItems();
        this.jXAttributeSelector.addItem("<Select Attribute>");
        this.jYAttributeSelector.addItem("<Select Attribute>");
        this.jGroupByAttributeSelector.addItem("<Select Attribute>");
        ResourceUtils.resLabel((JLabel)this.lblX, (Component)this.jXAttributeSelector, (String)GraphLrb.get("X_LABEL"));
        ResourceUtils.resLabel((JLabel)this.lblY, (Component)this.jYAttributeSelector, (String)GraphLrb.get("Y_LABEL"));
        this.groupByChk.setText(GraphLrb.get("GROUP_BY_CHK"));
        this.binnedListBtn.setText(GraphLrb.get("RADIO_BINNED_VALUES"));
        this.filteredListBtn.setText(GraphLrb.get("RADIO_FILTERED_VALUES"));
        this.editSettingsLbl.setText(this.settings.getGroupByOption().isGroupByEnabled() ? GraphLrb.get("EDIT_SETTINGS_TEXT") : GraphLrb.get("EDIT_SETTINGS_TEXT_DISABLED"));
        Object object3 = null;
        Object object4 = this.availableAttributes.iterator();
        while (object4.hasNext()) {
            object2 = object4.next();
            if (!GraphUtils.isNumericType(object2.getDataType())) continue;
            object = new AttrItem((AttributeType)object2);
            this.jXAttributeSelector.addItem(object);
            if (object3 != null || !MetaDataHelper.isEqual(((AttrItem)object).getAttribute(), this.settings.getXAttribute())) continue;
            object3 = object;
        }
        if (object3 != null) {
            this.jXAttributeSelector.removeItemAt(0);
            this.jXAttributeSelector.setSelectedItem(object3);
        }
        if ((object4 = this.jXAttributeSelector.getSelectedItem()) instanceof AttrItem) {
            object2 = (AttrItem)object4;
            this.settings.setXAttribute(((AttrItem)object2).getAttribute());
        }
        object2 = null;
        for (AttributeType object5 : this.availableAttributes) {
            if (!GraphUtils.isNumericType(object5.getDataType())) continue;
            AttrItem attrItem = new AttrItem(object5);
            this.jYAttributeSelector.addItem(attrItem);
        }
        if (object2 != null) {
            this.jYAttributeSelector.removeItemAt(0);
            this.jYAttributeSelector.setSelectedItem(object2);
        }
        if ((object4 = this.jYAttributeSelector.getSelectedItem()) instanceof AttrItem) {
            object = (AttrItem)object4;
        }
        object = null;
        for (AttributeType attributeType : this.availableAttributes) {
            AttrItem attrItem = new AttrItem(attributeType);
            this.jGroupByAttributeSelector.addItem(attrItem);
            if (object != null || !MetaDataHelper.isEqual(attrItem.getAttribute(), this.settings.getGroupByOption().getGroupByAttribute())) continue;
            object = attrItem;
        }
        if (object != null) {
            this.jGroupByAttributeSelector.removeItemAt(0);
            this.jGroupByAttributeSelector.setSelectedItem(object);
        }
        if ((object4 = this.jGroupByAttributeSelector.getSelectedItem()) instanceof AttrItem) {
            AttrItem attrItem = (AttrItem)object4;
            this.settings.getGroupByOption().setGroupByAttribute(attrItem.getAttribute());
        }
        this.jXAttributeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof AttrItem) {
                    AttrItem attrItem = (AttrItem)object;
                    XYPlotPanel.this.settings.setXAttribute(attrItem.getAttribute());
                    if (jComboBox.getItemAt(0) instanceof String) {
                        jComboBox.removeItemAt(0);
                    }
                }
            }
        });
        this.jYAttributeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof AttrItem) {
                    AttrItem attrItem = (AttrItem)object;
                    if (jComboBox.getItemAt(0) instanceof String) {
                        jComboBox.removeItemAt(0);
                    }
                }
            }
        });
        this.jGroupByAttributeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof AttrItem) {
                    AttrItem attrItem = (AttrItem)object;
                    XYPlotPanel.this.settings.getGroupByOption().setGroupByAttribute(attrItem.getAttribute());
                    if (jComboBox.getItemAt(0) instanceof String) {
                        jComboBox.removeItemAt(0);
                    }
                }
            }
        });
        boolean bl = this.settings.getGroupByOption().isGroupByEnabled();
        this.groupByChk.setSelected(bl);
        this.enableGroupByUI(bl);
        this.groupByChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                boolean bl = jCheckBox.isSelected();
                XYPlotPanel.this.settings.getGroupByOption().setGroupByEnabled(bl);
                XYPlotPanel.this.enableGroupByUI(bl);
            }
        });
        this.editSettingsLbl.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (XYPlotPanel.this.settings.getGroupByOption().getGroupByAttribute() == null) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)GraphLrb.get("NO_GROUPBY_SPECIFIED"), (String)GraphLrb.get("NO_GROUPBY_SPECIFIED_TITLE"), null);
                    return;
                }
                Dialog dialog = SwingUtils.getAncestorDialog((Component)XYPlotPanel.this);
                GroupByValuesDialog groupByValuesDialog = new GroupByValuesDialog(dialog, XYPlotPanel.this.context, true, XYPlotPanel.this.settings.getXBinningSettings(), XYPlotPanel.this.settings.getXAttribute());
                groupByValuesDialog.setVisible(true);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
    }

    private void enableGroupByUI(boolean bl) {
        this.jGroupByAttributeSelector.setEnabled(bl);
        this.groupByHandlingLabel.setEnabled(bl);
        this.filteredListBtn.setEnabled(bl);
        this.binnedListBtn.setEnabled(bl);
        this.editSettingsLbl.setEnabled(bl);
        this.editSettingsLbl.setText(bl ? GraphLrb.get("EDIT_SETTINGS_TEXT") : GraphLrb.get("EDIT_SETTINGS_TEXT_DISABLED"));
    }

    public boolean isGroupByEnabled() {
        return this.groupByChk.isSelected();
    }

    private static class AttrItem {
        AttributeType item = new AttributeType();

        AttrItem(AttributeType attributeType) {
            this.item.setAlias(attributeType.getAlias());
            this.item.setDataType(attributeType.getDataType());
            this.item.setName(attributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)attributeType.getStatus().value()));
        }

        public AttributeType getAttribute() {
            return this.item;
        }

        public String toString() {
            return this.item.getName();
        }
    }
}

