/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.dmt.dataminer.controls.GraphDataDisplay;
import oracle.dmt.dataminer.controls.GraphPopupClickListener;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.teditor.graph.AddGraphDialog;
import oracle.dmt.dataminer.teditor.graph.GraphDataDialog;
import oracle.dmt.dataminer.teditor.graph.GraphEditorPanel;
import oracle.dmt.dataminer.teditor.graph.GraphLoader;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.teditor.graph.OdmrGraph;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.DropDownMenuButton;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

class GraphContainerPanel
extends JPanel
implements ActionListener,
ComponentListener,
GraphDataDisplay {
    private BlockingComponent overLayPanel = null;
    private OdmrGraph graph;
    private Context context;
    private GraphSettingsType settings;
    private boolean zoomed;
    private JButton zoomBtn;
    private DropDownMenuButton graphTypeChoice;
    private JLabel label;
    private JButton editBtn;
    private JButton removeBtn;
    private ControlBar cbar;
    private ComponentWithTitlebar<JComponent> toolbar;
    private List<Object[]> data;
    private List<Object[]> userReadableData;
    private List<String> columnTitles;
    private int timerDelay = 30;
    private static int defaultIncrement = 100;
    private Timer timer;
    private Dimension value;
    private Dimension zoomedSize;
    private int hincrement;
    private int vincrement;

    public GraphContainerPanel(Context context, OdmrGraph odmrGraph, GraphSettingsType graphSettingsType) {
        this.context = context;
        this.graph = odmrGraph;
        this.graph.addMouseListener(new GraphPopupClickListener(this, (Object)odmrGraph));
        this.settings = graphSettingsType;
        this.zoomed = false;
        this.initUI();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public GraphSettingsType getSettings() {
        return this.settings;
    }

    public void showData() {
        String string = "";
        if (this.settings.getType().equals((Object)GraphType.BOX_PLOT)) {
            string = GraphLrb.get("GRAPH_DATA_BOX_VARIABLE") + " " + this.settings.getXAttribute().getName();
        }
        GraphDataDialog graphDataDialog = new GraphDataDialog((Frame)Ide.getMainWindow(), true, string);
        graphDataDialog.setData(this.userReadableData, this.columnTitles);
        graphDataDialog.setVisible(true);
    }

    public void toggleZoom() {
        this.zoomed = !this.zoomed;
        this.zoomedSize = this.getZoomedSize();
        Container container = this.getViewport();
        this.hincrement = defaultIncrement;
        if (!this.zoomed) {
            this.hincrement *= -1;
        }
        this.vincrement = Double.valueOf(this.zoomedSize.getHeight() / this.zoomedSize.getWidth() * (double)this.hincrement).intValue();
        if (this.zoomed) {
            GraphEditorPanel graphEditorPanel = (GraphEditorPanel)SwingUtilities.getAncestorOfClass(GraphEditorPanel.class, this);
            if (graphEditorPanel == null) {
                throw new IllegalStateException("Unexpected state");
            }
            Map<String, GraphContainerPanel> map = graphEditorPanel.getGraphs();
            for (GraphContainerPanel graphContainerPanel : map.values()) {
                if (graphContainerPanel == this) continue;
                graphContainerPanel.setVisible(false);
            }
        }
        this.timer = new Timer(this.timerDelay, this);
        this.value = this.zoomed ? new Dimension(OdmrGraph.NORMAL_DIM) : new Dimension(this.zoomedSize);
        this.timer.start();
        if (this.zoomed) {
            this.zoomBtn.setIcon(DataMinerIcons.get(Icons.RESTORE));
            container.addComponentListener(this);
        } else {
            this.zoomBtn.setIcon(DataMinerIcons.get(Icons.MAXIMIZE));
            container.removeComponentListener(this);
        }
        this.toolbar.setControlBar(this.createControlBar(!this.zoomed));
        this.updateToolbarLayout();
    }

    private Container getViewport() {
        GraphEditorPanel graphEditorPanel = (GraphEditorPanel)SwingUtilities.getAncestorOfClass(GraphEditorPanel.class, this);
        if (graphEditorPanel == null) {
            throw new IllegalStateException("Could not find the parent GraphEditorPanel");
        }
        Container container = graphEditorPanel.getViewport();
        if (container == null) {
            throw new IllegalStateException("Could not find the parent GraphEditorPanel's viewport");
        }
        return container;
    }

    private Dimension getZoomedSize() {
        Container container = this.getViewport();
        Dimension dimension = container.getSize();
        dimension.setSize(dimension.getWidth() - 10.0, dimension.getHeight() - 10.0);
        return dimension;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.zoomed) {
            Dimension dimension = this.getZoomedSize();
            this.setSize(dimension);
            this.setPreferredSize(dimension);
        }
        this.updateToolbarLayout();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        bl = this.zoomed ? this.value.getWidth() >= this.zoomedSize.getWidth() || this.value.getHeight() >= this.zoomedSize.getHeight() : this.value.getWidth() <= OdmrGraph.NORMAL_DIM.getWidth() || this.value.getHeight() <= OdmrGraph.NORMAL_DIM.getHeight();
        this.value.setSize(this.value.getWidth() + (double)this.hincrement, this.value.getHeight() + (double)this.vincrement);
        if (bl && this.zoomed) {
            this.value.setSize(this.zoomedSize);
        } else if (bl && !this.zoomed) {
            this.value.setSize(OdmrGraph.NORMAL_DIM);
        }
        this.setSize(this.value);
        this.setPreferredSize(this.value);
        this.revalidate();
        if (bl) {
            this.timer.stop();
            GraphEditorPanel graphEditorPanel = (GraphEditorPanel)SwingUtilities.getAncestorOfClass(GraphEditorPanel.class, this);
            if (!this.zoomed) {
                Map<String, GraphContainerPanel> map = graphEditorPanel.getGraphs();
                for (GraphContainerPanel graphContainerPanel : map.values()) {
                    if (graphContainerPanel == this) continue;
                    graphContainerPanel.setVisible(true);
                }
                graphEditorPanel.validate();
                graphEditorPanel.repaint();
            }
        }
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        GraphUtils.updateAttributeStatus(this.context, this.settings);
        this.toolbar = new ComponentWithTitlebar();
        int n = GraphUtils.getDefaultGraphType(this.settings.getType());
        this.graph.setGraphType(n);
        this.graph.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    GraphContainerPanel.this.handleEditGraph(GraphContainerPanel.this.editBtn, (ComponentWithTitlebar<JComponent>)GraphContainerPanel.this.toolbar);
                    mouseEvent.consume();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.zoomBtn = new JButton();
        this.zoomBtn.setIcon(DataMinerIcons.get(Icons.MAXIMIZE));
        this.zoomBtn.setToolTipText(GraphLrb.get("TOOLBAR_ZOOM_IN"));
        this.zoomBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component component = (Component)actionEvent.getSource();
                GraphContainerPanel graphContainerPanel = (GraphContainerPanel)SwingUtilities.getAncestorOfClass(GraphContainerPanel.class, component);
                graphContainerPanel.toggleZoom();
                if (!GraphContainerPanel.this.zoomed) {
                    GraphContainerPanel.this.zoomBtn.setToolTipText(GraphLrb.get("TOOLBAR_ZOOM_IN"));
                } else {
                    GraphContainerPanel.this.zoomBtn.setToolTipText(GraphLrb.get("TOOLBAR_ZOOM_OUT"));
                }
            }
        });
        this.editBtn = new JButton();
        this.editBtn.setIcon(OracleIcons.getIcon((String)"edit.png"));
        this.editBtn.setToolTipText(GraphLrb.get("TOOLBAR_EDIT_SETTINGS"));
        this.editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphContainerPanel.this.handleEditGraph((Component)actionEvent.getSource(), (ComponentWithTitlebar<JComponent>)GraphContainerPanel.this.toolbar);
            }
        });
        this.removeBtn = new JButton();
        this.removeBtn.setIcon(OracleIcons.getIcon((String)"garbg.png"));
        this.removeBtn.setToolTipText(GraphLrb.get("TOOLBAR_REMOVE_GRAPH"));
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component component = (Component)actionEvent.getSource();
                GraphContainerPanel.this.handleRemoveGraph(component, (ComponentWithTitlebar<JComponent>)GraphContainerPanel.this.toolbar);
            }
        });
        this.cbar = this.createControlBar(true);
        this.toolbar.setComponent((JComponent)((Object)this.graph));
        this.toolbar.setControlBar(this.cbar);
        this.label = this.createTruncatedLabel(this.settings.getName());
        this.toolbar.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    GraphContainerPanel.this.toggleZoom();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        if (this.graph.getParent() != null) {
            this.graph.getGraphBackground().setBackground(this.graph.getParent().getBackground());
        }
        this.add((Component)this.toolbar);
        this.toolbar.setLabel(this.label);
    }

    private JLabel createTruncatedLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setToolTipText(string);
        jLabel.setPreferredSize(new Dimension(20, 20));
        jLabel.setMaximumSize(new Dimension(20, 20));
        jLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    GraphContainerPanel.this.toggleZoom();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        return jLabel;
    }

    public void updateToolbarLayout() {
        Dimension dimension = this.label.getSize();
        double d = this.isZoomed() ? this.getZoomedSize().getWidth() : OdmrGraph.NORMAL_DIM.getWidth();
        double d2 = this.removeBtn.getSize().getWidth() * 5.0;
        int n = Double.valueOf(d).intValue() - Double.valueOf(d2).intValue();
        int n2 = Double.valueOf(dimension.getHeight()).intValue();
        Dimension dimension2 = new Dimension(n, n2);
        this.label.setSize(dimension2);
        this.label.setMaximumSize(dimension2);
        this.label.setPreferredSize(dimension2);
        this.toolbar.setLabel(this.label);
    }

    private void handleRemoveGraph(Component component, ComponentWithTitlebar<JComponent> componentWithTitlebar) {
        Object object;
        GraphContainerPanel graphContainerPanel = (GraphContainerPanel)SwingUtilities.getAncestorOfClass(GraphContainerPanel.class, component);
        if (graphContainerPanel == null) {
            return;
        }
        GraphEditorPanel graphEditorPanel = (GraphEditorPanel)SwingUtilities.getAncestorOfClass(GraphEditorPanel.class, component);
        if (graphEditorPanel == null) {
            return;
        }
        if (this.zoomed) {
            object = graphEditorPanel.getGraphs();
            for (GraphContainerPanel graphContainerPanel2 : object.values()) {
                if (graphContainerPanel2 == this) continue;
                graphContainerPanel2.setVisible(true);
            }
            graphEditorPanel.validate();
            graphEditorPanel.repaint();
        }
        graphEditorPanel.removeGraph(graphContainerPanel);
        GraphUtils.updateGraphNodeSettings(this.context, this.settings, GraphUtils.UpdateAction.REMOVE);
        object = (BaseTreeNode)this.context.getNode();
        WorkflowNode workflowNode = GraphUtils.getWorkflowNavNode((BaseTreeNode)object);
        workflowNode.markDirty(true);
    }

    private void handleEditGraph(Component component, ComponentWithTitlebar<JComponent> componentWithTitlebar) {
        GraphContainerPanel graphContainerPanel = (GraphContainerPanel)SwingUtilities.getAncestorOfClass(GraphContainerPanel.class, component);
        if (graphContainerPanel == null) {
            return;
        }
        GraphEditorPanel graphEditorPanel = (GraphEditorPanel)SwingUtilities.getAncestorOfClass(GraphEditorPanel.class, component);
        if (graphEditorPanel == null) {
            return;
        }
        List<AttributeType> list = GraphUtils.getSourceAttributes(this.context);
        GraphType graphType = this.settings.getType();
        GraphUtils.updateAttributeStatus(list, this.settings);
        AddGraphDialog addGraphDialog = new AddGraphDialog((Frame)Ide.getMainWindow(), this.context, true, list, this.settings);
        addGraphDialog.setVisible(true);
        if (!addGraphDialog.isDialogOK()) {
            return;
        }
        GraphSettingsType graphSettingsType = addGraphDialog.getSettings();
        GraphType graphType2 = graphSettingsType.getType();
        int n = this.graph.getGraphType();
        if (graphType2 != graphType) {
            n = GraphUtils.getDefaultGraphType(graphSettingsType.getType());
        }
        GraphUtils.updateSettings(this.settings, graphSettingsType);
        graphEditorPanel.reloadGraph(graphContainerPanel, this.settings, n);
        componentWithTitlebar.setControlBar(this.createControlBar(true));
        this.label.setText(this.settings.getName());
        GraphUtils.updateGraphNodeSettings(this.context, this.settings, GraphUtils.UpdateAction.REPLACE);
        BaseTreeNode baseTreeNode = (BaseTreeNode)this.context.getNode();
        WorkflowNode workflowNode = GraphUtils.getWorkflowNavNode(baseTreeNode);
        workflowNode.markDirty(true);
    }

    private ControlBar createControlBar(boolean bl) {
        this.cbar = new ControlBar();
        this.graphTypeChoice = this.constructGraphTypeChoiceComponent();
        if ((this.settings.getType() == GraphType.BAR || this.settings.getType() == GraphType.HISTOGRAM) && this.settings.getGroupByOption().isGroupByEnabled()) {
            this.cbar.add((Component)this.graphTypeChoice);
        }
        if (bl) {
            this.cbar.add((Component)this.removeBtn);
        }
        this.cbar.add((Component)this.editBtn);
        this.cbar.add((Component)this.zoomBtn);
        return this.cbar;
    }

    private DropDownMenuButton constructGraphTypeChoiceComponent() {
        final String string = GraphLrb.get("GRAPH_STACKED_BAR");
        final String string2 = GraphLrb.get("GRAPH_DUAL_Y_BAR");
        final String string3 = GraphLrb.get("GRAPH_RECTANGLE_BAR");
        int n = this.graph.getGraphType();
        this.graphTypeChoice = new DropDownMenuButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(string2);
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(string3);
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        jRadioButtonMenuItem.setIcon(DataMinerIcons.get(Icons.BAR_GRAPH));
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphContainerPanel.this.graphTypeChoice.setIcon((Icon)DataMinerIcons.get(Icons.BAR_GRAPH));
                GraphContainerPanel.this.graphTypeChoice.setToolTipText(string);
                GraphContainerPanel.this.graph.setGraphType(18);
            }
        });
        jRadioButtonMenuItem2.setIcon(DataMinerIcons.get(Icons.DUAL_Y_BAR_GRAPH));
        jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphContainerPanel.this.graphTypeChoice.setIcon((Icon)DataMinerIcons.get(Icons.DUAL_Y_BAR_GRAPH));
                GraphContainerPanel.this.graphTypeChoice.setToolTipText(string2);
                GraphContainerPanel.this.graph.setGraphType(17);
            }
        });
        jRadioButtonMenuItem3.setIcon(DataMinerIcons.get(Icons.RECTANGLE_BAR_GRAPH));
        jRadioButtonMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphContainerPanel.this.graphTypeChoice.setIcon((Icon)DataMinerIcons.get(Icons.RECTANGLE_BAR_GRAPH));
                GraphContainerPanel.this.graphTypeChoice.setToolTipText(string3);
                GraphContainerPanel.this.graph.setGraphType(0);
            }
        });
        if (n == 18) {
            this.graphTypeChoice.setToolTipText(string);
            jRadioButtonMenuItem.setSelected(true);
            this.graphTypeChoice.setIcon((Icon)DataMinerIcons.get(Icons.BAR_GRAPH));
        } else if (n == 17) {
            this.graphTypeChoice.setToolTipText(string2);
            jRadioButtonMenuItem2.setSelected(false);
            this.graphTypeChoice.setIcon((Icon)DataMinerIcons.get(Icons.DUAL_Y_BAR_GRAPH));
        } else if (n == 0) {
            this.graphTypeChoice.setToolTipText(string3);
            jRadioButtonMenuItem3.setSelected(false);
            this.graphTypeChoice.setIcon((Icon)DataMinerIcons.get(Icons.RECTANGLE_BAR_GRAPH));
        }
        this.graphTypeChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GraphContainerPanel.this.graphTypeChoice.addPopupItem((JMenuItem)jRadioButtonMenuItem);
                    GraphContainerPanel.this.graphTypeChoice.addPopupItem((JMenuItem)jRadioButtonMenuItem2);
                } else if (itemEvent.getStateChange() == 2) {
                    GraphContainerPanel.this.graphTypeChoice.removeAllPopupItems();
                }
            }
        });
        return this.graphTypeChoice;
    }

    public OdmrGraph getGraph() {
        return this.graph;
    }

    public void setGraphData(List<Object[]> list, List<Object[]> list2, List<String> list3) {
        this.data = list;
        this.userReadableData = list2;
        this.columnTitles = list3;
        this.graph.setTabularData(list);
    }

    public List<Object[]> getGraphData() {
        return this.data;
    }

    public boolean isZoomed() {
        return this.zoomed;
    }

    public void refresh() {
        GraphUtils.updateAttributeStatus(this.context, this.settings);
        GraphLoader graphLoader = new GraphLoader(this.getName(), this.settings, this.context, this);
        graphLoader.setBlockingComponent(this.overLayPanel);
        graphLoader.execute();
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public void showData(Object object) {
        this.showData();
    }
}

