/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.JComponent;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.extendedtype.XMLExtendeType;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dmt.dataminer.teditor.data.ODMrDataTypesUtil;
import oracle.dmt.dataminer.teditor.data.ODMrExtendedTypeEditPanel;
import oracle.ide.Ide;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.sql.OPAQUE;

public class ODMrXMLTypeEditPanel
extends ODMrExtendedTypeEditPanel {
    public ODMrXMLTypeEditPanel() {
        super((ExtendedType)new XMLExtendeType(null));
    }

    @Override
    protected void createGUI() {
        this.savedDataTextArea.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.columnComponentWithTitlebar, "Center");
        this.showAsText(this.extendedType, true);
    }

    @Override
    protected String[][] getTableData() {
        return null;
    }

    @Override
    protected void load() {
        String string = this.getFilePath();
        if (string != null) {
            URL uRL = URLFactory.newFileURL((String)string);
            ((XMLExtendeType)this.extendedType).setLoadFromURL(uRL);
            this.showAsText(this.extendedType, true);
        }
    }

    private String getFilePath() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setSelectionScope(0);
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setURLFilter((URLFilter)new DefaultURLFilter(Messages.getString((String)"ODMrXMLTypeEditPanel.0"), new String[]{"xml", "XML"}));
        int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString((String)"ODMrXMLTypeEditPanel.3"));
        if (n == 0) {
            return uRLFileChooser.getSelectedURL().getPath();
        }
        return null;
    }

    @Override
    public boolean processExtendedType() {
        return true;
    }

    @Override
    public JComponent getDefaultComponent() {
        return this;
    }

    public String getHelpTopicId() {
        return null;
    }

    public Object getValue() {
        if (this.extendedType != null && this.extendedType.isSetNULL()) {
            return null;
        }
        return this.extendedType;
    }

    public void setValue(Object object) {
        if (object instanceof OPAQUE) {
            this.extendedType = new XMLExtendeType(null);
            ((XMLExtendeType)this.extendedType).setValue((OPAQUE)object);
        } else if (object instanceof String && ((String)object).length() > 0) {
            this.extendedType = new XMLExtendeType(null);
            ((XMLExtendeType)this.extendedType).setLoadFromURL(URLFactory.newFileURL((String)((String)object)));
        } else {
            this.extendedType = object instanceof XMLExtendeType ? (ExtendedType)object : new XMLExtendeType(null);
        }
        this.reload();
        this.showAsText(this.extendedType, true);
    }

    protected void reload() {
    }

    @Override
    protected StringBuilder readText(InputStream inputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        if (inputStream != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(200);
            try {
                StringWriter stringWriter = new StringWriter();
                if (DataTypesUtil.getXMLAsCharacters((InputStream)bufferedInputStream, (Writer)stringWriter, (String)IdeUtil.getIdeEncoding())) {
                    stringBuilder.append(stringWriter.toString());
                }
                String string = null;
                try {
                    string = ODMrDataTypesUtil.prettyPrintWithDOM3LS(stringBuilder.toString());
                }
                catch (Exception exception) {
                    string = stringBuilder.toString();
                }
                return new StringBuilder(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.readText(inputStream);
    }
}

