/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;

public class ODMrSortColumnPicker
extends JPanel
implements ListSelectionListener,
ListDataListener,
Cloneable {
    private static final Logger theLogger = Logger.getLogger(ODMrSortColumnPicker.class.getName());
    private JList lstFrom = new JList();
    private JList lstTo = new JList();
    private ListPicker pckFrom = new ListPicker(this.lstFrom);
    private ListPicker pckTo = new ReorderableListPicker(this.lstTo);
    private Shuttle shtColumns = new Shuttle();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel lblFrom = new JLabel();
    private JLabel lblTo = new JLabel();
    private DBObjectRenderer renderer = new DBObjectRenderer();
    protected DefaultListModel mdlFrom = new DefaultListModel();
    protected DefaultListModel mdlTo = new DefaultListModel();
    private JRadioButton _rdbAscending = new JRadioButton();
    private JRadioButton _rdbDescending = new JRadioButton();
    private JCheckBox _cbxNullFirst = new JCheckBox();
    private ButtonGroup _bgOrder = new ButtonGroup();
    private int start;
    private int end;
    private boolean supportsOrderingNulls = true;

    public ODMrSortColumnPicker() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.start = 0;
        this.end = 0;
    }

    protected void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.shtColumns.setFromPicker((ItemPicker)this.pckFrom);
        this.shtColumns.setToPicker((ItemPicker)this.pckTo);
        this.shtColumns.add((Component)this.lblFrom, (Object)"FromHeader");
        this.shtColumns.add((Component)this.lblTo, (Object)"ToHeader");
        ResourceUtils.resLabel((JLabel)this.lblFrom, (Component)this.lstFrom, (String)DataLrb.get("DATA_VIEWER_UNIQUE_LIST_AVAILABLE"));
        ResourceUtils.resLabel((JLabel)this.lblTo, (Component)this.lstTo, (String)DataLrb.get("DATA_VIEWER_UNIQUE_LIST_SELECTED"));
        this.lstFrom.setCellRenderer(this.renderer);
        this.lstTo.setCellRenderer(this.renderer);
        this._rdbAscending.setText(DataLrb.get("DATA_VIEWER_DATAED_ASCENDING"));
        this._rdbDescending.setText(DataLrb.get("DATA_VIEWER_DATAED_DESCENDING"));
        this._cbxNullFirst.setText(DataLrb.get("DATA_VIEWER_DATAED_NULLSFIRST"));
        this._bgOrder.add(this._rdbAscending);
        this._bgOrder.add(this._rdbDescending);
        this._rdbAscending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ODMrSortColumnPicker.this.lstTo.getSelectedIndex() != -1) {
                    SortCol sortCol = (SortCol)ODMrSortColumnPicker.this.mdlTo.get(ODMrSortColumnPicker.this.lstTo.getSelectedIndex());
                    sortCol.setAscending(true);
                    ODMrSortColumnPicker.this.lstTo.repaint();
                }
            }
        });
        this._rdbDescending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ODMrSortColumnPicker.this.lstTo.getSelectedIndex() != -1) {
                    SortCol sortCol = (SortCol)ODMrSortColumnPicker.this.mdlTo.get(ODMrSortColumnPicker.this.lstTo.getSelectedIndex());
                    sortCol.setAscending(false);
                    ODMrSortColumnPicker.this.lstTo.repaint();
                }
            }
        });
        this._cbxNullFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ODMrSortColumnPicker.this.lstTo.getSelectedIndex() != -1) {
                    SortCol sortCol = (SortCol)ODMrSortColumnPicker.this.mdlTo.get(ODMrSortColumnPicker.this.lstTo.getSelectedIndex());
                    sortCol.setNullFirst(ODMrSortColumnPicker.this._cbxNullFirst.isSelected());
                }
            }
        });
        this.add((Component)this.shtColumns, new GridBagConstraints(0, 0, 1, 4, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._rdbAscending, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this._rdbDescending, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._cbxNullFirst, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
    }

    public void init(String[] stringArray) {
        this.mdlFrom.removeAllElements();
        this.mdlTo.removeAllElements();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mdlFrom.addElement(new SortCol(stringArray[i]));
        }
        this.lstFrom.setModel(this.mdlFrom);
        this.lstTo.setModel(this.mdlTo);
        this.lstFrom.setSelectedIndex(0);
        this.shtColumns.setEnabled(true);
        this.lstFrom.setEnabled(true);
        this.lstTo.setEnabled(true);
        this.lstTo.setSelectionMode(0);
        this.shtColumns.validate();
        this._rdbAscending.setEnabled(false);
        this._rdbDescending.setEnabled(false);
        this._cbxNullFirst.setEnabled(false);
        this.mdlTo.addListDataListener(this);
        this.lstTo.addListSelectionListener(this);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.start = listDataEvent.getIndex0();
        this.end = listDataEvent.getIndex1();
        ListSelectionModel listSelectionModel = this.lstTo.getSelectionModel();
        listSelectionModel.setSelectionInterval(this.start, this.end);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.lstTo.getSelectedIndex() == -1 && this.mdlTo.size() > 0) {
            ListSelectionModel listSelectionModel = this.lstTo.getSelectionModel();
            if (this.mdlTo.size() <= this.end) {
                this.start = this.end = this.mdlTo.size() - 1;
            }
            listSelectionModel.setSelectionInterval(this.start, this.end);
        } else {
            this.start = this.end = this.lstTo.getSelectedIndex();
        }
        this.updateSortProperties();
    }

    public void updateSortProperties() {
        int n = this.lstTo.getSelectedIndex();
        if (n == -1) {
            this._rdbAscending.setEnabled(false);
            this._rdbAscending.setSelected(false);
            this._rdbDescending.setEnabled(false);
            this._rdbDescending.setSelected(false);
            this._cbxNullFirst.setEnabled(false);
            this._cbxNullFirst.setSelected(false);
        } else {
            SortCol sortCol = (SortCol)this.mdlTo.getElementAt(n);
            this._rdbAscending.setEnabled(true);
            this._rdbAscending.setSelected(sortCol.getAscending());
            this._rdbDescending.setEnabled(true);
            this._rdbDescending.setSelected(!sortCol.getAscending());
            if (this.isSupportsOrderingNulls()) {
                this._cbxNullFirst.setEnabled(true);
                this._cbxNullFirst.setSelected(sortCol.getNullFirst());
            }
        }
    }

    public String getOrderBy() {
        if (this.mdlTo.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mdlTo.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            SortCol sortCol = (SortCol)this.mdlTo.get(i);
            stringBuffer.append("\"" + sortCol.getValue() + "\"");
            if (sortCol.getAscending()) {
                stringBuffer.append(" ASC");
            } else {
                stringBuffer.append(" DESC");
            }
            if (this.isSupportsOrderingNulls()) {
                if (sortCol.getNullFirst()) {
                    stringBuffer.append(" NULLS FIRST");
                    continue;
                }
                stringBuffer.append(" NULLS LAST");
                continue;
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public boolean isFromListEmpty() {
        return this.mdlFrom.size() == 0;
    }

    public ArrayList getFromList() {
        ArrayList<SortCol> arrayList = new ArrayList<SortCol>();
        for (int i = 0; i < this.mdlFrom.size(); ++i) {
            arrayList.add(new SortCol((SortCol)this.mdlFrom.get(i)));
        }
        return arrayList;
    }

    public ArrayList getToList() {
        ArrayList<SortCol> arrayList = new ArrayList<SortCol>();
        for (int i = 0; i < this.mdlTo.size(); ++i) {
            arrayList.add(new SortCol((SortCol)this.mdlTo.get(i)));
        }
        return arrayList;
    }

    public void setFromList(ArrayList arrayList) {
        this.mdlFrom.removeAllElements();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.mdlFrom.addElement((SortCol)arrayList.get(i));
        }
    }

    public void setToList(ArrayList arrayList) {
        this.mdlTo.removeAllElements();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.mdlTo.addElement((SortCol)arrayList.get(i));
        }
    }

    boolean isSupportsOrderingNulls() {
        return this.supportsOrderingNulls;
    }

    void setSupportsOrderingNulls(boolean bl) {
        this.supportsOrderingNulls = bl;
    }

    private static class SortCol
    implements Element {
        private boolean _ascending;
        private boolean _nullFirst;
        private String _value;

        public SortCol(String string) {
            this._value = string;
            this._ascending = true;
            this._nullFirst = false;
        }

        public SortCol(SortCol sortCol) {
            this._value = sortCol._value;
            this._ascending = sortCol._ascending;
            this._nullFirst = sortCol._nullFirst;
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return null;
        }

        public Object getData() {
            return this.toString();
        }

        public String getShortLabel() {
            return this.toString();
        }

        public String getLongLabel() {
            return this.toString();
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return this.toString();
        }

        public String toString() {
            if (this._value == null) {
                return "";
            }
            String string = new String(this._value);
            string = this._ascending ? string + " " + DataLrb.get("DATA_VIEWER_DATAED_ASC") : string + " " + DataLrb.get("DATA_VIEWER_DATAED_DESC");
            return string;
        }

        public boolean getAscending() {
            return this._ascending;
        }

        public boolean getNullFirst() {
            return this._nullFirst;
        }

        public void setAscending(boolean bl) {
            this._ascending = bl;
        }

        public void setNullFirst(boolean bl) {
            this._nullFirst = bl;
        }

        public String getValue() {
            return this._value;
        }
    }
}

