/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.text.Format;
import java.text.ParsePosition;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.celleditor.ICellEditor;
import oracle.dbtools.raptor.controls.celleditor.RaptorTableEditorTextField;
import oracle.dbtools.raptor.controls.celleditor.popups.OracleDateTimeEditPanel;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditor;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorHandler;
import oracle.dbtools.raptor.navigator.net.editor.BreakoutEditorListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dmt.dataminer.teditor.data.ODMrDataTypesUtil;
import oracle.dmt.dataminer.teditor.data.ODMrPopupCellEditorFactory;
import oracle.dmt.dataminer.teditor.data.ODMrRaptorTableEditorJPanel;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTable;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModel;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.ModelUtil;
import oracle.xdb.XMLType;

public class ODMrResultSetTableCellEditor
extends DefaultCellEditor
implements PopupCellEditorHandler {
    private Object valFrompopupEditor = null;
    private int columnDataType = -1;
    private String columnDataTypeName = null;
    private Format format = null;
    private ICellEditor iCellEditor = null;
    private JTable table = null;

    public ODMrResultSetTableCellEditor(ODMrResultSetTable oDMrResultSetTable) {
        super((JTextField)new RaptorTableEditorTextField((JTable)oDMrResultSetTable));
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.valFrompopupEditor = null;
        this.columnDataType = -1;
        this.columnDataTypeName = null;
        this.format = null;
        this.iCellEditor = null;
        this.table = jTable;
        Component component = null;
        Object var7_7 = null;
        if (jTable instanceof ODMrResultSetTable && ((ODMrResultSetTable)jTable).getMdl() != null) {
            ODMrResultSetTable oDMrResultSetTable = (ODMrResultSetTable)jTable;
            ODMrResultSetTableModel oDMrResultSetTableModel = oDMrResultSetTable.getMdl();
            Connection connection = null;
            try {
                connection = oDMrResultSetTableModel.getConnection();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            if (connection != null) {
                PopupCellEditor popupCellEditor;
                boolean bl2 = true;
                this.columnDataType = oDMrResultSetTableModel.getType(n2);
                this.columnDataTypeName = null;
                this.format = this.getFormat(connection, this.columnDataType);
                boolean bl3 = false;
                boolean bl4 = false;
                if (bl2) {
                    bl4 = oDMrResultSetTableModel.isCellEditorEditable(oDMrResultSetTable.convertRowIndexToModel(n), oDMrResultSetTable.convertColumnIndexToModel(n2));
                    boolean bl5 = bl3 = bl4 && ODMrResultSetTableCellEditor.isInPlaceEditingAllowed(this.columnDataType);
                }
                if ((popupCellEditor = null) == null && this.iCellEditor == null) {
                    popupCellEditor = ODMrPopupCellEditorFactory.getPopupCellEditor(null, this.columnDataType, this.columnDataTypeName);
                }
                if (!Connections.getInstance().isOracle(connection) && DataTypesUtil.isDateOrTime((int)this.columnDataType) && popupCellEditor instanceof OracleDateTimeEditPanel) {
                    popupCellEditor = null;
                }
                if (popupCellEditor != null) {
                    popupCellEditor.setConnection(connection);
                    popupCellEditor.setEditable(bl4);
                }
                if (DataTypesUtil.isExtendedType((Object)object, (int)this.columnDataType) || DataTypesUtil.isTemporalType((Object)object, (int)this.columnDataType)) {
                    Object object2 = this.valFrompopupEditor = object instanceof String && ((String)object).length() == 0 ? null : object;
                }
                if (var7_7 == null) {
                    object = DataTypesUtil.stringValue((Object)object, (Connection)connection, (int)Integer.MAX_VALUE);
                    if (this.valFrompopupEditor instanceof XMLType) {
                        object = ODMrDataTypesUtil.convertXMLSpecialsChars((String)object);
                    }
                } else {
                    object = var7_7;
                }
                ODMrRaptorTableEditorJPanel oDMrRaptorTableEditorJPanel = null;
                if (component == null) {
                    final Connection connection2 = connection;
                    final RaptorTableEditorTextField raptorTableEditorTextField = new RaptorTableEditorTextField((JTable)oDMrResultSetTable);
                    raptorTableEditorTextField.setText(object != null ? object.toString() : "");
                    this.delegate = new DefaultCellEditor.EditorDelegate(){

                        @Override
                        public void setValue(Object object) {
                            String string = DataTypesUtil.stringValue((Object)object, (Connection)connection2, (int)Integer.MAX_VALUE);
                            raptorTableEditorTextField.setText(string != null ? string : "");
                        }

                        @Override
                        public Object getCellEditorValue() {
                            return raptorTableEditorTextField.getText();
                        }
                    };
                    raptorTableEditorTextField.addActionListener((ActionListener)this.delegate);
                    String string = raptorTableEditorTextField.getText();
                    if (string.contains("\n") || string.contains("\t") || string.contains("\r")) {
                        bl3 = false;
                    }
                    oDMrRaptorTableEditorJPanel = new ODMrRaptorTableEditorJPanel((PopupCellEditorHandler)this, (JTextField)raptorTableEditorTextField, bl3, popupCellEditor);
                } else {
                    oDMrRaptorTableEditorJPanel = new ODMrRaptorTableEditorJPanel((PopupCellEditorHandler)this, (JComponent)component, bl3, popupCellEditor);
                }
                component = oDMrRaptorTableEditorJPanel;
            }
        }
        if (component == null) {
            component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
        return component;
    }

    public static boolean isInPlaceEditingAllowed(int n) {
        switch (n) {
            case -13: 
            case -4: 
            case -3: 
            case -2: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2007: 
            case 2009: {
                return false;
            }
        }
        return true;
    }

    public static boolean hasExtendedEdit(int n) {
        switch (n) {
            case -15: 
            case -13: 
            case -9: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 93: 
            case 2004: 
            case 2005: 
            case 2007: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    protected Format getFormat(Connection connection, int n) {
        if (Connections.getInstance().isOracle(connection)) {
            try {
                return NLSUtils.getFormat((Connection)connection, (int)n);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        Object object = null;
        if (this.format != null) {
            String string = (String)super.getCellEditorValue();
            if (string != null) {
                try {
                    String string2 = this.format.format(this.valFrompopupEditor);
                    if (ModelUtil.areDifferent((Object)string, (Object)string2)) {
                        this.valFrompopupEditor = this.format.parseObject(string, new ParsePosition(0));
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
            object = this.valFrompopupEditor;
        } else {
            object = this.valFrompopupEditor != null ? this.valFrompopupEditor : (this.valFrompopupEditor != null ? this.valFrompopupEditor : (this.iCellEditor != null ? this.iCellEditor.getValue() : super.getCellEditorValue()));
        }
        return object;
    }

    public void setValue(Object object) {
        this.delegate.setValue(object);
    }

    public void handlePopupEdit(PopupCellEditor popupCellEditor) {
        JComponent jComponent = popupCellEditor.getComponent();
        if (jComponent == null) {
            return;
        }
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jComponent, (Component)popupCellEditor.getDefaultComponent(), (String)(popupCellEditor.isEditable() ? ControlsArb.getString((String)"RESULTSET_EDIT_VALUE_TITLE") : ControlsArb.getString((String)"RESULTSET_VIEW_VALUE_TITLE")));
        String string = popupCellEditor.getHelpTopicId();
        if (!ModelUtil.hasLength((String)string)) {
            string = "f1_extendeddataedit_html";
        }
        HelpSystem.getHelpSystem().registerTopic(jComponent, string);
        jEWTDialog.setResizable(true);
        DialogSizeKeeper.attachToComponent((Component)jEWTDialog, (String)(popupCellEditor.getClass().getName() + ".dialogSize"));
        int n = 0;
        jEWTDialog.setButtonMask(n |= 0x10);
        popupCellEditor.setValue(this.getCellEditorValue());
        popupCellEditor.setPopupDialog(jEWTDialog);
        popupCellEditor.setBreakoutEditorListener(new BreakoutEditorListener(){

            public void save(Object object) {
                if (this.savable()) {
                    ODMrResultSetTableCellEditor.this.valFrompopupEditor = object;
                    ODMrResultSetTableCellEditor.this.setValue(ODMrResultSetTableCellEditor.this.valFrompopupEditor);
                    ODMrResultSetTableCellEditor.this.stopCellEditing();
                }
            }

            public boolean savable() {
                int n = ODMrResultSetTableCellEditor.this.getCellEditorListeners().length;
                return n > 0;
            }
        });
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            this.valFrompopupEditor = popupCellEditor.getValue();
            this.setValue(this.valFrompopupEditor);
            this.stopCellEditing();
        } else if (!popupCellEditor.editorBrokeout()) {
            this.cancelCellEditing();
        }
        popupCellEditor.dismissPopupEditor();
        if (this.table != null) {
            this.table.requestFocusInWindow();
            this.table = null;
        }
    }
}

