/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataNode;
import oracle.dmt.dataminer.navigator.DataProfilePhysicalNode;
import oracle.dmt.dataminer.navigator.LogicalDataNode;
import oracle.dmt.dataminer.navigator.PhysicalDataNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.wflownodes.DataProfileNavNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.data.DataSourceViewOption;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModel;
import oracle.dmt.dataminer.utils.ConnectionProperties;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.parallelquery.ViewDataParallelPanel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.ExceptionDialog;

public class DataViewerState {
    private static final Logger theLogger = Logger.getLogger(DataViewerState.class.getName());
    private Context _context;
    private String _connectionName;
    private ModelViewerState1 _modelViewerState;
    private String _schemaName;
    private String _tableName;
    private String _cacheTableName;
    private String _cacheSchemaName;
    private String _selectSQL;
    private Connection _conn = null;
    private ODMrResultSetTableModel _resultSetModel;
    private Node _node;
    private DataSourceViewOption _currentSourceOption = DataSourceViewOption.CACHE;
    private boolean _loadFromNode = true;
    private boolean _loadFromSQL = false;
    private static final ParallelQueryPreferences parallelQueryPreferences = ParallelQueryPreferences.getInstance();
    private boolean closing = false;

    public void setClosing(boolean bl) {
        this.closing = bl;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public DataViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructore as a null.";
        this._context = context;
        this.initTable();
    }

    public DataViewerState(Context context, boolean bl) {
        assert (context != null) : "Context cannot be passed into constructore as a null.";
        this._context = context;
        this._loadFromNode = bl;
        if (this._loadFromNode) {
            this.initTable();
        } else {
            this._resultSetModel = new ODMrResultSetTableModel(this);
        }
    }

    public DataViewerState(String string, String string2, String string3) {
        this._connectionName = string;
        this._context = null;
        this._loadFromNode = true;
        this._resultSetModel = new ODMrResultSetTableModel(this);
        this._cacheTableName = string3;
        this._cacheSchemaName = string2;
    }

    public DataViewerState(Context context, String string) {
        assert (context != null) : "Context cannot be passed into constructore as a null.";
        this._context = context;
        this._loadFromNode = false;
        this._loadFromSQL = true;
        this._resultSetModel = new ODMrResultSetTableModel(this);
        this._selectSQL = string;
    }

    public void setCacheTableName(String string) {
        this._cacheTableName = string;
    }

    public void setTableName(String string, String string2) {
        this._schemaName = string;
        this._tableName = string2;
    }

    public void setSqlExpression(String string) {
        this._selectSQL = string;
    }

    private void initTable() {
        BaseTreeNode baseTreeNode;
        this._node = this._context.getNode();
        assert (this._node != null) : "Tree Node is null";
        assert (this._node instanceof PhysicalDataNode || this._node instanceof GLMRModelNode || this._node instanceof DataProfileNavNode || this._node instanceof GLMCModelNode || this._node instanceof LogicalDataNode) : "Node is not acceptable with Data Viewer";
        String string = null;
        try {
            baseTreeNode = ConnectionFolder.getConnectionFolder(this._context);
            string = ((ConnectionFolder)baseTreeNode).getUserAccountName();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
        }
        if (this._node instanceof PhysicalDataNode) {
            baseTreeNode = (PhysicalDataNode)this._node;
            this._schemaName = ((DataNode)baseTreeNode).getUserName();
            this._tableName = ((PhysicalDataNode)baseTreeNode).getTableName();
            this._cacheTableName = ((DataNode)baseTreeNode).getCacheTableName();
            this._cacheSchemaName = ((DataNode)baseTreeNode).getCacheSchemaName();
            if (this._cacheTableName.length() == 0) {
                this._currentSourceOption = DataSourceViewOption.ACTUAL;
            }
        } else if (this._node instanceof GLMRModelNode) {
            baseTreeNode = (GLMRModelNode)this._node;
            RGeneralizedLinearModelType rGeneralizedLinearModelType = (RGeneralizedLinearModelType)baseTreeNode.getRepositoryData();
            this._schemaName = string;
            this._tableName = rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME();
            this._cacheSchemaName = "";
            this._cacheTableName = "";
            this._currentSourceOption = DataSourceViewOption.ACTUAL;
        } else if (this._node instanceof GLMCModelNode) {
            baseTreeNode = (GLMCModelNode)this._node;
            CGeneralizedLinearModelType cGeneralizedLinearModelType = (CGeneralizedLinearModelType)baseTreeNode.getRepositoryData();
            this._schemaName = string;
            this._tableName = cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSDIAGNOSTICSTABLENAME();
            this._cacheSchemaName = "";
            this._cacheTableName = "";
            this._currentSourceOption = DataSourceViewOption.ACTUAL;
        } else if (this._node instanceof LogicalDataNode) {
            baseTreeNode = (LogicalDataNode)this._node;
            this._schemaName = "";
            this._tableName = "";
            this._cacheTableName = ((DataNode)baseTreeNode).getCacheTableName();
            this._cacheSchemaName = ((DataNode)baseTreeNode).getCacheSchemaName();
            if (this._selectSQL == null) {
                this._selectSQL = this.getStackedSQL();
            }
            if (this._cacheTableName.length() == 0) {
                this._currentSourceOption = DataSourceViewOption.ACTUAL;
            }
        } else if (this._node instanceof DataProfilePhysicalNode) {
            baseTreeNode = (DataProfilePhysicalNode)this._node;
            this._schemaName = ((DataNode)baseTreeNode).getCacheSchemaName();
            this._tableName = ((DataNode)baseTreeNode).getCacheTableName();
            this._cacheTableName = ((DataNode)baseTreeNode).getCacheTableName();
            this._cacheSchemaName = ((DataNode)baseTreeNode).getCacheSchemaName();
            if (this._cacheTableName.length() == 0) {
                this._currentSourceOption = DataSourceViewOption.ACTUAL;
            }
        }
        this._resultSetModel = new ODMrResultSetTableModel(this);
    }

    private String getStackedSQL() {
        DataNode dataNode = (DataNode)this._context.getNode();
        WorkflowNode workflowNode = (WorkflowNode)dataNode.getParent().getAncestor(WorkflowNode.class);
        WorkflowModel workflowModel = workflowNode.getWorkflowModel();
        if (workflowModel == null) {
            return null;
        }
        DataNodeType dataNodeType = (DataNodeType)dataNode.getRepositoryData();
        AbstractDataNode abstractDataNode = (AbstractDataNode)workflowModel.findNodeByMetadataId(dataNodeType.getId());
        if (abstractDataNode == null) {
            return null;
        }
        return abstractDataNode.getStackedSQL(workflowModel);
    }

    public String getSchema() {
        return this._schemaName;
    }

    public String getName() {
        return this._tableName;
    }

    private synchronized Connection getConnection() throws SQLException {
        if (this._conn == null) {
            this._conn = this._context != null ? ConnectionFolder.getConnection(this._context, ConnectionProperties.UNIQUE, ConnectionProperties.ALTER_SESSION_FIXES) : ConnectionFolder.getConnection(this._connectionName, ConnectionProperties.ALTER_SESSION_FIXES);
        }
        return this._conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        DataViewerState dataViewerState = this;
        synchronized (dataViewerState) {
            this._resultSetModel.setConnection(this.getConnection(), this._context);
        }
        if (!(this._node instanceof PhysicalDataNode) && (this._node instanceof GLMRModelNode || this._node instanceof GLMCModelNode)) {
            this._modelViewerState = new ModelViewerState1(this._context);
            this._modelViewerState.load();
            assert (this._modelViewerState.getModelDesc().isGeneralizedLinearModelAlgorithm()) : "Data Viewer accepts only models of type GLM";
        }
    }

    public static String getParallelHint() {
        String string = "";
        String string2 = parallelQueryPreferences.getViewDataProperty(ViewDataParallelPanel.VIEW_KEY, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
        String string3 = parallelQueryPreferences.getViewDataProperty(ViewDataParallelPanel.VIEW_KEY, ParallelQueryPreferences.PROPERTY.VALUE);
        if (string2 == null || !Boolean.parseBoolean(string2)) {
            string = "";
        } else {
            if (string3 == null || string3.equalsIgnoreCase("System Determined")) {
                string = "PARALLEL (AUTO)";
            } else {
                String string4 = String.valueOf(string3);
                string = StringUtils.getReplacedString("PARALLEL (<DOP>)", "<DOP>", string4);
            }
            string = "/*+ " + string + " */";
        }
        return string;
    }

    private String getQueryFromActual() {
        if (this._node instanceof PhysicalDataNode || this._node instanceof GLMCModelNode || this._node instanceof GLMRModelNode) {
            List list;
            Attributes attributes;
            DataNodeType dataNodeType;
            BaseTreeNode baseTreeNode = (BaseTreeNode)this._node;
            Object object = baseTreeNode.getRepositoryData();
            if (object instanceof DataNodeType && (dataNodeType = (DataNodeType)object) instanceof DataSourceNodeType && (attributes = ((DataSourceNodeType)dataNodeType).getAttributes()) != null && (list = attributes.getAttribute()) != null && !list.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder("SELECT ");
                stringBuilder.append(DataViewerState.getParallelHint() + " ");
                boolean bl = true;
                for (AttributeType attributeType : list) {
                    if (!bl) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(attributeType.getAlias() != null ? StringUtils.addDoubleQuotes(attributeType.getName()) + " AS " + StringUtils.addDoubleQuotes(attributeType.getAlias()) : StringUtils.addDoubleQuotes(attributeType.getName()));
                    bl = false;
                }
                stringBuilder.append(" FROM \"" + this.getSchema() + "\".\"" + this.getName() + "\"");
                return stringBuilder.toString();
            }
            return "SELECT " + DataViewerState.getParallelHint() + " * FROM \"" + this.getSchema() + "\".\"" + this.getName() + "\"";
        }
        if (this._node instanceof LogicalDataNode) {
            if (this._selectSQL == null) {
                return null;
            }
            return "select " + DataViewerState.getParallelHint() + " * from ( " + this._selectSQL + " )";
        }
        if (this._node instanceof DataProfilePhysicalNode) {
            String string = ((DataProfilePhysicalNode)this._node).getStatsTableName();
            return "SELECT " + DataViewerState.getParallelHint() + " * FROM \"" + string + "\"";
        }
        return "select 'not implemented' as NOT_IMPLEMENTED from dual";
    }

    private String getQueryFromCache() {
        return "SELECT " + DataViewerState.getParallelHint() + " * FROM \"" + this._cacheSchemaName + "\".\"" + this._cacheTableName + "\"";
    }

    private String getQueryFromManual() {
        return "SELECT " + DataViewerState.getParallelHint() + " * FROM \"" + this._schemaName + "\".\"" + this._tableName + "\"";
    }

    public String getQuery() {
        String string;
        if (this._loadFromNode) {
            switch (this._currentSourceOption) {
                case CACHE: {
                    string = this.getQueryFromCache();
                    break;
                }
                case ACTUAL: {
                    string = this.getQueryFromActual();
                    break;
                }
                default: {
                    string = "";
                    break;
                }
            }
        } else {
            string = this._loadFromSQL ? this._selectSQL : this.getQueryFromManual();
        }
        return string;
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        if (this._resultSetModel != null && this._resultSetModel.isUIUpdated()) {
            try {
                this._resultSetModel.closeConnection();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        }
    }

    public void closeRS() {
        if (this._resultSetModel != null) {
            this._resultSetModel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadModel() throws Exception {
        this._resultSetModel.setResultSet(null);
        Object object = this;
        synchronized (object) {
            this._resultSetModel.setConnection(this.getConnection(), this._context);
        }
        object = this.getQuery();
        if (object == null) {
            object = "SELECT '" + DataLrb.get("DATA_VIEWER_ACTUAL_NO_QUERY_AVAILABLE") + "' as MESSAGE FROM DUAL";
            this._resultSetModel.setUseStandardColumnSize(true);
            this._resultSetModel.setStandardColumnSize(800);
        }
        this._resultSetModel.setSql((String)object);
        this._resultSetModel.setBindMap(null);
        this._resultSetModel.setTranslatedColNames(true);
        if (this._node instanceof GLMRModelNode || this._node instanceof GLMCModelNode) {
            this._resultSetModel.setUseStandardColumnSize(true);
            this._resultSetModel.setStandardColumnSize(100);
        }
        this._resultSetModel.setThreaded(false);
        this._resultSetModel.setVerticalDisplay(false);
        this._resultSetModel.setSortCol(-1);
    }

    public void setResultSetModel(ODMrResultSetTableModel oDMrResultSetTableModel) {
        this._resultSetModel = oDMrResultSetTableModel;
    }

    public ODMrResultSetTableModel getResultSetModel() {
        return this._resultSetModel;
    }

    public void setCurrentSourceOption(DataSourceViewOption dataSourceViewOption) throws Exception {
        this._currentSourceOption = dataSourceViewOption;
    }

    public void reloadModel() throws Exception {
        String string = this._resultSetModel.getWhere();
        String string2 = this._resultSetModel.getOrderBy();
        this._resultSetModel = new ODMrResultSetTableModel(this);
        this._resultSetModel.setWhere(string);
        this._resultSetModel.setOrderBy(string2);
        this.loadModel();
    }

    public DataSourceViewOption getCurrentSourceOption() {
        return this._currentSourceOption;
    }
}

