/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.MatrixInfo;
import oracle.dmt.dataminer.controls.PerformanceInfo;
import oracle.dmt.dataminer.controls.PriorsInfo;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningModelAttributes;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.ModelGeneralDescription;
import oracle.dmt.dataminer.server.model.PartitionModelViewerAttributes;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.ConnectionProperties;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;

public class Model {
    private static final Logger theLogger = Logger.getLogger(Model.class.getName());
    private String _modelName;
    private String _userName;
    private boolean _loaded;
    private Vector<MiningModelSettings> _modelSettings;
    private ModelGeneralDescription _modelGeneralDescription;
    static String BASE_QUERY = "select ATTRIBUTE_NAME  from all_mining_model_attributes WHERE OWNER = ? AND MODEL_NAME=? AND DATA_TYPE = 'BFILE' and USAGE_TYPE='ACTIVE'";
    private static String _SETTING_VALUE = "select SETTING_VALUE from ALL_MINING_MODEL_SETTINGS WHERE OWNER=? and MODEL_NAME=? AND SETTING_NAME=?";
    private static String _TARGET_VALUE = "TARGET_VALUE";
    private static String _ACTUAL = "ACTUAL";
    private static String _PREDICTED = "PREDICTED";
    private static String _ACTUAL_TARGET_VALUE = "ACTUAL_TARGET_VALUE";
    private static String _PREDICTED_TARGET_VALUE = "PREDICTED_TARGET_VALUE";
    private static String _PRIOR_PROBABILITY = "PRIOR_PROBABILITY";
    private static String _CLASS_WEIGHT = "CLASS_WEIGHT";
    private static String _COST = "COST";
    private static final String COSTS_MATRIX_QRY = "select " + _ACTUAL + "," + _PREDICTED + "," + _COST + " from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(?))";
    private static String _SVM_WEIGHT_QRY = "select " + _TARGET_VALUE + ", " + _CLASS_WEIGHT + " from ";
    private static String _NB_PRIOR_QRY = "select " + _TARGET_VALUE + ", " + _PRIOR_PROBABILITY + " from ";
    private static String _GLM_WEIGHT_QRY = "select * from ";
    private static String _SVM_COST_QRY = "select " + _ACTUAL_TARGET_VALUE + "," + _PREDICTED_TARGET_VALUE + "," + _COST + " from ";
    private static String _GLM_CLASS_REFERENCE_VALUES_COMPLEMENTARY = "select distinct CLASS from TABLE(dbms_data_mining.get_model_details_glm(?))";

    public Model(String string) {
        this(null, string);
    }

    public Model(String string, String string2) {
        this._userName = string;
        this._modelName = string2;
        this._loaded = false;
    }

    public Model() {
        this._loaded = false;
    }

    public static String getCombinedUserNameModelName(String string, String string2, boolean bl) {
        String string3 = "\"" + string + "\".\"" + string2.toUpperCase() + "\"";
        if (bl) {
            string3 = StringUtils.escapeSingleQuotesForSQL(string3);
        }
        return string3;
    }

    public ModelGeneralDescription getModelGeneralDescription() {
        assert (this._loaded) : "Accesing model details prior to loading.";
        return this._modelGeneralDescription;
    }

    public Vector<MiningModelSettings> getModelSettings() {
        assert (this._loaded) : "Accesing model details prior to loading.";
        return this._modelSettings;
    }

    public synchronized void load(ConnectionManager connectionManager) throws SQLException {
        assert (this._modelName.trim().length() > 0) : "Model name is empty. Unable to load model.";
        if (this._loaded) {
            return;
        }
        this.loadModelGeneralDescription(connectionManager);
        this.loadModelSetting(connectionManager);
        this._loaded = true;
    }

    private void loadModelSetting(ConnectionManager connectionManager) throws SQLException {
        this._modelSettings = this.getModelSetting(connectionManager, this._userName, this._modelName);
    }

    public Vector<MiningModelSettings> getModelSetting(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        Vector<String> vector = new Vector<String>();
        vector.add(string2);
        return this.getModelSettings(connectionManager, string, vector);
    }

    public String getRegressionModelTarget(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = "select ATTRIBUTE_NAME  from all_mining_model_attributes WHERE OWNER = ? AND TARGET='YES' AND MODEL_NAME=?";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string4);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string3 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBFILEColumns(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        CharSequence charSequence;
        ArrayList<String> arrayList = new ArrayList<String>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(BASE_QUERY);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                charSequence = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                arrayList.add((String)charSequence);
            }
        }
        charSequence = new StringBuilder();
        for (String string3 : arrayList) {
            if (((StringBuilder)charSequence).length() > 0) {
                ((StringBuilder)charSequence).append(", ");
            }
            ((StringBuilder)charSequence).append("bfilename(NULL,NULL) ");
            ((StringBuilder)charSequence).append(string3);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public List<String> getModelAttributes(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = "select ATTRIBUTE_NAME  from all_mining_model_attributes WHERE OWNER = ? AND MODEL_NAME=?";
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string4 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                arrayList.add(string4);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public static Vector<MiningModelSettings> getModelSettings(ConnectionManager connectionManager, Vector<String> vector) throws SQLException {
        Vector<MiningModelSettings> vector2 = new Vector<MiningModelSettings>();
        SQLHelper sQLHelper = new SQLHelper();
        String string = " SELECT OWNER  ,\n  MODEL_NAME   ,\n  SETTING_NAME ,\n  SETTING_VALUE,\n  SETTING_TYPE\n   FROM ALL_MINING_MODEL_SETTINGS\n   WHERE '\"' || OWNER || '\".\"' || MODEL_NAME || '\"' IN(<MODEL_LIST>)";
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = vector.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("'" + iterator.next() + "'");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        string2 = StringUtils.getReplacedString(string, "<MODEL_LIST>", stringBuffer.toString());
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string2);
            sQLHelper.pstmt.setFetchSize(100);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                MiningModelSettings miningModelSettings = new MiningModelSettings(sQLHelper.rs.getString("OWNER"), sQLHelper.rs.getString("MODEL_NAME"), sQLHelper.rs.getString("SETTING_NAME"), sQLHelper.rs.getString("SETTING_VALUE"), sQLHelper.rs.getString("SETTING_TYPE"));
                vector2.add(miningModelSettings);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return vector2;
    }

    public Vector<MiningModelSettings> getModelSettings(ConnectionManager connectionManager, String string, Vector<String> vector) throws SQLException {
        Object object;
        Vector<MiningModelSettings> vector2 = new Vector<MiningModelSettings>();
        SQLHelper sQLHelper = new SQLHelper();
        String string2 = "select OWNER, MODEL_NAME,SETTING_NAME,SETTING_VALUE,SETTING_TYPE from ALL_MINING_MODEL_SETTINGS";
        String string3 = null;
        if (vector == null) {
            string3 = string2;
        } else {
            object = new StringBuffer("WHERE MODEL_NAME IN(");
            Iterator<String> iterator = vector.iterator();
            while (iterator.hasNext()) {
                ((StringBuffer)object).append("'" + iterator.next().toUpperCase() + "'");
                if (!iterator.hasNext()) continue;
                ((StringBuffer)object).append(",");
            }
            ((StringBuffer)object).append(")");
            ((StringBuffer)object).append(" AND OWNER = ?");
            string3 = string2 + " " + ((StringBuffer)object).toString();
        }
        try {
            sQLHelper.conn = connectionManager.getConnection(ConnectionProperties.ALTER_SESSION_FIXES);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setFetchSize(100);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                object = new MiningModelSettings(sQLHelper.rs.getString("OWNER"), sQLHelper.rs.getString("MODEL_NAME"), sQLHelper.rs.getString("SETTING_NAME"), sQLHelper.rs.getString("SETTING_VALUE"), sQLHelper.rs.getString("SETTING_TYPE"));
                vector2.add((MiningModelSettings)object);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return vector2;
    }

    public Vector<MiningModelSettings> getModelSettings(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        Vector<MiningModelSettings> vector = new Vector<MiningModelSettings>();
        String string3 = "select MODEL_NAME,SETTING_NAME,SETTING_VALUE,SETTING_TYPE from ALL_MINING_MODEL_SETTINGS WHERE OWNER=? and MODEL_NAME=?";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2);
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string3);
            while (sQLHelper.rs.next()) {
                MiningModelSettings miningModelSettings = new MiningModelSettings(string, string2, sQLHelper.rs.getString("SETTING_NAME"), sQLHelper.rs.getString("SETTING_VALUE"), sQLHelper.rs.getString("SETTING_TYPE"));
                vector.add(miningModelSettings);
            }
        }
        return vector;
    }

    private void loadModelGeneralDescription(ConnectionManager connectionManager) throws SQLException {
        this._modelGeneralDescription = this.getModelGeneralDescription(connectionManager, this._userName, this._modelName);
    }

    public ModelGeneralDescription getModelGeneralDescription(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        Vector<String> vector = new Vector<String>();
        vector.add(string2);
        Vector<ModelGeneralDescription> vector2 = this.getModelGeneralDescriptions(connectionManager, string, vector);
        if (vector2 == null || vector2.isEmpty()) {
            return ModelGeneralDescription._NONE;
        }
        return vector2.get(0);
    }

    public Vector<ModelGeneralDescription> getModelGeneralDescriptions(ConnectionManager connectionManager, String string, Vector<String> vector) throws SQLException {
        Object object;
        Vector<ModelGeneralDescription> vector2 = new Vector<ModelGeneralDescription>();
        SQLHelper sQLHelper = new SQLHelper();
        String string2 = "select OWNER, MODEL_NAME, MINING_FUNCTION, ALGORITHM, CREATION_DATE, BUILD_DURATION, MODEL_SIZE,COMMENTS from ALL_MINING_MODELS";
        String string3 = null;
        if (vector == null) {
            string3 = string2;
        } else {
            object = new StringBuffer("WHERE MODEL_NAME IN(");
            Iterator<String> iterator = vector.iterator();
            while (iterator.hasNext()) {
                ((StringBuffer)object).append("'" + iterator.next().toUpperCase() + "'");
                if (!iterator.hasNext()) continue;
                ((StringBuffer)object).append(",");
            }
            ((StringBuffer)object).append(")");
            ((StringBuffer)object).append(" AND OWNER = ?");
            string3 = string2 + " " + ((StringBuffer)object).toString();
        }
        try {
            sQLHelper.conn = connectionManager.getConnection(ConnectionProperties.ALTER_SESSION_FIXES);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setFetchSize(100);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                object = new ModelGeneralDescription(sQLHelper.rs.getString("OWNER"), sQLHelper.rs.getString("MODEL_NAME"), sQLHelper.rs.getString("MINING_FUNCTION"), sQLHelper.rs.getString("ALGORITHM"), sQLHelper.rs.getDate("CREATION_DATE"), sQLHelper.rs.getBigDecimal("BUILD_DURATION"), sQLHelper.rs.getBigDecimal("MODEL_SIZE"), sQLHelper.rs.getString("COMMENTS"));
                vector2.add((ModelGeneralDescription)object);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return vector2;
    }

    public static Vector<String> getModelNames(ConnectionManager connectionManager, String string, String string2, boolean bl) throws SQLException {
        Vector<String> vector = new Vector<String>();
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = null;
        string3 = bl ? "select MODEL_NAME from USER_MINING_MODELS " : "select MODEL_NAME from ALL_MINING_MODELS ";
        String string4 = "where MINING_FUNCTION = '" + string + "' AND " + " ALGORITHM = '" + string2 + "' ";
        String string5 = "order by MODEL_NAME";
        String string6 = string3 + string4 + string5;
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string6);
            while (sQLHelper.rs.next()) {
                vector.add(sQLHelper.rs.getString("MODEL_NAME"));
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    public static boolean isModelExists(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = null;
        string3 = "select MODEL_NAME from ALL_MINING_MODELS ";
        boolean bl = false;
        String string4 = "where MODEL_NAME = '" + string2 + "' " + " AND OWNER = '" + string + "' ";
        String string5 = string3 + string4;
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string5);
            if (sQLHelper.rs.next()) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return bl;
    }

    public Vector<ModelGeneralDescription> getAllModelGeneralDescriptions(ConnectionManager connectionManager) throws SQLException {
        return this.getModelGeneralDescriptions(connectionManager, this._userName, null);
    }

    public static PartitionModelViewerAttributes getPartitionKeyAttributes(ConnectionManager connectionManager, String string, String string2, String string3, List<MiningAttributeType> list) throws SQLException {
        PartitionModelViewerAttributes partitionModelViewerAttributes = PartitionModelViewerAttributes.getPartitionModelViewerAttributes(connectionManager, string, string3, string2);
        return partitionModelViewerAttributes;
    }

    public static MiningModelAttributes getMiningModelAttributes(ConnectionFolder connectionFolder, String string, String string2, String string3, List<MiningAttributeType> list) {
        MiningModelAttributes miningModelAttributes = null;
        try {
            Version version = connectionFolder.getDbVersion();
            Version version2 = new Version("11.2.0.1.2");
            miningModelAttributes = version.compareTo((Object)version2) < 0 ? MiningModelAttributes.getMiningModelAttributes2(connectionFolder, string, string2) : MiningModelAttributes.getMiningModelAttributes(connectionFolder, string, string2, string3, list);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        return miningModelAttributes;
    }

    public String getModelName() {
        return this._modelName;
    }

    public String getUserName() {
        return this._userName;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CostMatrixInfo getModelCostMatrix(ConnectionManager connectionManager, String string, String string2) {
        CostMatrixInfo costMatrixInfo = new CostMatrixInfo("BUILD_SETTING_CSTBNF_OP_TRUE");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(COSTS_MATRIX_QRY);
            String string3 = "\"" + string + "\".\"" + string2 + "\"";
            sQLHelper.pstmt.setString(1, string3);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string4 = sQLHelper.rs.getString(_ACTUAL);
                String string5 = sQLHelper.rs.getString(_PREDICTED);
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(_COST);
                if (bigDecimal == null) continue;
                costMatrixInfo.setType("T");
                if (string4 == null || 0 == string4.length() || string5 == null || 0 == string5.length()) continue;
                costMatrixInfo.put(string4, string5, bigDecimal);
            }
            if (costMatrixInfo.isEmpty()) {
                costMatrixInfo = CostMatrixInfo._NONE;
            }
        }
        return costMatrixInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PerformanceInfo getGLMWeights(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        String string3 = "CLAS_WEIGHTS_TABLE_NAME";
        String string4 = Model.getSettingValue(connectionManager, string, string2, string3);
        if (string4 == null || string4.isEmpty()) {
            return null;
        }
        String string5 = string4.toUpperCase();
        if (!DatabaseMetadataUtils.isTable(connectionManager, string, string5)) {
            return null;
        }
        Hashtable<String, String> hashtable = DatabaseMetadataUtils.getColumnTypes(connectionManager, string, string5);
        if (hashtable == null || hashtable.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(_GLM_WEIGHT_QRY);
        stringBuffer.append("\"" + string + "\".\"" + string4 + "\"");
        PerformanceInfo performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_CUST");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer.toString());
            while (sQLHelper.rs.next()) {
                Enumeration<String> enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string6 = enumeration.nextElement();
                    String string7 = hashtable.get(string6);
                    Object object = null;
                    object = string7.equals("NUMBER") || string7.equals("FLOAT") || string7.equals("BINARY_FLOAT") || string7.equals("BINARY_DOUBLE") ? sQLHelper.rs.getBigDecimal(_TARGET_VALUE) : sQLHelper.rs.getString(_TARGET_VALUE);
                    BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(_CLASS_WEIGHT);
                    assert (bigDecimal != null) : "Performance value is missing!";
                    if (object != null && null != bigDecimal) {
                        performanceInfo.put(object.toString(), bigDecimal);
                        continue;
                    }
                    assert (object == null && bigDecimal == null) : "incorrect Performance  specification";
                }
            }
        }
        return performanceInfo;
    }

    public static PerformanceInfo getSVMWeights(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        String string3 = "CLAS_WEIGHTS_TABLE_NAME";
        PerformanceInfo performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_CUST");
        Model.getWeights(connectionManager, string, string2, string3, performanceInfo);
        if (performanceInfo.isEmpty()) {
            return null;
        }
        return performanceInfo;
    }

    public static PriorsInfo getNBPriors(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        PriorsInfo priorsInfo = new PriorsInfo("Y");
        String string3 = "CLAS_PRIORS_TABLE_NAME";
        Model.getPriors(connectionManager, string, string2, string3, priorsInfo);
        if (priorsInfo.isEmpty()) {
            return null;
        }
        return priorsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getPriors(ConnectionManager connectionManager, String string, String string2, String string3, MatrixInfo matrixInfo) throws SQLException {
        String string4 = Model.getSettingValue(connectionManager, string, string2, string3);
        if (string4 == null || string4.isEmpty()) {
            return;
        }
        String string5 = string4.toUpperCase();
        if (!DatabaseMetadataUtils.isTable(connectionManager, string, string5)) {
            return;
        }
        String string6 = DatabaseMetadataUtils.getColumnType(connectionManager, string, string5, _TARGET_VALUE);
        if (string6 == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(_NB_PRIOR_QRY);
        stringBuffer.append("\"" + string + "\".\"" + string4 + "\"");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer.toString());
            while (sQLHelper.rs.next()) {
                Object object = null;
                object = string6.equals("NUMBER") || string6.equals("FLOAT") || string6.equals("BINARY_FLOAT") || string6.equals("BINARY_DOUBLE") ? sQLHelper.rs.getBigDecimal(_TARGET_VALUE) : sQLHelper.rs.getString(_TARGET_VALUE);
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(_PRIOR_PROBABILITY);
                assert (bigDecimal != null) : "Performance value is missing!";
                if (object != null && null != bigDecimal) {
                    matrixInfo.put(object.toString(), bigDecimal);
                    continue;
                }
                assert (object == null && bigDecimal == null) : "incorrect Performance  specification";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getWeights(ConnectionManager connectionManager, String string, String string2, String string3, MatrixInfo matrixInfo) throws SQLException {
        String string4 = Model.getSettingValue(connectionManager, string, string2, string3);
        if (string4 == null || string4.isEmpty()) {
            return;
        }
        String string5 = string4.toUpperCase();
        if (!DatabaseMetadataUtils.isTable(connectionManager, string, string5)) {
            return;
        }
        String string6 = DatabaseMetadataUtils.getColumnType(connectionManager, string, string5, _TARGET_VALUE);
        if (string6 == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(_SVM_WEIGHT_QRY);
        stringBuffer.append("\"" + string + "\".\"" + string4 + "\"");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer.toString());
            while (sQLHelper.rs.next()) {
                Object object = null;
                object = string6.equals("NUMBER") || string6.equals("FLOAT") || string6.equals("BINARY_FLOAT") || string6.equals("BINARY_DOUBLE") ? sQLHelper.rs.getBigDecimal(_TARGET_VALUE) : sQLHelper.rs.getString(_TARGET_VALUE);
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(_CLASS_WEIGHT);
                assert (bigDecimal != null) : "Performance value is missing!";
                if (object != null && null != bigDecimal) {
                    matrixInfo.put(object.toString(), bigDecimal);
                    continue;
                }
                assert (object == null && bigDecimal == null) : "incorrect Performance  specification";
            }
        }
    }

    private static String getSettingValue(ConnectionManager connectionManager, String string, String string2, String string3) throws SQLException {
        String string4 = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(_SETTING_VALUE);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2.toUpperCase());
            sQLHelper.pstmt.setString(3, string3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string4 = sQLHelper.rs.getString("SETTING_VALUE");
            }
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CostMatrixInfo getModelBuildCostMatrix(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        String string3 = "CLAS_COST_TABLE_NAME";
        String string4 = Model.getSettingValue(connectionManager, string, string2, string3);
        if (string4 == null || string4.isEmpty()) {
            return null;
        }
        String string5 = string4.toUpperCase();
        if (!DatabaseMetadataUtils.isTable(connectionManager, string, string5)) {
            return null;
        }
        String string6 = DatabaseMetadataUtils.getColumnType(connectionManager, string, string5, _ACTUAL_TARGET_VALUE);
        if (string6 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(_SVM_COST_QRY);
        stringBuffer.append("\"" + string + "\".\"" + string4 + "\"");
        CostMatrixInfo costMatrixInfo = new CostMatrixInfo("BUILD_SETTING_CSTBNF_OP_TRUE");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer.toString());
            while (sQLHelper.rs.next()) {
                String string7 = null;
                String string8 = null;
                string7 = sQLHelper.rs.getString(_ACTUAL_TARGET_VALUE);
                string8 = sQLHelper.rs.getString(_PREDICTED_TARGET_VALUE);
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(_COST);
                if (bigDecimal == null) continue;
                costMatrixInfo.setType("T");
                if (string7 == null || string8 == null) continue;
                costMatrixInfo.put(string7, string8, bigDecimal);
            }
        }
        return costMatrixInfo;
    }

    public static void doModelsContainScoringCostMatrix(ConnectionManager connectionManager, ModelNodeType.Models models, Vector<MiningModelSettings> vector, boolean bl) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        String string = "IMBEDDED_SCORING_COST_MATRIX";
        String string2 = "INPUT";
        String string3 = "TRUE";
        try {
            Object object;
            Object object2;
            Object object32;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Object object32 : models.getModel()) {
                List list;
                if (bl && (object2 = object32.getPartitionExpressions()) != null && (list = object2.getPartitionExpression()) != null && list.size() > 0 && (object = (PartitionExpressionType)list.get(0)).getPartitionAttribute() != null && !"".equals(object.getPartitionAttribute().getName().trim())) {
                    boolean bl2 = false;
                    for (MiningModelSettings miningModelSettings : vector) {
                        if (miningModelSettings.getModelName().compareTo(object32.getName()) != 0 || miningModelSettings.getOwner().compareTo(object32.getSchema()) != 0 || !miningModelSettings.getSettingName().equals("CLAS_WEIGHTS_BALANCED") || !miningModelSettings.getSettingValue().equals("ON")) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    MiningModelSettings miningModelSettings = new MiningModelSettings(object32.getSchema(), object32.getName(), string, string3, string2);
                    vector.add(miningModelSettings);
                    continue;
                }
                arrayList.add(object32.getSchema());
                arrayList2.add(object32.getName());
            }
            if (arrayList2.size() == 0) {
                return;
            }
            sQLHelper.conn = connectionManager.getConnection();
            OracleConnection oracleConnection = (OracleConnection)sQLHelper.conn;
            object32 = oracleConnection.createOracleArray("ODMR_OBJECT_NAMES", (Object)arrayList.toArray(new String[arrayList.size()]));
            object2 = oracleConnection.createOracleArray("ODMR_OBJECT_NAMES", (Object)arrayList2.toArray(new String[arrayList2.size()]));
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareCall("SELECT * FROM TABLE (ODMRSYS.ODMR_UTIL.GET_MODELS_WITH_COST_MATRIX(?,?))");
            int n = 1;
            sQLHelper.opstmt.setArray(n++, (Array)object32);
            sQLHelper.opstmt.setArray(n++, (Array)object2);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string4 = sQLHelper.rs.getString("USER_NAME");
                object = sQLHelper.rs.getString("OBJECT_NAME");
                MiningModelSettings miningModelSettings = new MiningModelSettings(string4, (String)object, string, string3, string2);
                vector.add(miningModelSettings);
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "Failed trying to query for imbedded model cost matrix.", sQLException);
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
    }

    public static List<String> getGLMClassRefValues(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(_GLM_CLASS_REFERENCE_VALUES_COMPLEMENTARY);
            sQLHelper.pstmt.setString(1, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString("CLASS");
                arrayList.add(string3);
            }
        }
        return arrayList;
    }
}

