/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DmHistogramBin;
import oracle.dmt.dataminer.generated.server.DmHistograms;
import oracle.dmt.dataminer.server.model.AttributeBinIdentifier;

public class HistogramRowData {
    private String attribute_name;
    private String attribute_subname;
    private Integer bin_id;
    private Double lower_bound;
    private Double upper_bound;
    private String label;
    private Double count;

    public HistogramRowData() {
        this.attribute_name = "";
        this.attribute_subname = "";
        this.bin_id = 0;
        this.lower_bound = 0.0;
        this.upper_bound = 0.0;
        this.label = "";
        this.count = 0.0;
    }

    public HistogramRowData(String string, String string2, Integer n, Double d, Double d2, String string3, Double d3) {
        this.attribute_name = string;
        this.attribute_subname = string2;
        this.bin_id = n;
        this.lower_bound = d;
        this.upper_bound = d2;
        this.label = string3;
        this.count = d3;
    }

    public HistogramRowData(DmHistogramBin dmHistogramBin) throws SQLException {
        this.attribute_name = dmHistogramBin.getAttributeName();
        this.attribute_subname = dmHistogramBin.getAttributeSubname() != null ? dmHistogramBin.getAttributeSubname() : null;
        this.bin_id = dmHistogramBin.getBinId() != null ? Integer.valueOf(dmHistogramBin.getBinId().intValue()) : null;
        this.lower_bound = dmHistogramBin.getLowerBound() != null ? Double.valueOf(dmHistogramBin.getLowerBound().doubleValue()) : null;
        this.upper_bound = dmHistogramBin.getUpperBound() != null ? Double.valueOf(dmHistogramBin.getUpperBound().doubleValue()) : null;
        this.label = dmHistogramBin.getLabel() != null ? dmHistogramBin.getLabel() : null;
        this.count = dmHistogramBin.getCount() != null ? Double.valueOf(dmHistogramBin.getCount().doubleValue()) : null;
    }

    public static HashMap<AttributeBinIdentifier, HistogramRowData> createMappedAttributeHistogram(Vector<HistogramRowData> vector) {
        HashMap<AttributeBinIdentifier, HistogramRowData> hashMap = new HashMap<AttributeBinIdentifier, HistogramRowData>();
        AttributeBinIdentifier attributeBinIdentifier = null;
        for (HistogramRowData histogramRowData : vector) {
            attributeBinIdentifier = new AttributeBinIdentifier(histogramRowData.getFullAttributeName(), histogramRowData.getBin_id());
            hashMap.put(attributeBinIdentifier, histogramRowData);
        }
        return hashMap;
    }

    public static Vector<HistogramRowData> createAttributeHistogram(Vector<HistogramRowData> vector, String string) {
        Vector<HistogramRowData> vector2 = new Vector<HistogramRowData>();
        for (HistogramRowData histogramRowData : vector) {
            if (histogramRowData.getFullAttributeName().compareTo(string) != 0) continue;
            vector2.add(histogramRowData);
        }
        return vector2;
    }

    public static Vector<HistogramRowData> createAttributeHistogramFromMap(HashMap<AttributeBinIdentifier, HistogramRowData> hashMap, String string) {
        Vector<HistogramRowData> vector = new Vector<HistogramRowData>();
        boolean bl = true;
        int n = 1;
        HistogramRowData histogramRowData = null;
        AttributeBinIdentifier attributeBinIdentifier = new AttributeBinIdentifier(string, 1);
        while (bl) {
            attributeBinIdentifier.setBin_id(n);
            histogramRowData = hashMap.get(attributeBinIdentifier);
            if (histogramRowData == null) {
                bl = false;
                continue;
            }
            vector.add(histogramRowData);
        }
        return vector;
    }

    public String getFullAttributeName() {
        String string = this.attribute_subname != null ? this.attribute_name + "." + this.attribute_subname : this.attribute_name;
        return string;
    }

    public void setAttribute_name(String string) {
        this.attribute_name = string;
    }

    public String getAttribute_name() {
        return this.attribute_name;
    }

    public void setAttribute_subname(String string) {
        this.attribute_subname = string;
    }

    public String getAttribute_subname() {
        return this.attribute_subname;
    }

    public void setBin_id(Integer n) {
        this.bin_id = n;
    }

    public Integer getBin_id() {
        return this.bin_id;
    }

    public void setLower_bound(Double d) {
        this.lower_bound = d;
    }

    public Double getLower_bound() {
        return this.lower_bound;
    }

    public void setUpper_bound(Double d) {
        this.upper_bound = d;
    }

    public Double getUpper_bound() {
        return this.upper_bound;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setCount(Double d) {
        this.count = d;
    }

    public Double getCount() {
        return this.count;
    }

    public static Vector<HistogramRowData> createHistogramsFromDmHistograms(DmHistograms dmHistograms) throws SQLException {
        Vector<HistogramRowData> vector = new Vector<HistogramRowData>();
        for (int i = 0; i < dmHistograms.length(); ++i) {
            DmHistogramBin dmHistogramBin = dmHistograms.getElement(i);
            HistogramRowData histogramRowData = new HistogramRowData(dmHistogramBin);
            vector.add(histogramRowData);
        }
        return vector;
    }
}

