/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.CoefficientSortSpec;
import oracle.dmt.dataminer.server.model.FilterSetting;
import oracle.dmt.dataminer.server.model.GLMCoefficientRowData;
import oracle.dmt.dataminer.server.model.GLMModelDetails;
import oracle.dmt.dataminer.server.model.GLMModelDetailsRowData;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;

public class GLMModelDetailsImpl
implements GLMModelDetails {
    private static final Logger LOGGER = Logger.getLogger(GLMModelDetailsImpl.class.getName());
    public static final String CLASSIFICATION = "CLASSIFICATION";
    public static final String REGRESSION = "REGRESSION";
    private static final String PROPENSITY_TARGET_ONE = "propensity_target_one";
    private static final String PROPENSITY_TARGET_TWO = "propensity_target_two";
    private static final String QRY_CLASSIFICATION_COEFFICIENTS_Db11 = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT * FROM ( \n SELECT NVL2(attribute_subname,attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n      attribute_name \"attribute_name\", attribute_value \"attribute_value\", coefficient \"coefficient\", \n      STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT \"std_coefficient\", \n       LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT \n FROM  \t (SELECT class, attribute_name, attribute_subname, attribute_value,\n \t         STD_ERROR, TEST_STATISTIC, P_VALUE, <std_coefficient>, \n \t         <lower_coeff_limit>, <upper_coeff_limit>, <exp_coefficient>, <exp_lower_coeff_limit>, <exp_upper_coeff_limit>, \n \t         <coefficient_value> \n \t FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param)) \n \t WHERE class = :target_value_param \n \t <and1> <and2> <and3> ) r )\n \t <where_condition> \t) <order> \n \t) <rownum>  \n";
    private static final String QRY_CLASSIFICATION_COEFFICIENTS_Db12 = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT * FROM ( \n SELECT NVL2(attribute_subname,attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n feature_expression \"feature_expression\", \n      attribute_name \"attribute_name\", attribute_value \"attribute_value\", coefficient \"coefficient\", \n      STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT \"std_coefficient\", \n       LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT \n FROM  \t (SELECT class, attribute_name, attribute_subname,feature_expression, attribute_value,\n \t         STD_ERROR, TEST_STATISTIC, P_VALUE, <std_coefficient>, \n \t         <lower_coeff_limit>, <upper_coeff_limit>, <exp_coefficient>, <exp_lower_coeff_limit>, <exp_upper_coeff_limit>, \n \t         <coefficient_value> \n \t FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param)) \n \t WHERE class = :target_value_param \n \t <and1> <and2> <and3> ) r )\n \t <where_condition> \t) <order> \n \t) <rownum>  \n";
    private static final String QRY_CLASSIFICATION_COEFFICIENTS_Db12_partition = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT * FROM ( \n SELECT NVL2(attribute_subname,attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n feature_expression \"feature_expression\", \n      attribute_name \"attribute_name\", attribute_value \"attribute_value\", coefficient \"coefficient\", \n      STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT \"std_coefficient\", \n       LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT \n FROM  \t (SELECT class, attribute_name, attribute_subname,feature_expression, attribute_value,\n \t         STD_ERROR, TEST_STATISTIC, P_VALUE, <std_coefficient>, \n \t         <lower_coeff_limit>, <upper_coeff_limit>, <exp_coefficient>, <exp_lower_coeff_limit>, <exp_upper_coeff_limit>, \n \t         <coefficient_value> \n \t FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param, :partitionId)) \n \t WHERE class = :target_value_param \n \t <and1> <and2> <and3> ) r )\n \t <where_condition> \t) <order> \n \t) <rownum>  \n";
    private static final String QRY_REGRESSION_COEFFICIENTS_Db11 = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT * FROM ( \n SELECT NVL2(attribute_subname,attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n      attribute_name \"attribute_name\", attribute_value \"attribute_value\", coefficient \"coefficient\", \n      STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT \"std_coefficient\", \n       LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT \n FROM  \t (SELECT class, attribute_name, attribute_subname, attribute_value,\n \t         STD_ERROR, TEST_STATISTIC, P_VALUE, <std_coefficient>, \n \t         <lower_coeff_limit>, <upper_coeff_limit>, <exp_coefficient>, <exp_lower_coeff_limit>, <exp_upper_coeff_limit>, \n \t         <coefficient_value> \n \t FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param)) \n \t <where_key_word>  \t <and2> <and3> ) r )\n \t <where_condition> \t) <order> \n \t) <rownum>  \n";
    private static final String QRY_REGRESSION_COEFFICIENTS_Db12 = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT * FROM ( \n SELECT NVL2(attribute_subname,attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n feature_expression \"feature_expression\", \n      attribute_name \"attribute_name\", attribute_value \"attribute_value\", coefficient \"coefficient\", \n      STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT \"std_coefficient\", \n       LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT \n FROM  \t (SELECT class, attribute_name, attribute_subname,feature_expression, attribute_value,\n \t         STD_ERROR, TEST_STATISTIC, P_VALUE, <std_coefficient>, \n \t         <lower_coeff_limit>, <upper_coeff_limit>, <exp_coefficient>, <exp_lower_coeff_limit>, <exp_upper_coeff_limit>, \n \t         <coefficient_value> \n \t FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param)) \n \t <where_key_word>  \t <and2> <and3> ) r )\n \t <where_condition> \t) <order> \n \t) <rownum>  \n";
    private static final String QRY_REGRESSION_COEFFICIENTS_Db12_partition = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT * FROM ( \n SELECT NVL2(attribute_subname,attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n feature_expression \"feature_expression\", \n      attribute_name \"attribute_name\", attribute_value \"attribute_value\", coefficient \"coefficient\", \n      STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT \"std_coefficient\", \n       LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT \n FROM  \t (SELECT class, attribute_name, attribute_subname,feature_expression, attribute_value,\n \t         STD_ERROR, TEST_STATISTIC, P_VALUE, <std_coefficient>, \n \t         <lower_coeff_limit>, <upper_coeff_limit>, <exp_coefficient>, <exp_lower_coeff_limit>, <exp_upper_coeff_limit>, \n \t         <coefficient_value> \n \t FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param, :partitionId)) \n \t <where_key_word>  \t <and2> <and3> ) r )\n \t <where_condition> \t) <order> \n \t) <rownum>  \n";
    static final String QRY_ALL_PROPENSITIES_Db11_2 = "SELECT <COUNT_ONLY> FROM (\nSELECT * FROM (\n  SELECT \"target\", \n       NVL2( attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n       attribute_name  \"attribute_name\", \n        \"attribute_value\", \n       case when (c1 is not null) AND (c2 is not null) AND (c1 > c2) then c1 \n             when (c2 is null) then c1 \n             else null \n       end \"propensity_target_one\",\n       case when (c2 is not null) AND (c1 is not null) AND (c2 > c1) then c2 \n             when (c1 is null) then c2 \n             else null \n       end \"propensity_target_two\", \n       ( <ABSOLUTE_VALUE>( nvl(c1, 0) ) +  <ABSOLUTE_VALUE>(nvl(c2,0)) ) \"propensity_target\"\n  FROM (\n    SELECT t.class \"target_attribute_value\", t.class \"target\", \n           t.attribute_name, t.attribute_subname, t.attribute_value \"attribute_value\", \n           t.std_coefficient \"coefficient\"  \n   FROM \n     TABLE(dbms_data_mining.get_model_details_glm(:model_name_param)) t \n   <where_clause> \n  )\n  pivot(max(\"coefficient\") FOR \"target_attribute_value\" IN (<target_value_one> c1, <target_value_two> c2 ) )  where c1 is not null or c2 is not null \n) <where_clause_like> \n <order> \n) <rownum>  \n";
    static final String QRY_ALL_PROPENSITIES_Db12 = "SELECT <COUNT_ONLY> FROM (\nSELECT * FROM (\n  SELECT \"target\",feature_expression \"feature_expression\", \n       NVL2( attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n       attribute_name  \"attribute_name\", \n        \"attribute_value\", \n       case when (c1 is not null) AND (c2 is not null) AND (c1 > c2) then c1 \n             when (c2 is null) then c1 \n             else null \n       end \"propensity_target_one\",\n       case when (c2 is not null) AND (c1 is not null) AND (c2 > c1) then c2 \n             when (c1 is null) then c2 \n             else null \n       end \"propensity_target_two\", \n       ( <ABSOLUTE_VALUE>( nvl(c1, 0) ) +  <ABSOLUTE_VALUE>(nvl(c2,0)) ) \"propensity_target\"\n  FROM (\n    SELECT t.class \"target_attribute_value\", t.class \"target\", \n           t.attribute_name, t.attribute_subname, t.attribute_value \"attribute_value\", \n           t.std_coefficient \"coefficient\", t.feature_expression  \n   FROM \n     TABLE(dbms_data_mining.get_model_details_glm(:model_name_param)) t \n   <where_clause> \n  )\n  pivot(max(\"coefficient\") FOR \"target_attribute_value\" IN (<target_value_one> c1, <target_value_two> c2 ) )  where c1 is not null or c2 is not null \n) <where_clause_like> \n <order> \n) <rownum>  \n";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param))  \n   WHERE class IN(<target_values>)  ";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_REGRESSION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param))";
    private static final String QUERY_MIN_MAX = "WITH base_query AS\n  (SELECT attribute_name, nvl(t.std_coefficient, t.coefficient) coefficient\n  FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param)) t)\nSELECT MIN(coefficient) minimum_coefficient, MAX(coefficient) maximum_coefficient\nFROM base_query\nWHERE attribute_name is not null";

    public GLMModelDetailsImpl(String string) {
        assert (string.equalsIgnoreCase(CLASSIFICATION) || string.equalsIgnoreCase(REGRESSION)) : "Invalid GLM model type";
    }

    private Vector<GLMCoefficientRowData> invokeCoefficientQuery_Db11(SQLHelper sQLHelper) throws SQLException {
        Vector<GLMCoefficientRowData> vector = new Vector<GLMCoefficientRowData>();
        sQLHelper.opstmt.setFetchSize(1000);
        sQLHelper.ors = (OracleResultSet)sQLHelper.opstmt.executeQuery();
        Double d = null;
        Double d2 = null;
        Double d3 = null;
        Double d4 = null;
        Double d5 = null;
        Double d6 = null;
        Double d7 = null;
        Double d8 = null;
        Double d9 = null;
        while (sQLHelper.ors.next()) {
            String string;
            String string2 = sQLHelper.ors.getString("attribute_name");
            if (string2 == null) {
                string2 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
            }
            if ((string = sQLHelper.ors.getString("attribute_value")) == null) {
                string = "";
            }
            Double d10 = sQLHelper.ors.getDouble("coefficient");
            d = sQLHelper.ors.getDouble("STD_ERROR");
            d2 = sQLHelper.ors.getDouble("TEST_STATISTIC");
            d3 = sQLHelper.ors.getDouble("P_VALUE");
            d4 = sQLHelper.ors.getDouble("STD_COEFFICIENT");
            d5 = sQLHelper.ors.getDouble("LOWER_COEFF_LIMIT");
            d6 = sQLHelper.ors.getDouble("UPPER_COEFF_LIMIT");
            d7 = sQLHelper.ors.getDouble("EXP_COEFFICIENT");
            d8 = sQLHelper.ors.getDouble("EXP_LOWER_COEFF_LIMIT");
            d9 = sQLHelper.ors.getDouble("EXP_UPPER_COEFF_LIMIT");
            GLMCoefficientRowData gLMCoefficientRowData = new GLMCoefficientRowData(string2, string, d10, d, d2, d3, d4, d5, d6, d7, d8, d9);
            vector.add(gLMCoefficientRowData);
        }
        return vector;
    }

    private Vector<GLMCoefficientRowData> invokeCoefficientQuery_Db12(SQLHelper sQLHelper) throws SQLException {
        Vector<GLMCoefficientRowData> vector = new Vector<GLMCoefficientRowData>();
        sQLHelper.ors = (OracleResultSet)sQLHelper.opstmt.executeQuery();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Double d = null;
        Double d2 = null;
        Double d3 = null;
        Double d4 = null;
        Double d5 = null;
        Double d6 = null;
        Double d7 = null;
        Double d8 = null;
        Double d9 = null;
        while (sQLHelper.ors.next()) {
            string3 = sQLHelper.ors.getString("feature_expression");
            string = sQLHelper.ors.getString("attribute_name");
            string4 = sQLHelper.ors.getString("attribute_name_subname");
            string = string == null && string3 == null ? "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">" : (string == null ? string3 : string4);
            string2 = sQLHelper.ors.getString("attribute_value");
            if (string2 == null) {
                string2 = "";
            }
            Double d10 = sQLHelper.ors.getDouble("coefficient");
            d = sQLHelper.ors.getDouble("STD_ERROR");
            d2 = sQLHelper.ors.getDouble("TEST_STATISTIC");
            d3 = sQLHelper.ors.getDouble("P_VALUE");
            d4 = sQLHelper.ors.getDouble("STD_COEFFICIENT");
            d5 = sQLHelper.ors.getDouble("LOWER_COEFF_LIMIT");
            d6 = sQLHelper.ors.getDouble("UPPER_COEFF_LIMIT");
            d7 = sQLHelper.ors.getDouble("EXP_COEFFICIENT");
            d8 = sQLHelper.ors.getDouble("EXP_LOWER_COEFF_LIMIT");
            d9 = sQLHelper.ors.getDouble("EXP_UPPER_COEFF_LIMIT");
            GLMCoefficientRowData gLMCoefficientRowData = new GLMCoefficientRowData(string, string2, d10, d, d2, d3, d4, d5, d6, d7, d8, d9);
            vector.add(gLMCoefficientRowData);
        }
        return vector;
    }

    private Vector<CoefficientRowData> invokeCompareQuery_Db11(SQLHelper sQLHelper) throws SQLException {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        sQLHelper.ors = (OracleResultSet)sQLHelper.opstmt.executeQuery();
        while (sQLHelper.ors.next()) {
            String string;
            String string2 = sQLHelper.ors.getString("attribute_name");
            if (string2 == null) {
                string2 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
            }
            if ((string = sQLHelper.ors.getString("attribute_value")) == null) {
                string = "";
            }
            BigDecimal bigDecimal = sQLHelper.ors.getBigDecimal(PROPENSITY_TARGET_ONE);
            BigDecimal bigDecimal2 = sQLHelper.ors.getBigDecimal(PROPENSITY_TARGET_TWO);
            if (bigDecimal == null && bigDecimal2 != null) {
                bigDecimal = new BigDecimal(-1.0 * bigDecimal2.doubleValue());
            } else if (bigDecimal2 == null && bigDecimal != null) {
                bigDecimal2 = new BigDecimal(-1.0 * bigDecimal.doubleValue());
            }
            CoefficientRowData coefficientRowData = new CoefficientRowData(string2, string, bigDecimal != null ? Double.valueOf(bigDecimal.doubleValue()) : null, bigDecimal2 != null ? Double.valueOf(bigDecimal2.doubleValue()) : null);
            vector.add(coefficientRowData);
        }
        return vector;
    }

    private Vector<CoefficientRowData> invokeCompareQuery_Db12(SQLHelper sQLHelper) throws SQLException {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        try {
            sQLHelper.ors = (OracleResultSet)sQLHelper.opstmt.executeQuery();
            while (sQLHelper.ors.next()) {
                String string = sQLHelper.ors.getString("feature_expression");
                String string2 = sQLHelper.ors.getString("attribute_name");
                String string3 = sQLHelper.ors.getString("attribute_name_subname");
                string2 = string2 == null && string == null ? "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">" : (string2 == null ? string : string3);
                String string4 = sQLHelper.ors.getString("attribute_value");
                if (string4 == null) {
                    string4 = "";
                }
                BigDecimal bigDecimal = sQLHelper.ors.getBigDecimal(PROPENSITY_TARGET_ONE);
                BigDecimal bigDecimal2 = sQLHelper.ors.getBigDecimal(PROPENSITY_TARGET_TWO);
                if (bigDecimal == null && bigDecimal2 != null) {
                    bigDecimal = new BigDecimal(-1.0 * bigDecimal2.doubleValue());
                } else if (bigDecimal2 == null && bigDecimal != null) {
                    bigDecimal2 = new BigDecimal(-1.0 * bigDecimal.doubleValue());
                }
                CoefficientRowData coefficientRowData = new CoefficientRowData(string2, string4, bigDecimal != null ? Double.valueOf(bigDecimal.doubleValue()) : null, bigDecimal2 != null ? Double.valueOf(bigDecimal2.doubleValue()) : null);
                vector.add(coefficientRowData);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            LOGGER.log(Level.SEVERE, outOfMemoryError.getMessage(), outOfMemoryError);
        }
        return vector;
    }

    private void prepareCoefficientSQL(Version version, SQLHelper sQLHelper, String string, String string2, CoefficientFilterSetting coefficientFilterSetting, String string3, boolean bl, String string4) throws SQLException {
        String string5 = null;
        string5 = version == null || version.toCanonicalString().startsWith("11") ? QRY_CLASSIFICATION_COEFFICIENTS_Db11 : (StringUtils.isNotEmpty(string4) ? QRY_CLASSIFICATION_COEFFICIENTS_Db12_partition : QRY_CLASSIFICATION_COEFFICIENTS_Db12);
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = string2;
        String string14 = string;
        String string15 = "";
        String string16 = "";
        String string17 = "";
        StringBuilder stringBuilder = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string18 = "";
        Boolean bl2 = null;
        Vector<CoefficientSortSpec> vector = null;
        if (coefficientFilterSetting != null) {
            bl2 = coefficientFilterSetting.getFilterAndSortByAbsolute();
            vector = coefficientFilterSetting.getSortSpecification();
            string6 = bl ? "nvl(-coefficient,0) as coefficient" : "coefficient";
            string7 = bl ? "nvl(-STD_COEFFICIENT,0) as STD_COEFFICIENT" : "STD_COEFFICIENT";
            string8 = bl ? "( nvl(TO_BINARY_DOUBLE(-coefficient),0) + (nvl(TO_BINARY_DOUBLE(TO_BINARY_DOUBLE(UPPER_COEFF_LIMIT)),0) - nvl(TO_BINARY_DOUBLE(coefficient),0))) as UPPER_COEFF_LIMIT" : "UPPER_COEFF_LIMIT";
            string9 = bl ? "(nvl(TO_BINARY_DOUBLE(-coefficient),0) - (nvl(TO_BINARY_DOUBLE(TO_BINARY_DOUBLE(UPPER_COEFF_LIMIT)),0) - nvl(TO_BINARY_DOUBLE(coefficient),0))) as LOWER_COEFF_LIMIT" : "LOWER_COEFF_LIMIT";
            string10 = bl ? "exp(nvl(TO_BINARY_DOUBLE(-coefficient),0))  as EXP_COEFFICIENT" : "EXP_COEFFICIENT";
            string11 = bl ? "exp( ( nvl(TO_BINARY_DOUBLE(-coefficient),0) - ( nvl(TO_BINARY_DOUBLE(TO_BINARY_DOUBLE(UPPER_COEFF_LIMIT)),0) - nvl(TO_BINARY_DOUBLE(coefficient),0)))  )  as EXP_LOWER_COEFF_LIMIT" : "EXP_LOWER_COEFF_LIMIT";
            String string19 = string12 = bl ? "exp( ( nvl(TO_BINARY_DOUBLE(-coefficient),0) + ( nvl(TO_BINARY_DOUBLE(TO_BINARY_DOUBLE(UPPER_COEFF_LIMIT)),0) - nvl(TO_BINARY_DOUBLE(coefficient),0)))  )  as EXP_UPPER_COEFF_LIMIT" : "EXP_UPPER_COEFF_LIMIT";
            if (coefficientFilterSetting.getFetchSize() > 0) {
                string18 = " where rownum <= :fetch_size_param";
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<CoefficientSortSpec> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = iterator.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    if (coefficientSortSpec.getAttributeName().equals("attribute_name_subname") || coefficientSortSpec.getAttributeName().equals("attribute_value")) {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    } else if (coefficientFilterSetting.getFilterAndSortByAbsolute()) {
                        stringBuffer.append("ABS(\"" + coefficientSortSpec.getAttributeName() + "\") ");
                    } else {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        string5 = StringUtils.getReplacedString(string5, "<coefficient_value>", string6);
        string5 = StringUtils.getReplacedString(string5, "<std_coefficient>", string7);
        string5 = StringUtils.getReplacedString(string5, "<upper_coeff_limit>", string8);
        string5 = StringUtils.getReplacedString(string5, "<lower_coeff_limit>", string9);
        string5 = StringUtils.getReplacedString(string5, "<exp_coefficient>", string10);
        string5 = StringUtils.getReplacedString(string5, "<exp_lower_coeff_limit>", string11);
        string5 = StringUtils.getReplacedString(string5, "<exp_upper_coeff_limit>", string12);
        string5 = StringUtils.getReplacedString(string5, "<and1>", string15);
        string5 = StringUtils.getReplacedString(string5, "<and2>", string16);
        string5 = StringUtils.getReplacedString(string5, "<and3>", string17);
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder("");
        }
        string5 = StringUtils.getReplacedString(string5, "<where_condition>", stringBuilder.toString());
        string5 = StringUtils.getReplacedString(string5, "<order>", stringBuffer.toString());
        string5 = StringUtils.getReplacedString(string5, "<rownum>", string18);
        sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string5);
        LOGGER.log(Level.INFO, string5);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string14, string13, false));
        if (StringUtils.isNotEmpty(string4)) {
            sQLHelper.opstmt.setStringAtName("partitionId", string4);
        }
        if (coefficientFilterSetting.getTargetValue() instanceof Number) {
            sQLHelper.opstmt.setBigDecimalAtName("target_value_param", BigDecimal.valueOf(Double.parseDouble(string3)));
        } else {
            sQLHelper.opstmt.setStringAtName("target_value_param", string3);
        }
        if (string18.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", coefficientFilterSetting.getFetchSize());
        }
    }

    private void prepareRegressionCoefficientSQL(Version version, SQLHelper sQLHelper, String string, String string2, CoefficientFilterSetting coefficientFilterSetting, boolean bl, String string3) throws SQLException {
        String string4 = null;
        string4 = version == null || version.toCanonicalString().startsWith("11") ? QRY_REGRESSION_COEFFICIENTS_Db11 : (StringUtils.isNotEmpty(string3) ? QRY_REGRESSION_COEFFICIENTS_Db12_partition : QRY_REGRESSION_COEFFICIENTS_Db12);
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = string2;
        String string13 = string;
        String string14 = "";
        String string15 = "";
        StringBuilder stringBuilder = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string16 = "";
        Boolean bl2 = null;
        Vector<CoefficientSortSpec> vector = null;
        if (coefficientFilterSetting != null) {
            bl2 = coefficientFilterSetting.getFilterAndSortByAbsolute();
            vector = coefficientFilterSetting.getSortSpecification();
            string5 = bl ? "nvl(-coefficient,0) as coefficient" : "coefficient";
            string6 = bl ? "nvl(-STD_COEFFICIENT,0) as STD_COEFFICIENT" : "STD_COEFFICIENT";
            string7 = bl ? "( nvl(TO_BINARY_DOUBLE(-coefficient),0) + (nvl(TO_BINARY_DOUBLE(UPPER_COEFF_LIMIT),0) - nvl(TO_BINARY_DOUBLE(coefficient),0))) as UPPER_COEFF_LIMIT" : "UPPER_COEFF_LIMIT";
            string8 = bl ? "(nvl(TO_BINARY_DOUBLE(-coefficient),0) - (nvl(TO_BINARY_DOUBLE(UPPER_COEFF_LIMIT),0) - nvl(TO_BINARY_DOUBLE(coefficient,0))) as LOWER_COEFF_LIMIT" : "LOWER_COEFF_LIMIT";
            string9 = bl ? "exp(nvl(TO_BINARY_DOUBLE(-coefficient),0))  as EXP_COEFFICIENT" : "EXP_COEFFICIENT";
            string10 = bl ? "exp( ( nvl(TO_BINARY_DOUBLE(-coefficient),0) - ( nvl(TO_BINARY_DOUBLE(UPPER_COEFF_LIMIT),0) - nvl(TO_BINARY_DOUBLE(coefficient),0)))  )  as EXP_LOWER_COEFF_LIMIT" : "EXP_LOWER_COEFF_LIMIT";
            String string17 = string11 = bl ? "exp( ( nvl(TO_BINARY_DOUBLE(-coefficient),0) + ( nvl(TO_BINARY_DOUBLE(UPPER_COEFF_LIMIT),0) - nvl(TO_BINARY_DOUBLE(coefficient),0)))  )  as EXP_UPPER_COEFF_LIMIT" : "EXP_UPPER_COEFF_LIMIT";
            if (coefficientFilterSetting.getFetchSize() > 0) {
                string16 = " where rownum <= :fetch_size_param";
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<CoefficientSortSpec> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = iterator.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    if (coefficientSortSpec.getAttributeName().equals("attribute_name_subname") || coefficientSortSpec.getAttributeName().equals("attribute_value")) {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    } else if (coefficientFilterSetting.getFilterAndSortByAbsolute()) {
                        stringBuffer.append("ABS(\"" + coefficientSortSpec.getAttributeName() + "\") ");
                    } else {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        string4 = StringUtils.getReplacedString(string4, "<coefficient_value>", string5);
        string4 = StringUtils.getReplacedString(string4, "<std_coefficient>", string6);
        string4 = StringUtils.getReplacedString(string4, "<upper_coeff_limit>", string7);
        string4 = StringUtils.getReplacedString(string4, "<lower_coeff_limit>", string8);
        string4 = StringUtils.getReplacedString(string4, "<exp_coefficient>", string9);
        string4 = StringUtils.getReplacedString(string4, "<exp_lower_coeff_limit>", string10);
        string4 = StringUtils.getReplacedString(string4, "<exp_upper_coeff_limit>", string11);
        if (!string14.isEmpty() || !string15.isEmpty()) {
            if (string15.isEmpty()) {
                string4 = StringUtils.getReplacedString(string4, "<and2>", string14);
                string4 = StringUtils.getReplacedString(string4, "<and3>", string15);
            } else {
                string4 = StringUtils.getReplacedString(string4, "<and2>", string14);
                string4 = StringUtils.getReplacedString(string4, "<and3>", " AND " + string15);
            }
        } else {
            string4 = StringUtils.getReplacedString(string4, "<where_key_word>", "");
            string4 = StringUtils.getReplacedString(string4, "<and2>", "");
            string4 = StringUtils.getReplacedString(string4, "<and3>", "");
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder("");
        }
        string4 = StringUtils.getReplacedString(string4, "<where_condition>", stringBuilder.toString());
        string4 = StringUtils.getReplacedString(string4, "<order>", stringBuffer.toString());
        string4 = StringUtils.getReplacedString(string4, "<rownum>", string16);
        sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string4);
        LOGGER.log(Level.INFO, string4);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string13, string12, false));
        if (StringUtils.isNotEmpty(string3)) {
            sQLHelper.opstmt.setStringAtName("partitionId", string3);
        }
        if (string16.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", coefficientFilterSetting.getFetchSize());
        }
    }

    @Override
    public Vector<GLMCoefficientRowData> getAllCoefficients(ConnectionManager connectionManager, String string, String string2, FilterSetting filterSetting) throws SQLException {
        Vector<GLMCoefficientRowData> vector = new Vector<GLMCoefficientRowData>();
        return vector;
    }

    public Vector<GLMCoefficientRowData> getRegressionCoefficients(ConnectionManager connectionManager, Version version, String string, String string2, CoefficientFilterSetting coefficientFilterSetting, String string3) throws SQLException {
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            this.prepareRegressionCoefficientSQL(version, sQLHelper, string, string2, coefficientFilterSetting, false, string3);
            if (version == null || version.toCanonicalString().startsWith("11")) {
                Vector<GLMCoefficientRowData> vector = this.invokeCoefficientQuery_Db11(sQLHelper);
                return vector;
            }
            Vector<GLMCoefficientRowData> vector = this.invokeCoefficientQuery_Db12(sQLHelper);
            return vector;
        }
    }

    @Override
    public Vector<GLMCoefficientRowData> getCoefficients(ConnectionManager connectionManager, Version version, String string, String string2, CoefficientFilterSetting coefficientFilterSetting, String string3) throws SQLException {
        Vector<Object> vector = new Vector();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            if (coefficientFilterSetting.isBinaryClassModel()) {
                this.prepareCoefficientSQL(version, sQLHelper, string, string2, coefficientFilterSetting, coefficientFilterSetting.getTargetValue().toString(), false, string3);
                vector = version == null || version.toCanonicalString().startsWith("11") ? this.invokeCoefficientQuery_Db11(sQLHelper) : this.invokeCoefficientQuery_Db12(sQLHelper);
                if (vector.size() == 0) {
                    this.prepareCoefficientSQL(version, sQLHelper, string, string2, coefficientFilterSetting, coefficientFilterSetting.getNonSelectedBinaryClassValue().toString(), true, string3);
                    vector = version == null || version.toCanonicalString().startsWith("11") ? this.invokeCoefficientQuery_Db11(sQLHelper) : this.invokeCoefficientQuery_Db12(sQLHelper);
                }
            } else {
                this.prepareCoefficientSQL(version, sQLHelper, string, string2, coefficientFilterSetting, coefficientFilterSetting.getTargetValue().toString(), false, string3);
                vector = version == null || version.toCanonicalString().startsWith("11") ? this.invokeCoefficientQuery_Db11(sQLHelper) : this.invokeCoefficientQuery_Db12(sQLHelper);
            }
        }
        return vector;
    }

    public Integer getTotalCountCoefficients(ConnectionManager connectionManager, String string, String string2) {
        Integer n = null;
        return n;
    }

    public Integer getTotalCountCoefficients(ConnectionManager connectionManager, String string, String string2, List<Object> list, FilterSetting filterSetting) {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        Integer n = null;
        return n;
    }

    private void prepareTotalCountCoefficientsClassificationQuery(SQLHelper sQLHelper, String string, String string2, List<Object> list) throws SQLException {
        String string3 = QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        boolean bl = list.get(0) instanceof String;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        int n = 0;
        for (Object object : list) {
            ++n;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(":target_value_");
            stringBuilder.append(n);
            hashMap.put(object, n);
        }
        string3 = StringUtils.getReplacedString(string3, "<target_values>", stringBuilder.toString());
        sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string3);
        LOGGER.log(Level.INFO, string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
        if (bl) {
            for (Map.Entry entry : hashMap.entrySet()) {
                String string4 = "target_value_" + ((Integer)entry.getValue()).toString();
                String string5 = entry.getKey().toString();
                sQLHelper.opstmt.setStringAtName(string4, string5);
            }
        } else {
            for (Map.Entry entry : hashMap.entrySet()) {
                String string6 = "target_value_" + ((Integer)entry.getValue()).toString();
                BigDecimal bigDecimal = (BigDecimal)entry.getKey();
                sQLHelper.opstmt.setBigDecimalAtName(string6, bigDecimal);
            }
        }
    }

    private void prepareTotalCountCoefficientsRegressionQuery(SQLHelper sQLHelper, String string, String string2) throws SQLException {
        String string3 = QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_REGRESSION;
        sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string3);
        LOGGER.log(Level.INFO, string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
    }

    public Map<String, Object> getCoefficientStatistics(ConnectionManager connectionManager, String string, String string2, List<Object> list, FilterSetting filterSetting) throws SQLException {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        Map<String, Object> map = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            if (filterSetting.isBinaryClassModel()) {
                this.prepareTotalCountCoefficientsClassificationQuery(sQLHelper, string, string2, list);
                map = this.invokeCoefficientsStatisticsQuery(sQLHelper);
                Integer n = (Integer)map.get("TOTAL_COEFFICIENTS");
                if (n == 0) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(filterSetting.getNonSelectedBinaryClassValue());
                    this.prepareTotalCountCoefficientsClassificationQuery(sQLHelper, string, string2, arrayList);
                    map = this.invokeCoefficientsStatisticsQuery(sQLHelper);
                }
            } else {
                this.prepareTotalCountCoefficientsClassificationQuery(sQLHelper, string, string2, list);
                map = this.invokeCoefficientsStatisticsQuery(sQLHelper);
            }
        }
        return map;
    }

    public Map<String, Object> getCoefficientStatistics(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        Map<String, Object> map = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            this.prepareTotalCountCoefficientsRegressionQuery(sQLHelper, string, string2);
            map = this.invokeCoefficientsStatisticsQuery(sQLHelper);
        }
        return map;
    }

    private Map<String, Object> invokeCoefficientsStatisticsQuery(SQLHelper sQLHelper) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        sQLHelper.ors = (OracleResultSet)sQLHelper.opstmt.executeQuery();
        if (sQLHelper.ors.next()) {
            Integer n = sQLHelper.ors.getInt("TOTAL_COEFFICIENTS");
            hashMap.put("TOTAL_COEFFICIENTS", n);
            Double d = sQLHelper.ors.getDouble("MAXIMUM_ABS_COEFFICIENT_VALUE");
            hashMap.put("MAXIMUM_ABS_COEFFICIENT_VALUE", d);
        } else {
            hashMap.put("TOTAL_COEFFICIENTS", 0);
            hashMap.put("MAXIMUM_ABS_COEFFICIENT_VALUE", 0.0);
        }
        return hashMap;
    }

    @Override
    public Vector<GLMModelDetailsRowData> getGlobalDetails(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        Vector<GLMModelDetailsRowData> vector = new Vector<GLMModelDetailsRowData>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string3 = "SELECT \n     global_detail_name,\n     global_detail_value\n   FROM TABLE(dbms_data_mining.get_model_details_global(:model_name_param))\n   order by global_detail_name";
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.ors = (OracleResultSet)sQLHelper.opstmt.executeQuery();
            while (sQLHelper.ors.next()) {
                Integer n;
                String string4 = sQLHelper.ors.getString("global_detail_name");
                GLMModelDetailsRowData gLMModelDetailsRowData = new GLMModelDetailsRowData(string4);
                Constable constable = string4.equalsIgnoreCase("MODEL_CONVERGED") || string4.equalsIgnoreCase("VALID_COVARIANCE_MATRIX") ? (Comparable<Boolean>)((n = Integer.valueOf(sQLHelper.ors.getInt("global_detail_value"))) == 0 ? Boolean.FALSE : Boolean.TRUE) : (Comparable<Boolean>)Double.valueOf(sQLHelper.ors.getDouble("global_detail_value"));
                gLMModelDetailsRowData.setValue(constable);
                vector.add(gLMModelDetailsRowData);
            }
        }
        return vector;
    }

    public Double[] getMinMaxValue(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        Double[] doubleArray = null;
        String string3 = QUERY_MIN_MAX;
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string3);
            LOGGER.log(Level.INFO, string3);
            sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.ors = (OracleResultSet)sQLHelper.opstmt.executeQuery();
            if (sQLHelper.ors.next()) {
                doubleArray = new Double[]{sQLHelper.ors.getDouble("minimum_coefficient"), sQLHelper.ors.getDouble("maximum_coefficient")};
            }
        }
        catch (SQLException sQLException) {
            doubleArray = null;
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return doubleArray;
    }

    public Vector<CoefficientRowData> getPropensities(ConnectionManager connectionManager, Version version, String string, String string2, FilterSetting filterSetting) throws SQLException {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            if (filterSetting.isBinaryClassModel()) {
                sQLHelper.conn = connectionManager.getConnection();
                sQLHelper = this.prepareBinaryPropensitiesSQL(version, sQLHelper, string, string2, filterSetting, false);
                vector = version == null || version.toCanonicalString().startsWith("11") ? this.invokeCompareQuery_Db11(sQLHelper) : this.invokeCompareQuery_Db12(sQLHelper);
            }
        }
        return vector;
    }

    public Integer getTotalCountPropensities(ConnectionManager connectionManager, Version version, String string, String string2, FilterSetting filterSetting) throws SQLException {
        Integer n = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            if (filterSetting.isBinaryClassModel()) {
                sQLHelper.conn = connectionManager.getConnection();
                sQLHelper = this.prepareBinaryPropensitiesSQL(version, sQLHelper, string, string2, filterSetting, true);
                n = this.invokeCompareCountQuery(sQLHelper);
            }
        }
        return n;
    }

    private SQLHelper prepareBinaryPropensitiesSQL(Version version, SQLHelper sQLHelper, String string, String string2, FilterSetting filterSetting, boolean bl) throws SQLException {
        boolean bl2;
        String string3 = "";
        string3 = version == null || version.toCanonicalString().startsWith("11") ? QRY_ALL_PROPENSITIES_Db11_2 : QRY_ALL_PROPENSITIES_Db12;
        StringBuilder stringBuilder = null;
        StringBuilder stringBuilder2 = null;
        String string4 = string;
        String string5 = string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder stringBuilder3 = new StringBuilder();
        Boolean bl3 = null;
        Vector<CoefficientSortSpec> vector = null;
        if (filterSetting != null) {
            bl3 = filterSetting.getFilterAndSortByAbsolute();
            vector = filterSetting.getSortSpecification();
            if (filterSetting.getFetchSize() > 0) {
                stringBuilder3.append(" WHERE rownum <= :fetch_size_param ");
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<CoefficientSortSpec> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = iterator.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    if (coefficientSortSpec.getAttributeName().equals("coefficient")) {
                        if (filterSetting.getFilterAndSortByAbsolute()) {
                            stringBuffer.append("ABS(\"" + coefficientSortSpec.getAttributeName() + "\") ");
                        } else {
                            stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                        }
                    } else {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        if (bl2 = filterSetting.getTargetValue() instanceof Number) {
            string3 = StringUtils.getReplacedString(string3, "<target_value_one>", filterSetting.getTargetValue().toString());
            string3 = StringUtils.getReplacedString(string3, "<target_value_two>", filterSetting.getSecondTargetValue().toString());
        } else {
            string3 = StringUtils.getReplacedString(string3, "<target_value_one>", "'" + StringUtils.escapeSingleQuotesForSQL(filterSetting.getTargetValue().toString()) + "'");
            string3 = StringUtils.getReplacedString(string3, "<target_value_two>", "'" + StringUtils.escapeSingleQuotesForSQL(filterSetting.getSecondTargetValue().toString()) + "'");
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(" ");
        }
        string3 = StringUtils.getReplacedString(string3, "<where_clause>", stringBuilder.toString());
        string3 = StringUtils.getReplacedString(string3, "<where_clause_like>", stringBuilder2 != null ? stringBuilder2.toString() : "");
        string3 = StringUtils.getReplacedString(string3, "<order>", stringBuffer.toString());
        string3 = filterSetting.getFilterAndSortByAbsolute() ? StringUtils.getReplacedString(string3, "<ABSOLUTE_VALUE>", "ABS") : StringUtils.getReplacedString(string3, "<ABSOLUTE_VALUE>", " ");
        if (bl) {
            string3 = StringUtils.getReplacedString(string3, "<COUNT_ONLY>", "COUNT(*) TOTAL_PROPENSITIES");
            string3 = StringUtils.getReplacedString(string3, "<rownum>", " ");
        } else {
            string3 = StringUtils.getReplacedString(string3, "<COUNT_ONLY>", "*");
            string3 = StringUtils.getReplacedString(string3, "<rownum>", stringBuilder3.toString());
        }
        sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string3);
        LOGGER.log(Level.INFO, string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string4, string5, false));
        if (!bl && stringBuilder3.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", filterSetting.getFetchSize());
        }
        return sQLHelper;
    }

    private Integer invokeCompareCountQuery(SQLHelper sQLHelper) throws SQLException {
        Integer n = null;
        sQLHelper.ors = (OracleResultSet)sQLHelper.opstmt.executeQuery();
        sQLHelper.ors.next();
        n = sQLHelper.ors.getInt("TOTAL_PROPENSITIES");
        return n;
    }
}

