/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

public abstract class CoefficientBaseData {
    protected String _attributeName;
    protected String _attributeSubName;
    protected String _value;
    protected COMPARISON_LEVEL _comparisonLevel = COMPARISON_LEVEL.NAME;

    public void setAttributeName(String string) {
        this._attributeName = string;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public void setAttributeSubName(String string) {
        this._attributeSubName = string;
    }

    public String getAttributeSubName() {
        return this._attributeSubName;
    }

    public String getAttributeFullName() {
        StringBuilder stringBuilder = new StringBuilder(this._attributeName);
        if (this._attributeSubName != null && this._attributeSubName.length() > 0) {
            stringBuilder.append(".");
            stringBuilder.append(this._attributeSubName);
        }
        return stringBuilder.toString();
    }

    public void setValue(String string) {
        this._value = string;
    }

    public String getValue() {
        return this._value;
    }

    public abstract void setCoefficient1(Double var1);

    public abstract Double getCoefficient1();

    public abstract void setCoefficient2(Double var1);

    public abstract Double getCoefficient2();

    public void setComparisonLevel(COMPARISON_LEVEL cOMPARISON_LEVEL) {
        this._comparisonLevel = cOMPARISON_LEVEL;
    }

    protected boolean isNameSort() {
        return this._comparisonLevel.equals((Object)COMPARISON_LEVEL.NAME);
    }

    protected boolean isNameSubnameSort() {
        return this._comparisonLevel.equals((Object)COMPARISON_LEVEL.NAME_SUBNAME);
    }

    public boolean isNameSubnameValueSort() {
        return this._comparisonLevel.equals((Object)COMPARISON_LEVEL.NAME_SUBNAME_VALUE);
    }

    public boolean isObjectSpecific() {
        return this._comparisonLevel.equals((Object)COMPARISON_LEVEL.OBJECT_SPECIFIC);
    }

    protected abstract boolean objectSpecificEquals(Object var1);

    public boolean equals(Object object) {
        if (!(object instanceof CoefficientBaseData)) {
            return false;
        }
        CoefficientBaseData coefficientBaseData = (CoefficientBaseData)object;
        if (coefficientBaseData.getAttributeName() != null && this.getAttributeName() != null && coefficientBaseData.getAttributeName().equals(this.getAttributeName())) {
            if (this.isNameSort()) {
                return true;
            }
            if (this.areEqual(coefficientBaseData.getAttributeSubName(), this.getAttributeSubName()) && this.isNameSubnameSort()) {
                return true;
            }
            if (this.areEqual(coefficientBaseData.getValue(), this.getValue())) {
                if (this.isNameSubnameSort()) {
                    return true;
                }
                return this.objectSpecificEquals(object);
            }
        }
        return false;
    }

    protected boolean areEqual(Double d, Double d2) {
        if (d == null && d2 == null) {
            return true;
        }
        return d != null && d2 != null && d.equals(d2);
    }

    protected boolean areEqual(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        return string != null && string2 != null && string.equals(string2);
    }

    public static enum COMPARISON_LEVEL {
        NAME,
        NAME_SUBNAME,
        NAME_SUBNAME_VALUE,
        OBJECT_SPECIFIC;

    }
}

