/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server;

import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.controls.OutputAttributeType;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;

public class DataExtractBase {
    public static Attributes convertOutputColumnList(List<OutputAttributeType> list) {
        Attributes attributes = new Attributes();
        List list2 = attributes.getAttribute();
        for (OutputAttributeType outputAttributeType : list) {
            list2.add(outputAttributeType.getAttributeType());
        }
        return attributes;
    }

    protected static String addColumnAlias(String string, List<AttributeType> list, List<OutputAttributeType> list2) {
        for (OutputAttributeType outputAttributeType : list2) {
            String string2 = DataExtractBase.getAliasName(outputAttributeType, list);
            string = StringUtils.getReplacedString(string, "<" + outputAttributeType.getName() + ">", string2);
        }
        return string;
    }

    protected static String getAliasName(OutputAttributeType outputAttributeType, List<AttributeType> list) {
        String string = outputAttributeType.getName();
        for (AttributeType attributeType : list) {
            if (outputAttributeType.getName().compareTo(attributeType.getName()) != 0) continue;
            if (attributeType.getAlias() == null || attributeType.getAlias().length() <= 0) break;
            string = attributeType.getAlias();
            break;
        }
        return string;
    }

    protected static boolean containsColumn(AttributeType attributeType, List<OutputAttributeType> list) {
        boolean bl = false;
        for (OutputAttributeType outputAttributeType : list) {
            if (attributeType.getName().compareTo(outputAttributeType.getName()) != 0 || attributeType.getDataType().compareTo(outputAttributeType.getDataType()) != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected static boolean validateOutputColumns(List<OutputAttributeType> list, List<AttributeType> list2) {
        boolean bl = true;
        for (AttributeType attributeType : list2) {
            if (DataExtractBase.containsColumn(attributeType, list)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected static ArrayList<OutputAttributeType> generateCollection(String[][] stringArray, ArrayList<OutputAttributeType> arrayList) {
        for (int i = 0; i < stringArray.length; ++i) {
            OutputAttributeType outputAttributeType = new OutputAttributeType(stringArray[i][0], stringArray[i][1]);
            arrayList.add(outputAttributeType);
        }
        return arrayList;
    }
}

