/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class RunnerPreferencesSettings
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.dmt.dataminer.runner.RunnerPreferencesSettings";
    protected static final String SHOW_ERRORS = "showErrors";
    protected static final String SHOW_WARNINGS = "showWarnings";
    protected static final String SHOW_INFO = "showInfo";
    protected static final String MAX_JOB_AGE = "maxJobAge";
    protected static final String AUTO_SELECT_CONNECTION = "autoSelectConnection";
    protected static final String INITIAL_CONNECTION_NAME = "initialConnectionName";
    protected static final boolean SHOW_ERRORS_DEFAULT = true;
    protected static final boolean SHOW_WARNINGS_DEFAULT = false;
    protected static final boolean SHOW_INFO_DEFAULT = false;
    protected static final int DEFAULT_MAX_JOB_AGE = 24;
    protected static final boolean DEFAULT_AUTO_SELECT_CONNECTION = true;

    public static RunnerPreferencesSettings getInstance() {
        return RunnerPreferencesSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private RunnerPreferencesSettings(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static RunnerPreferencesSettings getInstance(PropertyStorage propertyStorage) {
        return new RunnerPreferencesSettings(RunnerPreferencesSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public void setShowErrors(boolean bl) {
        this._hash.putBoolean(SHOW_ERRORS, bl);
    }

    public boolean isShowErrors() {
        return this._hash.getBoolean(SHOW_ERRORS, true);
    }

    public void setShowWarnings(boolean bl) {
        this._hash.putBoolean(SHOW_WARNINGS, bl);
    }

    public boolean isShowWarnings() {
        return this._hash.getBoolean(SHOW_WARNINGS, false);
    }

    public void setShowInfo(boolean bl) {
        this._hash.putBoolean(SHOW_INFO, bl);
    }

    public boolean isShowInfo() {
        return this._hash.getBoolean(SHOW_INFO, false);
    }

    public void setMaxJobAgeName(int n) {
        this._hash.putInt(MAX_JOB_AGE, n);
    }

    public int getMaxJobAge() {
        return this._hash.getInt(MAX_JOB_AGE, 24);
    }

    public void setDefaultConnectionName(String string) {
        this._hash.putString(INITIAL_CONNECTION_NAME, string);
    }

    public String getDefaultConnectionName() {
        return this._hash.getString(INITIAL_CONNECTION_NAME);
    }

    public void setAutoSelectConnection(boolean bl) {
        this._hash.putBoolean(AUTO_SELECT_CONNECTION, bl);
    }

    public boolean getAutoSelectConnection() {
        return this._hash.getBoolean(AUTO_SELECT_CONNECTION, true);
    }
}

