/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.util.List;
import oracle.dmt.dataminer.repository.Result;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;

public abstract class TestResult
extends Result {
    public static final String _SHOW_RESULT = "_SHOW_RESULT";
    protected static final String PERFORM_METRICS_TABLE_NAME = "PERFORM_METRICS_TABLE_NAME";
    protected static final String PREDICTIVE_CONFIDENCE = "PREDICTIVE_CONFIDENCE";
    protected Context _context;
    protected TestNodeType _test;
    protected BuildNodeType _build;
    protected MiningResultType _result;
    protected boolean _showSchema = false;

    public TestResult(TestResult testResult) {
        super(testResult.getName(), testResult.getId(), testResult.getParentId());
        this._data.putAll(testResult._data);
    }

    public TestResult(Context context, BuildNodeType buildNodeType, MiningResultType miningResultType) {
        super(miningResultType.getName(), new BigDecimal(miningResultType.getModelId()), new BigDecimal(miningResultType.getModelId()));
        this._context = context;
        this._build = buildNodeType;
        this._result = miningResultType;
    }

    public TestResult(Context context, TestNodeType testNodeType, MiningResultType miningResultType) {
        super(miningResultType.getName(), new BigDecimal(miningResultType.getModelId()), new BigDecimal(miningResultType.getModelId()));
        this._context = context;
        this._test = testNodeType;
        this._result = miningResultType;
    }

    public Boolean isResultSelected() {
        return (Boolean)this._data.get(_SHOW_RESULT);
    }

    public void setResultSelected(boolean bl) {
        this._data.put(_SHOW_RESULT, bl);
    }

    public BuildNodeType getBuild() {
        return this._build;
    }

    public TestNodeType getTest() {
        return this._test;
    }

    public MiningResultType getResult() {
        return this._result;
    }

    public void setResult(MiningResultType miningResultType) {
        this._result = miningResultType;
    }

    public void setShowSchema(boolean bl) {
        this._showSchema = bl;
    }

    public boolean isShowSchema() {
        return this._showSchema;
    }

    public String getPerformanceMatrixTable() {
        return (String)this._data.get(PERFORM_METRICS_TABLE_NAME);
    }

    public boolean performanceMatrixExists() {
        return this._data.get(PERFORM_METRICS_TABLE_NAME) != null;
    }

    public boolean isPartitionedResult() {
        List list;
        boolean bl = false;
        bl = this._build != null ? this._build.getPartitionExpressions() != null : ((list = this._test.getTestModels().getModel()).isEmpty() ? false : ((TestModelType.Model)this._test.getTestModels().getModel().get(0)).getPartitionExpressions() != null);
        return bl;
    }

    @Override
    public String toString() {
        String string = this.getModelName();
        String string2 = this.getModelSchema();
        if (string2 != null) {
            string = this._showSchema ? string2 + "." + this.getModelName() : this.getModelName();
        }
        return string;
    }
}

