/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.RepositoryObject;
import oracle.dmt.dataminer.repository.TestResult;

public class Test
extends RepositoryObject {
    private ArrayList<TestResult> _testResults = new ArrayList();
    private String _target;
    private String _algorithm;
    private String _function;
    private Date _createDate;
    private boolean _bSelected;
    private Date _startDate;
    private Date _endDate;

    public Test(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        super(string, bigDecimal, bigDecimal2);
    }

    public Test(Test test) {
        this(test.getName(), test.getId(), test.getParentId());
        this.setTarget(test.getTarget());
        this.setAlgorithm(test.getAlgorithm());
        this.setFunction(test.getFunction());
        this.setCreateDate(test.getCreateDate());
        if (test._testResults != null) {
            for (int i = 0; i < test._testResults.size(); ++i) {
                this._testResults.add(new ClassTestResult((ClassTestResult)test._testResults.get(i)));
            }
        }
    }

    public boolean isSelected() {
        if (this._testResults.isEmpty()) {
            this._bSelected = false;
        }
        for (int i = 0; i < this._testResults.size(); ++i) {
            TestResult testResult = this._testResults.get(i);
            if (!testResult.isResultSelected().booleanValue()) continue;
            this._bSelected = true;
            break;
        }
        return this._bSelected;
    }

    public void setSelected(boolean bl) {
        if (this._testResults.isEmpty()) {
            this._bSelected = false;
            return;
        }
        for (int i = 0; i < this._testResults.size(); ++i) {
            TestResult testResult = this._testResults.get(i);
            testResult.setResultSelected(bl);
        }
        this._bSelected = bl;
    }

    public void addTestResult(TestResult testResult) {
        this._testResults.add(testResult);
    }

    public ArrayList<TestResult> getTestResults() {
        return this._testResults;
    }

    public TestResult getTestResult(String string) {
        TestResult testResult = null;
        for (int i = 0; i < this._testResults.size() && 0 != string.compareTo((testResult = this._testResults.get(i)).getName()); ++i) {
        }
        return testResult;
    }

    @Override
    public String toString() {
        return this._name;
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String string) {
        this._target = string;
    }

    public void setAlgorithm(String string) {
        this._algorithm = string;
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public List<TestResult> getTestResultsWithinTimeframe() {
        assert (this._startDate != null && this._endDate != null);
        if (this._testResults.isEmpty()) {
            return null;
        }
        ArrayList<TestResult> arrayList = null;
        for (TestResult testResult : this._testResults) {
            Timestamp timestamp = testResult.getCreationTimestamp();
            Date date = new Date(timestamp.getTime());
            if (date.compareTo(this._startDate) < 0 || date.compareTo(this._endDate) > 0) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<TestResult>();
            }
            arrayList.add(testResult);
        }
        return arrayList;
    }

    public boolean hasTestResultsWithinTimeframe(Date date, Date date2) {
        assert (date != null && date2 != null);
        boolean bl = false;
        if (this._testResults.isEmpty()) {
            return bl;
        }
        for (TestResult testResult : this._testResults) {
            Timestamp timestamp = testResult.getCreationTimestamp();
            Date date3 = new Date(timestamp.getTime());
            if (date3.compareTo(date) < 0 || date3.compareTo(date2) > 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void setStartDate(Date date) {
        this._startDate = date;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public void setEndDate(Date date) {
        this._endDate = date;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public void setFunction(String string) {
        this._function = string;
    }

    public String getFunction() {
        return this._function;
    }

    public void setCreateDate(Date date) {
        this._createDate = date;
    }

    public Date getCreateDate() {
        return this._createDate;
    }
}

