/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dmt.dataminer.common.vo.TableVO;
import oracle.dmt.dataminer.generated.server.OdmrTabColMap;
import oracle.dmt.dataminer.generated.server.OdmrTabColMaps;
import oracle.dmt.dataminer.generated.server.OdmrTableMap;
import oracle.dmt.dataminer.repository.ColumnMapping;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.LoadableRepositoryObject;
import oracle.dmt.dataminer.utils.ConnectionManager;

public class TableMapping
extends LoadableRepositoryObject {
    private String _schemaName;
    private String _tableName;
    private String _mapSchemaName;
    private String _mapTableName;
    private List<ColumnMapping> _colMappingList = new ArrayList<ColumnMapping>();
    private Map<String, Set<String>> _dataTypeColsMap = null;
    public static final String ODMR_USER_DG_TABLE_MAP = "ODMR_USER_DG_TABLE_MAP";
    public static final String DG_TAB_MAP_ID = "DG_TAB_MAP_ID";
    public static final String DG_TABLE_ID = "DG_TABLE_ID";
    public static final String DG_SHEMA_NAME = "DG_SHEMA_NAME";
    public static final String DG_TABLE_NAME = "DG_TABLE_NAME";
    public static final String MAP_SCHEMA_NAME = "MAP_SCHEMA_NAME";
    public static final String MAP_TABLE_NAME = "MAP_TABLE_NAME";

    public TableMapping(BigDecimal bigDecimal) {
        this(bigDecimal, null);
    }

    public TableMapping(BigDecimal bigDecimal, String string, String string2) {
        this(bigDecimal, null, string, string2, null, null);
    }

    public TableMapping(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        this(bigDecimal, bigDecimal2, null, null, null, null);
    }

    public TableMapping(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string, String string2, String string3, String string4) {
        super(bigDecimal, bigDecimal2);
        this._schemaName = string;
        this._tableName = string2;
        this._mapSchemaName = string3;
        this._mapTableName = string4;
    }

    public void setSchemaName(String string) {
        this._schemaName = string;
    }

    public void setTableName(String string) {
        this._tableName = string;
    }

    public void setMapSchemaName(String string) {
        this._mapSchemaName = string;
    }

    public void setMapTableName(String string) {
        this._mapTableName = string;
    }

    public void addColumnMapping(ColumnMapping columnMapping) {
        this._colMappingList.add(columnMapping);
    }

    public String getShemaName() {
        return this._schemaName;
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getMapShemaName() {
        return this._mapSchemaName;
    }

    public String getMapTableName() {
        return this._mapTableName;
    }

    public List<ColumnMapping> getColumnMappings() {
        return this._colMappingList;
    }

    public Map<String, Set<String>> getDataTypeColsMap() {
        return this._dataTypeColsMap;
    }

    public void setDataTypeColsMap(Map<String, Set<String>> map) {
        this._dataTypeColsMap = map;
    }

    public OdmrTableMap getOdmrTableMap() throws Exception {
        OdmrTabColMaps odmrTabColMaps = new OdmrTabColMaps();
        OdmrTabColMap[] odmrTabColMapArray = new OdmrTabColMap[this._colMappingList.size()];
        int n = 0;
        for (ColumnMapping columnMapping : this._colMappingList) {
            odmrTabColMapArray[n++] = columnMapping.getOdmrTabColMap();
        }
        odmrTabColMaps.setArray(odmrTabColMapArray);
        OdmrTableMap odmrTableMap = new OdmrTableMap(this.getId(), this._mapSchemaName, this._mapTableName, odmrTabColMaps);
        return odmrTableMap;
    }

    @Override
    public void load(ConnectionManager connectionManager) throws Exception {
        this.loadDataTypeColsMap(connectionManager);
        this.setLoaded(true);
    }

    public void loadDataTypeColsMap(ConnectionManager connectionManager) throws SQLException {
        if (this._mapTableName != null) {
            TableVO tableVO = new TableVO(this._mapSchemaName, this._mapTableName);
            List<List<String>> list = DatabaseMetadataUtils.getColumnDetails(connectionManager, tableVO);
            this._dataTypeColsMap = new HashMap<String, Set<String>>();
            for (List<String> list2 : list) {
                String string = list2.get(0);
                String string2 = list2.get(1);
                if (string == null || string2 == null) continue;
                Set<String> set = this._dataTypeColsMap.get(string2);
                if (set == null) {
                    set = new TreeSet<String>();
                    this._dataTypeColsMap.put(string2, set);
                }
                set.add(string);
            }
        }
    }

    @Override
    public void refresh(ConnectionManager connectionManager) throws Exception {
        this.load(connectionManager);
    }

    @Override
    public void unload() {
        this.setLoaded(false);
    }
}

